/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.ClusterMetrics;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.QueueAclsInfo;
import org.apache.hadoop.mapreduce.QueueInfo;
import org.apache.hadoop.mapreduce.TaskTrackerInfo;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.QueueUserACLInfo;
import org.apache.hadoop.yarn.api.records.YarnClusterMetrics;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.client.api.YarnClientApplication;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.util.ConverterUtils;

public class ResourceMgrDelegate
extends YarnClient {
    private static final Log LOG = LogFactory.getLog(ResourceMgrDelegate.class);
    private YarnConfiguration conf;
    private ApplicationSubmissionContext application;
    private ApplicationId applicationId;
    @InterfaceAudience.Private
    @VisibleForTesting
    protected YarnClient client;
    private InetSocketAddress rmAddress;

    public ResourceMgrDelegate(YarnConfiguration conf) {
        this(conf, null);
    }

    public ResourceMgrDelegate(YarnConfiguration conf, InetSocketAddress rmAddress) {
        super(ResourceMgrDelegate.class.getName());
        this.conf = conf;
        this.rmAddress = rmAddress;
        this.client = rmAddress == null ? YarnClient.createYarnClient() : YarnClient.createYarnClient((InetSocketAddress)rmAddress);
        this.init((Configuration)conf);
        this.start();
    }

    protected void serviceInit(Configuration conf) throws Exception {
        if (this.rmAddress == null) {
            this.rmAddress = conf.getSocketAddr("yarn.resourcemanager.address", "0.0.0.0:8032", 8032);
        }
        this.client.init(conf);
        super.serviceInit(conf);
    }

    protected void serviceStart() throws Exception {
        this.client.start();
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        this.client.stop();
        super.serviceStop();
    }

    public TaskTrackerInfo[] getActiveTrackers() throws IOException, InterruptedException {
        try {
            return TypeConverter.fromYarnNodes((List)this.client.getNodeReports());
        }
        catch (YarnException e) {
            throw new IOException(e);
        }
    }

    public JobStatus[] getAllJobs() throws IOException, InterruptedException {
        try {
            return TypeConverter.fromYarnApps((List)this.client.getApplicationList(), (Configuration)this.conf);
        }
        catch (YarnException e) {
            throw new IOException(e);
        }
    }

    public TaskTrackerInfo[] getBlacklistedTrackers() throws IOException, InterruptedException {
        LOG.warn((Object)"getBlacklistedTrackers - Not implemented yet");
        return new TaskTrackerInfo[0];
    }

    public ClusterMetrics getClusterMetrics() throws IOException, InterruptedException {
        try {
            YarnClusterMetrics metrics = this.client.getYarnClusterMetrics();
            ClusterMetrics oldMetrics = new ClusterMetrics(1, 1, 1, 1, 1, 1, metrics.getNumNodeManagers() * 10, metrics.getNumNodeManagers() * 2, 1, metrics.getNumNodeManagers(), 0, 0);
            return oldMetrics;
        }
        catch (YarnException e) {
            throw new IOException(e);
        }
    }

    InetSocketAddress getConnectAddress() {
        return this.rmAddress;
    }

    public Token getDelegationToken(Text renewer) throws IOException, InterruptedException {
        try {
            return ConverterUtils.convertFromYarn((org.apache.hadoop.yarn.api.records.Token)this.client.getRMDelegationToken(renewer), (InetSocketAddress)this.rmAddress);
        }
        catch (YarnException e) {
            throw new IOException(e);
        }
    }

    public String getFilesystemName() throws IOException, InterruptedException {
        return FileSystem.get((Configuration)this.conf).getUri().toString();
    }

    public JobID getNewJobID() throws IOException, InterruptedException {
        try {
            this.application = this.client.createApplication().getApplicationSubmissionContext();
            this.applicationId = this.application.getApplicationId();
            return TypeConverter.fromYarn((ApplicationId)this.applicationId);
        }
        catch (YarnException e) {
            throw new IOException(e);
        }
    }

    public QueueInfo getQueue(String queueName) throws IOException, InterruptedException {
        try {
            org.apache.hadoop.yarn.api.records.QueueInfo queueInfo = this.client.getQueueInfo(queueName);
            return queueInfo == null ? null : TypeConverter.fromYarn((org.apache.hadoop.yarn.api.records.QueueInfo)queueInfo, (Configuration)this.conf);
        }
        catch (YarnException e) {
            throw new IOException(e);
        }
    }

    public QueueAclsInfo[] getQueueAclsForCurrentUser() throws IOException, InterruptedException {
        try {
            return TypeConverter.fromYarnQueueUserAclsInfo((List)this.client.getQueueAclsInfo());
        }
        catch (YarnException e) {
            throw new IOException(e);
        }
    }

    public QueueInfo[] getQueues() throws IOException, InterruptedException {
        try {
            return TypeConverter.fromYarnQueueInfo((List)this.client.getAllQueues(), (Configuration)this.conf);
        }
        catch (YarnException e) {
            throw new IOException(e);
        }
    }

    public QueueInfo[] getRootQueues() throws IOException, InterruptedException {
        try {
            return TypeConverter.fromYarnQueueInfo((List)this.client.getRootQueueInfos(), (Configuration)this.conf);
        }
        catch (YarnException e) {
            throw new IOException(e);
        }
    }

    public QueueInfo[] getChildQueues(String parent) throws IOException, InterruptedException {
        try {
            return TypeConverter.fromYarnQueueInfo((List)this.client.getChildQueueInfos(parent), (Configuration)this.conf);
        }
        catch (YarnException e) {
            throw new IOException(e);
        }
    }

    public String getStagingAreaDir() throws IOException, InterruptedException {
        String user = UserGroupInformation.getCurrentUser().getShortUserName();
        Path path = MRApps.getStagingAreaDir((Configuration)this.conf, (String)user);
        LOG.debug((Object)("getStagingAreaDir: dir=" + path));
        return path.toString();
    }

    public String getSystemDir() throws IOException, InterruptedException {
        Path sysDir = new Path("jobSubmitDir");
        return sysDir.toString();
    }

    public long getTaskTrackerExpiryInterval() throws IOException, InterruptedException {
        return 0L;
    }

    public void setJobPriority(JobID arg0, String arg1) throws IOException, InterruptedException {
    }

    public long getProtocolVersion(String arg0, long arg1) throws IOException {
        return 0L;
    }

    public ApplicationId getApplicationId() {
        return this.applicationId;
    }

    public YarnClientApplication createApplication() throws YarnException, IOException {
        return this.client.createApplication();
    }

    public ApplicationId submitApplication(ApplicationSubmissionContext appContext) throws YarnException, IOException {
        return this.client.submitApplication(appContext);
    }

    public void killApplication(ApplicationId applicationId) throws YarnException, IOException {
        this.client.killApplication(applicationId);
    }

    public ApplicationReport getApplicationReport(ApplicationId appId) throws YarnException, IOException {
        return this.client.getApplicationReport(appId);
    }

    public List<ApplicationReport> getApplicationList() throws YarnException, IOException {
        return this.client.getApplicationList();
    }

    public YarnClusterMetrics getYarnClusterMetrics() throws YarnException, IOException {
        return this.client.getYarnClusterMetrics();
    }

    public List<NodeReport> getNodeReports() throws YarnException, IOException {
        return this.client.getNodeReports();
    }

    public org.apache.hadoop.yarn.api.records.Token getRMDelegationToken(Text renewer) throws YarnException, IOException {
        return this.client.getRMDelegationToken(renewer);
    }

    public org.apache.hadoop.yarn.api.records.QueueInfo getQueueInfo(String queueName) throws YarnException, IOException {
        return this.client.getQueueInfo(queueName);
    }

    public List<org.apache.hadoop.yarn.api.records.QueueInfo> getAllQueues() throws YarnException, IOException {
        return this.client.getAllQueues();
    }

    public List<org.apache.hadoop.yarn.api.records.QueueInfo> getRootQueueInfos() throws YarnException, IOException {
        return this.client.getRootQueueInfos();
    }

    public List<org.apache.hadoop.yarn.api.records.QueueInfo> getChildQueueInfos(String parent) throws YarnException, IOException {
        return this.client.getChildQueueInfos(parent);
    }

    public List<QueueUserACLInfo> getQueueAclsInfo() throws YarnException, IOException {
        return this.client.getQueueAclsInfo();
    }
}

