/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TestMiniMRClasspath;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestMiniMRWithDFSWithDistinctUsers {
    static final UserGroupInformation DFS_UGI = TestMiniMRWithDFSWithDistinctUsers.createUGI((String)"dfs", (boolean)true);
    static final UserGroupInformation ALICE_UGI = TestMiniMRWithDFSWithDistinctUsers.createUGI((String)"alice", (boolean)false);
    static final UserGroupInformation BOB_UGI = TestMiniMRWithDFSWithDistinctUsers.createUGI((String)"bob", (boolean)false);
    MiniMRCluster mr = null;
    MiniDFSCluster dfs = null;
    FileSystem fs = null;
    Configuration conf = new Configuration();

    static UserGroupInformation createUGI(String name, boolean issuper) {
        String group = issuper ? "supergroup" : name;
        return UserGroupInformation.createUserForTesting((String)name, (String[])new String[]{group});
    }

    static void mkdir(FileSystem fs, String dir, String user, String group, short mode) throws IOException {
        Path p = new Path(dir);
        fs.mkdirs(p);
        fs.setPermission(p, new FsPermission(mode));
        fs.setOwner(p, user, group);
    }

    void runJobAsUser(JobConf job, UserGroupInformation ugi) throws Exception {
        RunningJob rj = (RunningJob)ugi.doAs((PrivilegedExceptionAction)new /* Unavailable Anonymous Inner Class!! */);
        rj.waitForCompletion();
        Assert.assertEquals((Object)"SUCCEEDED", (Object)JobStatus.getJobRunState((int)rj.getJobState()));
    }

    @Before
    public void setUp() throws Exception {
        this.dfs = new MiniDFSCluster(this.conf, 4, true, null);
        this.fs = (FileSystem)DFS_UGI.doAs((PrivilegedExceptionAction)new /* Unavailable Anonymous Inner Class!! */);
        TestMiniMRWithDFSWithDistinctUsers.mkdir((FileSystem)this.fs, (String)"/user", (String)"nobody", (String)"nogroup", (short)1023);
        TestMiniMRWithDFSWithDistinctUsers.mkdir((FileSystem)this.fs, (String)"/user/alice", (String)"alice", (String)"nogroup", (short)493);
        TestMiniMRWithDFSWithDistinctUsers.mkdir((FileSystem)this.fs, (String)"/user/bob", (String)"bob", (String)"nogroup", (short)493);
        UserGroupInformation MR_UGI = UserGroupInformation.getLoginUser();
        TestMiniMRWithDFSWithDistinctUsers.mkdir((FileSystem)this.fs, (String)"/staging", (String)MR_UGI.getShortUserName(), (String)"nogroup", (short)1023);
        JobConf mrConf = new JobConf();
        mrConf.set("mapreduce.jobtracker.staging.root.dir", "/staging");
        this.mr = new MiniMRCluster(0, 0, 4, this.dfs.getFileSystem().getUri().toString(), 1, null, null, MR_UGI, mrConf);
    }

    @After
    public void tearDown() throws Exception {
        if (this.mr != null) {
            this.mr.shutdown();
        }
        if (this.dfs != null) {
            this.dfs.shutdown();
        }
    }

    @Test
    public void testDistinctUsers() throws Exception {
        JobConf job1 = this.mr.createJobConf();
        String input = "The quick brown fox\nhas many silly\nred fox sox\n";
        Path inDir = new Path("/testing/distinct/input");
        Path outDir = new Path("/user/alice/output");
        TestMiniMRClasspath.configureWordCount((FileSystem)this.fs, (JobConf)job1, (String)input, (int)2, (int)1, (Path)inDir, (Path)outDir);
        this.runJobAsUser(job1, ALICE_UGI);
        JobConf job2 = this.mr.createJobConf();
        Path inDir2 = new Path("/testing/distinct/input2");
        Path outDir2 = new Path("/user/bob/output2");
        TestMiniMRClasspath.configureWordCount((FileSystem)this.fs, (JobConf)job2, (String)input, (int)2, (int)1, (Path)inDir2, (Path)outDir2);
        this.runJobAsUser(job2, BOB_UGI);
    }

    @Test
    public void testMultipleSpills() throws Exception {
        JobConf job1 = this.mr.createJobConf();
        job1.setFloat("mapreduce.map.sort.spill.percent", 1.0E-4f);
        job1.setInt("mapreduce.task.io.sort.mb", 1);
        job1.setInt("mapreduce.task.index.cache.limit.bytes", 0);
        String input = "The quick brown fox\nhas many silly\nred fox sox\n";
        Path inDir = new Path("/testing/distinct/input");
        Path outDir = new Path("/user/alice/output");
        TestMiniMRClasspath.configureWordCount((FileSystem)this.fs, (JobConf)job1, (String)input, (int)2, (int)1, (Path)inDir, (Path)outDir);
        this.runJobAsUser(job1, ALICE_UGI);
    }
}

