/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.LocalJobRunner;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskCounter;
import org.apache.hadoop.mapreduce.TestLocalRunner;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.ReflectionUtils;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestLocalRunner
extends TestCase {
    private static final Log LOG = LogFactory.getLog(TestLocalRunner.class);
    private static int[] INPUT_SIZES = new int[]{50000, 500, 500, 20, 5000, 500};
    private static int[] OUTPUT_SIZES = new int[]{1, 500, 500, 500, 500, 500};
    private static int[] SLEEP_INTERVALS = new int[]{10000, 15, 15, 20, 250, 60};
    private static int TOTAL_RECORDS = 0;
    private final String INPUT_DIR = "multiMapInput";
    private final String OUTPUT_DIR = "multiMapOutput";

    private void createInputFile(Path dirPath, int id, int numRecords) throws IOException {
        String MESSAGE = "This is a line in a file: ";
        Path filePath = new Path(dirPath, "" + id);
        Configuration conf = new Configuration();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        FSDataOutputStream os = fs.create(filePath);
        BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)os));
        for (int i = 0; i < numRecords; ++i) {
            w.write("This is a line in a file: " + id + " " + i + "\n");
        }
        w.close();
    }

    private Path getInputPath() {
        String dataDir = System.getProperty("test.build.data");
        if (null == dataDir) {
            return new Path("multiMapInput");
        }
        return new Path(new Path(dataDir), "multiMapInput");
    }

    private Path getOutputPath() {
        String dataDir = System.getProperty("test.build.data");
        if (null == dataDir) {
            return new Path("multiMapOutput");
        }
        return new Path(new Path(dataDir), "multiMapOutput");
    }

    private Path createMultiMapsInput() throws IOException {
        Path inputPath;
        Configuration conf = new Configuration();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        if (fs.exists(inputPath = this.getInputPath())) {
            fs.delete(inputPath, true);
        }
        for (int i = 0; i < 6; ++i) {
            this.createInputFile(inputPath, i, INPUT_SIZES[i]);
        }
        return inputPath;
    }

    private void verifyOutput(Path outputPath) throws IOException {
        Configuration conf = new Configuration();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        Path outputFile = new Path(outputPath, "part-r-00000");
        FSDataInputStream is = fs.open(outputFile);
        BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)is));
        String line = r.readLine().trim();
        TestLocalRunner.assertTrue((String)"Line does not have correct key", (boolean)line.startsWith("0\t"));
        int count = Integer.valueOf(line.substring(2));
        TestLocalRunner.assertEquals((String)"Incorrect count generated!", (int)TOTAL_RECORDS, (int)count);
        r.close();
    }

    @Test
    public void testGcCounter() throws Exception {
        Path inputPath = this.getInputPath();
        Path outputPath = this.getOutputPath();
        Configuration conf = new Configuration();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        if (fs.exists(outputPath)) {
            fs.delete(outputPath, true);
        }
        if (fs.exists(inputPath)) {
            fs.delete(inputPath, true);
        }
        this.createInputFile(inputPath, 0, 20);
        Job job = Job.getInstance();
        job.setMapperClass(GCMapper.class);
        job.setNumReduceTasks(0);
        job.getConfiguration().set("mapreduce.task.io.sort.mb", "25");
        FileInputFormat.addInputPath((Job)job, (Path)inputPath);
        FileOutputFormat.setOutputPath((Job)job, (Path)outputPath);
        boolean ret = job.waitForCompletion(true);
        TestLocalRunner.assertTrue((String)"job failed", (boolean)ret);
        Counter gcCounter = job.getCounters().findCounter((Enum)TaskCounter.GC_TIME_MILLIS);
        TestLocalRunner.assertNotNull((Object)gcCounter);
        TestLocalRunner.assertTrue((String)"No time spent in gc", (gcCounter.getValue() > 0L ? 1 : 0) != 0);
    }

    @Test(timeout=120000L)
    public void testMultiMaps() throws Exception {
        Job job = Job.getInstance();
        Path inputPath = this.createMultiMapsInput();
        Path outputPath = this.getOutputPath();
        Configuration conf = new Configuration();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        if (fs.exists(outputPath)) {
            fs.delete(outputPath, true);
        }
        job.setMapperClass(StressMapper.class);
        job.setReducerClass(CountingReducer.class);
        job.setNumReduceTasks(1);
        LocalJobRunner.setLocalMaxRunningMaps((JobContext)job, (int)6);
        job.getConfiguration().set("mapreduce.task.io.sort.mb", "25");
        FileInputFormat.addInputPath((Job)job, (Path)inputPath);
        FileOutputFormat.setOutputPath((Job)job, (Path)outputPath);
        Thread toInterrupt = Thread.currentThread();
        1 interrupter = new /* Unavailable Anonymous Inner Class!! */;
        LOG.info((Object)"Submitting job...");
        job.submit();
        LOG.info((Object)"Starting thread to interrupt main thread in 2 minutes");
        interrupter.start();
        LOG.info((Object)"Waiting for job to complete...");
        try {
            job.waitForCompletion(true);
        }
        catch (InterruptedException ie) {
            LOG.fatal((Object)"Interrupted while waiting for job completion", (Throwable)ie);
            for (int i = 0; i < 10; ++i) {
                LOG.fatal((Object)"Dumping stacks");
                ReflectionUtils.logThreadInfo((Log)LOG, (String)"multimap threads", (long)0L);
                Thread.sleep(1000L);
            }
            throw ie;
        }
        LOG.info((Object)"Job completed, stopping interrupter");
        interrupter.interrupt();
        try {
            interrupter.join();
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        LOG.info((Object)"Verifying output");
        this.verifyOutput(outputPath);
    }

    @Test
    public void testInvalidMultiMapParallelism() throws Exception {
        Job job = Job.getInstance();
        Path inputPath = this.createMultiMapsInput();
        Path outputPath = this.getOutputPath();
        Configuration conf = new Configuration();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        if (fs.exists(outputPath)) {
            fs.delete(outputPath, true);
        }
        job.setMapperClass(StressMapper.class);
        job.setReducerClass(CountingReducer.class);
        job.setNumReduceTasks(1);
        LocalJobRunner.setLocalMaxRunningMaps((JobContext)job, (int)-6);
        FileInputFormat.addInputPath((Job)job, (Path)inputPath);
        FileOutputFormat.setOutputPath((Job)job, (Path)outputPath);
        boolean success = job.waitForCompletion(true);
        TestLocalRunner.assertFalse((String)"Job succeeded somehow", (boolean)success);
    }

    public void testEmptyMaps() throws Exception {
        Job job = Job.getInstance();
        Path outputPath = this.getOutputPath();
        Configuration conf = new Configuration();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        if (fs.exists(outputPath)) {
            fs.delete(outputPath, true);
        }
        job.setInputFormatClass(EmptyInputFormat.class);
        job.setNumReduceTasks(1);
        FileOutputFormat.setOutputPath((Job)job, (Path)outputPath);
        boolean success = job.waitForCompletion(true);
        TestLocalRunner.assertTrue((String)"Empty job should work", (boolean)success);
    }

    static /* synthetic */ Log access$000() {
        return LOG;
    }

    static /* synthetic */ int[] access$100() {
        return OUTPUT_SIZES;
    }

    static /* synthetic */ int[] access$200() {
        return SLEEP_INTERVALS;
    }

    static {
        for (int i = 0; i < 6; ++i) {
            TOTAL_RECORDS += INPUT_SIZES[i] * OUTPUT_SIZES[i];
        }
    }
}

