/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.TestMapperReducerCleanup;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.junit.Assert;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestMapperReducerCleanup {
    static boolean mapCleanup = false;
    static boolean reduceCleanup = false;
    static boolean recordReaderCleanup = false;
    static boolean recordWriterCleanup = false;
    private final String INPUT_DIR = "input";
    private final String OUTPUT_DIR = "output";

    static void reset() {
        mapCleanup = false;
        reduceCleanup = false;
        recordReaderCleanup = false;
        recordWriterCleanup = false;
    }

    private void createInputFile(Path dirPath, int id, int numRecords) throws IOException {
        String MESSAGE = "This is a line in a file: ";
        Path filePath = new Path(dirPath, "" + id);
        Configuration conf = new Configuration();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        FSDataOutputStream os = fs.create(filePath);
        BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)os));
        for (int i = 0; i < numRecords; ++i) {
            w.write("This is a line in a file: " + id + " " + i + "\n");
        }
        w.close();
    }

    private Path getInputPath() {
        String dataDir = System.getProperty("test.build.data");
        if (null == dataDir) {
            return new Path("input");
        }
        return new Path(new Path(dataDir), "input");
    }

    private Path getOutputPath() {
        String dataDir = System.getProperty("test.build.data");
        if (null == dataDir) {
            return new Path("output");
        }
        return new Path(new Path(dataDir), "output");
    }

    private Path createInput() throws IOException {
        Path inputPath;
        Configuration conf = new Configuration();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        if (fs.exists(inputPath = this.getInputPath())) {
            fs.delete(inputPath, true);
        }
        this.createInputFile(inputPath, 0, 10);
        return inputPath;
    }

    @Test
    public void testMapCleanup() throws Exception {
        TestMapperReducerCleanup.reset();
        Job job = Job.getInstance();
        Path inputPath = this.createInput();
        Path outputPath = this.getOutputPath();
        Configuration conf = new Configuration();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        if (fs.exists(outputPath)) {
            fs.delete(outputPath, true);
        }
        job.setMapperClass(FailingMapper.class);
        job.setInputFormatClass(TrackingTextInputFormat.class);
        job.setOutputFormatClass(TrackingTextOutputFormat.class);
        job.setNumReduceTasks(0);
        FileInputFormat.addInputPath((Job)job, (Path)inputPath);
        FileOutputFormat.setOutputPath((Job)job, (Path)outputPath);
        job.waitForCompletion(true);
        Assert.assertTrue((boolean)mapCleanup);
        Assert.assertTrue((boolean)recordReaderCleanup);
        Assert.assertTrue((boolean)recordWriterCleanup);
    }

    @Test
    public void testReduceCleanup() throws Exception {
        TestMapperReducerCleanup.reset();
        Job job = Job.getInstance();
        Path inputPath = this.createInput();
        Path outputPath = this.getOutputPath();
        Configuration conf = new Configuration();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        if (fs.exists(outputPath)) {
            fs.delete(outputPath, true);
        }
        job.setMapperClass(TrackingTokenizerMapper.class);
        job.setReducerClass(FailingReducer.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(IntWritable.class);
        job.setInputFormatClass(TrackingTextInputFormat.class);
        job.setOutputFormatClass(TrackingTextOutputFormat.class);
        job.setNumReduceTasks(1);
        FileInputFormat.addInputPath((Job)job, (Path)inputPath);
        FileOutputFormat.setOutputPath((Job)job, (Path)outputPath);
        job.waitForCompletion(true);
        Assert.assertTrue((boolean)mapCleanup);
        Assert.assertTrue((boolean)reduceCleanup);
        Assert.assertTrue((boolean)recordReaderCleanup);
        Assert.assertTrue((boolean)recordWriterCleanup);
    }

    @Test
    public void testJobSuccessCleanup() throws Exception {
        TestMapperReducerCleanup.reset();
        Job job = Job.getInstance();
        Path inputPath = this.createInput();
        Path outputPath = this.getOutputPath();
        Configuration conf = new Configuration();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        if (fs.exists(outputPath)) {
            fs.delete(outputPath, true);
        }
        job.setMapperClass(TrackingTokenizerMapper.class);
        job.setReducerClass(TrackingIntSumReducer.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(IntWritable.class);
        job.setInputFormatClass(TrackingTextInputFormat.class);
        job.setOutputFormatClass(TrackingTextOutputFormat.class);
        job.setNumReduceTasks(1);
        FileInputFormat.addInputPath((Job)job, (Path)inputPath);
        FileOutputFormat.setOutputPath((Job)job, (Path)outputPath);
        job.waitForCompletion(true);
        Assert.assertTrue((boolean)mapCleanup);
        Assert.assertTrue((boolean)reduceCleanup);
        Assert.assertTrue((boolean)recordReaderCleanup);
        Assert.assertTrue((boolean)recordWriterCleanup);
    }
}

