/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.util;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.util.MRAsyncDiskService;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestMRAsyncDiskService
extends TestCase {
    public static final Log LOG = LogFactory.getLog(TestMRAsyncDiskService.class);
    private static String TEST_ROOT_DIR = new Path(System.getProperty("test.build.data", "/tmp")).toString();

    protected void setUp() {
        FileUtil.fullyDelete((File)new File(TEST_ROOT_DIR));
    }

    private String relativeToWorking(String pathname) {
        int i;
        String cwd = System.getProperty("user.dir", "/");
        pathname = new Path(pathname).toUri().getPath();
        cwd = new Path(cwd).toUri().getPath();
        String[] cwdParts = cwd.split("/");
        String[] pathParts = pathname.split("/");
        if (cwd.equals(pathname)) {
            LOG.info((Object)("relative to working: " + pathname + " -> ."));
            return ".";
        }
        int common = 0;
        for (int i2 = 0; i2 < Math.min(cwdParts.length, pathParts.length) && cwdParts[i2].equals(pathParts[i2]); ++i2) {
            ++common;
        }
        StringBuilder sb = new StringBuilder();
        int parentDirsRequired = cwdParts.length - common;
        for (i = 0; i < parentDirsRequired; ++i) {
            sb.append("..");
            sb.append("/");
        }
        for (i = common; i < pathParts.length; ++i) {
            sb.append(pathParts[i]);
            sb.append("/");
        }
        String s = sb.toString();
        if (s.endsWith("/")) {
            s = s.substring(0, s.length() - 1);
        }
        LOG.info((Object)("relative to working: " + pathname + " -> " + s));
        return s;
    }

    @Test
    public void testRelativeToWorking() {
        TestMRAsyncDiskService.assertEquals((String)".", (String)this.relativeToWorking(System.getProperty("user.dir", ".")));
        String cwd = System.getProperty("user.dir", ".");
        Path cwdPath = new Path(cwd);
        Path subdir = new Path(cwdPath, "foo");
        TestMRAsyncDiskService.assertEquals((String)"foo", (String)this.relativeToWorking(subdir.toUri().getPath()));
        Path subsubdir = new Path(subdir, "bar");
        TestMRAsyncDiskService.assertEquals((String)"foo/bar", (String)this.relativeToWorking(subsubdir.toUri().getPath()));
        Path parent = new Path(cwdPath, "..");
        TestMRAsyncDiskService.assertEquals((String)"..", (String)this.relativeToWorking(parent.toUri().getPath()));
        Path sideways = new Path(parent, "baz");
        TestMRAsyncDiskService.assertEquals((String)"../baz", (String)this.relativeToWorking(sideways.toUri().getPath()));
    }

    @Test
    public void testVolumeNormalization() throws Throwable {
        LOG.info((Object)("TEST_ROOT_DIR is " + TEST_ROOT_DIR));
        String relativeTestRoot = this.relativeToWorking(TEST_ROOT_DIR);
        LocalFileSystem localFileSystem = FileSystem.getLocal((Configuration)new Configuration());
        String[] vols = new String[]{relativeTestRoot + "/0", relativeTestRoot + "/1"};
        Path delDir = new Path(vols[0], "toBeDeleted");
        localFileSystem.mkdirs(delDir);
        localFileSystem.create(new Path(delDir, "foo")).close();
        MRAsyncDiskService service = new MRAsyncDiskService((FileSystem)localFileSystem, vols);
        this.makeSureCleanedUp(vols, service);
    }

    @Test
    public void testMRAsyncDiskService() throws Throwable {
        LocalFileSystem localFileSystem = FileSystem.getLocal((Configuration)new Configuration());
        String[] vols = new String[]{TEST_ROOT_DIR + "/0", TEST_ROOT_DIR + "/1"};
        MRAsyncDiskService service = new MRAsyncDiskService((FileSystem)localFileSystem, vols);
        String a = "a";
        String b = "b";
        String c = "b/c";
        String d = "d";
        File fa = new File(vols[0], a);
        File fb = new File(vols[1], b);
        File fc = new File(vols[1], c);
        File fd = new File(vols[1], d);
        fa.mkdirs();
        fb.mkdirs();
        fc.mkdirs();
        fd.mkdirs();
        TestMRAsyncDiskService.assertTrue((boolean)fa.exists());
        TestMRAsyncDiskService.assertTrue((boolean)fb.exists());
        TestMRAsyncDiskService.assertTrue((boolean)fc.exists());
        TestMRAsyncDiskService.assertTrue((boolean)fd.exists());
        service.moveAndDeleteRelativePath(vols[0], a);
        TestMRAsyncDiskService.assertFalse((boolean)fa.exists());
        service.moveAndDeleteRelativePath(vols[1], b);
        TestMRAsyncDiskService.assertFalse((boolean)fb.exists());
        TestMRAsyncDiskService.assertFalse((boolean)fc.exists());
        TestMRAsyncDiskService.assertFalse((boolean)service.moveAndDeleteRelativePath(vols[1], "not_exists"));
        IOException ee = null;
        try {
            service.moveAndDeleteAbsolutePath(TEST_ROOT_DIR + "/2");
        }
        catch (IOException e) {
            ee = e;
        }
        TestMRAsyncDiskService.assertNotNull((String)"asyncDiskService should not be able to delete files outside all volumes", (Object)ee);
        TestMRAsyncDiskService.assertTrue((boolean)service.moveAndDeleteAbsolutePath(vols[1] + '/' + d));
        this.makeSureCleanedUp(vols, service);
    }

    @Test
    public void testMRAsyncDiskServiceMoveAndDeleteAllVolumes() throws Throwable {
        LocalFileSystem localFileSystem = FileSystem.getLocal((Configuration)new Configuration());
        String[] vols = new String[]{TEST_ROOT_DIR + "/0", TEST_ROOT_DIR + "/1"};
        MRAsyncDiskService service = new MRAsyncDiskService((FileSystem)localFileSystem, vols);
        String a = "a";
        String b = "b";
        String c = "b/c";
        String d = "d";
        File fa = new File(vols[0], a);
        File fb = new File(vols[1], b);
        File fc = new File(vols[1], c);
        File fd = new File(vols[1], d);
        fa.mkdirs();
        fb.mkdirs();
        fc.mkdirs();
        fd.mkdirs();
        TestMRAsyncDiskService.assertTrue((boolean)fa.exists());
        TestMRAsyncDiskService.assertTrue((boolean)fb.exists());
        TestMRAsyncDiskService.assertTrue((boolean)fc.exists());
        TestMRAsyncDiskService.assertTrue((boolean)fd.exists());
        service.cleanupAllVolumes();
        TestMRAsyncDiskService.assertFalse((boolean)fa.exists());
        TestMRAsyncDiskService.assertFalse((boolean)fb.exists());
        TestMRAsyncDiskService.assertFalse((boolean)fc.exists());
        TestMRAsyncDiskService.assertFalse((boolean)fd.exists());
        this.makeSureCleanedUp(vols, service);
    }

    @Test
    public void testMRAsyncDiskServiceStartupCleaning() throws Throwable {
        LocalFileSystem localFileSystem = FileSystem.getLocal((Configuration)new Configuration());
        String[] vols = new String[]{TEST_ROOT_DIR + "/0", TEST_ROOT_DIR + "/1"};
        String a = "a";
        String b = "b";
        String c = "b/c";
        String d = "d";
        String suffix = "/toBeDeleted";
        File fa = new File(vols[0] + suffix, a);
        File fb = new File(vols[1] + suffix, b);
        File fc = new File(vols[1] + suffix, c);
        File fd = new File(vols[1] + suffix, d);
        fa.mkdirs();
        fb.mkdirs();
        fc.mkdirs();
        fd.mkdirs();
        TestMRAsyncDiskService.assertTrue((boolean)fa.exists());
        TestMRAsyncDiskService.assertTrue((boolean)fb.exists());
        TestMRAsyncDiskService.assertTrue((boolean)fc.exists());
        TestMRAsyncDiskService.assertTrue((boolean)fd.exists());
        MRAsyncDiskService service = new MRAsyncDiskService((FileSystem)localFileSystem, vols);
        this.makeSureCleanedUp(vols, service);
    }

    private void makeSureCleanedUp(String[] vols, MRAsyncDiskService service) throws Throwable {
        service.shutdown();
        if (!service.awaitTermination(5000L)) {
            TestMRAsyncDiskService.fail((String)"MRAsyncDiskService is still not shutdown in 5 seconds!");
        }
        for (int i = 0; i < vols.length; ++i) {
            File subDir = new File(vols[0]);
            String[] subDirContent = subDir.list();
            TestMRAsyncDiskService.assertEquals((String)"Volume should contain a single child: toBeDeleted", (int)1, (int)subDirContent.length);
            File toBeDeletedDir = new File(vols[0], "toBeDeleted");
            String[] content = toBeDeletedDir.list();
            TestMRAsyncDiskService.assertNotNull((String)("Cannot find " + toBeDeletedDir), (Object)content);
            TestMRAsyncDiskService.assertEquals((String)("" + toBeDeletedDir + " should be empty now."), (int)0, (int)content.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testToleratesSomeUnwritableVolumes() throws Throwable {
        LocalFileSystem localFileSystem = FileSystem.getLocal((Configuration)new Configuration());
        String[] vols = new String[]{TEST_ROOT_DIR + "/0", TEST_ROOT_DIR + "/1"};
        TestMRAsyncDiskService.assertTrue((boolean)new File(vols[0]).mkdirs());
        TestMRAsyncDiskService.assertEquals((int)0, (int)FileUtil.chmod((String)vols[0], (String)"400"));
        try {
            new MRAsyncDiskService((FileSystem)localFileSystem, vols);
        }
        finally {
            FileUtil.chmod((String)vols[0], (String)"755");
        }
    }
}

