/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataInputByteBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.mapred.IndexCache;
import org.apache.hadoop.mapred.IndexRecord;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapreduce.security.SecureShuffleUtils;
import org.apache.hadoop.mapreduce.security.token.JobTokenIdentifier;
import org.apache.hadoop.mapreduce.security.token.JobTokenSecretManager;
import org.apache.hadoop.mapreduce.task.reduce.ShuffleHeader;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MutableCounterInt;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableGaugeInt;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.AuxServices;
import org.apache.hadoop.yarn.service.AbstractService;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.Records;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.DefaultFileRegion;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.FileRegion;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.handler.codec.frame.TooLongFrameException;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpChunkAggregator;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpRequestDecoder;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseEncoder;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.codec.http.QueryStringDecoder;
import org.jboss.netty.handler.stream.ChunkedWriteHandler;
import org.jboss.netty.util.CharsetUtil;

public class ShuffleHandler
extends AbstractService
implements AuxServices.AuxiliaryService {
    private static final Log LOG = LogFactory.getLog(ShuffleHandler.class);
    private int port;
    private ChannelFactory selector;
    private final ChannelGroup accepted = new DefaultChannelGroup();
    public static final String MAPREDUCE_SHUFFLE_SERVICEID = "mapreduce.shuffle";
    private static final Map<String, String> userRsrc = new ConcurrentHashMap<String, String>();
    private static final JobTokenSecretManager secretManager = new JobTokenSecretManager();
    public static final String SHUFFLE_PORT_CONFIG_KEY = "mapreduce.shuffle.port";
    public static final int DEFAULT_SHUFFLE_PORT = 8080;
    final ShuffleMetrics metrics;

    ShuffleHandler(MetricsSystem ms) {
        super("httpshuffle");
        this.metrics = (ShuffleMetrics)ms.register((Object)new ShuffleMetrics());
    }

    public ShuffleHandler() {
        this(DefaultMetricsSystem.instance());
    }

    public static ByteBuffer serializeMetaData(int port) throws IOException {
        DataOutputBuffer port_dob = new DataOutputBuffer();
        port_dob.writeInt(port);
        return ByteBuffer.wrap(port_dob.getData(), 0, port_dob.getLength());
    }

    public static int deserializeMetaData(ByteBuffer meta) throws IOException {
        DataInputByteBuffer in = new DataInputByteBuffer();
        in.reset(new ByteBuffer[]{meta});
        int port = in.readInt();
        return port;
    }

    public static ByteBuffer serializeServiceData(Token<JobTokenIdentifier> jobToken) throws IOException {
        DataOutputBuffer jobToken_dob = new DataOutputBuffer();
        jobToken.write((DataOutput)jobToken_dob);
        return ByteBuffer.wrap(jobToken_dob.getData(), 0, jobToken_dob.getLength());
    }

    static Token<JobTokenIdentifier> deserializeServiceData(ByteBuffer secret) throws IOException {
        DataInputByteBuffer in = new DataInputByteBuffer();
        in.reset(new ByteBuffer[]{secret});
        Token jt = new Token();
        jt.readFields((DataInput)in);
        return jt;
    }

    public void initApp(String user, ApplicationId appId, ByteBuffer secret) {
        try {
            Token<JobTokenIdentifier> jt = ShuffleHandler.deserializeServiceData(secret);
            JobID jobId = new JobID(Long.toString(appId.getClusterTimestamp()), appId.getId());
            userRsrc.put(jobId.toString(), user);
            LOG.info((Object)("Added token for " + jobId.toString()));
            secretManager.addTokenForJob(jobId.toString(), jt);
        }
        catch (IOException e) {
            LOG.error((Object)"Error during initApp", (Throwable)e);
        }
    }

    public void stopApp(ApplicationId appId) {
        JobID jobId = new JobID(Long.toString(appId.getClusterTimestamp()), appId.getId());
        secretManager.removeTokenForJob(jobId.toString());
        userRsrc.remove(jobId.toString());
    }

    public synchronized void init(Configuration conf) {
        ThreadFactory bossFactory = new ThreadFactoryBuilder().setNameFormat("ShuffleHandler Netty Boss #%d").build();
        ThreadFactory workerFactory = new ThreadFactoryBuilder().setNameFormat("ShuffleHandler Netty Worker #%d").build();
        this.selector = new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(bossFactory), (Executor)Executors.newCachedThreadPool(workerFactory));
        super.init(new Configuration(conf));
    }

    public synchronized void start() {
        Configuration conf = this.getConfig();
        ServerBootstrap bootstrap = new ServerBootstrap(this.selector);
        HttpPipelineFactory pipelineFact = new HttpPipelineFactory(conf);
        bootstrap.setPipelineFactory((ChannelPipelineFactory)pipelineFact);
        this.port = conf.getInt(SHUFFLE_PORT_CONFIG_KEY, 8080);
        Channel ch = bootstrap.bind((SocketAddress)new InetSocketAddress(this.port));
        this.accepted.add((Object)ch);
        this.port = ((InetSocketAddress)ch.getLocalAddress()).getPort();
        conf.set(SHUFFLE_PORT_CONFIG_KEY, Integer.toString(this.port));
        pipelineFact.SHUFFLE.setPort(this.port);
        LOG.info((Object)(this.getName() + " listening on port " + this.port));
        super.start();
    }

    public synchronized void stop() {
        this.accepted.close().awaitUninterruptibly(10L, TimeUnit.SECONDS);
        ServerBootstrap bootstrap = new ServerBootstrap(this.selector);
        bootstrap.releaseExternalResources();
        super.stop();
    }

    public synchronized ByteBuffer getMeta() {
        try {
            return ShuffleHandler.serializeMetaData(this.port);
        }
        catch (IOException e) {
            LOG.error((Object)"Error during getMeta", (Throwable)e);
            return null;
        }
    }

    class Shuffle
    extends SimpleChannelUpstreamHandler {
        private final Configuration conf;
        private final IndexCache indexCache;
        private final LocalDirAllocator lDirAlloc = new LocalDirAllocator("yarn.nodemanager.local-dirs");
        private int port;

        public Shuffle(Configuration conf) {
            this.conf = conf;
            this.indexCache = new IndexCache(new JobConf(conf));
            this.port = conf.getInt(ShuffleHandler.SHUFFLE_PORT_CONFIG_KEY, 8080);
        }

        public void setPort(int port) {
            this.port = port;
        }

        private List<String> splitMaps(List<String> mapq) {
            if (null == mapq) {
                return null;
            }
            ArrayList<String> ret = new ArrayList<String>();
            for (String s : mapq) {
                Collections.addAll(ret, s.split(","));
            }
            return ret;
        }

        public void messageReceived(ChannelHandlerContext ctx, MessageEvent evt) throws Exception {
            String jobId;
            int reduceId;
            HttpRequest request = (HttpRequest)evt.getMessage();
            if (request.getMethod() != HttpMethod.GET) {
                this.sendError(ctx, HttpResponseStatus.METHOD_NOT_ALLOWED);
                return;
            }
            Map q = new QueryStringDecoder(request.getUri()).getParameters();
            List<String> mapIds = this.splitMaps((List)q.get("map"));
            List reduceQ = (List)q.get("reduce");
            List jobQ = (List)q.get("job");
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("RECV: " + request.getUri() + "\n  mapId: " + mapIds + "\n  reduceId: " + reduceQ + "\n  jobId: " + jobQ));
            }
            if (mapIds == null || reduceQ == null || jobQ == null) {
                this.sendError(ctx, "Required param job, map and reduce", HttpResponseStatus.BAD_REQUEST);
                return;
            }
            if (reduceQ.size() != 1 || jobQ.size() != 1) {
                this.sendError(ctx, "Too many job/reduce parameters", HttpResponseStatus.BAD_REQUEST);
                return;
            }
            try {
                reduceId = Integer.parseInt((String)reduceQ.get(0));
                jobId = (String)jobQ.get(0);
            }
            catch (NumberFormatException e) {
                this.sendError(ctx, "Bad reduce parameter", HttpResponseStatus.BAD_REQUEST);
                return;
            }
            catch (IllegalArgumentException e) {
                this.sendError(ctx, "Bad job parameter", HttpResponseStatus.BAD_REQUEST);
                return;
            }
            String reqUri = request.getUri();
            if (null == reqUri) {
                this.sendError(ctx, HttpResponseStatus.FORBIDDEN);
                return;
            }
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
            try {
                this.verifyRequest(jobId, ctx, request, (HttpResponse)response, new URL("http", "", this.port, reqUri));
            }
            catch (IOException e) {
                LOG.warn((Object)"Shuffle failure ", (Throwable)e);
                this.sendError(ctx, e.getMessage(), HttpResponseStatus.UNAUTHORIZED);
                return;
            }
            Channel ch = evt.getChannel();
            ch.write((Object)response);
            ChannelFuture lastMap = null;
            for (String mapId : mapIds) {
                try {
                    lastMap = this.sendMapOutput(ctx, ch, (String)userRsrc.get(jobId), jobId, mapId, reduceId);
                    if (null != lastMap) continue;
                    this.sendError(ctx, HttpResponseStatus.NOT_FOUND);
                    return;
                }
                catch (IOException e) {
                    LOG.error((Object)"Shuffle error ", (Throwable)e);
                    this.sendError(ctx, e.getMessage(), HttpResponseStatus.INTERNAL_SERVER_ERROR);
                    return;
                }
            }
            lastMap.addListener((ChannelFutureListener)ShuffleHandler.this.metrics);
            lastMap.addListener(ChannelFutureListener.CLOSE);
        }

        private void verifyRequest(String appid, ChannelHandlerContext ctx, HttpRequest request, HttpResponse response, URL requestUri) throws IOException {
            SecretKey tokenSecret = secretManager.retrieveTokenSecret(appid);
            if (null == tokenSecret) {
                LOG.info((Object)("Request for unknown token " + appid));
                throw new IOException("could not find jobid");
            }
            String enc_str = SecureShuffleUtils.buildMsgFrom((URL)requestUri);
            String urlHashStr = request.getHeader("UrlHash");
            if (urlHashStr == null) {
                LOG.info((Object)("Missing header hash for " + appid));
                throw new IOException("fetcher cannot be authenticated");
            }
            if (LOG.isDebugEnabled()) {
                int len = urlHashStr.length();
                LOG.debug((Object)("verifying request. enc_str=" + enc_str + "; hash=..." + urlHashStr.substring(len - len / 2, len - 1)));
            }
            SecureShuffleUtils.verifyReply((String)urlHashStr, (String)enc_str, (SecretKey)tokenSecret);
            String reply = SecureShuffleUtils.generateHash((byte[])urlHashStr.getBytes(), (SecretKey)tokenSecret);
            response.setHeader("ReplyHash", (Object)reply);
            if (LOG.isDebugEnabled()) {
                int len = reply.length();
                LOG.debug((Object)("Fetcher request verfied. enc_str=" + enc_str + ";reply=" + reply.substring(len - len / 2, len - 1)));
            }
        }

        protected ChannelFuture sendMapOutput(ChannelHandlerContext ctx, Channel ch, String user, String jobId, String mapId, int reduce) throws IOException {
            RandomAccessFile spill;
            JobID jobID = JobID.forName((String)jobId);
            ApplicationId appID = (ApplicationId)Records.newRecord(ApplicationId.class);
            appID.setClusterTimestamp(Long.parseLong(jobID.getJtIdentifier()));
            appID.setId(jobID.getId());
            String base = "usercache/" + user + "/" + "appcache" + "/" + ConverterUtils.toString((ApplicationId)appID) + "/output" + "/" + mapId;
            LOG.debug((Object)("DEBUG0 " + base));
            Path indexFileName = this.lDirAlloc.getLocalPathToRead(base + "/file.out.index", this.conf);
            Path mapOutputFileName = this.lDirAlloc.getLocalPathToRead(base + "/file.out", this.conf);
            LOG.debug((Object)("DEBUG1 " + base + " : " + mapOutputFileName + " : " + indexFileName));
            IndexRecord info = this.indexCache.getIndexInformation(mapId, reduce, indexFileName, user);
            ShuffleHeader header = new ShuffleHeader(mapId, info.partLength, info.rawLength, reduce);
            DataOutputBuffer dob = new DataOutputBuffer();
            header.write((DataOutput)dob);
            ch.write((Object)ChannelBuffers.wrappedBuffer((byte[])dob.getData(), (int)0, (int)dob.getLength()));
            File spillfile = new File(mapOutputFileName.toString());
            try {
                spill = new RandomAccessFile(spillfile, "r");
            }
            catch (FileNotFoundException e) {
                LOG.info((Object)(spillfile + " not found"));
                return null;
            }
            DefaultFileRegion partition = new DefaultFileRegion(spill.getChannel(), info.startOffset, info.partLength);
            ChannelFuture writeFuture = ch.write((Object)partition);
            writeFuture.addListener(new ChannelFutureListener((FileRegion)partition){
                final /* synthetic */ FileRegion val$partition;
                {
                    this.val$partition = fileRegion;
                }

                public void operationComplete(ChannelFuture future) {
                    this.val$partition.releaseExternalResources();
                }
            });
            ShuffleHandler.this.metrics.shuffleConnections.incr();
            ShuffleHandler.this.metrics.shuffleOutputBytes.incr(info.partLength);
            return writeFuture;
        }

        private void sendError(ChannelHandlerContext ctx, HttpResponseStatus status) {
            this.sendError(ctx, "", status);
        }

        private void sendError(ChannelHandlerContext ctx, String message, HttpResponseStatus status) {
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, status);
            response.setHeader("Content-Type", (Object)"text/plain; charset=UTF-8");
            response.setContent(ChannelBuffers.copiedBuffer((CharSequence)message, (Charset)CharsetUtil.UTF_8));
            ctx.getChannel().write((Object)response).addListener(ChannelFutureListener.CLOSE);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
            Channel ch = e.getChannel();
            Throwable cause = e.getCause();
            if (cause instanceof TooLongFrameException) {
                this.sendError(ctx, HttpResponseStatus.BAD_REQUEST);
                return;
            }
            LOG.error((Object)"Shuffle error: ", cause);
            if (ch.isConnected()) {
                LOG.error((Object)("Shuffle error " + e));
                this.sendError(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR);
            }
        }
    }

    class HttpPipelineFactory
    implements ChannelPipelineFactory {
        final Shuffle SHUFFLE;

        public HttpPipelineFactory(Configuration conf) {
            this.SHUFFLE = new Shuffle(conf);
        }

        public ChannelPipeline getPipeline() throws Exception {
            return Channels.pipeline((ChannelHandler[])new ChannelHandler[]{new HttpRequestDecoder(), new HttpChunkAggregator(65536), new HttpResponseEncoder(), new ChunkedWriteHandler(), this.SHUFFLE});
        }
    }

    @Metrics(about="Shuffle output metrics", context="mapred")
    static class ShuffleMetrics
    implements ChannelFutureListener {
        @Metric(value={"Shuffle output in bytes"})
        MutableCounterLong shuffleOutputBytes;
        @Metric(value={"# of failed shuffle outputs"})
        MutableCounterInt shuffleOutputsFailed;
        @Metric(value={"# of succeeeded shuffle outputs"})
        MutableCounterInt shuffleOutputsOK;
        @Metric(value={"# of current shuffle connections"})
        MutableGaugeInt shuffleConnections;

        ShuffleMetrics() {
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            if (future.isSuccess()) {
                this.shuffleOutputsOK.incr();
            } else {
                this.shuffleOutputsFailed.incr();
            }
            this.shuffleConnections.decr();
        }
    }
}

