/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.protocolrecords.impl.pb;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.impl.pb.ResourcePBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;
import org.apache.hadoop.yarn.util.ProtoUtils;

public class RegisterApplicationMasterResponsePBImpl
extends RegisterApplicationMasterResponse {
    YarnServiceProtos.RegisterApplicationMasterResponseProto proto = YarnServiceProtos.RegisterApplicationMasterResponseProto.getDefaultInstance();
    YarnServiceProtos.RegisterApplicationMasterResponseProto.Builder builder = null;
    boolean viaProto = false;
    private Resource minimumResourceCapability;
    private Resource maximumResourceCapability;
    private Map<ApplicationAccessType, String> applicationACLS = null;

    public RegisterApplicationMasterResponsePBImpl() {
        this.builder = YarnServiceProtos.RegisterApplicationMasterResponseProto.newBuilder();
    }

    public RegisterApplicationMasterResponsePBImpl(YarnServiceProtos.RegisterApplicationMasterResponseProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public YarnServiceProtos.RegisterApplicationMasterResponseProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(this.getClass())) {
            return this.getProto().equals(((RegisterApplicationMasterResponsePBImpl)this.getClass().cast(other)).getProto());
        }
        return false;
    }

    public String toString() {
        return this.getProto().toString().replaceAll("\\n", ", ").replaceAll("\\s+", " ");
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void mergeLocalToBuilder() {
        if (this.minimumResourceCapability != null) {
            this.builder.setMinimumCapability(this.convertToProtoFormat(this.minimumResourceCapability));
        }
        if (this.maximumResourceCapability != null) {
            this.builder.setMaximumCapability(this.convertToProtoFormat(this.maximumResourceCapability));
        }
        if (this.applicationACLS != null) {
            this.addApplicationACLs();
        }
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnServiceProtos.RegisterApplicationMasterResponseProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    @Override
    public Resource getMaximumResourceCapability() {
        YarnServiceProtos.RegisterApplicationMasterResponseProtoOrBuilder p;
        if (this.maximumResourceCapability != null) {
            return this.maximumResourceCapability;
        }
        YarnServiceProtos.RegisterApplicationMasterResponseProtoOrBuilder registerApplicationMasterResponseProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasMaximumCapability()) {
            return null;
        }
        this.maximumResourceCapability = this.convertFromProtoFormat(p.getMaximumCapability());
        return this.maximumResourceCapability;
    }

    public Resource getMinimumResourceCapability() {
        YarnServiceProtos.RegisterApplicationMasterResponseProtoOrBuilder p;
        if (this.minimumResourceCapability != null) {
            return this.minimumResourceCapability;
        }
        YarnServiceProtos.RegisterApplicationMasterResponseProtoOrBuilder registerApplicationMasterResponseProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasMinimumCapability()) {
            return null;
        }
        this.minimumResourceCapability = this.convertFromProtoFormat(p.getMinimumCapability());
        return this.minimumResourceCapability;
    }

    @Override
    public void setMaximumResourceCapability(Resource capability) {
        this.maybeInitBuilder();
        if (this.maximumResourceCapability == null) {
            this.builder.clearMaximumCapability();
        }
        this.maximumResourceCapability = capability;
    }

    public void setMinimumResourceCapability(Resource capability) {
        this.maybeInitBuilder();
        if (this.minimumResourceCapability == null) {
            this.builder.clearMinimumCapability();
        }
        this.minimumResourceCapability = capability;
    }

    @Override
    public Map<ApplicationAccessType, String> getApplicationACLs() {
        this.initApplicationACLs();
        return this.applicationACLS;
    }

    private void initApplicationACLs() {
        if (this.applicationACLS != null) {
            return;
        }
        YarnServiceProtos.RegisterApplicationMasterResponseProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<YarnProtos.ApplicationACLMapProto> list = p.getApplicationACLsList();
        this.applicationACLS = new HashMap<ApplicationAccessType, String>(list.size());
        for (YarnProtos.ApplicationACLMapProto aclProto : list) {
            this.applicationACLS.put(ProtoUtils.convertFromProtoFormat(aclProto.getAccessType()), aclProto.getAcl());
        }
    }

    private void addApplicationACLs() {
        this.maybeInitBuilder();
        this.builder.clearApplicationACLs();
        if (this.applicationACLS == null) {
            return;
        }
        Iterable<YarnProtos.ApplicationACLMapProto> values = new Iterable<YarnProtos.ApplicationACLMapProto>(){

            @Override
            public Iterator<YarnProtos.ApplicationACLMapProto> iterator() {
                return new Iterator<YarnProtos.ApplicationACLMapProto>(){
                    Iterator<ApplicationAccessType> aclsIterator;
                    {
                        this.aclsIterator = RegisterApplicationMasterResponsePBImpl.this.applicationACLS.keySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.aclsIterator.hasNext();
                    }

                    @Override
                    public YarnProtos.ApplicationACLMapProto next() {
                        ApplicationAccessType key = this.aclsIterator.next();
                        return YarnProtos.ApplicationACLMapProto.newBuilder().setAcl((String)RegisterApplicationMasterResponsePBImpl.this.applicationACLS.get((Object)key)).setAccessType(ProtoUtils.convertToProtoFormat(key)).build();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
        this.builder.addAllApplicationACLs((Iterable<? extends YarnProtos.ApplicationACLMapProto>)values);
    }

    @Override
    public void setApplicationACLs(Map<ApplicationAccessType, String> appACLs) {
        if (appACLs == null) {
            return;
        }
        this.initApplicationACLs();
        this.applicationACLS.clear();
        this.applicationACLS.putAll(appACLs);
    }

    private Resource convertFromProtoFormat(YarnProtos.ResourceProto resource) {
        return new ResourcePBImpl(resource);
    }

    private YarnProtos.ResourceProto convertToProtoFormat(Resource resource) {
        return ((ResourcePBImpl)resource).getProto();
    }
}

