/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import com.google.protobuf.ByteString;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.yarn.api.records.AMCommand;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationResourceUsageReport;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueState;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationResourceUsageReportPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.NodeIdPBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;

public class ProtoUtils {
    private static String CONTAINER_STATE_PREFIX = "C_";
    private static String NODE_STATE_PREFIX = "NS_";
    private static String FINAL_APPLICATION_STATUS_PREFIX = "APP_";
    private static String QUEUE_STATE_PREFIX = "Q_";
    private static String QUEUE_ACL_PREFIX = "QACL_";
    private static String APP_ACCESS_TYPE_PREFIX = "APPACCESS_";

    public static YarnProtos.ContainerStateProto convertToProtoFormat(ContainerState e) {
        return YarnProtos.ContainerStateProto.valueOf(CONTAINER_STATE_PREFIX + e.name());
    }

    public static ContainerState convertFromProtoFormat(YarnProtos.ContainerStateProto e) {
        return ContainerState.valueOf(e.name().replace(CONTAINER_STATE_PREFIX, ""));
    }

    public static YarnProtos.NodeStateProto convertToProtoFormat(NodeState e) {
        return YarnProtos.NodeStateProto.valueOf(NODE_STATE_PREFIX + e.name());
    }

    public static NodeState convertFromProtoFormat(YarnProtos.NodeStateProto e) {
        return NodeState.valueOf(e.name().replace(NODE_STATE_PREFIX, ""));
    }

    public static YarnProtos.NodeIdProto convertToProtoFormat(NodeId e) {
        return ((NodeIdPBImpl)e).getProto();
    }

    public static NodeId convertFromProtoFormat(YarnProtos.NodeIdProto e) {
        return new NodeIdPBImpl(e);
    }

    public static YarnProtos.YarnApplicationStateProto convertToProtoFormat(YarnApplicationState e) {
        return YarnProtos.YarnApplicationStateProto.valueOf(e.name());
    }

    public static YarnApplicationState convertFromProtoFormat(YarnProtos.YarnApplicationStateProto e) {
        return YarnApplicationState.valueOf(e.name());
    }

    public static YarnProtos.ApplicationResourceUsageReportProto convertToProtoFormat(ApplicationResourceUsageReport e) {
        return ((ApplicationResourceUsageReportPBImpl)e).getProto();
    }

    public static ApplicationResourceUsageReport convertFromProtoFormat(YarnProtos.ApplicationResourceUsageReportProto e) {
        return new ApplicationResourceUsageReportPBImpl(e);
    }

    public static YarnProtos.FinalApplicationStatusProto convertToProtoFormat(FinalApplicationStatus e) {
        return YarnProtos.FinalApplicationStatusProto.valueOf(FINAL_APPLICATION_STATUS_PREFIX + e.name());
    }

    public static FinalApplicationStatus convertFromProtoFormat(YarnProtos.FinalApplicationStatusProto e) {
        return FinalApplicationStatus.valueOf(e.name().replace(FINAL_APPLICATION_STATUS_PREFIX, ""));
    }

    public static YarnProtos.LocalResourceTypeProto convertToProtoFormat(LocalResourceType e) {
        return YarnProtos.LocalResourceTypeProto.valueOf(e.name());
    }

    public static LocalResourceType convertFromProtoFormat(YarnProtos.LocalResourceTypeProto e) {
        return LocalResourceType.valueOf(e.name());
    }

    public static YarnProtos.LocalResourceVisibilityProto convertToProtoFormat(LocalResourceVisibility e) {
        return YarnProtos.LocalResourceVisibilityProto.valueOf(e.name());
    }

    public static LocalResourceVisibility convertFromProtoFormat(YarnProtos.LocalResourceVisibilityProto e) {
        return LocalResourceVisibility.valueOf(e.name());
    }

    public static YarnProtos.AMCommandProto convertToProtoFormat(AMCommand e) {
        return YarnProtos.AMCommandProto.valueOf(e.name());
    }

    public static AMCommand convertFromProtoFormat(YarnProtos.AMCommandProto e) {
        return AMCommand.valueOf(e.name());
    }

    public static ByteBuffer convertFromProtoFormat(ByteString byteString) {
        int capacity = byteString.asReadOnlyByteBuffer().rewind().remaining();
        byte[] b = new byte[capacity];
        byteString.asReadOnlyByteBuffer().get(b, 0, capacity);
        return ByteBuffer.wrap(b);
    }

    public static ByteString convertToProtoFormat(ByteBuffer byteBuffer) {
        int oldPos = byteBuffer.position();
        byteBuffer.rewind();
        ByteString bs = ByteString.copyFrom((ByteBuffer)byteBuffer);
        byteBuffer.position(oldPos);
        return bs;
    }

    public static YarnProtos.QueueStateProto convertToProtoFormat(QueueState e) {
        return YarnProtos.QueueStateProto.valueOf(QUEUE_STATE_PREFIX + e.name());
    }

    public static QueueState convertFromProtoFormat(YarnProtos.QueueStateProto e) {
        return QueueState.valueOf(e.name().replace(QUEUE_STATE_PREFIX, ""));
    }

    public static YarnProtos.QueueACLProto convertToProtoFormat(QueueACL e) {
        return YarnProtos.QueueACLProto.valueOf(QUEUE_ACL_PREFIX + e.name());
    }

    public static QueueACL convertFromProtoFormat(YarnProtos.QueueACLProto e) {
        return QueueACL.valueOf(e.name().replace(QUEUE_ACL_PREFIX, ""));
    }

    public static YarnProtos.ApplicationAccessTypeProto convertToProtoFormat(ApplicationAccessType e) {
        return YarnProtos.ApplicationAccessTypeProto.valueOf(APP_ACCESS_TYPE_PREFIX + e.name());
    }

    public static ApplicationAccessType convertFromProtoFormat(YarnProtos.ApplicationAccessTypeProto e) {
        return ApplicationAccessType.valueOf(e.name().replace(APP_ACCESS_TYPE_PREFIX, ""));
    }

    public static <T extends TokenIdentifier> Token<T> convertFromProtoFormat(org.apache.hadoop.yarn.api.records.Token protoToken, InetSocketAddress serviceAddr) {
        Token token = new Token(protoToken.getIdentifier().array(), protoToken.getPassword().array(), new Text(protoToken.getKind()), new Text(protoToken.getService()));
        if (serviceAddr != null) {
            SecurityUtil.setTokenService((Token)token, (InetSocketAddress)serviceAddr);
        }
        return token;
    }
}

