/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.yarn.api.ClientRMProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.GetAllApplicationsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetAllApplicationsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterMetricsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterMetricsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetDelegationTokenResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueInfoRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueUserAclsInfoRequest;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationRequest;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.DelegationToken;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.QueueUserACLInfo;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.api.records.YarnClusterMetrics;
import org.apache.hadoop.yarn.client.YarnClient;
import org.apache.hadoop.yarn.exceptions.YarnRemoteException;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.service.AbstractService;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class YarnClientImpl
extends AbstractService
implements YarnClient {
    private static final Log LOG = LogFactory.getLog(YarnClientImpl.class);
    protected ClientRMProtocol rmClient;
    protected InetSocketAddress rmAddress;
    protected long statePollIntervalMillis;
    private static final String ROOT = "root";

    public YarnClientImpl() {
        this(null);
    }

    public YarnClientImpl(InetSocketAddress rmAddress) {
        super(YarnClientImpl.class.getName());
        this.rmAddress = rmAddress;
    }

    private static InetSocketAddress getRmAddress(Configuration conf) {
        return conf.getSocketAddr("yarn.resourcemanager.address", "0.0.0.0:8032", 8032);
    }

    public synchronized void init(Configuration conf) {
        if (this.rmAddress == null) {
            this.rmAddress = YarnClientImpl.getRmAddress(conf);
        }
        this.statePollIntervalMillis = conf.getLong("yarn.client.app-submission.poll-interval", 1000L);
        super.init(conf);
    }

    public synchronized void start() {
        YarnRPC rpc = YarnRPC.create((Configuration)this.getConfig());
        this.rmClient = (ClientRMProtocol)rpc.getProxy(ClientRMProtocol.class, this.rmAddress, this.getConfig());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Connecting to ResourceManager at " + this.rmAddress));
        }
        super.start();
    }

    public synchronized void stop() {
        if (this.rmClient != null) {
            RPC.stopProxy((Object)this.rmClient);
        }
        super.stop();
    }

    @Override
    public GetNewApplicationResponse getNewApplication() throws YarnRemoteException, IOException {
        GetNewApplicationRequest request = (GetNewApplicationRequest)Records.newRecord(GetNewApplicationRequest.class);
        return this.rmClient.getNewApplication(request);
    }

    @Override
    public ApplicationId submitApplication(ApplicationSubmissionContext appContext) throws YarnRemoteException, IOException {
        YarnApplicationState state;
        ApplicationId applicationId = appContext.getApplicationId();
        appContext.setApplicationId(applicationId);
        SubmitApplicationRequest request = (SubmitApplicationRequest)Records.newRecord(SubmitApplicationRequest.class);
        request.setApplicationSubmissionContext(appContext);
        this.rmClient.submitApplication(request);
        int pollCount = 0;
        while ((state = this.getApplicationReport(applicationId).getYarnApplicationState()).equals((Object)YarnApplicationState.NEW) || state.equals((Object)YarnApplicationState.NEW_SAVING)) {
            if (++pollCount % 10 == 0) {
                LOG.info((Object)("Application submission is not finished, submitted application " + applicationId + " is still in " + state));
            }
            try {
                Thread.sleep(this.statePollIntervalMillis);
            }
            catch (InterruptedException ie) {}
        }
        LOG.info((Object)("Submitted application " + applicationId + " to ResourceManager" + " at " + this.rmAddress));
        return applicationId;
    }

    @Override
    public void killApplication(ApplicationId applicationId) throws YarnRemoteException, IOException {
        LOG.info((Object)("Killing application " + applicationId));
        KillApplicationRequest request = (KillApplicationRequest)Records.newRecord(KillApplicationRequest.class);
        request.setApplicationId(applicationId);
        this.rmClient.forceKillApplication(request);
    }

    @Override
    public ApplicationReport getApplicationReport(ApplicationId appId) throws YarnRemoteException, IOException {
        GetApplicationReportRequest request = (GetApplicationReportRequest)Records.newRecord(GetApplicationReportRequest.class);
        request.setApplicationId(appId);
        GetApplicationReportResponse response = this.rmClient.getApplicationReport(request);
        return response.getApplicationReport();
    }

    @Override
    public List<ApplicationReport> getApplicationList() throws YarnRemoteException, IOException {
        GetAllApplicationsRequest request = (GetAllApplicationsRequest)Records.newRecord(GetAllApplicationsRequest.class);
        GetAllApplicationsResponse response = this.rmClient.getAllApplications(request);
        return response.getApplicationList();
    }

    @Override
    public YarnClusterMetrics getYarnClusterMetrics() throws YarnRemoteException, IOException {
        GetClusterMetricsRequest request = (GetClusterMetricsRequest)Records.newRecord(GetClusterMetricsRequest.class);
        GetClusterMetricsResponse response = this.rmClient.getClusterMetrics(request);
        return response.getClusterMetrics();
    }

    @Override
    public List<NodeReport> getNodeReports() throws YarnRemoteException, IOException {
        GetClusterNodesRequest request = (GetClusterNodesRequest)Records.newRecord(GetClusterNodesRequest.class);
        GetClusterNodesResponse response = this.rmClient.getClusterNodes(request);
        return response.getNodeReports();
    }

    @Override
    public DelegationToken getRMDelegationToken(Text renewer) throws YarnRemoteException, IOException {
        GetDelegationTokenRequest rmDTRequest = (GetDelegationTokenRequest)Records.newRecord(GetDelegationTokenRequest.class);
        rmDTRequest.setRenewer(renewer.toString());
        GetDelegationTokenResponse response = this.rmClient.getDelegationToken(rmDTRequest);
        return response.getRMDelegationToken();
    }

    private GetQueueInfoRequest getQueueInfoRequest(String queueName, boolean includeApplications, boolean includeChildQueues, boolean recursive) {
        GetQueueInfoRequest request = (GetQueueInfoRequest)Records.newRecord(GetQueueInfoRequest.class);
        request.setQueueName(queueName);
        request.setIncludeApplications(includeApplications);
        request.setIncludeChildQueues(includeChildQueues);
        request.setRecursive(recursive);
        return request;
    }

    @Override
    public QueueInfo getQueueInfo(String queueName) throws YarnRemoteException, IOException {
        GetQueueInfoRequest request = this.getQueueInfoRequest(queueName, true, false, false);
        Records.newRecord(GetQueueInfoRequest.class);
        return this.rmClient.getQueueInfo(request).getQueueInfo();
    }

    @Override
    public List<QueueUserACLInfo> getQueueAclsInfo() throws YarnRemoteException, IOException {
        GetQueueUserAclsInfoRequest request = (GetQueueUserAclsInfoRequest)Records.newRecord(GetQueueUserAclsInfoRequest.class);
        return this.rmClient.getQueueUserAcls(request).getUserAclsInfoList();
    }

    @Override
    public List<QueueInfo> getAllQueues() throws YarnRemoteException, IOException {
        ArrayList<QueueInfo> queues = new ArrayList<QueueInfo>();
        QueueInfo rootQueue = this.rmClient.getQueueInfo(this.getQueueInfoRequest(ROOT, false, true, true)).getQueueInfo();
        this.getChildQueues(rootQueue, queues, true);
        return queues;
    }

    @Override
    public List<QueueInfo> getRootQueueInfos() throws YarnRemoteException, IOException {
        ArrayList<QueueInfo> queues = new ArrayList<QueueInfo>();
        QueueInfo rootQueue = this.rmClient.getQueueInfo(this.getQueueInfoRequest(ROOT, false, true, true)).getQueueInfo();
        this.getChildQueues(rootQueue, queues, false);
        return queues;
    }

    @Override
    public List<QueueInfo> getChildQueueInfos(String parent) throws YarnRemoteException, IOException {
        ArrayList<QueueInfo> queues = new ArrayList<QueueInfo>();
        QueueInfo parentQueue = this.rmClient.getQueueInfo(this.getQueueInfoRequest(parent, false, true, false)).getQueueInfo();
        this.getChildQueues(parentQueue, queues, true);
        return queues;
    }

    private void getChildQueues(QueueInfo parent, List<QueueInfo> queues, boolean recursive) {
        List childQueues = parent.getChildQueues();
        for (QueueInfo child : childQueues) {
            queues.add(child);
            if (!recursive) continue;
            this.getChildQueues(child, queues, recursive);
        }
    }
}

