/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.service.Service;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public interface AMRMClient<T extends ContainerRequest>
extends Service {
    public RegisterApplicationMasterResponse registerApplicationMaster(String var1, int var2, String var3) throws YarnException, IOException;

    public AllocateResponse allocate(float var1) throws YarnException, IOException;

    public void unregisterApplicationMaster(FinalApplicationStatus var1, String var2, String var3) throws YarnException, IOException;

    public void addContainerRequest(T var1);

    public void removeContainerRequest(T var1);

    public void releaseAssignedContainer(ContainerId var1);

    public Resource getClusterAvailableResources();

    public int getClusterNodeCount();

    public List<? extends Collection<T>> getMatchingRequests(Priority var1, String var2, Resource var3);

    public static class StoredContainerRequest
    extends ContainerRequest {
        public StoredContainerRequest(Resource capability, String[] hosts, String[] racks, Priority priority) {
            super(capability, hosts, racks, priority, 1);
        }
    }

    public static class ContainerRequest {
        final Resource capability;
        final ImmutableList<String> hosts;
        final ImmutableList<String> racks;
        final Priority priority;
        final int containerCount;

        public ContainerRequest(Resource capability, String[] hosts, String[] racks, Priority priority, int containerCount) {
            this.capability = capability;
            this.hosts = hosts != null ? ImmutableList.copyOf((Object[])hosts) : null;
            this.racks = racks != null ? ImmutableList.copyOf((Object[])racks) : null;
            this.priority = priority;
            this.containerCount = containerCount;
        }

        public Resource getCapability() {
            return this.capability;
        }

        public List<String> getHosts() {
            return this.hosts;
        }

        public List<String> getRacks() {
            return this.racks;
        }

        public Priority getPriority() {
            return this.priority;
        }

        public int getContainerCount() {
            return this.containerCount;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Capability[").append(this.capability).append("]");
            sb.append("Priority[").append(this.priority).append("]");
            sb.append("ContainerCount[").append(this.containerCount).append("]");
            return sb.toString();
        }
    }
}

