/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.AMRMProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.client.AMRMClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.service.AbstractService;

@InterfaceStability.Unstable
public class AMRMClientImpl<T extends AMRMClient.ContainerRequest>
extends AbstractService
implements AMRMClient<T> {
    private static final Log LOG = LogFactory.getLog(AMRMClientImpl.class);
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private int lastResponseId = 0;
    protected AMRMProtocol rmClient;
    protected final ApplicationAttemptId appAttemptId;
    protected Resource clusterAvailableResources;
    protected int clusterNodeCount;
    protected final Map<Priority, Map<String, TreeMap<Resource, ResourceRequestInfo>>> remoteRequestsTable = new TreeMap<Priority, Map<String, TreeMap<Resource, ResourceRequestInfo>>>();
    protected final Set<ResourceRequest> ask = new TreeSet<ResourceRequest>((Comparator<ResourceRequest>)new ResourceRequest.ResourceRequestComparator());
    protected final Set<ContainerId> release = new TreeSet<ContainerId>();

    static boolean canFit(Resource arg0, Resource arg1) {
        int mem0 = arg0.getMemory();
        int mem1 = arg1.getMemory();
        int cpu0 = arg0.getVirtualCores();
        int cpu1 = arg1.getVirtualCores();
        return mem0 <= mem1 && cpu0 <= cpu1;
    }

    public AMRMClientImpl(ApplicationAttemptId appAttemptId) {
        super(AMRMClientImpl.class.getName());
        this.appAttemptId = appAttemptId;
    }

    protected void serviceInit(Configuration conf) throws Exception {
        super.serviceInit(conf);
    }

    protected void serviceStart() throws Exception {
        UserGroupInformation currentUser;
        final YarnConfiguration conf = new YarnConfiguration(this.getConfig());
        final YarnRPC rpc = YarnRPC.create((Configuration)conf);
        final InetSocketAddress rmAddress = conf.getSocketAddr("yarn.resourcemanager.scheduler.address", "0.0.0.0:8030", 8030);
        try {
            currentUser = UserGroupInformation.getCurrentUser();
        }
        catch (IOException e) {
            throw new YarnRuntimeException((Throwable)e);
        }
        this.rmClient = (AMRMProtocol)currentUser.doAs((PrivilegedAction)new PrivilegedAction<AMRMProtocol>(){

            @Override
            public AMRMProtocol run() {
                return (AMRMProtocol)rpc.getProxy(AMRMProtocol.class, rmAddress, (Configuration)conf);
            }
        });
        LOG.debug((Object)("Connecting to ResourceManager at " + rmAddress));
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        if (this.rmClient != null) {
            RPC.stopProxy((Object)this.rmClient);
        }
        super.serviceStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegisterApplicationMasterResponse registerApplicationMaster(String appHostName, int appHostPort, String appTrackingUrl) throws YarnException, IOException {
        RegisterApplicationMasterRequest request = (RegisterApplicationMasterRequest)this.recordFactory.newRecordInstance(RegisterApplicationMasterRequest.class);
        AMRMClientImpl aMRMClientImpl = this;
        synchronized (aMRMClientImpl) {
            request.setApplicationAttemptId(this.appAttemptId);
        }
        request.setHost(appHostName);
        request.setRpcPort(appHostPort);
        if (appTrackingUrl != null) {
            request.setTrackingUrl(appTrackingUrl);
        }
        RegisterApplicationMasterResponse response = this.rmClient.registerApplicationMaster(request);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AllocateResponse allocate(float progressIndicator) throws YarnException, IOException {
        AMRMClientImpl aMRMClientImpl;
        AllocateResponse allocateResponse = null;
        ArrayList<ResourceRequest> askList = null;
        ArrayList<ContainerId> releaseList = null;
        AllocateRequest allocateRequest = null;
        try {
            aMRMClientImpl = this;
            synchronized (aMRMClientImpl) {
                askList = new ArrayList<ResourceRequest>(this.ask);
                releaseList = new ArrayList<ContainerId>(this.release);
                this.ask.clear();
                this.release.clear();
                allocateRequest = AllocateRequest.newInstance((ApplicationAttemptId)this.appAttemptId, (int)this.lastResponseId, (float)progressIndicator, askList, releaseList, null);
            }
            allocateResponse = this.rmClient.allocate(allocateRequest);
            aMRMClientImpl = this;
            synchronized (aMRMClientImpl) {
                this.clusterNodeCount = allocateResponse.getNumClusterNodes();
                this.lastResponseId = allocateResponse.getResponseId();
                this.clusterAvailableResources = allocateResponse.getAvailableResources();
            }
        }
        finally {
            if (allocateResponse == null) {
                aMRMClientImpl = this;
                synchronized (aMRMClientImpl) {
                    this.release.addAll(releaseList);
                    for (ResourceRequest oldAsk : askList) {
                        if (this.ask.contains(oldAsk)) continue;
                        this.ask.add(oldAsk);
                    }
                }
            }
        }
        return allocateResponse;
    }

    @Override
    public void unregisterApplicationMaster(FinalApplicationStatus appStatus, String appMessage, String appTrackingUrl) throws YarnException, IOException {
        FinishApplicationMasterRequest request = (FinishApplicationMasterRequest)this.recordFactory.newRecordInstance(FinishApplicationMasterRequest.class);
        request.setAppAttemptId(this.appAttemptId);
        request.setFinishApplicationStatus(appStatus);
        if (appMessage != null) {
            request.setDiagnostics(appMessage);
        }
        if (appTrackingUrl != null) {
            request.setTrackingUrl(appTrackingUrl);
        }
        this.rmClient.finishApplicationMaster(request);
    }

    @Override
    public synchronized void addContainerRequest(T req) {
        if (((AMRMClient.ContainerRequest)req).hosts != null) {
            for (String host : ((AMRMClient.ContainerRequest)req).hosts) {
                this.addResourceRequest(((AMRMClient.ContainerRequest)req).priority, host, ((AMRMClient.ContainerRequest)req).capability, ((AMRMClient.ContainerRequest)req).containerCount, req);
            }
        }
        if (((AMRMClient.ContainerRequest)req).racks != null) {
            for (String rack : ((AMRMClient.ContainerRequest)req).racks) {
                this.addResourceRequest(((AMRMClient.ContainerRequest)req).priority, rack, ((AMRMClient.ContainerRequest)req).capability, ((AMRMClient.ContainerRequest)req).containerCount, req);
            }
        }
        this.addResourceRequest(((AMRMClient.ContainerRequest)req).priority, "*", ((AMRMClient.ContainerRequest)req).capability, ((AMRMClient.ContainerRequest)req).containerCount, req);
    }

    @Override
    public synchronized void removeContainerRequest(T req) {
        if (((AMRMClient.ContainerRequest)req).hosts != null) {
            for (String hostName : ((AMRMClient.ContainerRequest)req).hosts) {
                this.decResourceRequest(((AMRMClient.ContainerRequest)req).priority, hostName, ((AMRMClient.ContainerRequest)req).capability, ((AMRMClient.ContainerRequest)req).containerCount, req);
            }
        }
        if (((AMRMClient.ContainerRequest)req).racks != null) {
            for (String rack : ((AMRMClient.ContainerRequest)req).racks) {
                this.decResourceRequest(((AMRMClient.ContainerRequest)req).priority, rack, ((AMRMClient.ContainerRequest)req).capability, ((AMRMClient.ContainerRequest)req).containerCount, req);
            }
        }
        this.decResourceRequest(((AMRMClient.ContainerRequest)req).priority, "*", ((AMRMClient.ContainerRequest)req).capability, ((AMRMClient.ContainerRequest)req).containerCount, req);
    }

    @Override
    public synchronized void releaseAssignedContainer(ContainerId containerId) {
        this.release.add(containerId);
    }

    @Override
    public synchronized Resource getClusterAvailableResources() {
        return this.clusterAvailableResources;
    }

    @Override
    public synchronized int getClusterNodeCount() {
        return this.clusterNodeCount;
    }

    @Override
    public synchronized List<? extends Collection<T>> getMatchingRequests(Priority priority, String resourceName, Resource capability) {
        LinkedList list = new LinkedList();
        Map<String, TreeMap<Resource, ResourceRequestInfo>> remoteRequests = this.remoteRequestsTable.get(priority);
        if (remoteRequests == null) {
            return list;
        }
        TreeMap<Resource, ResourceRequestInfo> reqMap = remoteRequests.get(resourceName);
        if (reqMap == null) {
            return list;
        }
        ResourceRequestInfo resourceRequestInfo = reqMap.get(capability);
        if (resourceRequestInfo != null) {
            list.add(resourceRequestInfo.containerRequests);
            return list;
        }
        SortedMap<Resource, ResourceRequestInfo> tailMap = reqMap.tailMap(capability);
        for (Map.Entry<Resource, ResourceRequestInfo> entry : tailMap.entrySet()) {
            if (!AMRMClientImpl.canFit(entry.getKey(), capability)) continue;
            list.add(entry.getValue().containerRequests);
        }
        return list;
    }

    private void addResourceRequestToAsk(ResourceRequest remoteRequest) {
        if (this.ask.contains(remoteRequest)) {
            this.ask.remove(remoteRequest);
        }
        this.ask.add(remoteRequest);
    }

    private void addResourceRequest(Priority priority, String resourceName, Resource capability, int containerCount, T req) {
        ResourceRequestInfo resourceRequestInfo;
        TreeMap<Resource, ResourceRequestInfo> reqMap;
        Map<String, TreeMap<Resource, ResourceRequestInfo>> remoteRequests = this.remoteRequestsTable.get(priority);
        if (remoteRequests == null) {
            remoteRequests = new HashMap<String, TreeMap<Resource, ResourceRequestInfo>>();
            this.remoteRequestsTable.put(priority, remoteRequests);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Added priority=" + priority));
            }
        }
        if ((reqMap = remoteRequests.get(resourceName)) == null) {
            reqMap = new TreeMap(new ResourceReverseMemoryThenCpuComparator());
            remoteRequests.put(resourceName, reqMap);
        }
        if ((resourceRequestInfo = reqMap.get(capability)) == null) {
            resourceRequestInfo = new ResourceRequestInfo(priority, resourceName, capability);
            reqMap.put(capability, resourceRequestInfo);
        }
        resourceRequestInfo.remoteRequest.setNumContainers(resourceRequestInfo.remoteRequest.getNumContainers() + containerCount);
        if (req instanceof AMRMClient.StoredContainerRequest) {
            resourceRequestInfo.containerRequests.add(req);
        }
        this.addResourceRequestToAsk(resourceRequestInfo.remoteRequest);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("addResourceRequest: applicationId=" + this.appAttemptId + " priority=" + priority.getPriority() + " resourceName=" + resourceName + " numContainers=" + resourceRequestInfo.remoteRequest.getNumContainers() + " #asks=" + this.ask.size()));
        }
    }

    private void decResourceRequest(Priority priority, String resourceName, Resource capability, int containerCount, T req) {
        Map<String, TreeMap<Resource, ResourceRequestInfo>> remoteRequests = this.remoteRequestsTable.get(priority);
        if (remoteRequests == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Not decrementing resource as priority " + priority + " is not present in request table"));
            }
            return;
        }
        Map reqMap = remoteRequests.get(resourceName);
        if (reqMap == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Not decrementing resource as " + resourceName + " is not present in request table"));
            }
            return;
        }
        ResourceRequestInfo resourceRequestInfo = (ResourceRequestInfo)reqMap.get(capability);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("BEFORE decResourceRequest: applicationId=" + this.appAttemptId + " priority=" + priority.getPriority() + " resourceName=" + resourceName + " numContainers=" + resourceRequestInfo.remoteRequest.getNumContainers() + " #asks=" + this.ask.size()));
        }
        resourceRequestInfo.remoteRequest.setNumContainers(resourceRequestInfo.remoteRequest.getNumContainers() - containerCount);
        if (req instanceof AMRMClient.StoredContainerRequest) {
            resourceRequestInfo.containerRequests.remove(req);
        }
        if (resourceRequestInfo.remoteRequest.getNumContainers() < 0) {
            resourceRequestInfo.remoteRequest.setNumContainers(0);
        }
        this.addResourceRequestToAsk(resourceRequestInfo.remoteRequest);
        if (resourceRequestInfo.remoteRequest.getNumContainers() == 0) {
            reqMap.remove(capability);
            if (reqMap.size() == 0) {
                remoteRequests.remove(resourceName);
            }
            if (remoteRequests.size() == 0) {
                this.remoteRequestsTable.remove(priority);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.info((Object)("AFTER decResourceRequest: applicationId=" + this.appAttemptId + " priority=" + priority.getPriority() + " resourceName=" + resourceName + " numContainers=" + resourceRequestInfo.remoteRequest.getNumContainers() + " #asks=" + this.ask.size()));
        }
    }

    class ResourceReverseMemoryThenCpuComparator
    implements Comparator<Resource> {
        ResourceReverseMemoryThenCpuComparator() {
        }

        @Override
        public int compare(Resource arg0, Resource arg1) {
            int mem0 = arg0.getMemory();
            int mem1 = arg1.getMemory();
            int cpu0 = arg0.getVirtualCores();
            int cpu1 = arg1.getVirtualCores();
            if (mem0 == mem1) {
                if (cpu0 == cpu1) {
                    return 0;
                }
                if (cpu0 < cpu1) {
                    return 1;
                }
                return -1;
            }
            if (mem0 < mem1) {
                return 1;
            }
            return -1;
        }
    }

    class ResourceRequestInfo {
        ResourceRequest remoteRequest;
        LinkedHashSet<T> containerRequests;

        ResourceRequestInfo(Priority priority, String resourceName, Resource capability) {
            this.remoteRequest = ResourceRequest.newInstance((Priority)priority, (String)resourceName, (Resource)capability, (int)0);
            this.containerRequests = new LinkedHashSet();
        }
    }
}

