/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.DNSToSwitchMapping;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.net.NodeBase;
import org.apache.hadoop.net.ScriptBasedMapping;

public class RackResolver {
    private static DNSToSwitchMapping dnsToSwitchMapping;
    private static boolean initCalled;
    private static final Log LOG;

    public static synchronized void init(Configuration conf) {
        if (initCalled) {
            return;
        }
        initCalled = true;
        Class dnsToSwitchMappingClass = conf.getClass("net.topology.node.switch.mapping.impl", ScriptBasedMapping.class, DNSToSwitchMapping.class);
        try {
            Constructor dnsToSwitchMappingConstructor = dnsToSwitchMappingClass.getConstructor(new Class[0]);
            dnsToSwitchMapping = (DNSToSwitchMapping)dnsToSwitchMappingConstructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Node resolve(Configuration conf, String hostName) {
        RackResolver.init(conf);
        return RackResolver.coreResolve(hostName);
    }

    public static Node resolve(String hostName) {
        if (!initCalled) {
            throw new IllegalStateException("RackResolver class not yet initialized");
        }
        return RackResolver.coreResolve(hostName);
    }

    private static Node coreResolve(String hostName) {
        ArrayList<String> tmpList = new ArrayList<String>(1);
        tmpList.add(hostName);
        List rNameList = dnsToSwitchMapping.resolve(tmpList);
        String rName = (String)rNameList.get(0);
        LOG.info((Object)("Resolved " + hostName + " to " + rName));
        return new NodeBase(hostName, rName);
    }

    static {
        initCalled = false;
        LOG = LogFactory.getLog(RackResolver.class);
    }
}

