/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.webapp.log;

import com.google.inject.Inject;
import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.logaggregation.AggregatedLogFormat;
import org.apache.hadoop.yarn.logaggregation.LogAggregationUtils;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.hamlet.HamletImpl;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;

public class AggregatedLogsBlock
extends HtmlBlock {
    private final Configuration conf;

    @Inject
    AggregatedLogsBlock(Configuration conf) {
        this.conf = conf;
    }

    @Override
    protected void render(HtmlBlock.Block html) {
        ContainerId containerId = this.verifyAndGetContainerId(html);
        NodeId nodeId = this.verifyAndGetNodeId(html);
        String appOwner = this.verifyAndGetAppOwner(html);
        if (containerId == null || nodeId == null || appOwner == null || appOwner.isEmpty()) {
            return;
        }
        ApplicationId applicationId = containerId.getApplicationAttemptId().getApplicationId();
        String logEntity = this.$("entity.string");
        if (logEntity == null || logEntity.isEmpty()) {
            logEntity = containerId.toString();
        }
        if (!this.conf.getBoolean("yarn.nodemanager.log-aggregation-enable", false)) {
            ((HamletImpl.EImp)((Object)((Hamlet.H1)html.h1())._(new Object[]{"Aggregation is not enabled. Try the nodemanager at " + nodeId})))._();
            return;
        }
        Path remoteRootLogDir = new Path(this.conf.get("yarn.nodemanager.remote-app-log-dir", "/tmp/logs"));
        AggregatedLogFormat.LogReader reader = null;
        try {
            reader = new AggregatedLogFormat.LogReader(this.conf, LogAggregationUtils.getRemoteNodeLogFileForApp(remoteRootLogDir, applicationId, appOwner, nodeId, LogAggregationUtils.getRemoteNodeLogDirSuffix(this.conf)));
        }
        catch (FileNotFoundException e) {
            ((HamletImpl.EImp)((Object)((Hamlet.H1)html.h1())._(new Object[]{"Logs not available for " + logEntity + ". Aggregation may not be complete, " + "Check back later or try the nodemanager at " + nodeId})))._();
            return;
        }
        catch (IOException e) {
            ((HamletImpl.EImp)((Object)((Hamlet.H1)html.h1())._(new Object[]{"Error getting logs for " + logEntity})))._();
            LOG.error("Error getting logs for " + logEntity, (Throwable)e);
            return;
        }
        String owner = null;
        Map<ApplicationAccessType, String> appAcls = null;
        try {
            owner = reader.getApplicationOwner();
            appAcls = reader.getApplicationAcls();
        }
        catch (IOException e) {
            ((HamletImpl.EImp)((Object)((Hamlet.H1)html.h1())._(new Object[]{"Error getting logs for " + logEntity})))._();
            LOG.error("Error getting logs for " + logEntity, (Throwable)e);
            return;
        }
        ApplicationACLsManager aclsManager = new ApplicationACLsManager(this.conf);
        aclsManager.addApplication(applicationId, appAcls);
        String remoteUser = this.request().getRemoteUser();
        UserGroupInformation callerUGI = null;
        if (remoteUser != null) {
            callerUGI = UserGroupInformation.createRemoteUser((String)remoteUser);
        }
        if (callerUGI != null && !aclsManager.checkAccess(callerUGI, ApplicationAccessType.VIEW_APP, owner, applicationId)) {
            ((HamletImpl.EImp)((Object)((Hamlet.H1)html.h1())._(new Object[]{"User [" + remoteUser + "] is not authorized to view the logs for " + logEntity})))._();
            return;
        }
        AggregatedLogFormat.LogKey key = new AggregatedLogFormat.LogKey();
        try {
            DataInputStream valueStream = reader.next(key);
            while (valueStream != null && !key.toString().equals(containerId.toString())) {
                valueStream = reader.next(key);
            }
            if (valueStream == null) {
                ((HamletImpl.EImp)((Object)((Hamlet.H1)html.h1())._(new Object[]{"Logs not available for " + logEntity + ". Could be caused by the rentention policy"})))._();
                return;
            }
            this.writer().write("<pre>");
            AggregatedLogFormat.LogReader.readAcontainerLogs(valueStream, this.writer());
            this.writer().write("</pre>");
            return;
        }
        catch (IOException e) {
            ((HamletImpl.EImp)((Object)((Hamlet.H1)html.h1())._(new Object[]{"Error getting logs for " + logEntity})))._();
            LOG.error("Error getting logs for " + logEntity, (Throwable)e);
            return;
        }
    }

    private ContainerId verifyAndGetContainerId(HtmlBlock.Block html) {
        String containerIdStr = this.$("container.id");
        if (containerIdStr == null || containerIdStr.isEmpty()) {
            ((HamletImpl.EImp)((Object)((Hamlet.H1)html.h1())._(new Object[]{"Cannot get container logs without a ContainerId"})))._();
            return null;
        }
        ContainerId containerId = null;
        try {
            containerId = ConverterUtils.toContainerId(containerIdStr);
        }
        catch (IllegalArgumentException e) {
            ((HamletImpl.EImp)((Object)((Hamlet.H1)html.h1())._(new Object[]{"Cannot get container logs for invalid containerId: " + containerIdStr})))._();
            return null;
        }
        return containerId;
    }

    private NodeId verifyAndGetNodeId(HtmlBlock.Block html) {
        String nodeIdStr = this.$("nm.id");
        if (nodeIdStr == null || nodeIdStr.isEmpty()) {
            ((HamletImpl.EImp)((Object)((Hamlet.H1)html.h1())._(new Object[]{"Cannot get container logs without a NodeId"})))._();
            return null;
        }
        NodeId nodeId = null;
        try {
            nodeId = ConverterUtils.toNodeId(nodeIdStr);
        }
        catch (IllegalArgumentException e) {
            ((HamletImpl.EImp)((Object)((Hamlet.H1)html.h1())._(new Object[]{"Cannot get container logs. Invalid nodeId: " + nodeIdStr})))._();
            return null;
        }
        return nodeId;
    }

    private String verifyAndGetAppOwner(HtmlBlock.Block html) {
        String appOwner = this.$("app.owner");
        if (appOwner == null || appOwner.isEmpty()) {
            ((HamletImpl.EImp)((Object)((Hamlet.H1)html.h1())._(new Object[]{"Cannot get container logs without an app owner"})))._();
        }
        return appOwner;
    }
}

