/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.security.client;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.util.BuilderUtils;

public class ClientTokenIdentifier
extends TokenIdentifier {
    public static final Text KIND_NAME = new Text("YARN_CLIENT_TOKEN");
    private ApplicationId appId;
    private Text clientName;

    public ClientTokenIdentifier(ApplicationId id, String clientName) {
        this.appId = id;
        this.clientName = new Text(clientName);
    }

    public ClientTokenIdentifier() {
        this.clientName = new Text();
    }

    public ApplicationId getApplicationID() {
        return this.appId;
    }

    public Text getClientName() {
        return this.clientName;
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.appId.getClusterTimestamp());
        out.writeInt(this.appId.getId());
        this.clientName.write(out);
    }

    public void readFields(DataInput in) throws IOException {
        this.appId = BuilderUtils.newApplicationId(in.readLong(), in.readInt());
        this.clientName.readFields(in);
    }

    public Text getKind() {
        return KIND_NAME;
    }

    public UserGroupInformation getUser() {
        String userName = this.clientName.toString();
        if (userName.isEmpty()) {
            return null;
        }
        return UserGroupInformation.createRemoteUser((String)userName);
    }

    @InterfaceAudience.Private
    public static class Renewer
    extends Token.TrivialRenewer {
        protected Text getKind() {
            return KIND_NAME;
        }
    }
}

