/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.security.client;

import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.yarn.security.client.ClientTokenIdentifier;

public class ClientToAMSecretManager
extends SecretManager<ClientTokenIdentifier> {
    private static Log LOG = LogFactory.getLog(ClientToAMSecretManager.class);
    private Map<Text, SecretKey> masterKeys = new HashMap<Text, SecretKey>();

    public void setMasterKey(ClientTokenIdentifier identifier, byte[] key) {
        SecretKey sk = SecretManager.createSecretKey((byte[])key);
        Text applicationID = identifier.getApplicationID();
        this.masterKeys.put(applicationID, sk);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Setting master key for " + applicationID + " as " + new String(Base64.encodeBase64((byte[])this.masterKeys.get(applicationID).getEncoded()))));
        }
    }

    private void addMasterKey(ClientTokenIdentifier identifier) {
        Text applicationID = identifier.getApplicationID();
        this.masterKeys.put(applicationID, this.generateSecret());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Creating master key for " + applicationID + " as " + new String(Base64.encodeBase64((byte[])this.masterKeys.get(applicationID).getEncoded()))));
        }
    }

    public synchronized SecretKey getMasterKey(ClientTokenIdentifier identifier) {
        Text applicationID = identifier.getApplicationID();
        if (!this.masterKeys.containsKey(applicationID)) {
            this.addMasterKey(identifier);
        }
        return this.masterKeys.get(applicationID);
    }

    public synchronized byte[] createPassword(ClientTokenIdentifier identifier) {
        byte[] password = ClientToAMSecretManager.createPassword((byte[])identifier.getBytes(), (SecretKey)this.getMasterKey(identifier));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Password created is " + new String(Base64.encodeBase64((byte[])password))));
        }
        return password;
    }

    public byte[] retrievePassword(ClientTokenIdentifier identifier) throws SecretManager.InvalidToken {
        byte[] password = ClientToAMSecretManager.createPassword((byte[])identifier.getBytes(), (SecretKey)this.getMasterKey(identifier));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Password retrieved is " + new String(Base64.encodeBase64((byte[])password))));
        }
        return password;
    }

    public ClientTokenIdentifier createIdentifier() {
        return new ClientTokenIdentifier();
    }
}

