/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.logaggregation;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.security.PrivilegedExceptionAction;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.file.tfile.TFile;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.YarnException;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.util.ConverterUtils;

public class AggregatedLogFormat {
    static final Log LOG = LogFactory.getLog(AggregatedLogFormat.class);
    private static final LogKey APPLICATION_ACL_KEY = new LogKey("APPLICATION_ACL");
    private static final LogKey APPLICATION_OWNER_KEY = new LogKey("APPLICATION_OWNER");
    private static final LogKey VERSION_KEY = new LogKey("VERSION");
    private static final Map<String, LogKey> RESERVED_KEYS = new HashMap<String, LogKey>();
    private static final int VERSION = 1;

    static {
        RESERVED_KEYS.put(APPLICATION_ACL_KEY.toString(), APPLICATION_ACL_KEY);
        RESERVED_KEYS.put(APPLICATION_OWNER_KEY.toString(), APPLICATION_OWNER_KEY);
        RESERVED_KEYS.put(VERSION_KEY.toString(), VERSION_KEY);
    }

    public static class LogReader {
        private final FSDataInputStream fsDataIStream;
        private final TFile.Reader.Scanner scanner;
        private final TFile.Reader reader;
        private boolean atBeginning = true;

        public LogReader(Configuration conf, Path remoteAppLogFile) throws IOException {
            FileContext fileContext = FileContext.getFileContext((Configuration)conf);
            this.fsDataIStream = fileContext.open(remoteAppLogFile);
            this.reader = new TFile.Reader(this.fsDataIStream, fileContext.getFileStatus(remoteAppLogFile).getLen(), conf);
            this.scanner = this.reader.createScanner();
        }

        public String getApplicationOwner() throws IOException {
            TFile.Reader.Scanner ownerScanner = this.reader.createScanner();
            LogKey key = new LogKey();
            while (!ownerScanner.atEnd()) {
                TFile.Reader.Scanner.Entry entry = ownerScanner.entry();
                key.readFields(entry.getKeyStream());
                if (key.toString().equals(APPLICATION_OWNER_KEY.toString())) {
                    DataInputStream valueStream = entry.getValueStream();
                    return valueStream.readUTF();
                }
                ownerScanner.advance();
            }
            return null;
        }

        public Map<ApplicationAccessType, String> getApplicationAcls() throws IOException {
            TFile.Reader.Scanner aclScanner = this.reader.createScanner();
            LogKey key = new LogKey();
            HashMap<ApplicationAccessType, String> acls = new HashMap<ApplicationAccessType, String>();
            while (!aclScanner.atEnd()) {
                TFile.Reader.Scanner.Entry entry = aclScanner.entry();
                key.readFields(entry.getKeyStream());
                if (key.toString().equals(APPLICATION_ACL_KEY.toString())) {
                    DataInputStream valueStream = entry.getValueStream();
                    while (true) {
                        String appAccessOp = null;
                        String aclString = null;
                        try {
                            appAccessOp = valueStream.readUTF();
                        }
                        catch (EOFException e) {
                            break;
                        }
                        try {
                            aclString = valueStream.readUTF();
                        }
                        catch (EOFException e) {
                            throw new YarnException("Error reading ACLs", e);
                        }
                        acls.put(ApplicationAccessType.valueOf((String)appAccessOp), aclString);
                    }
                }
                aclScanner.advance();
            }
            return acls;
        }

        public DataInputStream next(LogKey key) throws IOException {
            if (!this.atBeginning) {
                this.scanner.advance();
            } else {
                this.atBeginning = false;
            }
            if (this.scanner.atEnd()) {
                return null;
            }
            TFile.Reader.Scanner.Entry entry = this.scanner.entry();
            key.readFields(entry.getKeyStream());
            if (RESERVED_KEYS.containsKey(key.toString())) {
                return this.next(key);
            }
            DataInputStream valueStream = entry.getValueStream();
            return valueStream;
        }

        public static void readAcontainerLogs(DataInputStream valueStream, Writer writer) throws IOException {
            int bufferSize = 65536;
            char[] cbuf = new char[bufferSize];
            block2: while (true) {
                String fileType;
                try {
                    fileType = valueStream.readUTF();
                }
                catch (EOFException e) {
                    return;
                }
                String fileLengthStr = valueStream.readUTF();
                long fileLength = Long.parseLong(fileLengthStr);
                writer.write("\n\nLogType:");
                writer.write(fileType);
                writer.write("\nLogLength:");
                writer.write(fileLengthStr);
                writer.write("\nLog Contents:\n");
                BoundedInputStream bis = new BoundedInputStream((InputStream)valueStream, fileLength);
                InputStreamReader reader = new InputStreamReader((InputStream)bis);
                int currentRead = 0;
                int totalRead = 0;
                while (true) {
                    if ((currentRead = reader.read(cbuf, 0, bufferSize)) == -1) continue block2;
                    writer.write(cbuf, 0, currentRead);
                    totalRead += currentRead;
                }
                break;
            }
        }

        public static void readAContainerLogsForALogType(DataInputStream valueStream, DataOutputStream out) throws IOException {
            byte[] buf = new byte[65535];
            String fileType = valueStream.readUTF();
            String fileLengthStr = valueStream.readUTF();
            long fileLength = Long.parseLong(fileLengthStr);
            out.writeUTF("\nLogType:");
            out.writeUTF(fileType);
            out.writeUTF("\nLogLength:");
            out.writeUTF(fileLengthStr);
            out.writeUTF("\nLog Contents:\n");
            int curRead = 0;
            long pendingRead = fileLength - (long)curRead;
            int toRead = pendingRead > (long)buf.length ? buf.length : (int)pendingRead;
            int len = valueStream.read(buf, 0, toRead);
            while (len != -1 && (long)curRead < fileLength) {
                out.write(buf, 0, len);
                pendingRead = fileLength - (long)(curRead += len);
                toRead = pendingRead > (long)buf.length ? buf.length : (int)pendingRead;
                len = valueStream.read(buf, 0, toRead);
            }
        }

        public void close() throws IOException {
            this.scanner.close();
            this.fsDataIStream.close();
        }
    }

    public static class LogWriter {
        private final FSDataOutputStream fsDataOStream;
        private final TFile.Writer writer;

        public LogWriter(final Configuration conf, final Path remoteAppLogFile, UserGroupInformation userUgi) throws IOException {
            try {
                this.fsDataOStream = (FSDataOutputStream)userUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FSDataOutputStream>(){

                    @Override
                    public FSDataOutputStream run() throws Exception {
                        return FileContext.getFileContext((Configuration)conf).create(remoteAppLogFile, EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE), new Options.CreateOpts[0]);
                    }
                });
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
            this.writer = new TFile.Writer(this.fsDataOStream, 262144, conf.get("yarn.nodemanager.log-aggregation.compression-type", "none"), null, conf);
            this.writeVersion();
        }

        private void writeVersion() throws IOException {
            DataOutputStream out = this.writer.prepareAppendKey(-1);
            VERSION_KEY.write(out);
            out.close();
            out = this.writer.prepareAppendValue(-1);
            out.writeInt(1);
            out.close();
            this.fsDataOStream.hflush();
        }

        public void writeApplicationOwner(String user) throws IOException {
            DataOutputStream out = this.writer.prepareAppendKey(-1);
            APPLICATION_OWNER_KEY.write(out);
            out.close();
            out = this.writer.prepareAppendValue(-1);
            out.writeUTF(user);
            out.close();
        }

        public void writeApplicationACLs(Map<ApplicationAccessType, String> appAcls) throws IOException {
            DataOutputStream out = this.writer.prepareAppendKey(-1);
            APPLICATION_ACL_KEY.write(out);
            out.close();
            out = this.writer.prepareAppendValue(-1);
            for (Map.Entry<ApplicationAccessType, String> entry : appAcls.entrySet()) {
                out.writeUTF(entry.getKey().toString());
                out.writeUTF(entry.getValue());
            }
            out.close();
        }

        public void append(LogKey logKey, LogValue logValue) throws IOException {
            DataOutputStream out = this.writer.prepareAppendKey(-1);
            logKey.write(out);
            out.close();
            out = this.writer.prepareAppendValue(-1);
            logValue.write(out);
            out.close();
            this.fsDataOStream.hflush();
        }

        public void closeWriter() {
            try {
                this.writer.close();
            }
            catch (IOException e) {
                LOG.warn((Object)"Exception closing writer", (Throwable)e);
            }
            try {
                this.fsDataOStream.close();
            }
            catch (IOException e) {
                LOG.warn((Object)"Exception closing output-stream", (Throwable)e);
            }
        }
    }

    public static class LogValue {
        private final List<String> rootLogDirs;
        private final ContainerId containerId;

        public LogValue(List<String> rootLogDirs, ContainerId containerId) {
            this.rootLogDirs = rootLogDirs;
            this.containerId = containerId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(DataOutputStream out) throws IOException {
            for (String rootLogDir : this.rootLogDirs) {
                File appLogDir = new File(rootLogDir, ConverterUtils.toString(this.containerId.getApplicationAttemptId().getApplicationId()));
                File containerLogDir = new File(appLogDir, ConverterUtils.toString(this.containerId));
                if (!containerLogDir.isDirectory()) continue;
                for (File logFile : containerLogDir.listFiles()) {
                    out.writeUTF(logFile.getName());
                    out.writeUTF(String.valueOf(logFile.length()));
                    FileInputStream in = null;
                    try {
                        in = new FileInputStream(logFile);
                        byte[] buf = new byte[65535];
                        int len = 0;
                        while ((len = in.read(buf)) != -1) {
                            out.write(buf, 0, len);
                        }
                    }
                    finally {
                        in.close();
                    }
                }
            }
        }
    }

    public static class LogKey
    implements Writable {
        private String keyString;

        public LogKey() {
        }

        public LogKey(ContainerId containerId) {
            this.keyString = containerId.toString();
        }

        public LogKey(String keyString) {
            this.keyString = keyString;
        }

        public void write(DataOutput out) throws IOException {
            out.writeUTF(this.keyString);
        }

        public void readFields(DataInput in) throws IOException {
            this.keyString = in.readUTF();
        }

        public String toString() {
            return this.keyString;
        }
    }
}

