/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.state;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.hadoop.yarn.state.InvalidStateTransitonException;
import org.apache.hadoop.yarn.state.MultipleArcTransition;
import org.apache.hadoop.yarn.state.SingleArcTransition;
import org.apache.hadoop.yarn.state.StateMachine;
import org.apache.hadoop.yarn.util.Graph;

public final class StateMachineFactory<OPERAND, STATE extends Enum<STATE>, EVENTTYPE extends Enum<EVENTTYPE>, EVENT> {
    private final TransitionsListNode transitionsListNode;
    private Map<STATE, Map<EVENTTYPE, Transition<OPERAND, STATE, EVENTTYPE, EVENT>>> stateMachineTable;
    private STATE defaultInitialState;
    private final boolean optimized;

    public StateMachineFactory(STATE defaultInitialState) {
        this.transitionsListNode = null;
        this.defaultInitialState = defaultInitialState;
        this.optimized = false;
        this.stateMachineTable = null;
    }

    private StateMachineFactory(StateMachineFactory<OPERAND, STATE, EVENTTYPE, EVENT> that, ApplicableTransition t) {
        this.defaultInitialState = that.defaultInitialState;
        this.transitionsListNode = new TransitionsListNode(t, that.transitionsListNode);
        this.optimized = false;
        this.stateMachineTable = null;
    }

    private StateMachineFactory(StateMachineFactory<OPERAND, STATE, EVENTTYPE, EVENT> that, boolean optimized) {
        this.defaultInitialState = that.defaultInitialState;
        this.transitionsListNode = that.transitionsListNode;
        this.optimized = optimized;
        if (optimized) {
            this.makeStateMachineTable();
        } else {
            this.stateMachineTable = null;
        }
    }

    public StateMachineFactory<OPERAND, STATE, EVENTTYPE, EVENT> addTransition(STATE preState, STATE postState, EVENTTYPE eventType) {
        return this.addTransition(preState, postState, eventType, null);
    }

    public StateMachineFactory<OPERAND, STATE, EVENTTYPE, EVENT> addTransition(STATE preState, STATE postState, Set<EVENTTYPE> eventTypes) {
        return this.addTransition(preState, postState, (EVENTTYPE)eventTypes, null);
    }

    public StateMachineFactory<OPERAND, STATE, EVENTTYPE, EVENT> addTransition(STATE preState, STATE postState, Set<EVENTTYPE> eventTypes, SingleArcTransition<OPERAND, EVENT> hook) {
        StateMachineFactory<OPERAND, STATE, Enum, EVENT> factory = null;
        for (Enum event : eventTypes) {
            if (factory == null) {
                factory = this.addTransition(preState, postState, event, hook);
                continue;
            }
            factory = factory.addTransition(preState, postState, event, hook);
        }
        return factory;
    }

    public StateMachineFactory<OPERAND, STATE, EVENTTYPE, EVENT> addTransition(STATE preState, STATE postState, EVENTTYPE eventType, SingleArcTransition<OPERAND, EVENT> hook) {
        return new StateMachineFactory<OPERAND, STATE, EVENTTYPE, EVENT>(this, new ApplicableSingleOrMultipleTransition(preState, eventType, new SingleInternalArc(this, postState, hook)));
    }

    public StateMachineFactory<OPERAND, STATE, EVENTTYPE, EVENT> addTransition(STATE preState, Set<STATE> postStates, EVENTTYPE eventType, MultipleArcTransition<OPERAND, EVENT, STATE> hook) {
        return new StateMachineFactory<OPERAND, STATE, EVENTTYPE, EVENT>(this, new ApplicableSingleOrMultipleTransition(preState, eventType, new MultipleInternalArc(postStates, hook)));
    }

    public StateMachineFactory<OPERAND, STATE, EVENTTYPE, EVENT> installTopology() {
        return new StateMachineFactory<OPERAND, STATE, EVENTTYPE, EVENT>(this, true);
    }

    private STATE doTransition(OPERAND operand, STATE oldState, EVENTTYPE eventType, EVENT event) throws InvalidStateTransitonException {
        Transition<OPERAND, STATE, EVENTTYPE, EVENT> transition;
        Map<EVENTTYPE, Transition<OPERAND, STATE, EVENTTYPE, EVENT>> transitionMap = this.stateMachineTable.get(oldState);
        if (transitionMap != null && (transition = transitionMap.get(eventType)) != null) {
            return transition.doTransition(operand, oldState, event, eventType);
        }
        throw new InvalidStateTransitonException((Enum<?>)oldState, (Enum<?>)eventType);
    }

    private synchronized void maybeMakeStateMachineTable() {
        if (this.stateMachineTable == null) {
            this.makeStateMachineTable();
        }
    }

    private void makeStateMachineTable() {
        Stack<ApplicableTransition> stack = new Stack<ApplicableTransition>();
        HashMap<STATE, Object> prototype = new HashMap<STATE, Object>();
        prototype.put(this.defaultInitialState, null);
        this.stateMachineTable = new EnumMap<STATE, Map<EVENTTYPE, Transition<OPERAND, STATE, EVENTTYPE, EVENT>>>(prototype);
        TransitionsListNode cursor = this.transitionsListNode;
        while (cursor != null) {
            stack.push(cursor.transition);
            cursor = cursor.next;
        }
        while (!stack.isEmpty()) {
            ((ApplicableTransition)stack.pop()).apply(this);
        }
    }

    public StateMachine<STATE, EVENTTYPE, EVENT> make(OPERAND operand, STATE initialState) {
        return new InternalStateMachine(this, operand, initialState);
    }

    public StateMachine<STATE, EVENTTYPE, EVENT> make(OPERAND operand) {
        return new InternalStateMachine(this, operand, this.defaultInitialState);
    }

    public Graph generateStateGraph(String name) {
        this.maybeMakeStateMachineTable();
        Graph g = new Graph(name);
        for (Enum startState : this.stateMachineTable.keySet()) {
            Map<EVENTTYPE, Transition<OPERAND, STATE, EVENTTYPE, EVENT>> transitions = this.stateMachineTable.get(startState);
            for (Map.Entry<EVENTTYPE, Transition<OPERAND, STATE, EVENTTYPE, EVENT>> entry : transitions.entrySet()) {
                Transition<OPERAND, STATE, EVENTTYPE, EVENT> transition = entry.getValue();
                if (transition instanceof SingleInternalArc) {
                    SingleInternalArc sa = (SingleInternalArc)transition;
                    Graph.Node fromNode = g.getNode(startState.toString());
                    Graph.Node toNode = g.getNode(sa.postState.toString());
                    fromNode.addEdge(toNode, ((Enum)entry.getKey()).toString());
                    continue;
                }
                if (!(transition instanceof MultipleInternalArc)) continue;
                MultipleInternalArc ma = (MultipleInternalArc)transition;
                Iterator iter = ma.validPostStates.iterator();
                while (iter.hasNext()) {
                    Graph.Node fromNode = g.getNode(startState.toString());
                    Graph.Node toNode = g.getNode(((Enum)iter.next()).toString());
                    fromNode.addEdge(toNode, ((Enum)entry.getKey()).toString());
                }
            }
        }
        return g;
    }

    private static class InternalStateMachine
    implements StateMachine<STATE, EVENTTYPE, EVENT> {
        private final OPERAND operand;
        private STATE currentState;
        final /* synthetic */ StateMachineFactory this$0;

        InternalStateMachine(OPERAND operand, STATE initialState) {
            this.this$0 = var1_1;
            this.operand = operand;
            this.currentState = initialState;
            if (!((StateMachineFactory)var1_1).optimized) {
                ((StateMachineFactory)var1_1).maybeMakeStateMachineTable();
            }
        }

        @Override
        public synchronized STATE getCurrentState() {
            return this.currentState;
        }

        @Override
        public synchronized STATE doTransition(EVENTTYPE eventType, EVENT event) throws InvalidStateTransitonException {
            this.currentState = this.this$0.doTransition(this.operand, this.currentState, eventType, event);
            return this.currentState;
        }
    }

    private class MultipleInternalArc
    implements Transition<OPERAND, STATE, EVENTTYPE, EVENT> {
        private Set<STATE> validPostStates;
        private MultipleArcTransition<OPERAND, EVENT, STATE> hook;

        MultipleInternalArc(Set<STATE> postStates, MultipleArcTransition<OPERAND, EVENT, STATE> hook) {
            this.validPostStates = postStates;
            this.hook = hook;
        }

        @Override
        public STATE doTransition(OPERAND operand, STATE oldState, EVENT event, EVENTTYPE eventType) throws InvalidStateTransitonException {
            Object postState = this.hook.transition(operand, event);
            if (!this.validPostStates.contains(postState)) {
                throw new InvalidStateTransitonException((Enum<?>)oldState, (Enum<?>)eventType);
            }
            return postState;
        }
    }

    private static class SingleInternalArc
    implements Transition<OPERAND, STATE, EVENTTYPE, EVENT> {
        private STATE postState;
        private SingleArcTransition<OPERAND, EVENT> hook;
        final /* synthetic */ StateMachineFactory this$0;

        SingleInternalArc(STATE postState, SingleArcTransition<OPERAND, EVENT> hook) {
            this.this$0 = var1_1;
            this.postState = postState;
            this.hook = hook;
        }

        @Override
        public STATE doTransition(OPERAND operand, STATE oldState, EVENT event, EVENTTYPE eventType) {
            if (this.hook != null) {
                this.hook.transition(operand, event);
            }
            return this.postState;
        }
    }

    private static interface Transition<OPERAND, STATE extends Enum<STATE>, EVENTTYPE extends Enum<EVENTTYPE>, EVENT> {
        public STATE doTransition(OPERAND var1, STATE var2, EVENT var3, EVENTTYPE var4);
    }

    private static class ApplicableSingleOrMultipleTransition<OPERAND, STATE extends Enum<STATE>, EVENTTYPE extends Enum<EVENTTYPE>, EVENT>
    implements ApplicableTransition<OPERAND, STATE, EVENTTYPE, EVENT> {
        final STATE preState;
        final EVENTTYPE eventType;
        final Transition<OPERAND, STATE, EVENTTYPE, EVENT> transition;

        ApplicableSingleOrMultipleTransition(STATE preState, EVENTTYPE eventType, Transition<OPERAND, STATE, EVENTTYPE, EVENT> transition) {
            this.preState = preState;
            this.eventType = eventType;
            this.transition = transition;
        }

        @Override
        public void apply(StateMachineFactory<OPERAND, STATE, EVENTTYPE, EVENT> subject) {
            HashMap<EVENTTYPE, Transition<OPERAND, STATE, EVENTTYPE, EVENT>> transitionMap = (HashMap<EVENTTYPE, Transition<OPERAND, STATE, EVENTTYPE, EVENT>>)((StateMachineFactory)subject).stateMachineTable.get(this.preState);
            if (transitionMap == null) {
                transitionMap = new HashMap<EVENTTYPE, Transition<OPERAND, STATE, EVENTTYPE, EVENT>>();
                ((StateMachineFactory)subject).stateMachineTable.put(this.preState, transitionMap);
            }
            transitionMap.put(this.eventType, this.transition);
        }
    }

    private class TransitionsListNode {
        final ApplicableTransition transition;
        final TransitionsListNode next;

        TransitionsListNode(ApplicableTransition transition, TransitionsListNode next) {
            this.transition = transition;
            this.next = next;
        }
    }

    private static interface ApplicableTransition<OPERAND, STATE extends Enum<STATE>, EVENTTYPE extends Enum<EVENTTYPE>, EVENT> {
        public void apply(StateMachineFactory<OPERAND, STATE, EVENTTYPE, EVENT> var1);
    }
}

