/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.factory.providers;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.YarnException;
import org.apache.hadoop.yarn.factories.YarnRemoteExceptionFactory;
import org.apache.hadoop.yarn.factories.impl.pb.YarnRemoteExceptionFactoryPBImpl;

public class YarnRemoteExceptionFactoryProvider {
    private YarnRemoteExceptionFactoryProvider() {
    }

    public static YarnRemoteExceptionFactory getYarnRemoteExceptionFactory(Configuration conf) {
        String recordFactoryClassName;
        if (conf == null) {
            conf = new Configuration();
        }
        if ((recordFactoryClassName = conf.get("yarn.ipc.exception.factory.class")) == null) {
            String serializer = conf.get("yarn.ipc.serializer.type", "protocolbuffers");
            if (serializer.equals("protocolbuffers")) {
                return YarnRemoteExceptionFactoryPBImpl.get();
            }
            throw new YarnException("Unknown serializer: [" + conf.get("yarn.ipc.serializer.type") + "]. Use keys: [" + "yarn.ipc.exception.factory.class" + "] to specify Exception factory");
        }
        return (YarnRemoteExceptionFactory)YarnRemoteExceptionFactoryProvider.getFactoryClassInstance(recordFactoryClassName);
    }

    private static Object getFactoryClassInstance(String factoryClassName) {
        try {
            Class<?> clazz = Class.forName(factoryClassName);
            Method method = clazz.getMethod("get", null);
            method.setAccessible(true);
            return method.invoke(null, null);
        }
        catch (ClassNotFoundException e) {
            throw new YarnException(e);
        }
        catch (NoSuchMethodException e) {
            throw new YarnException(e);
        }
        catch (InvocationTargetException e) {
            throw new YarnException(e);
        }
        catch (IllegalAccessException e) {
            throw new YarnException(e);
        }
    }
}

