/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.logaggregation;

import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.yarn.logaggregation.LogAggregationUtils;
import org.apache.hadoop.yarn.service.AbstractService;

public class AggregatedLogDeletionService
extends AbstractService {
    private static final Log LOG = LogFactory.getLog(AggregatedLogDeletionService.class);
    private Timer timer = null;

    private static void logIOException(String comment, IOException e) {
        if (e instanceof AccessControlException) {
            String message = e.getMessage();
            message = message.split("\n")[0];
            LOG.warn((Object)(comment + " " + message));
        } else {
            LOG.error((Object)comment, (Throwable)e);
        }
    }

    public AggregatedLogDeletionService() {
        super(AggregatedLogDeletionService.class.getName());
    }

    @Override
    public void start() {
        Configuration conf = this.getConfig();
        if (!conf.getBoolean("yarn.log-aggregation-enable", false)) {
            return;
        }
        long retentionSecs = conf.getLong("yarn.log-aggregation.retain-seconds", -1L);
        if (retentionSecs < 0L) {
            LOG.info((Object)("Log Aggregation deletion is disabled because retention is too small (" + retentionSecs + ")"));
            return;
        }
        long checkIntervalMsecs = 1000L * conf.getLong("yarn.log-aggregation.retain-check-interval-seconds", -1L);
        if (checkIntervalMsecs <= 0L) {
            checkIntervalMsecs = retentionSecs * 1000L / 10L;
        }
        LogDeletionTask task = new LogDeletionTask(conf, retentionSecs);
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate((TimerTask)task, 0L, checkIntervalMsecs);
        super.start();
    }

    @Override
    public void stop() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        super.stop();
    }

    static class LogDeletionTask
    extends TimerTask {
        private Configuration conf;
        private long retentionMillis;
        private String suffix = null;
        private Path remoteRootLogDir = null;

        public LogDeletionTask(Configuration conf, long retentionSecs) {
            this.conf = conf;
            this.retentionMillis = retentionSecs * 1000L;
            this.suffix = LogAggregationUtils.getRemoteNodeLogDirSuffix(conf);
            this.remoteRootLogDir = new Path(conf.get("yarn.nodemanager.remote-app-log-dir", "/tmp/logs"));
        }

        @Override
        public void run() {
            long cutoffMillis = System.currentTimeMillis() - this.retentionMillis;
            LOG.info((Object)"aggregated log deletion started.");
            try {
                FileSystem fs = this.remoteRootLogDir.getFileSystem(this.conf);
                for (FileStatus userDir : fs.listStatus(this.remoteRootLogDir)) {
                    if (!userDir.isDirectory()) continue;
                    Path userDirPath = new Path(userDir.getPath(), this.suffix);
                    LogDeletionTask.deleteOldLogDirsFrom(userDirPath, cutoffMillis, fs);
                }
            }
            catch (IOException e) {
                AggregatedLogDeletionService.logIOException("Error reading root log dir this deletion attempt is being aborted", e);
            }
            LOG.info((Object)"aggregated log deletion finished.");
        }

        private static void deleteOldLogDirsFrom(Path dir, long cutoffMillis, FileSystem fs) {
            try {
                for (FileStatus appDir : fs.listStatus(dir)) {
                    if (!appDir.isDirectory() || appDir.getModificationTime() >= cutoffMillis || !LogDeletionTask.shouldDeleteLogDir(appDir, cutoffMillis, fs)) continue;
                    try {
                        LOG.info((Object)("Deleting aggregated logs in " + appDir.getPath()));
                        fs.delete(appDir.getPath(), true);
                    }
                    catch (IOException e) {
                        AggregatedLogDeletionService.logIOException("Could not delete " + appDir.getPath(), e);
                    }
                }
            }
            catch (IOException e) {
                AggregatedLogDeletionService.logIOException("Could not read the contents of " + dir, e);
            }
        }

        private static boolean shouldDeleteLogDir(FileStatus dir, long cutoffMillis, FileSystem fs) {
            boolean shouldDelete = true;
            try {
                for (FileStatus node : fs.listStatus(dir.getPath())) {
                    if (node.getModificationTime() < cutoffMillis) continue;
                    shouldDelete = false;
                    break;
                }
            }
            catch (IOException e) {
                AggregatedLogDeletionService.logIOException("Error reading the contents of " + dir.getPath(), e);
                shouldDelete = false;
            }
            return shouldDelete;
        }
    }
}

