/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.security.client;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ClientToAMTokenIdentifier
extends TokenIdentifier {
    public static final Text KIND_NAME = new Text("YARN_CLIENT_TOKEN");
    private ApplicationAttemptId applicationAttemptId;

    public ClientToAMTokenIdentifier() {
    }

    public ClientToAMTokenIdentifier(ApplicationAttemptId id) {
        this();
        this.applicationAttemptId = id;
    }

    public ApplicationAttemptId getApplicationAttemptID() {
        return this.applicationAttemptId;
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.applicationAttemptId.getApplicationId().getClusterTimestamp());
        out.writeInt(this.applicationAttemptId.getApplicationId().getId());
        out.writeInt(this.applicationAttemptId.getAttemptId());
    }

    public void readFields(DataInput in) throws IOException {
        this.applicationAttemptId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)in.readLong(), (int)in.readInt()), (int)in.readInt());
    }

    public Text getKind() {
        return KIND_NAME;
    }

    public UserGroupInformation getUser() {
        if (this.applicationAttemptId == null) {
            return null;
        }
        return UserGroupInformation.createRemoteUser((String)this.applicationAttemptId.toString());
    }

    @InterfaceAudience.Private
    public static class Renewer
    extends Token.TrivialRenewer {
        protected Text getKind() {
            return KIND_NAME;
        }
    }
}

