/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.nodelabels;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.hadoop.yarn.api.records.NodeAttribute;
import org.apache.hadoop.yarn.api.records.NodeAttributeKey;

public final class NodeLabelUtil {
    private static final int MAX_LABEL_LENGTH = 255;
    private static final Pattern LABEL_OR_VALUE_PATTERN = Pattern.compile("^[0-9a-zA-Z][0-9a-zA-Z-_]*");
    private static final Pattern PREFIX_PATTERN = Pattern.compile("^[0-9a-zA-Z][0-9a-zA-Z-_\\.]*");
    private static final Pattern ATTRIBUTE_VALUE_PATTERN = Pattern.compile("^[0-9a-zA-Z][0-9a-zA-Z-_.]*");

    private NodeLabelUtil() {
    }

    public static void checkAndThrowLabelName(String label) throws IOException {
        if (label == null || label.isEmpty() || label.length() > 255) {
            throw new IOException("label added is empty or exceeds 255 character(s)");
        }
        boolean match = LABEL_OR_VALUE_PATTERN.matcher(label = label.trim()).matches();
        if (!match) {
            throw new IOException("label name should only contains {0-9, a-z, A-Z, -, _} and should not started with {-,_}, now it is= " + label);
        }
    }

    public static void checkAndThrowAttributeValue(String value) throws IOException {
        if (value == null) {
            return;
        }
        if (value.trim().length() > 255) {
            throw new IOException("Attribute value added exceeds 255 character(s)");
        }
        if ((value = value.trim()).isEmpty()) {
            return;
        }
        boolean match = ATTRIBUTE_VALUE_PATTERN.matcher(value).matches();
        if (!match) {
            throw new IOException("attribute value should only contains {0-9, a-z, A-Z, -, _} and should not started with {-,_}, now it is= " + value);
        }
    }

    public static void checkAndThrowAttributePrefix(String prefix) throws IOException {
        if (prefix == null) {
            throw new IOException("Attribute prefix cannot be null.");
        }
        if (prefix.trim().length() > 255) {
            throw new IOException("Attribute value added exceeds 255 character(s)");
        }
        if ((prefix = prefix.trim()).isEmpty()) {
            return;
        }
        boolean match = PREFIX_PATTERN.matcher(prefix).matches();
        if (!match) {
            throw new IOException("attribute value should only contains {0-9, a-z, A-Z, -, _,.} and should not started with {-,_}, now it is= " + prefix);
        }
    }

    public static void validateNodeAttributes(Set<NodeAttribute> attributeSet) throws IOException {
        if (attributeSet != null && !attributeSet.isEmpty()) {
            for (NodeAttribute nodeAttribute : attributeSet) {
                NodeAttributeKey attributeKey = nodeAttribute.getAttributeKey();
                if (attributeKey == null) {
                    throw new IOException("AttributeKey  must be set");
                }
                String prefix = attributeKey.getAttributePrefix();
                if (Strings.isNullOrEmpty((String)prefix)) {
                    throw new IOException("Attribute prefix must be set");
                }
                NodeLabelUtil.checkAndThrowAttributePrefix(prefix);
                NodeLabelUtil.checkAndThrowLabelName(attributeKey.getAttributeName());
            }
        }
    }

    public static Set<NodeAttribute> filterAttributesByPrefix(Set<NodeAttribute> attributeSet, String prefix) {
        if (Strings.isNullOrEmpty((String)prefix)) {
            return attributeSet;
        }
        return attributeSet.stream().filter(nodeAttribute -> prefix.equals(nodeAttribute.getAttributeKey().getAttributePrefix())).collect(Collectors.toSet());
    }
}

