/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.logaggregation;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.commons.io.output.WriterOutputStream;
import org.apache.commons.math3.util.Pair;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FutureDataInputStreamBuilder;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.protocol.DSQuotaExceededException;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.SecureIOUtils;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.file.tfile.TFile;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.thirdparty.com.google.common.collect.Iterables;
import org.apache.hadoop.thirdparty.com.google.common.collect.Sets;
import org.apache.hadoop.util.functional.FutureIO;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.LogAggregationContext;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.util.Times;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class AggregatedLogFormat {
    private static final Logger LOG = LoggerFactory.getLogger(AggregatedLogFormat.class);
    private static final LogKey APPLICATION_ACL_KEY = new LogKey("APPLICATION_ACL");
    private static final LogKey APPLICATION_OWNER_KEY = new LogKey("APPLICATION_OWNER");
    private static final LogKey VERSION_KEY = new LogKey("VERSION");
    private static final Map<String, LogKey> RESERVED_KEYS;
    private static final int VERSION = 1;
    private static final FsPermission APP_LOG_FILE_UMASK;

    static {
        APP_LOG_FILE_UMASK = FsPermission.createImmutable((short)95);
        RESERVED_KEYS = new HashMap<String, LogKey>();
        RESERVED_KEYS.put(APPLICATION_ACL_KEY.toString(), APPLICATION_ACL_KEY);
        RESERVED_KEYS.put(APPLICATION_OWNER_KEY.toString(), APPLICATION_OWNER_KEY);
        RESERVED_KEYS.put(VERSION_KEY.toString(), VERSION_KEY);
    }

    @InterfaceAudience.Private
    public static class ContainerLogsReader
    extends InputStream {
        private DataInputStream valueStream;
        private String currentLogType = null;
        private long currentLogLength = 0L;
        private BoundedInputStream currentLogData = null;
        private InputStreamReader currentLogISR;

        public ContainerLogsReader(DataInputStream stream) {
            this.valueStream = stream;
        }

        public String nextLog() throws IOException {
            if (this.currentLogData != null && this.currentLogLength > 0L) {
                while (this.currentLogData.skip(this.currentLogLength) >= 0L && this.currentLogData.read() != -1) {
                }
            }
            this.currentLogType = null;
            this.currentLogLength = 0L;
            this.currentLogData = null;
            this.currentLogISR = null;
            try {
                String logType = this.valueStream.readUTF();
                String logLengthStr = this.valueStream.readUTF();
                this.currentLogLength = Long.parseLong(logLengthStr);
                this.currentLogData = new BoundedInputStream((InputStream)this.valueStream, this.currentLogLength);
                this.currentLogData.setPropagateClose(false);
                this.currentLogISR = new InputStreamReader((InputStream)this.currentLogData, Charset.forName("UTF-8"));
                this.currentLogType = logType;
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
            return this.currentLogType;
        }

        public String getCurrentLogType() {
            return this.currentLogType;
        }

        public long getCurrentLogLength() {
            return this.currentLogLength;
        }

        @Override
        public long skip(long n) throws IOException {
            return this.currentLogData.skip(n);
        }

        @Override
        public int read() throws IOException {
            return this.currentLogData.read();
        }

        @Override
        public int read(byte[] buf, int off, int len) throws IOException {
            return this.currentLogData.read(buf, off, len);
        }

        public int read(char[] buf, int off, int len) throws IOException {
            return this.currentLogISR.read(buf, off, len);
        }
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static class LogReader {
        private final FSDataInputStream fsDataIStream;
        private final TFile.Reader.Scanner scanner;
        private final TFile.Reader reader;
        private boolean atBeginning = true;

        public LogReader(Configuration conf, Path remoteAppLogFile) throws IOException {
            try {
                FileContext fileContext = FileContext.getFileContext((URI)remoteAppLogFile.toUri(), (Configuration)conf);
                FileStatus status = fileContext.getFileStatus(remoteAppLogFile);
                this.fsDataIStream = (FSDataInputStream)FutureIO.awaitFuture((Future)((FutureDataInputStreamBuilder)((FutureDataInputStreamBuilder)fileContext.openFile(remoteAppLogFile).opt("fs.option.openfile.read.policy", "sequential")).opt("fs.option.openfile.length", status.getLen())).build());
                this.reader = new TFile.Reader(this.fsDataIStream, status.getLen(), conf);
                this.scanner = this.reader.createScanner();
            }
            catch (IOException ioe) {
                this.close();
                throw new IOException("Error in creating LogReader", ioe);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public String getApplicationOwner() throws IOException {
            String string;
            TFile.Reader.Scanner ownerScanner;
            block5: {
                String string2;
                ownerScanner = null;
                try {
                    ownerScanner = this.reader.createScanner();
                    LogKey key = new LogKey();
                    while (!ownerScanner.atEnd()) {
                        TFile.Reader.Scanner.Entry entry = ownerScanner.entry();
                        key.readFields(entry.getKeyStream());
                        if (key.toString().equals(APPLICATION_OWNER_KEY.toString())) {
                            DataInputStream valueStream = entry.getValueStream();
                            string = valueStream.readUTF();
                            break block5;
                        }
                        ownerScanner.advance();
                    }
                    string2 = null;
                }
                catch (Throwable throwable) {
                    IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{ownerScanner});
                    throw throwable;
                }
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{ownerScanner});
                return string2;
            }
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{ownerScanner});
            return string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map<ApplicationAccessType, String> getApplicationAcls() throws IOException {
            HashMap<ApplicationAccessType, String> hashMap;
            TFile.Reader.Scanner aclScanner = null;
            try {
                aclScanner = this.reader.createScanner();
                LogKey key = new LogKey();
                HashMap<ApplicationAccessType, String> acls = new HashMap<ApplicationAccessType, String>();
                while (!aclScanner.atEnd()) {
                    TFile.Reader.Scanner.Entry entry = aclScanner.entry();
                    key.readFields(entry.getKeyStream());
                    if (key.toString().equals(APPLICATION_ACL_KEY.toString())) {
                        DataInputStream valueStream = entry.getValueStream();
                        while (true) {
                            String appAccessOp = null;
                            String aclString = null;
                            try {
                                appAccessOp = valueStream.readUTF();
                            }
                            catch (EOFException e) {
                                break;
                            }
                            try {
                                aclString = valueStream.readUTF();
                            }
                            catch (EOFException e) {
                                throw new YarnRuntimeException("Error reading ACLs", (Throwable)e);
                            }
                            acls.put(ApplicationAccessType.valueOf((String)appAccessOp), aclString);
                        }
                    }
                    aclScanner.advance();
                }
                hashMap = acls;
            }
            catch (Throwable throwable) {
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{aclScanner});
                throw throwable;
            }
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{aclScanner});
            return hashMap;
        }

        public DataInputStream next(LogKey key) throws IOException {
            if (!this.atBeginning) {
                this.scanner.advance();
            } else {
                this.atBeginning = false;
            }
            if (this.scanner.atEnd()) {
                return null;
            }
            TFile.Reader.Scanner.Entry entry = this.scanner.entry();
            key.readFields(entry.getKeyStream());
            if (RESERVED_KEYS.containsKey(key.toString())) {
                return this.next(key);
            }
            DataInputStream valueStream = entry.getValueStream();
            return valueStream;
        }

        @InterfaceAudience.Private
        public ContainerLogsReader getContainerLogsReader(ContainerId containerId) throws IOException {
            ContainerLogsReader logReader = null;
            LogKey containerKey = new LogKey(containerId);
            LogKey key = new LogKey();
            DataInputStream valueStream = this.next(key);
            while (valueStream != null && !key.equals(containerKey)) {
                valueStream = this.next(key);
            }
            if (valueStream != null) {
                logReader = new ContainerLogsReader(valueStream);
            }
            return logReader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void readAcontainerLogs(DataInputStream valueStream, Writer writer, long logUploadedTime) throws IOException {
            WriterOutputStream os = null;
            PrintStream ps = null;
            try {
                os = new WriterOutputStream(writer, Charset.forName("UTF-8"));
                ps = new PrintStream((OutputStream)os);
                try {
                    while (true) {
                        LogReader.readContainerLogs(valueStream, ps, logUploadedTime, Long.MAX_VALUE);
                    }
                }
                catch (EOFException e) {
                    IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{ps, os});
                    return;
                }
            }
            catch (Throwable throwable) {
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{ps, os});
                throw throwable;
            }
        }

        public static void readAcontainerLogs(DataInputStream valueStream, Writer writer) throws IOException {
            LogReader.readAcontainerLogs(valueStream, writer, -1L);
        }

        private static void readContainerLogs(DataInputStream valueStream, PrintStream out, long logUploadedTime, long bytes) throws IOException {
            byte[] buf = new byte[65535];
            String fileType = valueStream.readUTF();
            String fileLengthStr = valueStream.readUTF();
            long fileLength = Long.parseLong(fileLengthStr);
            out.print("LogType:");
            out.println(fileType);
            if (logUploadedTime != -1L) {
                out.print("Log Upload Time:");
                out.println(Times.format(logUploadedTime));
            }
            out.print("LogLength:");
            out.println(fileLengthStr);
            out.println("Log Contents:");
            long toSkip = 0L;
            long totalBytesToRead = fileLength;
            long skipAfterRead = 0L;
            if (bytes < 0L) {
                long absBytes = Math.abs(bytes);
                if (absBytes < fileLength) {
                    toSkip = fileLength - absBytes;
                    totalBytesToRead = absBytes;
                }
                IOUtils.skipFully((InputStream)valueStream, (long)toSkip);
            } else if (bytes < fileLength) {
                totalBytesToRead = bytes;
                skipAfterRead = fileLength - bytes;
            }
            long curRead = 0L;
            long pendingRead = totalBytesToRead - curRead;
            int toRead = pendingRead > (long)buf.length ? buf.length : (int)pendingRead;
            int len = valueStream.read(buf, 0, toRead);
            while (len != -1 && curRead < totalBytesToRead) {
                out.write(buf, 0, len);
                pendingRead = totalBytesToRead - (curRead += (long)len);
                toRead = pendingRead > (long)buf.length ? buf.length : (int)pendingRead;
                len = valueStream.read(buf, 0, toRead);
            }
            IOUtils.skipFully((InputStream)valueStream, (long)skipAfterRead);
            out.println("\nEnd of LogType:" + fileType);
            out.println("");
        }

        public static void readAContainerLogsForALogType(DataInputStream valueStream, PrintStream out, long logUploadedTime) throws IOException {
            LogReader.readContainerLogs(valueStream, out, logUploadedTime, Long.MAX_VALUE);
        }

        public static void readAContainerLogsForALogType(DataInputStream valueStream, PrintStream out, long logUploadedTime, long bytes) throws IOException {
            LogReader.readContainerLogs(valueStream, out, logUploadedTime, bytes);
        }

        public static void readAContainerLogsForALogType(DataInputStream valueStream, PrintStream out) throws IOException {
            LogReader.readAContainerLogsForALogType(valueStream, out, -1L);
        }

        public static int readContainerLogsForALogType(DataInputStream valueStream, PrintStream out, long logUploadedTime, List<String> logType) throws IOException {
            return LogReader.readContainerLogsForALogType(valueStream, out, logUploadedTime, logType, Long.MAX_VALUE);
        }

        public static int readContainerLogsForALogType(DataInputStream valueStream, PrintStream out, long logUploadedTime, List<String> logType, long bytes) throws IOException {
            byte[] buf = new byte[65535];
            String fileType = valueStream.readUTF();
            String fileLengthStr = valueStream.readUTF();
            long fileLength = Long.parseLong(fileLengthStr);
            if (logType.contains(fileType)) {
                out.print("LogType:");
                out.println(fileType);
                if (logUploadedTime != -1L) {
                    out.print("Log Upload Time:");
                    out.println(Times.format(logUploadedTime));
                }
                out.print("LogLength:");
                out.println(fileLengthStr);
                out.println("Log Contents:");
                long toSkip = 0L;
                long totalBytesToRead = fileLength;
                long skipAfterRead = 0L;
                if (bytes < 0L) {
                    long absBytes = Math.abs(bytes);
                    if (absBytes < fileLength) {
                        toSkip = fileLength - absBytes;
                        totalBytesToRead = absBytes;
                    }
                    IOUtils.skipFully((InputStream)valueStream, (long)toSkip);
                } else if (bytes < fileLength) {
                    totalBytesToRead = bytes;
                    skipAfterRead = fileLength - bytes;
                }
                long curRead = 0L;
                long pendingRead = totalBytesToRead - curRead;
                int toRead = pendingRead > (long)buf.length ? buf.length : (int)pendingRead;
                int len = valueStream.read(buf, 0, toRead);
                while (len != -1 && curRead < totalBytesToRead) {
                    out.write(buf, 0, len);
                    pendingRead = totalBytesToRead - (curRead += (long)len);
                    toRead = pendingRead > (long)buf.length ? buf.length : (int)pendingRead;
                    len = valueStream.read(buf, 0, toRead);
                }
                IOUtils.skipFully((InputStream)valueStream, (long)skipAfterRead);
                out.println("\nEnd of LogType:" + fileType);
                out.println("");
                return 0;
            }
            long currSkipped = 0L;
            for (long totalSkipped = 0L; currSkipped != -1L && totalSkipped < fileLength; totalSkipped += currSkipped) {
                currSkipped = valueStream.skip(fileLength - totalSkipped);
            }
            return -1;
        }

        @InterfaceAudience.Private
        public static Pair<String, String> readContainerMetaDataAndSkipData(DataInputStream valueStream) throws IOException {
            String fileType = valueStream.readUTF();
            String fileLengthStr = valueStream.readUTF();
            long fileLength = Long.parseLong(fileLengthStr);
            Pair logMeta = new Pair((Object)fileType, (Object)fileLengthStr);
            long currSkipped = 0L;
            for (long totalSkipped = 0L; currSkipped != -1L && totalSkipped < fileLength; totalSkipped += currSkipped) {
                currSkipped = valueStream.skip(fileLength - totalSkipped);
            }
            return logMeta;
        }

        public void close() {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.scanner, this.reader, this.fsDataIStream});
        }
    }

    @InterfaceAudience.Private
    public static class LogWriter
    implements AutoCloseable {
        private FSDataOutputStream fsDataOStream;
        private TFile.Writer writer;
        private FileContext fc;

        public void initialize(final Configuration conf, final Path remoteAppLogFile, UserGroupInformation userUgi) throws IOException {
            try {
                this.fsDataOStream = (FSDataOutputStream)userUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FSDataOutputStream>(){

                    @Override
                    public FSDataOutputStream run() throws Exception {
                        fc = FileContext.getFileContext((URI)remoteAppLogFile.toUri(), (Configuration)conf);
                        fc.setUMask(APP_LOG_FILE_UMASK);
                        return fc.create(remoteAppLogFile, EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE), new Options.CreateOpts[0]);
                    }
                });
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
            this.writer = new TFile.Writer(this.fsDataOStream, 262144, conf.get("yarn.nodemanager.log-aggregation.compression-type", "none"), null, conf);
            this.writeVersion();
        }

        @VisibleForTesting
        public TFile.Writer getWriter() {
            return this.writer;
        }

        private void writeVersion() throws IOException {
            try (DataOutputStream out = this.writer.prepareAppendKey(-1);){
                VERSION_KEY.write(out);
            }
            out = this.writer.prepareAppendValue(-1);
            var2_2 = null;
            try {
                out.writeInt(1);
            }
            catch (Throwable throwable) {
                var2_2 = throwable;
                throw throwable;
            }
            finally {
                if (out != null) {
                    if (var2_2 != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable) {
                            var2_2.addSuppressed(throwable);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }

        public void writeApplicationOwner(String user) throws IOException {
            try (DataOutputStream out = this.writer.prepareAppendKey(-1);){
                APPLICATION_OWNER_KEY.write(out);
            }
            out = this.writer.prepareAppendValue(-1);
            var3_3 = null;
            try {
                out.writeUTF(user);
            }
            catch (Throwable throwable) {
                var3_3 = throwable;
                throw throwable;
            }
            finally {
                if (out != null) {
                    if (var3_3 != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable) {
                            var3_3.addSuppressed(throwable);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }

        public void writeApplicationACLs(Map<ApplicationAccessType, String> appAcls) throws IOException {
            try (DataOutputStream out = this.writer.prepareAppendKey(-1);){
                APPLICATION_ACL_KEY.write(out);
            }
            out = this.writer.prepareAppendValue(-1);
            var3_3 = null;
            try {
                for (Map.Entry<ApplicationAccessType, String> entry : appAcls.entrySet()) {
                    out.writeUTF(entry.getKey().toString());
                    out.writeUTF(entry.getValue());
                }
            }
            catch (Throwable throwable) {
                var3_3 = throwable;
                throw throwable;
            }
            finally {
                if (out != null) {
                    if (var3_3 != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable) {
                            var3_3.addSuppressed(throwable);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }

        public void append(LogKey logKey, LogValue logValue) throws IOException {
            Set<File> pendingUploadFiles = logValue.getPendingLogFilesToUploadForThisContainer();
            if (pendingUploadFiles.size() == 0) {
                return;
            }
            try (DataOutputStream out = this.writer.prepareAppendKey(-1);){
                logKey.write(out);
            }
            out = this.writer.prepareAppendValue(-1);
            var5_5 = null;
            try {
                logValue.write(out, pendingUploadFiles);
            }
            catch (Throwable throwable) {
                var5_5 = throwable;
                throw throwable;
            }
            finally {
                if (out != null) {
                    if (var5_5 != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable) {
                            var5_5.addSuppressed(throwable);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }

        @Override
        public void close() throws DSQuotaExceededException {
            try {
                if (this.writer != null) {
                    this.writer.close();
                }
            }
            catch (Exception e) {
                LOG.warn("Exception closing writer", (Throwable)e);
            }
            finally {
                try {
                    this.fsDataOStream.close();
                }
                catch (DSQuotaExceededException e) {
                    LOG.error("Exception in closing {}", this.fsDataOStream.getClass(), (Object)e);
                    throw e;
                }
                catch (Throwable e) {
                    LOG.error("Exception in closing {}", this.fsDataOStream.getClass(), (Object)e);
                }
            }
        }
    }

    public static class LogRetentionContext {
        private final long logInitedTimeMillis;
        private final long logRetentionMillis;

        public LogRetentionContext(long logInitedTimeMillis, long logRetentionMillis) {
            this.logInitedTimeMillis = logInitedTimeMillis;
            this.logRetentionMillis = logRetentionMillis;
        }

        public boolean isDisabled() {
            return this.logInitedTimeMillis < 0L || this.logRetentionMillis < 0L;
        }

        public boolean shouldRetainLog() {
            return this.isDisabled() || System.currentTimeMillis() - this.logInitedTimeMillis < this.logRetentionMillis;
        }
    }

    @InterfaceAudience.Private
    public static class LogValue {
        private final List<String> rootLogDirs;
        private final ContainerId containerId;
        private final String user;
        private final LogAggregationContext logAggregationContext;
        private Set<File> uploadedFiles = new HashSet<File>();
        private final Set<String> alreadyUploadedLogFiles;
        private Set<String> allExistingFileMeta = new HashSet<String>();
        private final boolean appFinished;
        private final boolean containerFinished;
        private final LogRetentionContext logRetentionContext;
        private final Set<File> obsoleteRetentionLogFiles = new HashSet<File>();

        public LogValue(List<String> rootLogDirs, ContainerId containerId, String user) {
            this(rootLogDirs, containerId, user, null, new HashSet<String>(), null, true, true);
        }

        public LogValue(List<String> rootLogDirs, ContainerId containerId, String user, LogAggregationContext logAggregationContext, Set<String> alreadyUploadedLogFiles, LogRetentionContext retentionContext, boolean appFinished, boolean containerFinished) {
            this.rootLogDirs = new ArrayList<String>(rootLogDirs);
            this.containerId = containerId;
            this.user = user;
            Collections.sort(this.rootLogDirs);
            this.logAggregationContext = logAggregationContext;
            this.alreadyUploadedLogFiles = alreadyUploadedLogFiles;
            this.appFinished = appFinished;
            this.containerFinished = containerFinished;
            this.logRetentionContext = retentionContext;
        }

        @VisibleForTesting
        public Set<File> getPendingLogFilesToUploadForThisContainer() {
            HashSet<File> pendingUploadFiles = new HashSet<File>();
            for (String rootLogDir : this.rootLogDirs) {
                File appLogDir = new File(rootLogDir, this.containerId.getApplicationAttemptId().getApplicationId().toString());
                File containerLogDir = new File(appLogDir, this.containerId.toString());
                if (!containerLogDir.isDirectory()) continue;
                pendingUploadFiles.addAll(this.getPendingLogFilesToUpload(containerLogDir));
            }
            return pendingUploadFiles;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(DataOutputStream out, Set<File> pendingUploadFiles) throws IOException {
            ArrayList<File> fileList = new ArrayList<File>(pendingUploadFiles);
            Collections.sort(fileList);
            for (File logFile : fileList) {
                if (logFile.isDirectory()) {
                    LOG.warn(logFile.getAbsolutePath() + " is a directory. Ignore it.");
                    continue;
                }
                FileInputStream in = null;
                try {
                    in = this.secureOpenFile(logFile);
                }
                catch (IOException e) {
                    LogValue.logErrorMessage(logFile, e);
                    IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{in});
                    continue;
                }
                long fileLength = logFile.length();
                out.writeUTF(logFile.getName());
                out.writeUTF(String.valueOf(fileLength));
                try {
                    long newLength;
                    byte[] buf = new byte[65535];
                    int len = 0;
                    long bytesLeft = fileLength;
                    while ((len = in.read(buf)) != -1) {
                        if ((long)len < bytesLeft) {
                            out.write(buf, 0, len);
                            bytesLeft -= (long)len;
                            continue;
                        }
                        out.write(buf, 0, (int)bytesLeft);
                        break;
                    }
                    if (fileLength < (newLength = logFile.length())) {
                        LOG.warn("Aggregated logs truncated by approximately " + (newLength - fileLength) + " bytes.");
                    }
                    this.uploadedFiles.add(logFile);
                }
                catch (IOException e) {
                    try {
                        String message = LogValue.logErrorMessage(logFile, e);
                        out.write(message.getBytes(Charset.forName("UTF-8")));
                    }
                    catch (Throwable throwable) {
                        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{in});
                        throw throwable;
                    }
                    IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{in});
                    continue;
                }
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{in});
            }
        }

        @VisibleForTesting
        public FileInputStream secureOpenFile(File logFile) throws IOException {
            return SecureIOUtils.openForRead((File)logFile, (String)this.getUser(), null);
        }

        private static String logErrorMessage(File logFile, Exception e) {
            String message = "Error aggregating log file. Log file : " + logFile.getAbsolutePath() + ". " + e.getMessage();
            LOG.error(message, (Throwable)e);
            return message;
        }

        public String getUser() {
            return this.user;
        }

        private Set<File> getPendingLogFilesToUpload(File containerLogDir) {
            if (containerLogDir == null) {
                return new HashSet<File>(0);
            }
            File[] filesList = containerLogDir.listFiles();
            if (filesList == null) {
                return new HashSet<File>(0);
            }
            HashSet<File> candidates = new HashSet<File>(Arrays.asList(filesList));
            for (File logFile : candidates) {
                this.allExistingFileMeta.add(this.getLogFileMetaData(logFile));
            }
            if (this.logRetentionContext != null && !this.logRetentionContext.shouldRetainLog()) {
                this.obsoleteRetentionLogFiles.addAll(candidates);
                candidates.clear();
                return candidates;
            }
            Set<File> fileCandidates = new HashSet<File>(candidates);
            if (this.logAggregationContext != null && candidates.size() > 0) {
                fileCandidates = this.getFileCandidates(fileCandidates, this.appFinished);
                if (!this.appFinished && this.containerFinished) {
                    Set<File> addition = new HashSet<File>(candidates);
                    addition = this.getFileCandidates(addition, true);
                    fileCandidates.addAll(addition);
                }
            }
            return fileCandidates;
        }

        private Set<File> getFileCandidates(Set<File> candidates, boolean useRegularPattern) {
            this.filterFiles(useRegularPattern ? this.logAggregationContext.getIncludePattern() : this.logAggregationContext.getRolledLogsIncludePattern(), candidates, false);
            this.filterFiles(useRegularPattern ? this.logAggregationContext.getExcludePattern() : this.logAggregationContext.getRolledLogsExcludePattern(), candidates, true);
            Iterable mask = Iterables.filter(candidates, input -> !this.alreadyUploadedLogFiles.contains(this.getLogFileMetaData((File)input)));
            return Sets.newHashSet((Iterable)mask);
        }

        private void filterFiles(String pattern, Set<File> candidates, boolean exclusion) {
            if (pattern != null && !pattern.isEmpty()) {
                Pattern filterPattern = Pattern.compile(pattern);
                Iterator<File> candidatesItr = candidates.iterator();
                while (candidatesItr.hasNext()) {
                    File candidate = candidatesItr.next();
                    boolean match = filterPattern.matcher(candidate.getName()).find();
                    if ((match || exclusion) && (!match || !exclusion)) continue;
                    candidatesItr.remove();
                }
            }
        }

        public Set<Path> getCurrentUpLoadedFilesPath() {
            HashSet<Path> path = new HashSet<Path>();
            for (File file : this.uploadedFiles) {
                path.add(new Path(file.getAbsolutePath()));
            }
            return path;
        }

        public Set<String> getCurrentUpLoadedFileMeta() {
            HashSet<String> info = new HashSet<String>();
            for (File file : this.uploadedFiles) {
                info.add(this.getLogFileMetaData(file));
            }
            return info;
        }

        public Set<Path> getObsoleteRetentionLogFiles() {
            HashSet<Path> path = new HashSet<Path>();
            for (File file : this.obsoleteRetentionLogFiles) {
                path.add(new Path(file.getAbsolutePath()));
            }
            return path;
        }

        public Set<String> getAllExistingFilesMeta() {
            return this.allExistingFileMeta;
        }

        private String getLogFileMetaData(File file) {
            return this.containerId.toString() + "_" + file.getName() + "_" + file.lastModified();
        }
    }

    @InterfaceAudience.Public
    public static class LogKey
    implements Writable {
        private String keyString;

        public LogKey() {
        }

        public LogKey(ContainerId containerId) {
            this.keyString = containerId.toString();
        }

        public LogKey(String keyString) {
            this.keyString = keyString;
        }

        public int hashCode() {
            return this.keyString == null ? 0 : this.keyString.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof LogKey) {
                LogKey other = (LogKey)obj;
                if (this.keyString == null) {
                    return other.keyString == null;
                }
                return this.keyString.equals(other.keyString);
            }
            return false;
        }

        @InterfaceAudience.Private
        public void write(DataOutput out) throws IOException {
            out.writeUTF(this.keyString);
        }

        @InterfaceAudience.Private
        public void readFields(DataInput in) throws IOException {
            this.keyString = in.readUTF();
        }

        public String toString() {
            return this.keyString;
        }
    }
}

