/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer;

import java.net.URISyntaxException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.util.ConverterUtils;

public class LocalResourceRequest
implements LocalResource,
Comparable<LocalResourceRequest> {
    private final Path loc;
    private final long timestamp;
    private final LocalResourceType type;
    private final LocalResourceVisibility visibility;

    public LocalResourceRequest(LocalResource resource) throws URISyntaxException {
        this(ConverterUtils.getPathFromYarnURL((URL)resource.getResource()), resource.getTimestamp(), resource.getType(), resource.getVisibility());
    }

    LocalResourceRequest(Path loc, long timestamp, LocalResourceType type, LocalResourceVisibility visibility) {
        this.loc = loc;
        this.timestamp = timestamp;
        this.type = type;
        this.visibility = visibility;
    }

    public int hashCode() {
        return this.loc.hashCode() ^ (int)(this.timestamp >>> 32 ^ this.timestamp) * this.type.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LocalResourceRequest)) {
            return false;
        }
        LocalResourceRequest other = (LocalResourceRequest)o;
        return this.getPath().equals((Object)other.getPath()) && this.getTimestamp() == other.getTimestamp() && this.getType() == other.getType();
    }

    @Override
    public int compareTo(LocalResourceRequest other) {
        if (this == other) {
            return 0;
        }
        int ret = this.getPath().compareTo((Object)other.getPath());
        if (0 == ret && 0 == (ret = (int)(this.getTimestamp() - other.getTimestamp()))) {
            ret = this.getType().ordinal() - other.getType().ordinal();
        }
        return ret;
    }

    public Path getPath() {
        return this.loc;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public LocalResourceType getType() {
        return this.type;
    }

    public URL getResource() {
        return ConverterUtils.getYarnUrlFromPath((Path)this.loc);
    }

    public long getSize() {
        return -1L;
    }

    public LocalResourceVisibility getVisibility() {
        return this.visibility;
    }

    public void setResource(URL resource) {
        throw new UnsupportedOperationException();
    }

    public void setSize(long size) {
        throw new UnsupportedOperationException();
    }

    public void setTimestamp(long timestamp) {
        throw new UnsupportedOperationException();
    }

    public void setType(LocalResourceType type) {
        throw new UnsupportedOperationException();
    }

    public void setVisibility(LocalResourceVisibility visibility) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{ ");
        sb.append(this.getPath().toString()).append(", ");
        sb.append(this.getTimestamp()).append(", ");
        sb.append(this.getType()).append(" }");
        return sb.toString();
    }
}

