/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer;

import java.util.EnumSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerResourceLocalizedEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.LocalResourceRequest;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.LocalizerContext;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.ResourceState;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.event.LocalizerResourceRequestEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.event.ResourceEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.event.ResourceEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.event.ResourceLocalizedEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.event.ResourceReleaseEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.event.ResourceRequestEvent;
import org.apache.hadoop.yarn.state.InvalidStateTransitonException;
import org.apache.hadoop.yarn.state.MultipleArcTransition;
import org.apache.hadoop.yarn.state.SingleArcTransition;
import org.apache.hadoop.yarn.state.StateMachine;
import org.apache.hadoop.yarn.state.StateMachineFactory;

public class LocalizedResource
implements EventHandler<ResourceEvent> {
    private static final Log LOG = LogFactory.getLog(LocalizedResource.class);
    Path localPath;
    long size = -1L;
    final LocalResourceRequest rsrc;
    final Dispatcher dispatcher;
    final StateMachine<ResourceState, ResourceEventType, ResourceEvent> stateMachine;
    final Semaphore sem = new Semaphore(1);
    final Queue<ContainerId> ref;
    private final Lock readLock;
    private final Lock writeLock;
    final AtomicLong timestamp = new AtomicLong(this.currentTime());
    private static final StateMachineFactory<LocalizedResource, ResourceState, ResourceEventType, ResourceEvent> stateMachineFactory = new StateMachineFactory((Enum)ResourceState.INIT).addTransition((Enum)ResourceState.INIT, (Enum)ResourceState.DOWNLOADING, (Enum)ResourceEventType.REQUEST, (SingleArcTransition)new FetchResourceTransition()).addTransition((Enum)ResourceState.INIT, (Enum)ResourceState.LOCALIZED, (Enum)ResourceEventType.LOCALIZED, (SingleArcTransition)new FetchDirectTransition()).addTransition((Enum)ResourceState.INIT, (Enum)ResourceState.INIT, (Enum)ResourceEventType.RELEASE, (SingleArcTransition)new ReleaseTransition()).addTransition((Enum)ResourceState.DOWNLOADING, (Enum)ResourceState.DOWNLOADING, (Enum)ResourceEventType.REQUEST, (SingleArcTransition)new FetchResourceTransition()).addTransition((Enum)ResourceState.DOWNLOADING, (Enum)ResourceState.LOCALIZED, (Enum)ResourceEventType.LOCALIZED, (SingleArcTransition)new FetchSuccessTransition()).addTransition((Enum)ResourceState.DOWNLOADING, EnumSet.of(ResourceState.DOWNLOADING, ResourceState.INIT), (Enum)ResourceEventType.RELEASE, (MultipleArcTransition)new ReleasePendingTransition()).addTransition((Enum)ResourceState.LOCALIZED, (Enum)ResourceState.LOCALIZED, (Enum)ResourceEventType.REQUEST, (SingleArcTransition)new LocalizedResourceTransition()).addTransition((Enum)ResourceState.LOCALIZED, (Enum)ResourceState.LOCALIZED, (Enum)ResourceEventType.LOCALIZED).addTransition((Enum)ResourceState.LOCALIZED, (Enum)ResourceState.LOCALIZED, (Enum)ResourceEventType.RELEASE, (SingleArcTransition)new ReleaseTransition()).installTopology();

    public LocalizedResource(LocalResourceRequest rsrc, Dispatcher dispatcher) {
        this.rsrc = rsrc;
        this.dispatcher = dispatcher;
        this.ref = new LinkedList<ContainerId>();
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        this.readLock = readWriteLock.readLock();
        this.writeLock = readWriteLock.writeLock();
        this.stateMachine = stateMachineFactory.make((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{ ").append(this.rsrc.toString()).append(",").append(this.getState() == ResourceState.LOCALIZED ? this.getLocalPath() + "," + this.getSize() : "pending").append(",[");
        for (ContainerId c : this.ref) {
            sb.append("(").append(c.toString()).append(")");
        }
        sb.append("],").append(this.getTimestamp()).append(",").append((Object)this.getState()).append("}");
        return sb.toString();
    }

    private void release(ContainerId container) {
        if (!this.ref.remove(container)) {
            LOG.info((Object)("Attempt to release claim on " + this + " from unregistered container " + container));
            assert (false);
        }
        this.timestamp.set(this.currentTime());
    }

    private long currentTime() {
        return System.nanoTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceState getState() {
        this.readLock.lock();
        try {
            ResourceState resourceState = (ResourceState)this.stateMachine.getCurrentState();
            return resourceState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public LocalResourceRequest getRequest() {
        return this.rsrc;
    }

    public Path getLocalPath() {
        return this.localPath;
    }

    public long getTimestamp() {
        return this.timestamp.get();
    }

    public long getSize() {
        return this.size;
    }

    public int getRefCount() {
        return this.ref.size();
    }

    public boolean tryAcquire() {
        return this.sem.tryAcquire();
    }

    public void unlock() {
        this.sem.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(ResourceEvent event) {
        try {
            this.writeLock.lock();
            Path resourcePath = event.getLocalResourceRequest().getPath();
            LOG.info((Object)("Processing " + resourcePath + " of type " + event.getType()));
            ResourceState oldState = (ResourceState)this.stateMachine.getCurrentState();
            ResourceState newState = null;
            try {
                newState = (ResourceState)this.stateMachine.doTransition(event.getType(), (Object)event);
            }
            catch (InvalidStateTransitonException e) {
                LOG.warn((Object)"Can't handle this event at current state", (Throwable)e);
            }
            if (oldState != newState) {
                LOG.info((Object)("Resource " + resourcePath + " transitioned from " + (Object)((Object)oldState) + " to " + (Object)((Object)newState)));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private static class ReleasePendingTransition
    implements MultipleArcTransition<LocalizedResource, ResourceEvent, ResourceState> {
        private ReleasePendingTransition() {
        }

        public ResourceState transition(LocalizedResource rsrc, ResourceEvent event) {
            ResourceReleaseEvent relEvent = (ResourceReleaseEvent)event;
            rsrc.release(relEvent.getContainer());
            return rsrc.ref.isEmpty() ? ResourceState.INIT : ResourceState.DOWNLOADING;
        }
    }

    private static class ReleaseTransition
    extends ResourceTransition {
        private ReleaseTransition() {
        }

        public void transition(LocalizedResource rsrc, ResourceEvent event) {
            ResourceReleaseEvent relEvent = (ResourceReleaseEvent)event;
            rsrc.release(relEvent.getContainer());
        }
    }

    private static class LocalizedResourceTransition
    extends ResourceTransition {
        private LocalizedResourceTransition() {
        }

        public void transition(LocalizedResource rsrc, ResourceEvent event) {
            ResourceRequestEvent reqEvent = (ResourceRequestEvent)event;
            ContainerId container = reqEvent.getContext().getContainerId();
            rsrc.ref.add(container);
            rsrc.dispatcher.getEventHandler().handle((Event)new ContainerResourceLocalizedEvent(container, rsrc.rsrc, rsrc.localPath));
        }
    }

    private static class FetchSuccessTransition
    extends ResourceTransition {
        private FetchSuccessTransition() {
        }

        public void transition(LocalizedResource rsrc, ResourceEvent event) {
            ResourceLocalizedEvent locEvent = (ResourceLocalizedEvent)event;
            rsrc.localPath = locEvent.getLocation();
            rsrc.size = locEvent.getSize();
            for (ContainerId container : rsrc.ref) {
                rsrc.dispatcher.getEventHandler().handle((Event)new ContainerResourceLocalizedEvent(container, rsrc.rsrc, rsrc.localPath));
            }
        }
    }

    private static class FetchDirectTransition
    extends FetchSuccessTransition {
        private FetchDirectTransition() {
        }

        @Override
        public void transition(LocalizedResource rsrc, ResourceEvent event) {
            LOG.warn((Object)("Resource " + rsrc + " localized without listening container"));
            super.transition(rsrc, event);
        }
    }

    private static class FetchResourceTransition
    extends ResourceTransition {
        private FetchResourceTransition() {
        }

        public void transition(LocalizedResource rsrc, ResourceEvent event) {
            ResourceRequestEvent req = (ResourceRequestEvent)event;
            LocalizerContext ctxt = req.getContext();
            ContainerId container = ctxt.getContainerId();
            rsrc.ref.add(container);
            rsrc.dispatcher.getEventHandler().handle((Event)new LocalizerResourceRequestEvent(rsrc, req.getVisibility(), ctxt));
        }
    }

    static abstract class ResourceTransition
    implements SingleArcTransition<LocalizedResource, ResourceEvent> {
        ResourceTransition() {
        }
    }
}

