/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.webapp;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.YarnException;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.ResourceView;
import org.apache.hadoop.yarn.server.nodemanager.webapp.NMController;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.service.AbstractService;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.WebApp;
import org.apache.hadoop.yarn.webapp.WebApps;
import org.apache.hadoop.yarn.webapp.YarnWebParams;

public class WebServer
extends AbstractService {
    private static final Log LOG = LogFactory.getLog(WebServer.class);
    private final Context nmContext;
    private final NMWebApp nmWebApp;
    private WebApp webApp;

    public WebServer(Context nmContext, ResourceView resourceView, ApplicationACLsManager aclsManager) {
        super(WebServer.class.getName());
        this.nmContext = nmContext;
        this.nmWebApp = new NMWebApp(resourceView, aclsManager);
    }

    public synchronized void init(Configuration conf) {
        super.init(conf);
    }

    public synchronized void start() {
        String bindAddress = this.getConfig().get("yarn.nodemanager.webapp.address", "0.0.0.0:9999");
        LOG.info((Object)("Instantiating NMWebApp at " + bindAddress));
        try {
            this.webApp = WebApps.$for((String)"node", Context.class, (Object)this.nmContext).at(bindAddress).with(this.getConfig()).start((WebApp)this.nmWebApp);
        }
        catch (Exception e) {
            String msg = "NMWebapps failed to start.";
            LOG.error((Object)msg, (Throwable)e);
            throw new YarnException(msg);
        }
        super.start();
    }

    public synchronized void stop() {
        if (this.webApp != null) {
            this.webApp.stop();
        }
        super.stop();
    }

    public static class NMWebApp
    extends WebApp
    implements YarnWebParams {
        private final ResourceView resourceView;
        private final ApplicationACLsManager aclsManager;

        public NMWebApp(ResourceView resourceView, ApplicationACLsManager aclsManager) {
            this.resourceView = resourceView;
            this.aclsManager = aclsManager;
        }

        public void setup() {
            this.bind(ResourceView.class).toInstance((Object)this.resourceView);
            this.bind(ApplicationACLsManager.class).toInstance((Object)this.aclsManager);
            this.route("/", NMController.class, "info");
            this.route("/node", NMController.class, "node");
            this.route("/allApplications", NMController.class, "allApplications");
            this.route("/allContainers", NMController.class, "allContainers");
            this.route(StringHelper.pajoin((Object[])new Object[]{"/application", "app.id"}), NMController.class, "application");
            this.route(StringHelper.pajoin((Object[])new Object[]{"/container", "container.id"}), NMController.class, "container");
            this.route(StringHelper.pajoin((Object[])new Object[]{"/containerlogs", "container.id", "app.owner", "log.type"}), NMController.class, "logs");
        }
    }
}

