/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.util.DiskChecker;

class DirectoryCollection {
    private static final Log LOG = LogFactory.getLog(DirectoryCollection.class);
    private List<String> localDirs = new ArrayList<String>();
    private List<String> failedDirs;
    private int numFailures;

    public DirectoryCollection(String[] dirs) {
        this.localDirs.addAll(Arrays.asList(dirs));
        this.failedDirs = new ArrayList<String>();
    }

    synchronized List<String> getGoodDirs() {
        return this.localDirs;
    }

    synchronized List<String> getFailedDirs() {
        return this.failedDirs;
    }

    synchronized int getNumFailures() {
        return this.numFailures;
    }

    synchronized boolean checkDirs() {
        int oldNumFailures = this.numFailures;
        ListIterator<String> it = this.localDirs.listIterator();
        while (it.hasNext()) {
            String dir = it.next();
            try {
                DiskChecker.checkDir((File)new File(dir));
            }
            catch (DiskChecker.DiskErrorException de) {
                LOG.warn((Object)("Directory " + dir + " error " + de.getMessage() + ", removing from the list of valid directories."));
                it.remove();
                this.failedDirs.add(dir);
                ++this.numFailures;
            }
        }
        return this.numFailures > oldNumFailures;
    }
}

