/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.YarnException;
import org.apache.hadoop.yarn.server.nodemanager.DirectoryCollection;
import org.apache.hadoop.yarn.service.AbstractService;

public class LocalDirsHandlerService
extends AbstractService {
    private static Log LOG = LogFactory.getLog(LocalDirsHandlerService.class);
    private Timer dirsHandlerScheduler;
    private long diskHealthCheckInterval;
    private boolean isDiskHealthCheckerEnabled;
    private float minNeededHealthyDisksFactor;
    private MonitoringTimerTask monitoringTimerTask;
    private DirectoryCollection localDirs = null;
    private DirectoryCollection logDirs = null;
    private LocalDirAllocator localDirsAllocator;
    private LocalDirAllocator logDirsAllocator;
    private long lastDisksCheckTime;
    private static String FILE_SCHEME = "file";

    public LocalDirsHandlerService() {
        super(LocalDirsHandlerService.class.getName());
    }

    public void init(Configuration config) {
        FileContext localFs;
        Configuration conf = new Configuration(config);
        this.diskHealthCheckInterval = conf.getLong("yarn.nodemanager.disk-health-checker.interval-ms", 120000L);
        this.monitoringTimerTask = new MonitoringTimerTask(conf);
        this.isDiskHealthCheckerEnabled = conf.getBoolean("yarn.nodemanager.disk-health-checker.enable", true);
        this.minNeededHealthyDisksFactor = conf.getFloat("yarn.nodemanager.disk-health-checker.min-healthy-disks", 0.25f);
        this.lastDisksCheckTime = System.currentTimeMillis();
        super.init(conf);
        try {
            localFs = FileContext.getLocalFSFileContext((Configuration)config);
        }
        catch (IOException e) {
            throw new YarnException("Unable to get the local filesystem", (Throwable)e);
        }
        FsPermission perm = new FsPermission(493);
        boolean createSucceeded = this.localDirs.createNonExistentDirs(localFs, perm);
        if (!(createSucceeded &= this.logDirs.createNonExistentDirs(localFs, perm))) {
            this.updateDirsAfterFailure();
        }
        this.checkDirs();
    }

    public void start() {
        if (this.isDiskHealthCheckerEnabled) {
            this.dirsHandlerScheduler = new Timer("DiskHealthMonitor-Timer", true);
            this.dirsHandlerScheduler.scheduleAtFixedRate((TimerTask)this.monitoringTimerTask, this.diskHealthCheckInterval, this.diskHealthCheckInterval);
        }
        super.start();
    }

    public void stop() {
        if (this.dirsHandlerScheduler != null) {
            this.dirsHandlerScheduler.cancel();
        }
        super.stop();
    }

    public List<String> getLocalDirs() {
        return this.localDirs.getGoodDirs();
    }

    public List<String> getLogDirs() {
        return this.logDirs.getGoodDirs();
    }

    public String getDisksHealthReport() {
        if (!this.isDiskHealthCheckerEnabled) {
            return "";
        }
        StringBuilder report = new StringBuilder();
        List<String> failedLocalDirsList = this.localDirs.getFailedDirs();
        List<String> failedLogDirsList = this.logDirs.getFailedDirs();
        int numLocalDirs = this.localDirs.getGoodDirs().size() + failedLocalDirsList.size();
        int numLogDirs = this.logDirs.getGoodDirs().size() + failedLogDirsList.size();
        if (!failedLocalDirsList.isEmpty()) {
            report.append(failedLocalDirsList.size() + "/" + numLocalDirs + " local-dirs turned bad: " + StringUtils.join((CharSequence)",", failedLocalDirsList) + ";");
        }
        if (!failedLogDirsList.isEmpty()) {
            report.append(failedLogDirsList.size() + "/" + numLogDirs + " log-dirs turned bad: " + StringUtils.join((CharSequence)",", failedLogDirsList));
        }
        return report.toString();
    }

    public boolean areDisksHealthy() {
        int failedDirs;
        int totalConfiguredDirs;
        if (!this.isDiskHealthCheckerEnabled) {
            return true;
        }
        int goodDirs = this.getLocalDirs().size();
        if ((float)goodDirs / (float)(totalConfiguredDirs = goodDirs + (failedDirs = this.localDirs.getFailedDirs().size())) < this.minNeededHealthyDisksFactor) {
            return false;
        }
        goodDirs = this.getLogDirs().size();
        return !((float)goodDirs / (float)(totalConfiguredDirs = goodDirs + (failedDirs = this.logDirs.getFailedDirs().size())) < this.minNeededHealthyDisksFactor);
    }

    public long getLastDisksCheckTime() {
        return this.lastDisksCheckTime;
    }

    private void updateDirsAfterFailure() {
        LOG.info((Object)("Disk(s) failed. " + this.getDisksHealthReport()));
        Configuration conf = this.getConfig();
        List<String> localDirs = this.getLocalDirs();
        conf.setStrings("yarn.nodemanager.local-dirs", localDirs.toArray(new String[localDirs.size()]));
        List<String> logDirs = this.getLogDirs();
        conf.setStrings("yarn.nodemanager.log-dirs", logDirs.toArray(new String[logDirs.size()]));
        if (!this.areDisksHealthy()) {
            LOG.error((Object)("Most of the disks failed. " + this.getDisksHealthReport()));
        }
    }

    private void checkDirs() {
        boolean newFailure = false;
        if (this.localDirs.checkDirs()) {
            newFailure = true;
        }
        if (this.logDirs.checkDirs()) {
            newFailure = true;
        }
        if (newFailure) {
            this.updateDirsAfterFailure();
        }
        this.lastDisksCheckTime = System.currentTimeMillis();
    }

    public Path getLocalPathForWrite(String pathStr) throws IOException {
        return this.localDirsAllocator.getLocalPathForWrite(pathStr, this.getConfig());
    }

    public Path getLocalPathForWrite(String pathStr, long size, boolean checkWrite) throws IOException {
        return this.localDirsAllocator.getLocalPathForWrite(pathStr, size, this.getConfig(), checkWrite);
    }

    public Path getLogPathForWrite(String pathStr, boolean checkWrite) throws IOException {
        return this.logDirsAllocator.getLocalPathForWrite(pathStr, -1L, this.getConfig(), checkWrite);
    }

    public Path getLogPathToRead(String pathStr) throws IOException {
        return this.logDirsAllocator.getLocalPathToRead(pathStr, this.getConfig());
    }

    public static String[] validatePaths(String[] paths) {
        ArrayList<String> validPaths = new ArrayList<String>();
        for (int i = 0; i < paths.length; ++i) {
            try {
                URI uriPath = new URI(paths[i]);
                if (uriPath.getScheme() != null && !uriPath.getScheme().equals(FILE_SCHEME)) {
                    LOG.warn((Object)(paths[i] + " is not a valid path. Path should be with " + FILE_SCHEME + " scheme or without scheme"));
                    throw new YarnException(paths[i] + " is not a valid path. Path should be with " + FILE_SCHEME + " scheme or without scheme");
                }
                validPaths.add(uriPath.getPath());
                continue;
            }
            catch (URISyntaxException e) {
                LOG.warn((Object)e.getMessage());
                throw new YarnException(paths[i] + " is not a valid path. Path should be with " + FILE_SCHEME + " scheme or without scheme");
            }
        }
        String[] arrValidPaths = new String[validPaths.size()];
        validPaths.toArray(arrValidPaths);
        return arrValidPaths;
    }

    private final class MonitoringTimerTask
    extends TimerTask {
        public MonitoringTimerTask(Configuration conf) throws YarnException {
            LocalDirsHandlerService.this.localDirs = new DirectoryCollection(LocalDirsHandlerService.validatePaths(conf.getTrimmedStrings("yarn.nodemanager.local-dirs")));
            LocalDirsHandlerService.this.logDirs = new DirectoryCollection(LocalDirsHandlerService.validatePaths(conf.getTrimmedStrings("yarn.nodemanager.log-dirs")));
            LocalDirsHandlerService.this.localDirsAllocator = new LocalDirAllocator("yarn.nodemanager.local-dirs");
            LocalDirsHandlerService.this.logDirsAllocator = new LocalDirAllocator("yarn.nodemanager.log-dirs");
        }

        @Override
        public void run() {
            LocalDirsHandlerService.this.checkDirs();
        }
    }
}

