/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.YarnException;
import org.apache.hadoop.yarn.YarnUncaughtExceptionHandler;
import org.apache.hadoop.yarn.api.ContainerManager;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeHealthStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.nodemanager.CMgrCompletedContainersEvent;
import org.apache.hadoop.yarn.server.nodemanager.ContainerExecutor;
import org.apache.hadoop.yarn.server.nodemanager.ContainerManagerEventType;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.DefaultContainerExecutor;
import org.apache.hadoop.yarn.server.nodemanager.DeletionService;
import org.apache.hadoop.yarn.server.nodemanager.LocalDirsHandlerService;
import org.apache.hadoop.yarn.server.nodemanager.NodeHealthCheckerService;
import org.apache.hadoop.yarn.server.nodemanager.NodeManagerEvent;
import org.apache.hadoop.yarn.server.nodemanager.NodeManagerEventType;
import org.apache.hadoop.yarn.server.nodemanager.NodeResourceMonitor;
import org.apache.hadoop.yarn.server.nodemanager.NodeResourceMonitorImpl;
import org.apache.hadoop.yarn.server.nodemanager.NodeStatusUpdater;
import org.apache.hadoop.yarn.server.nodemanager.NodeStatusUpdaterImpl;
import org.apache.hadoop.yarn.server.nodemanager.ResourceView;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.ContainerManagerImpl;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.Application;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.metrics.NodeManagerMetrics;
import org.apache.hadoop.yarn.server.nodemanager.security.NMContainerTokenSecretManager;
import org.apache.hadoop.yarn.server.nodemanager.webapp.WebServer;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.service.CompositeService;
import org.apache.hadoop.yarn.service.Service;

public class NodeManager
extends CompositeService
implements EventHandler<NodeManagerEvent> {
    public static final int SHUTDOWN_HOOK_PRIORITY = 30;
    private static final int SHUTDOWN_CLEANUP_SLOP_MS = 1000;
    private static final Log LOG = LogFactory.getLog(NodeManager.class);
    protected final NodeManagerMetrics metrics = NodeManagerMetrics.create();
    private ApplicationACLsManager aclsManager;
    private NodeHealthCheckerService nodeHealthChecker;
    private LocalDirsHandlerService dirsHandler;
    private Context context;
    private AsyncDispatcher dispatcher;
    private ContainerManagerImpl containerManager;
    private NodeStatusUpdater nodeStatusUpdater;
    private static CompositeService.CompositeServiceShutdownHook nodeManagerShutdownHook;
    private long waitForContainersOnShutdownMillis;
    private AtomicBoolean isStopping = new AtomicBoolean(false);

    public NodeManager() {
        super(NodeManager.class.getName());
    }

    protected NodeStatusUpdater createNodeStatusUpdater(Context context, Dispatcher dispatcher, NodeHealthCheckerService healthChecker) {
        return new NodeStatusUpdaterImpl(context, dispatcher, healthChecker, this.metrics);
    }

    protected NodeResourceMonitor createNodeResourceMonitor() {
        return new NodeResourceMonitorImpl();
    }

    protected ContainerManagerImpl createContainerManager(Context context, ContainerExecutor exec, DeletionService del, NodeStatusUpdater nodeStatusUpdater, ApplicationACLsManager aclsManager, LocalDirsHandlerService dirsHandler) {
        return new ContainerManagerImpl(context, exec, del, nodeStatusUpdater, this.metrics, aclsManager, dirsHandler);
    }

    protected WebServer createWebServer(Context nmContext, ResourceView resourceView, ApplicationACLsManager aclsManager, LocalDirsHandlerService dirsHandler) {
        return new WebServer(nmContext, resourceView, aclsManager, dirsHandler);
    }

    protected DeletionService createDeletionService(ContainerExecutor exec) {
        return new DeletionService(exec);
    }

    protected NMContext createNMContext(NMContainerTokenSecretManager containerTokenSecretManager) {
        return new NMContext(containerTokenSecretManager);
    }

    protected void doSecureLogin() throws IOException {
        SecurityUtil.login((Configuration)this.getConfig(), (String)"yarn.nodemanager.keytab", (String)"yarn.nodemanager.principal");
    }

    public void init(Configuration conf) {
        conf.setBoolean("yarn.dispatcher.exit-on-error", true);
        NMContainerTokenSecretManager containerTokenSecretManager = new NMContainerTokenSecretManager(conf);
        this.context = this.createNMContext(containerTokenSecretManager);
        this.aclsManager = new ApplicationACLsManager(conf);
        ContainerExecutor exec = (ContainerExecutor)ReflectionUtils.newInstance((Class)conf.getClass("yarn.nodemanager.container-executor.class", DefaultContainerExecutor.class, ContainerExecutor.class), (Configuration)conf);
        try {
            exec.init();
        }
        catch (IOException e) {
            throw new YarnException("Failed to initialize container executor", (Throwable)e);
        }
        DeletionService del = this.createDeletionService(exec);
        this.addService((Service)del);
        this.dispatcher = new AsyncDispatcher();
        this.nodeHealthChecker = new NodeHealthCheckerService();
        this.addService((Service)this.nodeHealthChecker);
        this.dirsHandler = this.nodeHealthChecker.getDiskHandler();
        this.nodeStatusUpdater = this.createNodeStatusUpdater(this.context, (Dispatcher)this.dispatcher, this.nodeHealthChecker);
        NodeResourceMonitor nodeResourceMonitor = this.createNodeResourceMonitor();
        this.addService(nodeResourceMonitor);
        this.containerManager = this.createContainerManager(this.context, exec, del, this.nodeStatusUpdater, this.aclsManager, this.dirsHandler);
        this.addService((Service)this.containerManager);
        ((NMContext)this.context).setContainerManager(this.containerManager);
        WebServer webServer = this.createWebServer(this.context, this.containerManager.getContainersMonitor(), this.aclsManager, this.dirsHandler);
        this.addService((Service)webServer);
        ((NMContext)this.context).setWebServer(webServer);
        this.dispatcher.register(ContainerManagerEventType.class, (EventHandler)this.containerManager);
        this.dispatcher.register(NodeManagerEventType.class, (EventHandler)this);
        this.addService((Service)this.dispatcher);
        DefaultMetricsSystem.initialize((String)"NodeManager");
        this.addService(this.nodeStatusUpdater);
        this.waitForContainersOnShutdownMillis = conf.getLong("yarn.nodemanager.sleep-delay-before-sigkill.ms", 250L) + conf.getLong("yarn.nodemanager.process-kill-wait.ms", 2000L) + 1000L;
        super.init(conf);
    }

    public void start() {
        try {
            this.doSecureLogin();
        }
        catch (IOException e) {
            throw new YarnException("Failed NodeManager login", (Throwable)e);
        }
        super.start();
    }

    public void stop() {
        if (this.isStopping.getAndSet(true)) {
            return;
        }
        this.cleanupContainers(NodeManagerEventType.SHUTDOWN);
        super.stop();
        DefaultMetricsSystem.shutdown();
    }

    protected void resyncWithRM() {
        new Thread(){

            @Override
            public void run() {
                LOG.info((Object)"Notifying ContainerManager to block new container-requests");
                NodeManager.this.containerManager.setBlockNewContainerRequests(true);
                NodeManager.this.cleanupContainers(NodeManagerEventType.RESYNC);
                ((NodeStatusUpdaterImpl)NodeManager.this.nodeStatusUpdater).rebootNodeStatusUpdater();
            }
        }.start();
    }

    protected void cleanupContainers(NodeManagerEventType eventType) {
        ConcurrentMap<ContainerId, Container> containers = this.context.getContainers();
        if (containers.isEmpty()) {
            return;
        }
        LOG.info((Object)("Containers still running on " + (Object)((Object)eventType) + " : " + containers.keySet()));
        ArrayList<ContainerId> containerIds = new ArrayList<ContainerId>(containers.keySet());
        this.dispatcher.getEventHandler().handle((Event)new CMgrCompletedContainersEvent(containerIds, CMgrCompletedContainersEvent.Reason.ON_SHUTDOWN));
        LOG.info((Object)"Waiting for containers to be killed");
        switch (eventType) {
            case SHUTDOWN: {
                long waitStartTime = System.currentTimeMillis();
                while (!containers.isEmpty() && System.currentTimeMillis() - waitStartTime < this.waitForContainersOnShutdownMillis) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ex) {
                        LOG.warn((Object)"Interrupted while sleeping on container kill on shutdown", (Throwable)ex);
                    }
                }
                break;
            }
            case RESYNC: {
                while (!containers.isEmpty()) {
                    try {
                        Thread.sleep(1000L);
                        this.nodeStatusUpdater.getNodeStatusAndUpdateContainersInContext();
                    }
                    catch (InterruptedException ex) {
                        LOG.warn((Object)"Interrupted while sleeping on container kill on resync", (Throwable)ex);
                    }
                }
                break;
            }
            default: {
                LOG.warn((Object)("Invalid eventType: " + (Object)((Object)eventType)));
            }
        }
        if (containers.isEmpty()) {
            LOG.info((Object)"All containers in DONE state");
        } else {
            LOG.info((Object)("Done waiting for containers to be killed. Still alive: " + containers.keySet()));
        }
    }

    public NodeHealthCheckerService getNodeHealthChecker() {
        return this.nodeHealthChecker;
    }

    private void initAndStartNodeManager(Configuration conf, boolean hasToReboot) {
        try {
            if (hasToReboot && null != nodeManagerShutdownHook) {
                ShutdownHookManager.get().removeShutdownHook((Runnable)nodeManagerShutdownHook);
            }
            nodeManagerShutdownHook = new CompositeService.CompositeServiceShutdownHook((CompositeService)this);
            ShutdownHookManager.get().addShutdownHook((Runnable)nodeManagerShutdownHook, 30);
            this.init(conf);
            this.start();
        }
        catch (Throwable t) {
            LOG.fatal((Object)"Error starting NodeManager", t);
            System.exit(-1);
        }
    }

    public void handle(NodeManagerEvent event) {
        switch ((NodeManagerEventType)event.getType()) {
            case SHUTDOWN: {
                this.stop();
                break;
            }
            case RESYNC: {
                this.resyncWithRM();
                break;
            }
            default: {
                LOG.warn((Object)("Invalid shutdown event " + event.getType() + ". Ignoring."));
            }
        }
    }

    NodeManager createNewNodeManager() {
        return new NodeManager();
    }

    ContainerManagerImpl getContainerManager() {
        return this.containerManager;
    }

    Dispatcher getNMDispatcher() {
        return this.dispatcher;
    }

    @VisibleForTesting
    Context getNMContext() {
        return this.context;
    }

    public static void main(String[] args) {
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new YarnUncaughtExceptionHandler());
        StringUtils.startupShutdownMessage(NodeManager.class, (String[])args, (Log)LOG);
        NodeManager nodeManager = new NodeManager();
        YarnConfiguration conf = new YarnConfiguration();
        nodeManager.initAndStartNodeManager((Configuration)conf, false);
    }

    public static class NMContext
    implements Context {
        private NodeId nodeId = null;
        private final ConcurrentMap<ApplicationId, Application> applications = new ConcurrentHashMap<ApplicationId, Application>();
        private final ConcurrentMap<ContainerId, Container> containers = new ConcurrentSkipListMap<ContainerId, Container>();
        private final NMContainerTokenSecretManager containerTokenSecretManager;
        private ContainerManager containerManager;
        private WebServer webServer;
        private final NodeHealthStatus nodeHealthStatus = (NodeHealthStatus)RecordFactoryProvider.getRecordFactory(null).newRecordInstance(NodeHealthStatus.class);

        public NMContext(NMContainerTokenSecretManager containerTokenSecretManager) {
            this.containerTokenSecretManager = containerTokenSecretManager;
            this.nodeHealthStatus.setIsNodeHealthy(true);
            this.nodeHealthStatus.setHealthReport("Healthy");
            this.nodeHealthStatus.setLastHealthReportTime(System.currentTimeMillis());
        }

        @Override
        public NodeId getNodeId() {
            return this.nodeId;
        }

        @Override
        public int getHttpPort() {
            return this.webServer.getPort();
        }

        @Override
        public ConcurrentMap<ApplicationId, Application> getApplications() {
            return this.applications;
        }

        @Override
        public ConcurrentMap<ContainerId, Container> getContainers() {
            return this.containers;
        }

        @Override
        public NMContainerTokenSecretManager getContainerTokenSecretManager() {
            return this.containerTokenSecretManager;
        }

        @Override
        public NodeHealthStatus getNodeHealthStatus() {
            return this.nodeHealthStatus;
        }

        @Override
        public ContainerManager getContainerManager() {
            return this.containerManager;
        }

        public void setContainerManager(ContainerManager containerManager) {
            this.containerManager = containerManager;
        }

        public void setWebServer(WebServer webServer) {
            this.webServer = webServer;
        }

        public void setNodeId(NodeId nodeId) {
            this.nodeId = nodeId;
        }
    }
}

