/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager;

import com.google.common.annotations.VisibleForTesting;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataInputByteBuffer;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.ContainerManager;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerStatusRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerStatusResponse;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainerRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainerResponse;
import org.apache.hadoop.yarn.api.protocolrecords.StopContainerRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StopContainerResponse;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.ContainerToken;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnRemoteException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.ipc.RPCUtil;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.security.ContainerTokenIdentifier;
import org.apache.hadoop.yarn.server.nodemanager.CMgrCompletedAppsEvent;
import org.apache.hadoop.yarn.server.nodemanager.CMgrCompletedContainersEvent;
import org.apache.hadoop.yarn.server.nodemanager.ContainerExecutor;
import org.apache.hadoop.yarn.server.nodemanager.ContainerManagerEvent;
import org.apache.hadoop.yarn.server.nodemanager.ContainerManagerEventType;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.DeletionService;
import org.apache.hadoop.yarn.server.nodemanager.LocalDirsHandlerService;
import org.apache.hadoop.yarn.server.nodemanager.NMAuditLogger;
import org.apache.hadoop.yarn.server.nodemanager.NodeManager;
import org.apache.hadoop.yarn.server.nodemanager.NodeStatusUpdater;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.AuxServices;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.AuxServicesEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.InvalidContainerException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.NMNotYetReadyException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.Application;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationContainerInitEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationFinishEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationImpl;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationInitEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerImpl;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerKillEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.launcher.ContainersLauncher;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.launcher.ContainersLauncherEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.ResourceLocalizationService;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.event.LocalizationEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.logaggregation.LogAggregationService;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.loghandler.LogHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.loghandler.NonAggregatingLogHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.loghandler.event.LogHandlerEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.monitor.ContainersMonitor;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.monitor.ContainersMonitorEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.monitor.ContainersMonitorImpl;
import org.apache.hadoop.yarn.server.nodemanager.metrics.NodeManagerMetrics;
import org.apache.hadoop.yarn.server.nodemanager.security.authorize.NMPolicyProvider;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.service.CompositeService;
import org.apache.hadoop.yarn.service.Service;
import org.apache.hadoop.yarn.service.ServiceStateChangeListener;
import org.apache.hadoop.yarn.util.BuilderUtils;

public class ContainerManagerImpl
extends CompositeService
implements ServiceStateChangeListener,
ContainerManager,
EventHandler<ContainerManagerEvent> {
    private static final Log LOG = LogFactory.getLog(ContainerManagerImpl.class);
    final Context context;
    private final ContainersMonitor containersMonitor;
    private Server server;
    private final ResourceLocalizationService rsrcLocalizationSrvc;
    private final ContainersLauncher containersLauncher;
    private final AuxServices auxiliaryServices;
    private final NodeManagerMetrics metrics;
    private final NodeStatusUpdater nodeStatusUpdater;
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    protected LocalDirsHandlerService dirsHandler;
    protected final AsyncDispatcher dispatcher;
    private final ApplicationACLsManager aclsManager;
    private final DeletionService deletionService;
    private AtomicBoolean blockNewContainerRequests = new AtomicBoolean(false);

    public ContainerManagerImpl(Context context, ContainerExecutor exec, DeletionService deletionContext, NodeStatusUpdater nodeStatusUpdater, NodeManagerMetrics metrics, ApplicationACLsManager aclsManager, LocalDirsHandlerService dirsHandler) {
        super(ContainerManagerImpl.class.getName());
        this.context = context;
        this.dirsHandler = dirsHandler;
        this.dispatcher = new AsyncDispatcher();
        this.deletionService = deletionContext;
        this.metrics = metrics;
        this.rsrcLocalizationSrvc = this.createResourceLocalizationService(exec, deletionContext);
        this.addService((Service)this.rsrcLocalizationSrvc);
        this.containersLauncher = this.createContainersLauncher(context, exec);
        this.addService((Service)this.containersLauncher);
        this.nodeStatusUpdater = nodeStatusUpdater;
        this.aclsManager = aclsManager;
        this.auxiliaryServices = new AuxServices();
        this.auxiliaryServices.register(this);
        this.addService((Service)this.auxiliaryServices);
        this.containersMonitor = new ContainersMonitorImpl(exec, this.dispatcher, this.context);
        this.addService(this.containersMonitor);
        this.dispatcher.register(ContainerEventType.class, (EventHandler)new ContainerEventDispatcher());
        this.dispatcher.register(ApplicationEventType.class, (EventHandler)new ApplicationEventDispatcher());
        this.dispatcher.register(LocalizationEventType.class, (EventHandler)this.rsrcLocalizationSrvc);
        this.dispatcher.register(AuxServicesEventType.class, (EventHandler)this.auxiliaryServices);
        this.dispatcher.register(ContainersMonitorEventType.class, (EventHandler)this.containersMonitor);
        this.dispatcher.register(ContainersLauncherEventType.class, (EventHandler)this.containersLauncher);
        this.addService((Service)this.dispatcher);
    }

    public void init(Configuration conf) {
        LogHandler logHandler = this.createLogHandler(conf, this.context, this.deletionService);
        this.addIfService(logHandler);
        this.dispatcher.register(LogHandlerEventType.class, (EventHandler)logHandler);
        super.init(conf);
    }

    private void addIfService(Object object) {
        if (object instanceof Service) {
            this.addService((Service)object);
        }
    }

    protected LogHandler createLogHandler(Configuration conf, Context context, DeletionService deletionService) {
        if (conf.getBoolean("yarn.log-aggregation-enable", false)) {
            return new LogAggregationService((Dispatcher)this.dispatcher, context, deletionService, this.dirsHandler);
        }
        return new NonAggregatingLogHandler((Dispatcher)this.dispatcher, deletionService, this.dirsHandler);
    }

    public ContainersMonitor getContainersMonitor() {
        return this.containersMonitor;
    }

    protected ResourceLocalizationService createResourceLocalizationService(ContainerExecutor exec, DeletionService deletionContext) {
        return new ResourceLocalizationService((Dispatcher)this.dispatcher, exec, deletionContext, this.dirsHandler);
    }

    protected ContainersLauncher createContainersLauncher(Context context, ContainerExecutor exec) {
        return new ContainersLauncher(context, (Dispatcher)this.dispatcher, exec, this.dirsHandler);
    }

    public void start() {
        Configuration conf = this.getConfig();
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        InetSocketAddress initialAddress = conf.getSocketAddr("yarn.nodemanager.address", "0.0.0.0:0", 0);
        this.server = rpc.getServer(ContainerManager.class, (Object)this, initialAddress, conf, (SecretManager)this.context.getContainerTokenSecretManager(), conf.getInt("yarn.nodemanager.container-manager.thread-count", 20));
        if (conf.getBoolean("hadoop.security.authorization", false)) {
            this.refreshServiceAcls(conf, new NMPolicyProvider());
        }
        LOG.info((Object)"Blocking new container-requests as container manager rpc server is still starting.");
        this.setBlockNewContainerRequests(true);
        this.server.start();
        InetSocketAddress connectAddress = NetUtils.getConnectAddress((Server)this.server);
        NodeId nodeId = NodeId.newInstance((String)connectAddress.getHostName(), (int)connectAddress.getPort());
        ((NodeManager.NMContext)this.context).setNodeId(nodeId);
        LOG.info((Object)("ContainerManager started at " + connectAddress));
        super.start();
    }

    void refreshServiceAcls(Configuration configuration, PolicyProvider policyProvider) {
        this.server.refreshServiceAcl(configuration, policyProvider);
    }

    public void stop() {
        if (this.auxiliaryServices.getServiceState() == Service.STATE.STARTED) {
            this.auxiliaryServices.unregister(this);
        }
        if (this.server != null) {
            this.server.stop();
        }
        super.stop();
    }

    private UserGroupInformation getRemoteUgi() throws YarnRemoteException {
        UserGroupInformation remoteUgi;
        try {
            remoteUgi = UserGroupInformation.getCurrentUser();
        }
        catch (IOException e) {
            String msg = "Cannot obtain the user-name. Got exception: " + StringUtils.stringifyException((Throwable)e);
            LOG.warn((Object)msg);
            throw RPCUtil.getRemoteException((String)msg);
        }
        return remoteUgi;
    }

    private ContainerTokenIdentifier selectContainerTokenIdentifier(UserGroupInformation remoteUgi) {
        Set tokenIdentifiers = remoteUgi.getTokenIdentifiers();
        ContainerTokenIdentifier resultId = null;
        for (TokenIdentifier id : tokenIdentifiers) {
            if (!(id instanceof ContainerTokenIdentifier)) continue;
            resultId = (ContainerTokenIdentifier)id;
            break;
        }
        return resultId;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    protected ContainerTokenIdentifier getContainerTokenIdentifier(UserGroupInformation remoteUgi, ContainerTokenIdentifier containerTokenIdentifier) throws YarnRemoteException {
        if (UserGroupInformation.isSecurityEnabled()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Number of TokenIdentifiers in the UGI from RPC: " + remoteUgi.getTokenIdentifiers().size()));
            }
            return this.selectContainerTokenIdentifier(remoteUgi);
        }
        return containerTokenIdentifier;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    protected void authorizeRequest(String containerIDStr, ContainerLaunchContext launchContext, UserGroupInformation remoteUgi, ContainerTokenIdentifier tokenId) throws YarnRemoteException {
        boolean unauthorized = false;
        StringBuilder messageBuilder = new StringBuilder("Unauthorized request to start container. ");
        if (!remoteUgi.getUserName().equals(containerIDStr)) {
            unauthorized = true;
            messageBuilder.append("\nExpected containerId: " + remoteUgi.getUserName() + " Found: " + containerIDStr);
        } else if (launchContext != null) {
            if (tokenId == null) {
                unauthorized = true;
                messageBuilder.append("\nNo ContainerToken found for " + containerIDStr);
            } else {
                if (!this.context.getContainerTokenSecretManager().isValidStartContainerRequest(tokenId.getContainerID())) {
                    unauthorized = true;
                    messageBuilder.append("\n Attempt to relaunch the same container with id " + containerIDStr + ".");
                }
                if (tokenId.getExpiryTimeStamp() < System.currentTimeMillis()) {
                    unauthorized = true;
                    messageBuilder.append("\nThis token is expired. current time is " + System.currentTimeMillis() + " found " + tokenId.getExpiryTimeStamp());
                }
            }
        }
        if (unauthorized) {
            String msg = messageBuilder.toString();
            LOG.error((Object)msg);
            throw RPCUtil.getRemoteException((String)msg);
        }
    }

    public StartContainerResponse startContainer(StartContainerRequest request) throws YarnRemoteException, IOException {
        if (this.blockNewContainerRequests.get()) {
            throw RPCUtil.getRemoteException((Throwable)((Object)new NMNotYetReadyException("Rejecting new containers as NodeManager has not yet connected with ResourceManager")));
        }
        ContainerLaunchContext launchContext = request.getContainerLaunchContext();
        ContainerToken token = request.getContainerToken();
        ContainerTokenIdentifier tokenIdentifier = null;
        try {
            tokenIdentifier = BuilderUtils.newContainerTokenIdentifier((ContainerToken)token);
        }
        catch (IOException e) {
            throw RPCUtil.getRemoteException((Throwable)e);
        }
        UserGroupInformation remoteUgi = this.getRemoteUgi();
        ContainerTokenIdentifier tokenId = this.getContainerTokenIdentifier(remoteUgi, tokenIdentifier);
        ContainerId containerID = tokenId.getContainerID();
        String containerIDStr = containerID.toString();
        this.authorizeRequest(containerIDStr, launchContext, remoteUgi, tokenId);
        if (tokenId.getRMIdentifer() != this.nodeStatusUpdater.getRMIdentifier()) {
            String msg = "\nContainer " + containerIDStr + " rejected as it is allocated by a previous RM";
            LOG.error((Object)msg);
            throw RPCUtil.getRemoteException((Throwable)((Object)new InvalidContainerException(msg)));
        }
        LOG.info((Object)("Start request for " + containerIDStr + " by user " + tokenId.getApplicationSubmitter()));
        ByteBuffer tokens = launchContext.getTokens();
        Credentials credentials = new Credentials();
        if (tokens != null) {
            DataInputByteBuffer buf = new DataInputByteBuffer();
            tokens.rewind();
            buf.reset(new ByteBuffer[]{tokens});
            try {
                credentials.readTokenStorageStream((DataInputStream)buf);
                if (LOG.isDebugEnabled()) {
                    for (Token tk : credentials.getAllTokens()) {
                        LOG.debug((Object)(tk.getService() + " = " + tk.toString()));
                    }
                }
            }
            catch (IOException e) {
                throw RPCUtil.getRemoteException((Throwable)e);
            }
        }
        String user = tokenId.getApplicationSubmitter();
        ContainerImpl container = new ContainerImpl(this.getConfig(), (Dispatcher)this.dispatcher, launchContext, credentials, this.metrics, tokenId);
        ApplicationId applicationID = containerID.getApplicationAttemptId().getApplicationId();
        if (this.context.getContainers().putIfAbsent(containerID, container) != null) {
            NMAuditLogger.logFailure(user, "Start Container Request", "ContainerManagerImpl", "Container already running on this node!", applicationID, containerID);
            throw RPCUtil.getRemoteException((String)("Container " + containerIDStr + " already is running on this node!!"));
        }
        ApplicationImpl application = new ApplicationImpl((Dispatcher)this.dispatcher, this.aclsManager, user, applicationID, credentials, this.context);
        if (null == this.context.getApplications().putIfAbsent(applicationID, application)) {
            LOG.info((Object)("Creating a new application reference for app " + applicationID));
            this.dispatcher.getEventHandler().handle((Event)new ApplicationInitEvent(applicationID, container.getLaunchContext().getApplicationACLs()));
        }
        this.dispatcher.getEventHandler().handle((Event)new ApplicationContainerInitEvent(container));
        this.context.getContainerTokenSecretManager().startContainerSuccessful(tokenId);
        NMAuditLogger.logSuccess(user, "Start Container Request", "ContainerManageImpl", applicationID, containerID);
        StartContainerResponse response = (StartContainerResponse)this.recordFactory.newRecordInstance(StartContainerResponse.class);
        response.setAllServiceResponse(this.auxiliaryServices.getMeta());
        this.metrics.launchedContainer();
        this.metrics.allocateContainer(tokenId.getResource());
        return response;
    }

    public StopContainerResponse stopContainer(StopContainerRequest request) throws YarnRemoteException, IOException {
        ContainerId containerID = request.getContainerId();
        String containerIDStr = containerID.toString();
        UserGroupInformation remoteUgi = this.getRemoteUgi();
        Container container = (Container)this.context.getContainers().get(containerID);
        StopContainerResponse response = (StopContainerResponse)this.recordFactory.newRecordInstance(StopContainerResponse.class);
        if (container == null) {
            LOG.warn((Object)("Trying to stop unknown container " + containerID));
            NMAuditLogger.logFailure("UnknownUser", "Stop Container Request", "ContainerManagerImpl", "Trying to stop unknown container!", containerID.getApplicationAttemptId().getApplicationId(), containerID);
            return response;
        }
        this.authorizeRequest(containerIDStr, null, remoteUgi, this.getContainerTokenIdentifier(remoteUgi, container.getContainerTokenIdentifier()));
        this.dispatcher.getEventHandler().handle((Event)new ContainerKillEvent(containerID, "Container killed by the ApplicationMaster."));
        NMAuditLogger.logSuccess(container.getUser(), "Stop Container Request", "ContainerManageImpl", containerID.getApplicationAttemptId().getApplicationId(), containerID);
        this.nodeStatusUpdater.sendOutofBandHeartBeat();
        return response;
    }

    public GetContainerStatusResponse getContainerStatus(GetContainerStatusRequest request) throws YarnRemoteException, IOException {
        ContainerId containerID = request.getContainerId();
        String containerIDStr = containerID.toString();
        UserGroupInformation remoteUgi = this.getRemoteUgi();
        LOG.info((Object)("Getting container-status for " + containerIDStr));
        Container container = (Container)this.context.getContainers().get(containerID);
        if (container == null) {
            throw RPCUtil.getRemoteException((String)("Container " + containerIDStr + " is not handled by this NodeManager"));
        }
        this.authorizeRequest(containerIDStr, null, remoteUgi, this.getContainerTokenIdentifier(remoteUgi, container.getContainerTokenIdentifier()));
        ContainerStatus containerStatus = container.cloneAndGetContainerStatus();
        LOG.info((Object)("Returning " + containerStatus));
        GetContainerStatusResponse response = (GetContainerStatusResponse)this.recordFactory.newRecordInstance(GetContainerStatusResponse.class);
        response.setStatus(containerStatus);
        return response;
    }

    public void handle(ContainerManagerEvent event) {
        switch ((ContainerManagerEventType)event.getType()) {
            case FINISH_APPS: {
                CMgrCompletedAppsEvent appsFinishedEvent = (CMgrCompletedAppsEvent)event;
                for (ApplicationId appID : appsFinishedEvent.getAppsToCleanup()) {
                    this.dispatcher.getEventHandler().handle((Event)new ApplicationFinishEvent(appID, "Application Killed by ResourceManager"));
                }
                break;
            }
            case FINISH_CONTAINERS: {
                CMgrCompletedContainersEvent containersFinishedEvent = (CMgrCompletedContainersEvent)event;
                for (ContainerId container : containersFinishedEvent.getContainersToCleanup()) {
                    String diagnostic = "";
                    if (containersFinishedEvent.getReason() == CMgrCompletedContainersEvent.Reason.ON_SHUTDOWN) {
                        diagnostic = "Container Killed on Shutdown";
                    } else if (containersFinishedEvent.getReason() == CMgrCompletedContainersEvent.Reason.BY_RESOURCEMANAGER) {
                        diagnostic = "Container Killed by ResourceManager";
                    }
                    this.dispatcher.getEventHandler().handle((Event)new ContainerKillEvent(container, diagnostic));
                }
                break;
            }
            default: {
                LOG.warn((Object)("Invalid event " + event.getType() + ". Ignoring."));
            }
        }
    }

    public void setBlockNewContainerRequests(boolean blockNewContainerRequests) {
        this.blockNewContainerRequests.set(blockNewContainerRequests);
    }

    public void stateChanged(Service service) {
    }

    class ApplicationEventDispatcher
    implements EventHandler<ApplicationEvent> {
        ApplicationEventDispatcher() {
        }

        public void handle(ApplicationEvent event) {
            Application app = (Application)ContainerManagerImpl.this.context.getApplications().get(event.getApplicationID());
            if (app != null) {
                app.handle((Event)event);
            } else {
                LOG.warn((Object)("Event " + (Object)((Object)event) + " sent to absent application " + event.getApplicationID()));
            }
        }
    }

    class ContainerEventDispatcher
    implements EventHandler<ContainerEvent> {
        ContainerEventDispatcher() {
        }

        public void handle(ContainerEvent event) {
            ConcurrentMap<ContainerId, Container> containers = ContainerManagerImpl.this.context.getContainers();
            Container c = (Container)containers.get(event.getContainerID());
            if (c != null) {
                c.handle((Event)event);
            } else {
                LOG.warn((Object)("Event " + (Object)((Object)event) + " sent to absent container " + event.getContainerID()));
            }
        }
    }
}

