/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager;

import com.google.common.annotations.VisibleForTesting;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataInputByteBuffer;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.service.ServiceStateChangeListener;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.ContainerManagementProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerStatusRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerStatusResponse;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainerRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainerResponse;
import org.apache.hadoop.yarn.api.protocolrecords.StopContainerRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StopContainerResponse;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.ipc.RPCUtil;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.security.ContainerTokenIdentifier;
import org.apache.hadoop.yarn.security.NMTokenIdentifier;
import org.apache.hadoop.yarn.server.nodemanager.CMgrCompletedAppsEvent;
import org.apache.hadoop.yarn.server.nodemanager.CMgrCompletedContainersEvent;
import org.apache.hadoop.yarn.server.nodemanager.ContainerExecutor;
import org.apache.hadoop.yarn.server.nodemanager.ContainerManagerEvent;
import org.apache.hadoop.yarn.server.nodemanager.ContainerManagerEventType;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.DeletionService;
import org.apache.hadoop.yarn.server.nodemanager.LocalDirsHandlerService;
import org.apache.hadoop.yarn.server.nodemanager.NMAuditLogger;
import org.apache.hadoop.yarn.server.nodemanager.NodeManager;
import org.apache.hadoop.yarn.server.nodemanager.NodeStatusUpdater;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.AuxServices;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.AuxServicesEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.InvalidContainerException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.NMNotYetReadyException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.Application;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationContainerInitEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationFinishEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationImpl;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationInitEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerImpl;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerKillEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.launcher.ContainersLauncher;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.launcher.ContainersLauncherEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.ResourceLocalizationService;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.event.LocalizationEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.logaggregation.LogAggregationService;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.loghandler.LogHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.loghandler.NonAggregatingLogHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.loghandler.event.LogHandlerEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.monitor.ContainersMonitor;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.monitor.ContainersMonitorEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.monitor.ContainersMonitorImpl;
import org.apache.hadoop.yarn.server.nodemanager.metrics.NodeManagerMetrics;
import org.apache.hadoop.yarn.server.nodemanager.security.authorize.NMPolicyProvider;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;

public class ContainerManagerImpl
extends CompositeService
implements ServiceStateChangeListener,
ContainerManagementProtocol,
EventHandler<ContainerManagerEvent> {
    private static final Log LOG = LogFactory.getLog(ContainerManagerImpl.class);
    final Context context;
    private final ContainersMonitor containersMonitor;
    private Server server;
    private final ResourceLocalizationService rsrcLocalizationSrvc;
    private final ContainersLauncher containersLauncher;
    private final AuxServices auxiliaryServices;
    private final NodeManagerMetrics metrics;
    private final NodeStatusUpdater nodeStatusUpdater;
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    protected LocalDirsHandlerService dirsHandler;
    protected final AsyncDispatcher dispatcher;
    private final ApplicationACLsManager aclsManager;
    private final DeletionService deletionService;
    private AtomicBoolean blockNewContainerRequests = new AtomicBoolean(false);

    public ContainerManagerImpl(Context context, ContainerExecutor exec, DeletionService deletionContext, NodeStatusUpdater nodeStatusUpdater, NodeManagerMetrics metrics, ApplicationACLsManager aclsManager, LocalDirsHandlerService dirsHandler) {
        super(ContainerManagerImpl.class.getName());
        this.context = context;
        this.dirsHandler = dirsHandler;
        this.dispatcher = new AsyncDispatcher();
        this.deletionService = deletionContext;
        this.metrics = metrics;
        this.rsrcLocalizationSrvc = this.createResourceLocalizationService(exec, deletionContext);
        this.addService((Service)this.rsrcLocalizationSrvc);
        this.containersLauncher = this.createContainersLauncher(context, exec);
        this.addService((Service)this.containersLauncher);
        this.nodeStatusUpdater = nodeStatusUpdater;
        this.aclsManager = aclsManager;
        this.auxiliaryServices = new AuxServices();
        this.auxiliaryServices.registerServiceListener(this);
        this.addService((Service)this.auxiliaryServices);
        this.containersMonitor = new ContainersMonitorImpl(exec, this.dispatcher, this.context);
        this.addService(this.containersMonitor);
        this.dispatcher.register(ContainerEventType.class, (EventHandler)new ContainerEventDispatcher());
        this.dispatcher.register(ApplicationEventType.class, (EventHandler)new ApplicationEventDispatcher());
        this.dispatcher.register(LocalizationEventType.class, (EventHandler)this.rsrcLocalizationSrvc);
        this.dispatcher.register(AuxServicesEventType.class, (EventHandler)this.auxiliaryServices);
        this.dispatcher.register(ContainersMonitorEventType.class, (EventHandler)this.containersMonitor);
        this.dispatcher.register(ContainersLauncherEventType.class, (EventHandler)this.containersLauncher);
        this.addService((Service)this.dispatcher);
    }

    public void serviceInit(Configuration conf) throws Exception {
        LogHandler logHandler = this.createLogHandler(conf, this.context, this.deletionService);
        this.addIfService(logHandler);
        this.dispatcher.register(LogHandlerEventType.class, (EventHandler)logHandler);
        super.serviceInit(conf);
    }

    private void addIfService(Object object) {
        if (object instanceof Service) {
            this.addService((Service)object);
        }
    }

    protected LogHandler createLogHandler(Configuration conf, Context context, DeletionService deletionService) {
        if (conf.getBoolean("yarn.log-aggregation-enable", false)) {
            return new LogAggregationService((Dispatcher)this.dispatcher, context, deletionService, this.dirsHandler);
        }
        return new NonAggregatingLogHandler((Dispatcher)this.dispatcher, deletionService, this.dirsHandler);
    }

    public ContainersMonitor getContainersMonitor() {
        return this.containersMonitor;
    }

    protected ResourceLocalizationService createResourceLocalizationService(ContainerExecutor exec, DeletionService deletionContext) {
        return new ResourceLocalizationService((Dispatcher)this.dispatcher, exec, deletionContext, this.dirsHandler);
    }

    protected ContainersLauncher createContainersLauncher(Context context, ContainerExecutor exec) {
        return new ContainersLauncher(context, (Dispatcher)this.dispatcher, exec, this.dirsHandler);
    }

    protected void serviceStart() throws Exception {
        Configuration conf = this.getConfig();
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        InetSocketAddress initialAddress = conf.getSocketAddr("yarn.nodemanager.address", "0.0.0.0:0", 0);
        this.server = rpc.getServer(ContainerManagementProtocol.class, (Object)this, initialAddress, conf, (SecretManager)this.context.getNMTokenSecretManager(), conf.getInt("yarn.nodemanager.container-manager.thread-count", 20));
        if (conf.getBoolean("hadoop.security.authorization", false)) {
            this.refreshServiceAcls(conf, new NMPolicyProvider());
        }
        LOG.info((Object)"Blocking new container-requests as container manager rpc server is still starting.");
        this.setBlockNewContainerRequests(true);
        this.server.start();
        InetSocketAddress connectAddress = NetUtils.getConnectAddress((Server)this.server);
        NodeId nodeId = NodeId.newInstance((String)connectAddress.getAddress().getCanonicalHostName(), (int)connectAddress.getPort());
        ((NodeManager.NMContext)this.context).setNodeId(nodeId);
        this.context.getNMTokenSecretManager().setNodeId(nodeId);
        this.context.getContainerTokenSecretManager().setNodeId(nodeId);
        LOG.info((Object)("ContainerManager started at " + connectAddress));
        super.serviceStart();
    }

    void refreshServiceAcls(Configuration configuration, PolicyProvider policyProvider) {
        this.server.refreshServiceAcl(configuration, policyProvider);
    }

    public void serviceStop() throws Exception {
        if (this.auxiliaryServices.getServiceState() == Service.STATE.STARTED) {
            this.auxiliaryServices.unregisterServiceListener(this);
        }
        if (this.server != null) {
            this.server.stop();
        }
        super.serviceStop();
    }

    protected UserGroupInformation getRemoteUgi() throws YarnException {
        UserGroupInformation remoteUgi;
        try {
            remoteUgi = UserGroupInformation.getCurrentUser();
        }
        catch (IOException e) {
            String msg = "Cannot obtain the user-name. Got exception: " + StringUtils.stringifyException((Throwable)e);
            LOG.warn((Object)msg);
            throw RPCUtil.getRemoteException((String)msg);
        }
        return remoteUgi;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    protected NMTokenIdentifier selectNMTokenIdentifier(UserGroupInformation remoteUgi) {
        Set tokenIdentifiers = remoteUgi.getTokenIdentifiers();
        NMTokenIdentifier resultId = null;
        for (TokenIdentifier id : tokenIdentifiers) {
            if (!(id instanceof NMTokenIdentifier)) continue;
            resultId = (NMTokenIdentifier)id;
            break;
        }
        return resultId;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    protected void authorizeStartRequest(NMTokenIdentifier nmTokenIdentifier, ContainerTokenIdentifier containerTokenIdentifier, UserGroupInformation ugi) throws YarnException {
        ContainerId containerId = containerTokenIdentifier.getContainerID();
        String containerIDStr = containerId.toString();
        boolean unauthorized = false;
        StringBuilder messageBuilder = new StringBuilder("Unauthorized request to start container. ");
        if (!nmTokenIdentifier.getApplicationAttemptId().equals((Object)containerId.getApplicationAttemptId())) {
            unauthorized = true;
            messageBuilder.append("\nNMToken for application attempt : ").append(nmTokenIdentifier.getApplicationAttemptId()).append(" was used for starting container with container token").append(" issued for application attempt : ").append(containerId.getApplicationAttemptId());
        } else if (!ugi.getUserName().equals(nmTokenIdentifier.getApplicationAttemptId().toString())) {
            unauthorized = true;
            messageBuilder.append("\nExpected applicationAttemptId: ").append(ugi.getUserName()).append(" Found: ").append(nmTokenIdentifier.getApplicationAttemptId().toString());
        } else if (!this.context.getContainerTokenSecretManager().isValidStartContainerRequest(containerId)) {
            unauthorized = true;
            messageBuilder.append("\n Attempt to relaunch the same ").append("container with id ").append(containerIDStr).append(".");
        } else if (containerTokenIdentifier.getExpiryTimeStamp() < System.currentTimeMillis()) {
            unauthorized = true;
            messageBuilder.append("\nThis token is expired. current time is ").append(System.currentTimeMillis()).append(" found ").append(containerTokenIdentifier.getExpiryTimeStamp());
        }
        if (unauthorized) {
            String msg = messageBuilder.toString();
            LOG.error((Object)msg);
            throw RPCUtil.getRemoteException((String)msg);
        }
    }

    public StartContainerResponse startContainer(StartContainerRequest request) throws YarnException, IOException {
        if (this.blockNewContainerRequests.get()) {
            throw new NMNotYetReadyException("Rejecting new containers as NodeManager has not yet connected with ResourceManager");
        }
        UserGroupInformation remoteUgi = this.getRemoteUgi();
        NMTokenIdentifier nmTokenIdentifier = this.selectNMTokenIdentifier(remoteUgi);
        ContainerTokenIdentifier containerTokenIdentifier = this.verifyAndGetContainerTokenIdentifier(request.getContainerToken());
        this.authorizeStartRequest(nmTokenIdentifier, containerTokenIdentifier, remoteUgi);
        if (containerTokenIdentifier.getRMIdentifer() != this.nodeStatusUpdater.getRMIdentifier()) {
            StringBuilder sb = new StringBuilder("\nContainer ");
            sb.append(containerTokenIdentifier.getContainerID().toString()).append(" rejected as it is allocated by a previous RM");
            throw new InvalidContainerException(sb.toString());
        }
        this.updateNMTokenIdentifier(nmTokenIdentifier);
        ContainerId containerId = containerTokenIdentifier.getContainerID();
        String containerIdStr = containerId.toString();
        String user = containerTokenIdentifier.getApplicationSubmitter();
        LOG.info((Object)("Start request for " + containerIdStr + " by user " + user));
        ContainerLaunchContext launchContext = request.getContainerLaunchContext();
        Credentials credentials = this.parseCredentials(launchContext);
        ContainerImpl container = new ContainerImpl(this.getConfig(), (Dispatcher)this.dispatcher, launchContext, credentials, this.metrics, containerTokenIdentifier);
        ApplicationId applicationID = containerId.getApplicationAttemptId().getApplicationId();
        if (this.context.getContainers().putIfAbsent(containerId, container) != null) {
            NMAuditLogger.logFailure(user, "Start Container Request", "ContainerManagerImpl", "Container already running on this node!", applicationID, containerId);
            throw RPCUtil.getRemoteException((String)("Container " + containerIdStr + " already is running on this node!!"));
        }
        ApplicationImpl application = new ApplicationImpl((Dispatcher)this.dispatcher, this.aclsManager, user, applicationID, credentials, this.context);
        if (null == this.context.getApplications().putIfAbsent(applicationID, application)) {
            LOG.info((Object)("Creating a new application reference for app " + applicationID));
            this.dispatcher.getEventHandler().handle((Event)new ApplicationInitEvent(applicationID, container.getLaunchContext().getApplicationACLs()));
        }
        this.dispatcher.getEventHandler().handle((Event)new ApplicationContainerInitEvent(container));
        this.context.getContainerTokenSecretManager().startContainerSuccessful(containerTokenIdentifier);
        NMAuditLogger.logSuccess(user, "Start Container Request", "ContainerManageImpl", applicationID, containerId);
        StartContainerResponse response = (StartContainerResponse)this.recordFactory.newRecordInstance(StartContainerResponse.class);
        response.setAllServicesMetaData(this.auxiliaryServices.getMetaData());
        this.metrics.launchedContainer();
        this.metrics.allocateContainer(containerTokenIdentifier.getResource());
        return response;
    }

    protected ContainerTokenIdentifier verifyAndGetContainerTokenIdentifier(org.apache.hadoop.yarn.api.records.Token token) throws YarnException, SecretManager.InvalidToken {
        ContainerTokenIdentifier containerTokenIdentifier = null;
        try {
            containerTokenIdentifier = BuilderUtils.newContainerTokenIdentifier((org.apache.hadoop.yarn.api.records.Token)token);
        }
        catch (IOException e) {
            throw RPCUtil.getRemoteException((Throwable)e);
        }
        byte[] password = this.context.getContainerTokenSecretManager().retrievePassword(containerTokenIdentifier);
        byte[] tokenPass = token.getPassword().array();
        if (password == null || tokenPass == null || !Arrays.equals(password, tokenPass)) {
            throw new SecretManager.InvalidToken("Invalid container token used for starting container on : " + this.context.getNodeId().toString());
        }
        return containerTokenIdentifier;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    protected void updateNMTokenIdentifier(NMTokenIdentifier nmTokenIdentifier) throws SecretManager.InvalidToken {
        this.context.getNMTokenSecretManager().appAttemptStartContainer(nmTokenIdentifier);
    }

    private Credentials parseCredentials(ContainerLaunchContext launchContext) throws YarnException {
        Credentials credentials = new Credentials();
        ByteBuffer tokens = launchContext.getTokens();
        if (tokens != null) {
            DataInputByteBuffer buf = new DataInputByteBuffer();
            tokens.rewind();
            buf.reset(new ByteBuffer[]{tokens});
            try {
                credentials.readTokenStorageStream((DataInputStream)buf);
                if (LOG.isDebugEnabled()) {
                    for (Token tk : credentials.getAllTokens()) {
                        LOG.debug((Object)(tk.getService() + " = " + tk.toString()));
                    }
                }
            }
            catch (IOException e) {
                throw RPCUtil.getRemoteException((Throwable)e);
            }
        }
        return credentials;
    }

    public StopContainerResponse stopContainer(StopContainerRequest request) throws YarnException, IOException {
        ContainerId containerID = request.getContainerId();
        String containerIDStr = containerID.toString();
        Container container = (Container)this.context.getContainers().get(containerID);
        LOG.info((Object)("Getting container-status for " + containerIDStr));
        this.authorizeGetAndStopContainerRequest(containerID, container, true);
        StopContainerResponse response = (StopContainerResponse)this.recordFactory.newRecordInstance(StopContainerResponse.class);
        this.dispatcher.getEventHandler().handle((Event)new ContainerKillEvent(containerID, "Container killed by the ApplicationMaster."));
        NMAuditLogger.logSuccess(container.getUser(), "Stop Container Request", "ContainerManageImpl", containerID.getApplicationAttemptId().getApplicationId(), containerID);
        this.nodeStatusUpdater.sendOutofBandHeartBeat();
        return response;
    }

    public GetContainerStatusResponse getContainerStatus(GetContainerStatusRequest request) throws YarnException, IOException {
        ContainerId containerID = request.getContainerId();
        String containerIDStr = containerID.toString();
        Container container = (Container)this.context.getContainers().get(containerID);
        LOG.info((Object)("Getting container-status for " + containerIDStr));
        this.authorizeGetAndStopContainerRequest(containerID, container, false);
        ContainerStatus containerStatus = container.cloneAndGetContainerStatus();
        LOG.info((Object)("Returning " + containerStatus));
        GetContainerStatusResponse response = (GetContainerStatusResponse)this.recordFactory.newRecordInstance(GetContainerStatusResponse.class);
        response.setStatus(containerStatus);
        return response;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    protected void authorizeGetAndStopContainerRequest(ContainerId containerId, Container container, boolean stopRequest) throws YarnException {
        UserGroupInformation remoteUgi = this.getRemoteUgi();
        NMTokenIdentifier identifier = this.selectNMTokenIdentifier(remoteUgi);
        if (!identifier.getApplicationAttemptId().equals((Object)containerId.getApplicationAttemptId()) || container != null && !identifier.getApplicationAttemptId().equals((Object)container.getContainerId().getApplicationAttemptId())) {
            if (stopRequest) {
                LOG.warn((Object)(identifier.getApplicationAttemptId() + " attempted to stop non-application container : " + container.getContainerId().toString()));
                NMAuditLogger.logFailure("UnknownUser", "Stop Container Request", "ContainerManagerImpl", "Trying to stop unknown container!", identifier.getApplicationAttemptId().getApplicationId(), container.getContainerId());
            } else {
                LOG.warn((Object)(identifier.getApplicationAttemptId() + " attempted to get get status for non-application container : " + container.getContainerId().toString()));
            }
            throw RPCUtil.getRemoteException((String)("Container " + containerId.toString() + " is not started by this application attempt."));
        }
        if (container == null) {
            throw RPCUtil.getRemoteException((String)("Container " + containerId.toString() + " is not handled by this NodeManager"));
        }
    }

    public void handle(ContainerManagerEvent event) {
        switch ((ContainerManagerEventType)event.getType()) {
            case FINISH_APPS: {
                CMgrCompletedAppsEvent appsFinishedEvent = (CMgrCompletedAppsEvent)event;
                for (ApplicationId appID : appsFinishedEvent.getAppsToCleanup()) {
                    this.dispatcher.getEventHandler().handle((Event)new ApplicationFinishEvent(appID, "Application Killed by ResourceManager"));
                }
                break;
            }
            case FINISH_CONTAINERS: {
                CMgrCompletedContainersEvent containersFinishedEvent = (CMgrCompletedContainersEvent)event;
                for (ContainerId container : containersFinishedEvent.getContainersToCleanup()) {
                    String diagnostic = "";
                    if (containersFinishedEvent.getReason() == CMgrCompletedContainersEvent.Reason.ON_SHUTDOWN) {
                        diagnostic = "Container Killed on Shutdown";
                    } else if (containersFinishedEvent.getReason() == CMgrCompletedContainersEvent.Reason.BY_RESOURCEMANAGER) {
                        diagnostic = "Container Killed by ResourceManager";
                    }
                    this.dispatcher.getEventHandler().handle((Event)new ContainerKillEvent(container, diagnostic));
                }
                break;
            }
            default: {
                LOG.warn((Object)("Invalid event " + event.getType() + ". Ignoring."));
            }
        }
    }

    public void setBlockNewContainerRequests(boolean blockNewContainerRequests) {
        this.blockNewContainerRequests.set(blockNewContainerRequests);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public boolean getBlockNewContainerRequestsStatus() {
        return this.blockNewContainerRequests.get();
    }

    public void stateChanged(Service service) {
    }

    public Context getContext() {
        return this.context;
    }

    class ApplicationEventDispatcher
    implements EventHandler<ApplicationEvent> {
        ApplicationEventDispatcher() {
        }

        public void handle(ApplicationEvent event) {
            Application app = (Application)ContainerManagerImpl.this.context.getApplications().get(event.getApplicationID());
            if (app != null) {
                app.handle((Event)event);
            } else {
                LOG.warn((Object)("Event " + (Object)((Object)event) + " sent to absent application " + event.getApplicationID()));
            }
        }
    }

    class ContainerEventDispatcher
    implements EventHandler<ContainerEvent> {
        ContainerEventDispatcher() {
        }

        public void handle(ContainerEvent event) {
            ConcurrentMap<ContainerId, Container> containers = ContainerManagerImpl.this.context.getContainers();
            Container c = (Container)containers.get(event.getContainerID());
            if (c != null) {
                c.handle((Event)event);
            } else {
                LOG.warn((Object)("Event " + (Object)((Object)event) + " sent to absent container " + event.getContainerID()));
            }
        }
    }
}

