/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.UnsupportedFileSystemException;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.yarn.proto.YarnServerNodemanagerRecoveryProtos;
import org.apache.hadoop.yarn.server.nodemanager.ContainerExecutor;
import org.apache.hadoop.yarn.server.nodemanager.recovery.NMNullStateStoreService;
import org.apache.hadoop.yarn.server.nodemanager.recovery.NMStateStoreService;

public class DeletionService
extends AbstractService {
    static final Log LOG = LogFactory.getLog(DeletionService.class);
    private int debugDelay;
    private final ContainerExecutor exec;
    private ScheduledThreadPoolExecutor sched;
    private static final FileContext lfs = DeletionService.getLfs();
    private final NMStateStoreService stateStore;
    private AtomicInteger nextTaskId = new AtomicInteger(0);

    static final FileContext getLfs() {
        try {
            return FileContext.getLocalFSFileContext();
        }
        catch (UnsupportedFileSystemException e) {
            throw new RuntimeException(e);
        }
    }

    public DeletionService(ContainerExecutor exec) {
        this(exec, new NMNullStateStoreService());
    }

    public DeletionService(ContainerExecutor exec, NMStateStoreService stateStore) {
        super(DeletionService.class.getName());
        this.exec = exec;
        this.debugDelay = 0;
        this.stateStore = stateStore;
    }

    public void delete(String user, Path subDir, Path ... baseDirs) {
        if (this.debugDelay != -1) {
            List<Path> baseDirList = null;
            if (baseDirs != null && baseDirs.length != 0) {
                baseDirList = Arrays.asList(baseDirs);
            }
            FileDeletionTask task = new FileDeletionTask(this, user, subDir, baseDirList);
            this.recordDeletionTaskInStateStore(task);
            this.sched.schedule(task, (long)this.debugDelay, TimeUnit.SECONDS);
        }
    }

    public void scheduleFileDeletionTask(FileDeletionTask fileDeletionTask) {
        if (this.debugDelay != -1) {
            this.recordDeletionTaskInStateStore(fileDeletionTask);
            this.sched.schedule(fileDeletionTask, (long)this.debugDelay, TimeUnit.SECONDS);
        }
    }

    protected void serviceInit(Configuration conf) throws Exception {
        ThreadFactory tf = new ThreadFactoryBuilder().setNameFormat("DeletionService #%d").build();
        if (conf != null) {
            this.sched = new DelServiceSchedThreadPoolExecutor(conf.getInt("yarn.nodemanager.delete.thread-count", 4), tf);
            this.debugDelay = conf.getInt("yarn.nodemanager.delete.debug-delay-sec", 0);
        } else {
            this.sched = new DelServiceSchedThreadPoolExecutor(4, tf);
        }
        this.sched.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.sched.setKeepAliveTime(60L, TimeUnit.SECONDS);
        if (this.stateStore.canRecover()) {
            this.recover(this.stateStore.loadDeletionServiceState());
        }
        super.serviceInit(conf);
    }

    protected void serviceStop() throws Exception {
        if (this.sched != null) {
            this.sched.shutdown();
            boolean terminated = false;
            try {
                terminated = this.sched.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!terminated) {
                this.sched.shutdownNow();
            }
        }
        super.serviceStop();
    }

    @InterfaceAudience.Private
    public boolean isTerminated() {
        return this.getServiceState() == Service.STATE.STOPPED && this.sched.isTerminated();
    }

    public FileDeletionTask createFileDeletionTask(String user, Path subDir, Path[] baseDirs) {
        return new FileDeletionTask(this, user, subDir, Arrays.asList(baseDirs));
    }

    private void recover(NMStateStoreService.RecoveredDeletionServiceState state) throws IOException {
        List<YarnServerNodemanagerRecoveryProtos.DeletionServiceDeleteTaskProto> taskProtos = state.getTasks();
        HashMap<Integer, DeletionTaskRecoveryInfo> idToInfoMap = new HashMap<Integer, DeletionTaskRecoveryInfo>(taskProtos.size());
        HashSet<Integer> successorTasks = new HashSet<Integer>();
        for (YarnServerNodemanagerRecoveryProtos.DeletionServiceDeleteTaskProto proto : taskProtos) {
            DeletionTaskRecoveryInfo info = this.parseTaskProto(proto);
            idToInfoMap.put(info.task.taskId, info);
            this.nextTaskId.set(Math.max(this.nextTaskId.get(), info.task.taskId));
            successorTasks.addAll(info.successorTaskIds);
        }
        long now = System.currentTimeMillis();
        for (DeletionTaskRecoveryInfo info : idToInfoMap.values()) {
            for (Integer successorId : info.successorTaskIds) {
                DeletionTaskRecoveryInfo successor = (DeletionTaskRecoveryInfo)idToInfoMap.get(successorId);
                if (successor != null) {
                    info.task.addFileDeletionTaskDependency(successor.task);
                    continue;
                }
                LOG.error((Object)("Unable to locate dependency task for deletion task " + info.task.taskId + " at " + info.task.getSubDir()));
            }
            if (successorTasks.contains(info.task.taskId)) continue;
            long msecTilDeletion = info.deletionTimestamp - now;
            this.sched.schedule(info.task, msecTilDeletion, TimeUnit.MILLISECONDS);
        }
    }

    private DeletionTaskRecoveryInfo parseTaskProto(YarnServerNodemanagerRecoveryProtos.DeletionServiceDeleteTaskProto proto) throws IOException {
        List<String> basedirs;
        int taskId = proto.getId();
        String user = proto.hasUser() ? proto.getUser() : null;
        Path subdir = null;
        ArrayList<Path> basePaths = null;
        if (proto.hasSubdir()) {
            subdir = new Path(proto.getSubdir());
        }
        if ((basedirs = proto.getBasedirsList()) != null && basedirs.size() > 0) {
            basePaths = new ArrayList<Path>(basedirs.size());
            for (String basedir : basedirs) {
                basePaths.add(new Path(basedir));
            }
        }
        FileDeletionTask task = new FileDeletionTask(taskId, this, user, subdir, basePaths);
        return new DeletionTaskRecoveryInfo(task, proto.getSuccessorIdsList(), proto.getDeletionTime());
    }

    private int generateTaskId() {
        int taskId = this.nextTaskId.incrementAndGet();
        while (taskId == -1) {
            taskId = this.nextTaskId.incrementAndGet();
        }
        return taskId;
    }

    private void recordDeletionTaskInStateStore(FileDeletionTask task) {
        FileDeletionTask[] successors;
        if (!this.stateStore.canRecover()) {
            return;
        }
        if (task.taskId != -1) {
            return;
        }
        task.taskId = this.generateTaskId();
        for (FileDeletionTask successor : successors = task.getSuccessorTasks()) {
            this.recordDeletionTaskInStateStore(successor);
        }
        YarnServerNodemanagerRecoveryProtos.DeletionServiceDeleteTaskProto.Builder builder = YarnServerNodemanagerRecoveryProtos.DeletionServiceDeleteTaskProto.newBuilder();
        builder.setId(task.taskId);
        if (task.getUser() != null) {
            builder.setUser(task.getUser());
        }
        if (task.getSubDir() != null) {
            builder.setSubdir(task.getSubDir().toString());
        }
        builder.setDeletionTime(System.currentTimeMillis() + TimeUnit.MILLISECONDS.convert(this.debugDelay, TimeUnit.SECONDS));
        if (task.getBaseDirs() != null) {
            for (Path dir : task.getBaseDirs()) {
                builder.addBasedirs(dir.toString());
            }
        }
        for (FileDeletionTask successor : successors) {
            builder.addSuccessorIds(successor.taskId);
        }
        try {
            this.stateStore.storeDeletionTask(task.taskId, builder.build());
        }
        catch (IOException e) {
            LOG.error((Object)("Unable to store deletion task " + task.taskId + " for " + task.getSubDir()), (Throwable)e);
        }
    }

    private static class DeletionTaskRecoveryInfo {
        FileDeletionTask task;
        List<Integer> successorTaskIds;
        long deletionTimestamp;

        public DeletionTaskRecoveryInfo(FileDeletionTask task, List<Integer> successorTaskIds, long deletionTimestamp) {
            this.task = task;
            this.successorTaskIds = successorTaskIds;
            this.deletionTimestamp = deletionTimestamp;
        }
    }

    public static class FileDeletionTask
    implements Runnable {
        public static final int INVALID_TASK_ID = -1;
        private int taskId;
        private final String user;
        private final Path subDir;
        private final List<Path> baseDirs;
        private final AtomicInteger numberOfPendingPredecessorTasks;
        private final Set<FileDeletionTask> successorTaskSet;
        private final DeletionService delService;
        private boolean success;

        private FileDeletionTask(DeletionService delService, String user, Path subDir, List<Path> baseDirs) {
            this(-1, delService, user, subDir, baseDirs);
        }

        private FileDeletionTask(int taskId, DeletionService delService, String user, Path subDir, List<Path> baseDirs) {
            this.taskId = taskId;
            this.delService = delService;
            this.user = user;
            this.subDir = subDir;
            this.baseDirs = baseDirs;
            this.successorTaskSet = new HashSet<FileDeletionTask>();
            this.numberOfPendingPredecessorTasks = new AtomicInteger(0);
            this.success = true;
        }

        public int incrementAndGetPendingPredecessorTasks() {
            return this.numberOfPendingPredecessorTasks.incrementAndGet();
        }

        public int decrementAndGetPendingPredecessorTasks() {
            return this.numberOfPendingPredecessorTasks.decrementAndGet();
        }

        @VisibleForTesting
        public String getUser() {
            return this.user;
        }

        @VisibleForTesting
        public Path getSubDir() {
            return this.subDir;
        }

        @VisibleForTesting
        public List<Path> getBaseDirs() {
            return this.baseDirs;
        }

        public synchronized void setSuccess(boolean success) {
            this.success = success;
        }

        public synchronized boolean getSucess() {
            return this.success;
        }

        public synchronized FileDeletionTask[] getSuccessorTasks() {
            FileDeletionTask[] successors = new FileDeletionTask[this.successorTaskSet.size()];
            return this.successorTaskSet.toArray(successors);
        }

        @Override
        public void run() {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)this);
            }
            boolean error = false;
            if (null == this.user) {
                if (this.baseDirs == null || this.baseDirs.size() == 0) {
                    LOG.debug((Object)("NM deleting absolute path : " + this.subDir));
                    try {
                        lfs.delete(this.subDir, true);
                    }
                    catch (IOException e) {
                        error = true;
                        LOG.warn((Object)("Failed to delete " + this.subDir));
                    }
                } else {
                    for (Path baseDir : this.baseDirs) {
                        Path del = this.subDir == null ? baseDir : new Path(baseDir, this.subDir);
                        LOG.debug((Object)("NM deleting path : " + del));
                        try {
                            lfs.delete(del, true);
                        }
                        catch (IOException e) {
                            error = true;
                            LOG.warn((Object)("Failed to delete " + this.subDir));
                        }
                    }
                }
            } else {
                try {
                    LOG.debug((Object)("Deleting path: [" + this.subDir + "] as user: [" + this.user + "]"));
                    if (this.baseDirs == null || this.baseDirs.size() == 0) {
                        this.delService.exec.deleteAsUser(this.user, this.subDir, null);
                    }
                    this.delService.exec.deleteAsUser(this.user, this.subDir, this.baseDirs.toArray(new Path[0]));
                }
                catch (IOException e) {
                    error = true;
                    LOG.warn((Object)("Failed to delete as user " + this.user), (Throwable)e);
                }
                catch (InterruptedException e) {
                    error = true;
                    LOG.warn((Object)("Failed to delete as user " + this.user), (Throwable)e);
                }
            }
            if (error) {
                this.setSuccess(!error);
            }
            this.fileDeletionTaskFinished();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("\nFileDeletionTask : ");
            sb.append("  user : ").append(this.user);
            sb.append("  subDir : ").append(this.subDir == null ? "null" : this.subDir.toString());
            sb.append("  baseDir : ");
            if (this.baseDirs == null || this.baseDirs.size() == 0) {
                sb.append("null");
            } else {
                for (Path baseDir : this.baseDirs) {
                    sb.append(baseDir.toString()).append(',');
                }
            }
            return sb.toString();
        }

        public synchronized void addFileDeletionTaskDependency(FileDeletionTask successorTask) {
            if (this.successorTaskSet.add(successorTask)) {
                successorTask.incrementAndGetPendingPredecessorTasks();
            }
        }

        private synchronized void fileDeletionTaskFinished() {
            try {
                this.delService.stateStore.removeDeletionTask(this.taskId);
            }
            catch (IOException e) {
                LOG.error((Object)("Unable to remove deletion task " + this.taskId + " from state store"), (Throwable)e);
            }
            for (FileDeletionTask successorTask : this.successorTaskSet) {
                int count;
                if (!this.success) {
                    successorTask.setSuccess(this.success);
                }
                if ((count = successorTask.decrementAndGetPendingPredecessorTasks()) != 0) continue;
                if (successorTask.getSucess()) {
                    successorTask.delService.scheduleFileDeletionTask(successorTask);
                    continue;
                }
                successorTask.fileDeletionTaskFinished();
            }
        }
    }

    private static class DelServiceSchedThreadPoolExecutor
    extends ScheduledThreadPoolExecutor {
        public DelServiceSchedThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory) {
            super(corePoolSize, threadFactory);
        }

        @Override
        protected void afterExecute(Runnable task, Throwable exception) {
            FutureTask futureTask;
            if (task instanceof FutureTask && !(futureTask = (FutureTask)task).isCancelled()) {
                try {
                    futureTask.get();
                }
                catch (ExecutionException ee) {
                    exception = ee.getCause();
                }
                catch (InterruptedException ie) {
                    exception = ie;
                }
            }
            if (exception != null) {
                LOG.error((Object)"Exception during execution of task in DeletionService", exception);
            }
        }
    }
}

