/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.server.nodemanager.ContainerExecutor;
import org.apache.hadoop.yarn.server.nodemanager.LocalDirsHandlerService;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerDiagnosticsUpdateEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperation;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperationException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperationExecutor;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandlerException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandlerModule;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.DelegatingLinuxContainerRuntime;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.LinuxContainerRuntime;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.LinuxContainerRuntimeConstants;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.ContainerLocalizer;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.runtime.ContainerExecutionException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.runtime.ContainerRuntimeContext;
import org.apache.hadoop.yarn.server.nodemanager.executor.ContainerLivenessContext;
import org.apache.hadoop.yarn.server.nodemanager.executor.ContainerReacquisitionContext;
import org.apache.hadoop.yarn.server.nodemanager.executor.ContainerSignalContext;
import org.apache.hadoop.yarn.server.nodemanager.executor.ContainerStartContext;
import org.apache.hadoop.yarn.server.nodemanager.executor.DeletionAsUserContext;
import org.apache.hadoop.yarn.server.nodemanager.executor.LocalizerStartContext;
import org.apache.hadoop.yarn.server.nodemanager.util.DefaultLCEResourcesHandler;
import org.apache.hadoop.yarn.server.nodemanager.util.LCEResourcesHandler;

public class LinuxContainerExecutor
extends ContainerExecutor {
    private static final Log LOG = LogFactory.getLog(LinuxContainerExecutor.class);
    private String nonsecureLocalUser;
    private Pattern nonsecureLocalUserPattern;
    private LCEResourcesHandler resourcesHandler;
    private boolean containerSchedPriorityIsSet = false;
    private int containerSchedPriorityAdjustment = 0;
    private boolean containerLimitUsers;
    private ResourceHandler resourceHandlerChain;
    private LinuxContainerRuntime linuxContainerRuntime;

    public LinuxContainerExecutor() {
    }

    public LinuxContainerExecutor(LinuxContainerRuntime linuxContainerRuntime) {
        this.linuxContainerRuntime = linuxContainerRuntime;
    }

    @Override
    public void setConf(Configuration conf) {
        super.setConf(conf);
        this.resourcesHandler = (LCEResourcesHandler)ReflectionUtils.newInstance((Class)conf.getClass("yarn.nodemanager.linux-container-executor.resources-handler.class", DefaultLCEResourcesHandler.class, LCEResourcesHandler.class), (Configuration)conf);
        this.resourcesHandler.setConf(conf);
        if (conf.get("yarn.nodemanager.container-executor.os.sched.priority.adjustment") != null) {
            this.containerSchedPriorityIsSet = true;
            this.containerSchedPriorityAdjustment = conf.getInt("yarn.nodemanager.container-executor.os.sched.priority.adjustment", 0);
        }
        this.nonsecureLocalUser = conf.get("yarn.nodemanager.linux-container-executor.nonsecure-mode.local-user", "nobody");
        this.nonsecureLocalUserPattern = Pattern.compile(conf.get("yarn.nodemanager.linux-container-executor.nonsecure-mode.user-pattern", "^[_.A-Za-z0-9][-@_.A-Za-z0-9]{0,255}?[$]?$"));
        this.containerLimitUsers = conf.getBoolean("yarn.nodemanager.linux-container-executor.nonsecure-mode.limit-users", true);
        if (!this.containerLimitUsers) {
            LOG.warn((Object)"yarn.nodemanager.linux-container-executor.nonsecure-mode.limit-users: impersonation without authentication enabled");
        }
    }

    void verifyUsernamePattern(String user) {
        if (!UserGroupInformation.isSecurityEnabled() && !this.nonsecureLocalUserPattern.matcher(user).matches()) {
            throw new IllegalArgumentException("Invalid user name '" + user + "'," + " it must match '" + this.nonsecureLocalUserPattern.pattern() + "'");
        }
    }

    String getRunAsUser(String user) {
        if (UserGroupInformation.isSecurityEnabled() || !this.containerLimitUsers) {
            return user;
        }
        return this.nonsecureLocalUser;
    }

    protected String getContainerExecutorExecutablePath(Configuration conf) {
        String yarnHomeEnvVar = System.getenv(ApplicationConstants.Environment.HADOOP_YARN_HOME.key());
        File hadoopBin = new File(yarnHomeEnvVar, "bin");
        String defaultPath = new File(hadoopBin, "container-executor").getAbsolutePath();
        return null == conf ? defaultPath : conf.get("yarn.nodemanager.linux-container-executor.path", defaultPath);
    }

    protected void addSchedPriorityCommand(List<String> command) {
        if (this.containerSchedPriorityIsSet) {
            command.addAll(Arrays.asList("nice", "-n", Integer.toString(this.containerSchedPriorityAdjustment)));
        }
    }

    @Override
    public void init() throws IOException {
        Configuration conf = super.getConf();
        try {
            PrivilegedOperation checkSetupOp = new PrivilegedOperation(PrivilegedOperation.OperationType.CHECK_SETUP);
            PrivilegedOperationExecutor privilegedOperationExecutor = PrivilegedOperationExecutor.getInstance(conf);
            privilegedOperationExecutor.executePrivilegedOperation(checkSetupOp, false);
        }
        catch (PrivilegedOperationException e) {
            int exitCode = e.getExitCode();
            LOG.warn((Object)("Exit code from container executor initialization is : " + exitCode), (Throwable)((Object)e));
            throw new IOException("Linux container executor not configured properly (error=" + exitCode + ")", (Throwable)((Object)e));
        }
        try {
            this.resourceHandlerChain = ResourceHandlerModule.getConfiguredResourceHandlerChain(conf);
            if (this.resourceHandlerChain != null) {
                this.resourceHandlerChain.bootstrap(conf);
            }
        }
        catch (ResourceHandlerException e) {
            LOG.error((Object)"Failed to bootstrap configured resource subsystems! ", (Throwable)((Object)e));
            throw new IOException("Failed to bootstrap configured resource subsystems!");
        }
        try {
            if (this.linuxContainerRuntime == null) {
                DelegatingLinuxContainerRuntime runtime = new DelegatingLinuxContainerRuntime();
                runtime.initialize(conf);
                this.linuxContainerRuntime = runtime;
            }
        }
        catch (ContainerExecutionException e) {
            throw new IOException("Failed to initialize linux container runtime(s)!");
        }
        this.resourcesHandler.init(this);
    }

    @Override
    public void startLocalizer(LocalizerStartContext ctx) throws IOException, InterruptedException {
        Path nmPrivateContainerTokensPath = ctx.getNmPrivateContainerTokens();
        InetSocketAddress nmAddr = ctx.getNmAddr();
        String user = ctx.getUser();
        String appId = ctx.getAppId();
        String locId = ctx.getLocId();
        LocalDirsHandlerService dirsHandler = ctx.getDirsHandler();
        List<String> localDirs = dirsHandler.getLocalDirs();
        List<String> logDirs = dirsHandler.getLogDirs();
        this.verifyUsernamePattern(user);
        String runAsUser = this.getRunAsUser(user);
        PrivilegedOperation initializeContainerOp = new PrivilegedOperation(PrivilegedOperation.OperationType.INITIALIZE_CONTAINER);
        ArrayList<String> prefixCommands = new ArrayList<String>();
        this.addSchedPriorityCommand(prefixCommands);
        initializeContainerOp.appendArgs(runAsUser, user, Integer.toString(PrivilegedOperation.RunAsUserCommand.INITIALIZE_CONTAINER.getValue()), appId, nmPrivateContainerTokensPath.toUri().getPath().toString(), StringUtils.join((char)'%', localDirs), StringUtils.join((char)'%', logDirs));
        File jvm = new File(new File(System.getProperty("java.home"), "bin"), "java");
        initializeContainerOp.appendArgs(jvm.toString());
        initializeContainerOp.appendArgs("-classpath");
        initializeContainerOp.appendArgs(System.getProperty("java.class.path"));
        String javaLibPath = System.getProperty("java.library.path");
        if (javaLibPath != null) {
            initializeContainerOp.appendArgs("-Djava.library.path=" + javaLibPath);
        }
        initializeContainerOp.appendArgs(ContainerLocalizer.getJavaOpts(this.getConf()));
        ArrayList<String> localizerArgs = new ArrayList<String>();
        this.buildMainArgs(localizerArgs, user, appId, locId, nmAddr, localDirs);
        initializeContainerOp.appendArgs(localizerArgs);
        try {
            Configuration conf = super.getConf();
            PrivilegedOperationExecutor privilegedOperationExecutor = PrivilegedOperationExecutor.getInstance(conf);
            privilegedOperationExecutor.executePrivilegedOperation(prefixCommands, initializeContainerOp, null, null, false, true);
        }
        catch (PrivilegedOperationException e) {
            int exitCode = e.getExitCode();
            LOG.warn((Object)("Exit code from container " + locId + " startLocalizer is : " + exitCode), (Throwable)((Object)e));
            throw new IOException("Application " + appId + " initialization failed" + " (exitCode=" + exitCode + ") with output: " + e.getOutput(), (Throwable)((Object)e));
        }
    }

    @VisibleForTesting
    public void buildMainArgs(List<String> command, String user, String appId, String locId, InetSocketAddress nmAddr, List<String> localDirs) {
        ContainerLocalizer.buildMainArgs(command, user, appId, locId, nmAddr, localDirs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int launchContainer(ContainerStartContext ctx) throws IOException {
        block31: {
            Object builder;
            String tcCommandFile;
            String resourcesOptions;
            String containerIdStr;
            ContainerId containerId;
            String runAsUser;
            Map<Path, List<String>> localizedResources;
            List<String> logDirs;
            List<String> localDirs;
            Path containerWorkDir;
            String appId;
            String user;
            Path nmPrivateTokensPath;
            Path nmPrivateContainerScriptPath;
            Container container;
            block30: {
                container = ctx.getContainer();
                nmPrivateContainerScriptPath = ctx.getNmPrivateContainerScriptPath();
                nmPrivateTokensPath = ctx.getNmPrivateTokensPath();
                user = ctx.getUser();
                appId = ctx.getAppId();
                containerWorkDir = ctx.getContainerWorkDir();
                localDirs = ctx.getLocalDirs();
                logDirs = ctx.getLogDirs();
                localizedResources = ctx.getLocalizedResources();
                this.verifyUsernamePattern(user);
                runAsUser = this.getRunAsUser(user);
                containerId = container.getContainerId();
                containerIdStr = containerId.toString();
                this.resourcesHandler.preExecute(containerId, container.getResource());
                resourcesOptions = this.resourcesHandler.getResourcesOption(containerId);
                tcCommandFile = null;
                try {
                    List<PrivilegedOperation> ops;
                    if (this.resourceHandlerChain == null || (ops = this.resourceHandlerChain.preStart(container)) == null) break block30;
                    ArrayList<PrivilegedOperation> resourceOps = new ArrayList<PrivilegedOperation>();
                    resourceOps.add(new PrivilegedOperation(PrivilegedOperation.OperationType.ADD_PID_TO_CGROUP, resourcesOptions));
                    block21: for (PrivilegedOperation op : ops) {
                        switch (op.getOperationType()) {
                            case ADD_PID_TO_CGROUP: {
                                resourceOps.add(op);
                                continue block21;
                            }
                            case TC_MODIFY_STATE: {
                                tcCommandFile = op.getArguments().get(0);
                                continue block21;
                            }
                        }
                        LOG.warn((Object)("PrivilegedOperation type unsupported in launch: " + (Object)((Object)op.getOperationType())));
                    }
                    if (resourceOps.size() <= 1) break block30;
                    try {
                        PrivilegedOperation operation = PrivilegedOperationExecutor.squashCGroupOperations(resourceOps);
                        resourcesOptions = operation.getArguments().get(0);
                    }
                    catch (PrivilegedOperationException e) {
                        LOG.error((Object)"Failed to squash cgroup operations!", (Throwable)((Object)e));
                        throw new ResourceHandlerException("Failed to squash cgroup operations!");
                    }
                }
                catch (ResourceHandlerException e) {
                    LOG.error((Object)"ResourceHandlerChain.preStart() failed!", (Throwable)((Object)e));
                    throw new IOException("ResourceHandlerChain.preStart() failed!", (Throwable)((Object)e));
                }
            }
            try {
                Path pidFilePath = this.getPidFilePath(containerId);
                if (pidFilePath != null) {
                    ArrayList<String> prefixCommands = new ArrayList<String>();
                    builder = new ContainerRuntimeContext.Builder(container);
                    this.addSchedPriorityCommand(prefixCommands);
                    if (prefixCommands.size() > 0) {
                        ((ContainerRuntimeContext.Builder)builder).setExecutionAttribute(LinuxContainerRuntimeConstants.CONTAINER_LAUNCH_PREFIX_COMMANDS, prefixCommands);
                    }
                    ((ContainerRuntimeContext.Builder)builder).setExecutionAttribute(LinuxContainerRuntimeConstants.LOCALIZED_RESOURCES, localizedResources).setExecutionAttribute(LinuxContainerRuntimeConstants.RUN_AS_USER, runAsUser).setExecutionAttribute(LinuxContainerRuntimeConstants.USER, user).setExecutionAttribute(LinuxContainerRuntimeConstants.APPID, appId).setExecutionAttribute(LinuxContainerRuntimeConstants.CONTAINER_ID_STR, containerIdStr).setExecutionAttribute(LinuxContainerRuntimeConstants.CONTAINER_WORK_DIR, containerWorkDir).setExecutionAttribute(LinuxContainerRuntimeConstants.NM_PRIVATE_CONTAINER_SCRIPT_PATH, nmPrivateContainerScriptPath).setExecutionAttribute(LinuxContainerRuntimeConstants.NM_PRIVATE_TOKENS_PATH, nmPrivateTokensPath).setExecutionAttribute(LinuxContainerRuntimeConstants.PID_FILE_PATH, pidFilePath).setExecutionAttribute(LinuxContainerRuntimeConstants.LOCAL_DIRS, localDirs).setExecutionAttribute(LinuxContainerRuntimeConstants.LOG_DIRS, logDirs).setExecutionAttribute(LinuxContainerRuntimeConstants.RESOURCES_OPTIONS, resourcesOptions);
                    if (tcCommandFile != null) {
                        ((ContainerRuntimeContext.Builder)builder).setExecutionAttribute(LinuxContainerRuntimeConstants.TC_COMMAND_FILE, tcCommandFile);
                    }
                    this.linuxContainerRuntime.launchContainer(((ContainerRuntimeContext.Builder)builder).build());
                    break block31;
                }
                LOG.info((Object)"Container was marked as inactive. Returning terminated error");
                int prefixCommands = ContainerExecutor.ExitCode.TERMINATED.getExitCode();
                return prefixCommands;
            }
            catch (ContainerExecutionException e) {
                int exitCode = e.getExitCode();
                LOG.warn((Object)("Exit code from container " + containerId + " is : " + exitCode));
                if (exitCode != ContainerExecutor.ExitCode.FORCE_KILLED.getExitCode() && exitCode != ContainerExecutor.ExitCode.TERMINATED.getExitCode()) {
                    LOG.warn((Object)("Exception from container-launch with container ID: " + containerId + " and exit code: " + exitCode), (Throwable)((Object)e));
                    builder = new StringBuilder();
                    ((StringBuilder)builder).append("Exception from container-launch.\n");
                    ((StringBuilder)builder).append("Container id: " + containerId + "\n");
                    ((StringBuilder)builder).append("Exit code: " + exitCode + "\n");
                    if (!((String)Optional.fromNullable((Object)e.getErrorOutput()).or((Object)"")).isEmpty()) {
                        ((StringBuilder)builder).append("Exception message: " + e.getErrorOutput() + "\n");
                    }
                    ((StringBuilder)builder).append("Stack trace: " + StringUtils.stringifyException((Throwable)((Object)e)) + "\n");
                    if (!e.getOutput().isEmpty()) {
                        ((StringBuilder)builder).append("Shell output: " + e.getOutput() + "\n");
                    }
                    String diagnostics = ((StringBuilder)builder).toString();
                    this.logOutput(diagnostics);
                    container.handle((Event)new ContainerDiagnosticsUpdateEvent(containerId, diagnostics));
                } else {
                    container.handle((Event)new ContainerDiagnosticsUpdateEvent(containerId, "Container killed on request. Exit code is " + exitCode));
                }
                int n = exitCode;
                return n;
            }
            finally {
                this.resourcesHandler.postExecute(containerId);
                try {
                    if (this.resourceHandlerChain != null) {
                        this.resourceHandlerChain.postComplete(containerId);
                    }
                }
                catch (ResourceHandlerException e) {
                    LOG.warn((Object)("ResourceHandlerChain.postComplete failed for containerId: " + containerId + ". Exception: " + (Object)((Object)e)));
                }
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int reacquireContainer(ContainerReacquisitionContext ctx) throws IOException, InterruptedException {
        ContainerId containerId = ctx.getContainerId();
        try {
            if (this.resourceHandlerChain != null) {
                try {
                    this.resourceHandlerChain.reacquireContainer(containerId);
                }
                catch (ResourceHandlerException e) {
                    LOG.warn((Object)("ResourceHandlerChain.reacquireContainer failed for containerId: " + containerId + " Exception: " + (Object)((Object)e)));
                }
            }
            int n = super.reacquireContainer(ctx);
            return n;
        }
        finally {
            this.resourcesHandler.postExecute(containerId);
            if (this.resourceHandlerChain != null) {
                try {
                    this.resourceHandlerChain.postComplete(containerId);
                }
                catch (ResourceHandlerException e) {
                    LOG.warn((Object)("ResourceHandlerChain.postComplete failed for containerId: " + containerId + " Exception: " + (Object)((Object)e)));
                }
            }
        }
    }

    @Override
    public boolean signalContainer(ContainerSignalContext ctx) throws IOException {
        Container container = ctx.getContainer();
        String user = ctx.getUser();
        String pid = ctx.getPid();
        ContainerExecutor.Signal signal = ctx.getSignal();
        this.verifyUsernamePattern(user);
        String runAsUser = this.getRunAsUser(user);
        ContainerRuntimeContext runtimeContext = new ContainerRuntimeContext.Builder(container).setExecutionAttribute(LinuxContainerRuntimeConstants.RUN_AS_USER, runAsUser).setExecutionAttribute(LinuxContainerRuntimeConstants.USER, user).setExecutionAttribute(LinuxContainerRuntimeConstants.PID, pid).setExecutionAttribute(LinuxContainerRuntimeConstants.SIGNAL, signal).build();
        try {
            this.linuxContainerRuntime.signalContainer(runtimeContext);
        }
        catch (ContainerExecutionException e) {
            int retCode = e.getExitCode();
            if (retCode == PrivilegedOperation.ResultCode.INVALID_CONTAINER_PID.getValue()) {
                return false;
            }
            LOG.warn((Object)("Error in signalling container " + pid + " with " + (Object)((Object)signal) + "; exit = " + retCode), (Throwable)((Object)e));
            this.logOutput(e.getOutput());
            throw new IOException("Problem signalling container " + pid + " with " + (Object)((Object)signal) + "; output: " + e.getOutput() + " and exitCode: " + retCode, (Throwable)((Object)e));
        }
        return true;
    }

    @Override
    public void deleteAsUser(DeletionAsUserContext ctx) {
        String user = ctx.getUser();
        Path dir = ctx.getSubDir();
        List<Path> baseDirs = ctx.getBasedirs();
        this.verifyUsernamePattern(user);
        String runAsUser = this.getRunAsUser(user);
        String dirString = dir == null ? "" : dir.toUri().getPath();
        PrivilegedOperation deleteAsUserOp = new PrivilegedOperation(PrivilegedOperation.OperationType.DELETE_AS_USER, (String)null);
        deleteAsUserOp.appendArgs(runAsUser, user, Integer.toString(PrivilegedOperation.RunAsUserCommand.DELETE_AS_USER.getValue()), dirString);
        ArrayList<String> pathsToDelete = new ArrayList<String>();
        if (baseDirs == null || baseDirs.size() == 0) {
            LOG.info((Object)("Deleting absolute path : " + dir));
            pathsToDelete.add(dirString);
        } else {
            for (Path baseDir : baseDirs) {
                Path del = dir == null ? baseDir : new Path(baseDir, dir);
                LOG.info((Object)("Deleting path : " + del));
                pathsToDelete.add(del.toString());
                deleteAsUserOp.appendArgs(baseDir.toUri().getPath());
            }
        }
        try {
            Configuration conf = super.getConf();
            PrivilegedOperationExecutor privilegedOperationExecutor = PrivilegedOperationExecutor.getInstance(conf);
            privilegedOperationExecutor.executePrivilegedOperation(deleteAsUserOp, false);
        }
        catch (PrivilegedOperationException e) {
            int exitCode = e.getExitCode();
            LOG.error((Object)("DeleteAsUser for " + StringUtils.join((CharSequence)" ", pathsToDelete) + " returned with exit code: " + exitCode), (Throwable)((Object)e));
        }
    }

    @Override
    public boolean isContainerAlive(ContainerLivenessContext ctx) throws IOException {
        String user = ctx.getUser();
        String pid = ctx.getPid();
        Container container = ctx.getContainer();
        return this.signalContainer(new ContainerSignalContext.Builder().setContainer(container).setUser(user).setPid(pid).setSignal(ContainerExecutor.Signal.NULL).build());
    }

    public void mountCgroups(List<String> cgroupKVs, String hierarchy) throws IOException {
        try {
            PrivilegedOperation mountCGroupsOp = new PrivilegedOperation(PrivilegedOperation.OperationType.MOUNT_CGROUPS, hierarchy);
            Configuration conf = super.getConf();
            mountCGroupsOp.appendArgs(cgroupKVs);
            PrivilegedOperationExecutor privilegedOperationExecutor = PrivilegedOperationExecutor.getInstance(conf);
            privilegedOperationExecutor.executePrivilegedOperation(mountCGroupsOp, false);
        }
        catch (PrivilegedOperationException e) {
            int exitCode = e.getExitCode();
            LOG.warn((Object)"Exception in LinuxContainerExecutor mountCgroups ", (Throwable)((Object)e));
            throw new IOException("Problem mounting cgroups " + cgroupKVs + "; exit code = " + exitCode + " and output: " + e.getOutput(), (Throwable)((Object)e));
        }
    }
}

