/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.application;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.LogAggregationContext;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.AuxServicesEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.AuxServicesEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.Application;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationContainerFinishedEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationContainerInitEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationFinishEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationInitEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationState;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerInitEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerKillEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.event.ApplicationLocalizationEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.event.LocalizationEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.loghandler.event.LogHandlerAppFinishedEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.loghandler.event.LogHandlerAppStartedEvent;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.state.InvalidStateTransitionException;
import org.apache.hadoop.yarn.state.MultipleArcTransition;
import org.apache.hadoop.yarn.state.SingleArcTransition;
import org.apache.hadoop.yarn.state.StateMachine;
import org.apache.hadoop.yarn.state.StateMachineFactory;

public class ApplicationImpl
implements Application {
    final Dispatcher dispatcher;
    final String user;
    final ApplicationId appId;
    final Credentials credentials;
    Map<ApplicationAccessType, String> applicationACLs;
    final ApplicationACLsManager aclsManager;
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;
    private final Context context;
    private static final Log LOG = LogFactory.getLog(ApplicationImpl.class);
    private LogAggregationContext logAggregationContext;
    Map<ContainerId, Container> containers = new HashMap<ContainerId, Container>();
    private static final ContainerDoneTransition CONTAINER_DONE_TRANSITION = new ContainerDoneTransition();
    private static StateMachineFactory<ApplicationImpl, ApplicationState, ApplicationEventType, ApplicationEvent> stateMachineFactory = new StateMachineFactory((Enum)ApplicationState.NEW).addTransition((Enum)ApplicationState.NEW, (Enum)ApplicationState.INITING, (Enum)ApplicationEventType.INIT_APPLICATION, (SingleArcTransition)new AppInitTransition()).addTransition((Enum)ApplicationState.NEW, (Enum)ApplicationState.NEW, (Enum)ApplicationEventType.INIT_CONTAINER, (SingleArcTransition)new InitContainerTransition()).addTransition((Enum)ApplicationState.INITING, (Enum)ApplicationState.INITING, (Enum)ApplicationEventType.INIT_CONTAINER, (SingleArcTransition)new InitContainerTransition()).addTransition((Enum)ApplicationState.INITING, EnumSet.of(ApplicationState.FINISHING_CONTAINERS_WAIT, ApplicationState.APPLICATION_RESOURCES_CLEANINGUP), (Enum)ApplicationEventType.FINISH_APPLICATION, (MultipleArcTransition)new AppFinishTriggeredTransition()).addTransition((Enum)ApplicationState.INITING, (Enum)ApplicationState.INITING, (Enum)ApplicationEventType.APPLICATION_CONTAINER_FINISHED, (SingleArcTransition)CONTAINER_DONE_TRANSITION).addTransition((Enum)ApplicationState.INITING, (Enum)ApplicationState.INITING, (Enum)ApplicationEventType.APPLICATION_LOG_HANDLING_INITED, (SingleArcTransition)new AppLogInitDoneTransition()).addTransition((Enum)ApplicationState.INITING, (Enum)ApplicationState.INITING, (Enum)ApplicationEventType.APPLICATION_LOG_HANDLING_FAILED, (SingleArcTransition)new AppLogInitFailTransition()).addTransition((Enum)ApplicationState.INITING, (Enum)ApplicationState.RUNNING, (Enum)ApplicationEventType.APPLICATION_INITED, (SingleArcTransition)new AppInitDoneTransition()).addTransition((Enum)ApplicationState.RUNNING, (Enum)ApplicationState.RUNNING, (Enum)ApplicationEventType.INIT_CONTAINER, (SingleArcTransition)new InitContainerTransition()).addTransition((Enum)ApplicationState.RUNNING, (Enum)ApplicationState.RUNNING, (Enum)ApplicationEventType.APPLICATION_CONTAINER_FINISHED, (SingleArcTransition)CONTAINER_DONE_TRANSITION).addTransition((Enum)ApplicationState.RUNNING, EnumSet.of(ApplicationState.FINISHING_CONTAINERS_WAIT, ApplicationState.APPLICATION_RESOURCES_CLEANINGUP), (Enum)ApplicationEventType.FINISH_APPLICATION, (MultipleArcTransition)new AppFinishTriggeredTransition()).addTransition((Enum)ApplicationState.FINISHING_CONTAINERS_WAIT, EnumSet.of(ApplicationState.FINISHING_CONTAINERS_WAIT, ApplicationState.APPLICATION_RESOURCES_CLEANINGUP), (Enum)ApplicationEventType.APPLICATION_CONTAINER_FINISHED, (MultipleArcTransition)new AppFinishTransition()).addTransition((Enum)ApplicationState.FINISHING_CONTAINERS_WAIT, (Enum)ApplicationState.FINISHING_CONTAINERS_WAIT, EnumSet.of(ApplicationEventType.APPLICATION_LOG_HANDLING_INITED, ApplicationEventType.APPLICATION_LOG_HANDLING_FAILED, ApplicationEventType.APPLICATION_INITED, ApplicationEventType.FINISH_APPLICATION)).addTransition((Enum)ApplicationState.APPLICATION_RESOURCES_CLEANINGUP, (Enum)ApplicationState.APPLICATION_RESOURCES_CLEANINGUP, (Enum)ApplicationEventType.APPLICATION_CONTAINER_FINISHED).addTransition((Enum)ApplicationState.APPLICATION_RESOURCES_CLEANINGUP, (Enum)ApplicationState.FINISHED, (Enum)ApplicationEventType.APPLICATION_RESOURCES_CLEANEDUP, (SingleArcTransition)new AppCompletelyDoneTransition()).addTransition((Enum)ApplicationState.APPLICATION_RESOURCES_CLEANINGUP, (Enum)ApplicationState.APPLICATION_RESOURCES_CLEANINGUP, EnumSet.of(ApplicationEventType.APPLICATION_LOG_HANDLING_INITED, ApplicationEventType.APPLICATION_LOG_HANDLING_FAILED, ApplicationEventType.APPLICATION_LOG_HANDLING_FINISHED, ApplicationEventType.APPLICATION_INITED, ApplicationEventType.FINISH_APPLICATION)).addTransition((Enum)ApplicationState.FINISHED, (Enum)ApplicationState.FINISHED, EnumSet.of(ApplicationEventType.APPLICATION_LOG_HANDLING_FINISHED, ApplicationEventType.APPLICATION_LOG_HANDLING_FAILED), (SingleArcTransition)new AppLogsAggregatedTransition()).addTransition((Enum)ApplicationState.FINISHED, (Enum)ApplicationState.FINISHED, EnumSet.of(ApplicationEventType.APPLICATION_LOG_HANDLING_INITED, ApplicationEventType.FINISH_APPLICATION)).installTopology();
    private final StateMachine<ApplicationState, ApplicationEventType, ApplicationEvent> stateMachine;

    public ApplicationImpl(Dispatcher dispatcher, String user, ApplicationId appId, Credentials credentials, Context context) {
        this.dispatcher = dispatcher;
        this.user = user;
        this.appId = appId;
        this.credentials = credentials;
        this.aclsManager = context.getApplicationACLsManager();
        this.context = context;
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
        this.stateMachine = stateMachineFactory.make((Object)this);
    }

    @Override
    public String getUser() {
        return this.user.toString();
    }

    @Override
    public ApplicationId getAppId() {
        return this.appId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApplicationState getApplicationState() {
        this.readLock.lock();
        try {
            ApplicationState applicationState = (ApplicationState)this.stateMachine.getCurrentState();
            return applicationState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<ContainerId, Container> getContainers() {
        this.readLock.lock();
        try {
            Map<ContainerId, Container> map = this.containers;
            return map;
        }
        finally {
            this.readLock.unlock();
        }
    }

    void handleAppFinishWithContainersCleanedup() {
        this.dispatcher.getEventHandler().handle((Event)new ApplicationLocalizationEvent(LocalizationEventType.DESTROY_APPLICATION_RESOURCES, this));
        this.dispatcher.getEventHandler().handle((Event)new AuxServicesEvent(AuxServicesEventType.APPLICATION_STOP, this.appId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(ApplicationEvent event) {
        this.writeLock.lock();
        try {
            ApplicationId applicationID = event.getApplicationID();
            LOG.debug((Object)("Processing " + applicationID + " of type " + event.getType()));
            ApplicationState oldState = (ApplicationState)this.stateMachine.getCurrentState();
            ApplicationState newState = null;
            try {
                newState = (ApplicationState)this.stateMachine.doTransition(event.getType(), (Object)event);
            }
            catch (InvalidStateTransitionException e) {
                LOG.warn((Object)"Can't handle this event at current state", (Throwable)e);
            }
            if (oldState != newState) {
                LOG.info((Object)("Application " + applicationID + " transitioned from " + (Object)((Object)oldState) + " to " + (Object)((Object)newState)));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public String toString() {
        return this.appId.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public LogAggregationContext getLogAggregationContext() {
        try {
            this.readLock.lock();
            LogAggregationContext logAggregationContext = this.logAggregationContext;
            return logAggregationContext;
        }
        finally {
            this.readLock.unlock();
        }
    }

    static class AppLogsAggregatedTransition
    implements SingleArcTransition<ApplicationImpl, ApplicationEvent> {
        AppLogsAggregatedTransition() {
        }

        public void transition(ApplicationImpl app, ApplicationEvent event) {
            ApplicationId appId = event.getApplicationID();
            app.context.getApplications().remove(appId);
            app.aclsManager.removeApplication(appId);
            try {
                app.context.getNMStateStore().removeApplication(appId);
            }
            catch (IOException e) {
                LOG.error((Object)"Unable to remove application from state store", (Throwable)e);
            }
        }
    }

    static class AppCompletelyDoneTransition
    implements SingleArcTransition<ApplicationImpl, ApplicationEvent> {
        AppCompletelyDoneTransition() {
        }

        public void transition(ApplicationImpl app, ApplicationEvent event) {
            app.dispatcher.getEventHandler().handle((Event)new LogHandlerAppFinishedEvent(app.appId));
            app.context.getNMTokenSecretManager().appFinished(app.getAppId());
        }
    }

    static class AppFinishTransition
    implements MultipleArcTransition<ApplicationImpl, ApplicationEvent, ApplicationState> {
        AppFinishTransition() {
        }

        public ApplicationState transition(ApplicationImpl app, ApplicationEvent event) {
            ApplicationContainerFinishedEvent containerFinishEvent = (ApplicationContainerFinishedEvent)event;
            LOG.info((Object)("Removing " + containerFinishEvent.getContainerID() + " from application " + app.toString()));
            app.containers.remove(containerFinishEvent.getContainerID());
            if (app.containers.isEmpty()) {
                app.handleAppFinishWithContainersCleanedup();
                return ApplicationState.APPLICATION_RESOURCES_CLEANINGUP;
            }
            return ApplicationState.FINISHING_CONTAINERS_WAIT;
        }
    }

    static class AppFinishTriggeredTransition
    implements MultipleArcTransition<ApplicationImpl, ApplicationEvent, ApplicationState> {
        AppFinishTriggeredTransition() {
        }

        public ApplicationState transition(ApplicationImpl app, ApplicationEvent event) {
            ApplicationFinishEvent appEvent = (ApplicationFinishEvent)event;
            if (app.containers.isEmpty()) {
                app.handleAppFinishWithContainersCleanedup();
                return ApplicationState.APPLICATION_RESOURCES_CLEANINGUP;
            }
            for (ContainerId containerID : app.containers.keySet()) {
                app.dispatcher.getEventHandler().handle((Event)new ContainerKillEvent(containerID, -107, "Container killed on application-finish event: " + appEvent.getDiagnostic()));
            }
            return ApplicationState.FINISHING_CONTAINERS_WAIT;
        }
    }

    static final class ContainerDoneTransition
    implements SingleArcTransition<ApplicationImpl, ApplicationEvent> {
        ContainerDoneTransition() {
        }

        public void transition(ApplicationImpl app, ApplicationEvent event) {
            ApplicationContainerFinishedEvent containerEvent = (ApplicationContainerFinishedEvent)event;
            if (null == app.containers.remove(containerEvent.getContainerID())) {
                LOG.warn((Object)("Removing unknown " + containerEvent.getContainerID() + " from application " + app.toString()));
            } else {
                LOG.info((Object)("Removing " + containerEvent.getContainerID() + " from application " + app.toString()));
            }
        }
    }

    static class AppInitDoneTransition
    implements SingleArcTransition<ApplicationImpl, ApplicationEvent> {
        AppInitDoneTransition() {
        }

        public void transition(ApplicationImpl app, ApplicationEvent event) {
            for (Container container : app.containers.values()) {
                app.dispatcher.getEventHandler().handle((Event)new ContainerInitEvent(container.getContainerId()));
            }
        }
    }

    static class InitContainerTransition
    implements SingleArcTransition<ApplicationImpl, ApplicationEvent> {
        InitContainerTransition() {
        }

        public void transition(ApplicationImpl app, ApplicationEvent event) {
            ApplicationContainerInitEvent initEvent = (ApplicationContainerInitEvent)event;
            Container container = initEvent.getContainer();
            app.containers.put(container.getContainerId(), container);
            LOG.info((Object)("Adding " + container.getContainerId() + " to application " + app.toString()));
            switch (app.getApplicationState()) {
                case RUNNING: {
                    app.dispatcher.getEventHandler().handle((Event)new ContainerInitEvent(container.getContainerId()));
                    break;
                }
                case INITING: 
                case NEW: {
                    break;
                }
                default: {
                    assert (false) : "Invalid state for InitContainerTransition: " + (Object)((Object)app.getApplicationState());
                    break;
                }
            }
        }
    }

    static class AppLogInitFailTransition
    implements SingleArcTransition<ApplicationImpl, ApplicationEvent> {
        AppLogInitFailTransition() {
        }

        public void transition(ApplicationImpl app, ApplicationEvent event) {
            LOG.warn((Object)"Log Aggregation service failed to initialize, there will be no logs for this application");
            app.dispatcher.getEventHandler().handle((Event)new ApplicationLocalizationEvent(LocalizationEventType.INIT_APPLICATION_RESOURCES, app));
        }
    }

    static class AppLogInitDoneTransition
    implements SingleArcTransition<ApplicationImpl, ApplicationEvent> {
        AppLogInitDoneTransition() {
        }

        public void transition(ApplicationImpl app, ApplicationEvent event) {
            app.dispatcher.getEventHandler().handle((Event)new ApplicationLocalizationEvent(LocalizationEventType.INIT_APPLICATION_RESOURCES, app));
        }
    }

    static class AppInitTransition
    implements SingleArcTransition<ApplicationImpl, ApplicationEvent> {
        AppInitTransition() {
        }

        public void transition(ApplicationImpl app, ApplicationEvent event) {
            ApplicationInitEvent initEvent = (ApplicationInitEvent)event;
            app.applicationACLs = initEvent.getApplicationACLs();
            app.aclsManager.addApplication(app.getAppId(), app.applicationACLs);
            app.logAggregationContext = initEvent.getLogAggregationContext();
            app.dispatcher.getEventHandler().handle((Event)new LogHandlerAppStartedEvent(app.appId, app.user, app.credentials, app.applicationACLs, app.logAggregationContext));
        }
    }
}

