/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.recovery;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.yarn.api.records.ApplicationMaster;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.ApplicationsStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.MemStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.Store;

public class StoreFactory {
    public static Store getStore(Configuration conf) {
        Store store = (Store)ReflectionUtils.newInstance((Class)conf.getClass("yarn.resourcemanager.store.class", MemStore.class, Store.class), (Configuration)conf);
        return store;
    }

    public static ApplicationsStore.ApplicationStore createVoidAppStore() {
        return new VoidApplicationStore();
    }

    private static class VoidApplicationStore
    implements ApplicationsStore.ApplicationStore {
        @Override
        public void storeContainer(Container container) throws IOException {
        }

        @Override
        public void removeContainer(Container container) throws IOException {
        }

        @Override
        public void storeMasterContainer(Container container) throws IOException {
        }

        @Override
        public void updateApplicationState(ApplicationMaster master) throws IOException {
        }

        @Override
        public boolean isLoggable() {
            return false;
        }
    }
}

