/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.inject.Inject;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.AppsList;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.JQueryUI;

class AppsBlock
extends HtmlBlock {
    final AppsList list;

    @Inject
    AppsBlock(AppsList list, View.ViewContext ctx) {
        super(ctx);
        this.list = list;
    }

    public void render(HtmlBlock.Block html) {
        Hamlet.TBODY tbody = ((Hamlet.TABLE)((Hamlet.THEAD)html.table("#apps").thead().tr().th(".id", "ID").th(".user", "User").th(".name", "Name").th(".queue", "Queue").th(".state", "State").th(".finalstatus", "FinalStatus").th(".progress", "Progress").th(".ui", "Tracking UI").th(".note", "Note")._())._()).tbody();
        int i = 0;
        for (RMApp app : this.list.apps.values()) {
            boolean trackingUrlIsNotReady;
            String appId = app.getApplicationId().toString();
            String trackingUrl = app.getTrackingUrl();
            boolean bl = trackingUrlIsNotReady = trackingUrl == null || trackingUrl.isEmpty() || "N/A".equalsIgnoreCase(trackingUrl);
            String ui = trackingUrlIsNotReady ? "UNASSIGNED" : (app.getFinishTime() == 0L ? "ApplicationMaster" : "History");
            String percent = String.format("%.1f", Float.valueOf(app.getProgress() * 100.0f));
            ((Hamlet.TR)((Hamlet.TR)((Hamlet.TD)((Hamlet.DIV)((Hamlet.TD)((Hamlet.TR)((Hamlet.TD)tbody.tr().td().br().$title(String.valueOf(app.getApplicationId().getId()))._()).a(this.url(new String[]{"app", appId}), appId)._()).td(app.getUser().toString()).td(app.getName().toString()).td(app.getQueue().toString()).td(app.getState().toString()).td(app.getFinalApplicationStatus().toString()).td().br().$title(percent)._()).div(".ui-progressbar.ui-widget.ui-widget-content.ui-corner-all").$title(StringHelper.join((Object[])new Object[]{percent, Character.valueOf('%')})).div(".ui-progressbar-value.ui-widget-header.ui-corner-left").$style(StringHelper.join((Object[])new Object[]{"width:", percent, Character.valueOf('%')}))._())._())._()).td().a(trackingUrlIsNotReady ? "#" : StringHelper.join((Object[])new Object[]{"http://", trackingUrl}), ui)._()).td(app.getDiagnostics().toString())._();
            if (this.list.rendering == JQueryUI.Render.HTML || ++i < 20) continue;
            break;
        }
        ((Hamlet.TABLE)tbody._())._();
        if (this.list.rendering == JQueryUI.Render.JS_ARRAY) {
            this.echo(new Object[]{"<script type='text/javascript'>\n", "var appsData="});
            this.list.toDataTableArrays(this.writer());
            this.echo(new Object[]{"\n</script>\n"});
        }
    }
}

