/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.inject.Inject;
import com.google.inject.servlet.RequestScoped;
import java.io.PrintWriter;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.webapp.Controller;
import org.apache.hadoop.yarn.webapp.ToJSON;
import org.apache.hadoop.yarn.webapp.view.JQueryUI;
import org.apache.hadoop.yarn.webapp.view.Jsons;

@RequestScoped
class AppsList
implements ToJSON {
    final Controller.RequestContext rc;
    final ConcurrentMap<ApplicationId, RMApp> apps;
    JQueryUI.Render rendering;

    @Inject
    AppsList(Controller.RequestContext ctx, RMContext rmContext) {
        this.rc = ctx;
        this.apps = rmContext.getRMApps();
    }

    void toDataTableArrays(PrintWriter out) {
        out.append('[');
        boolean first = true;
        for (RMApp app : this.apps.values()) {
            boolean trackingUrlIsNotReady;
            if (first) {
                first = false;
            } else {
                out.append(",\n");
            }
            String appID = app.getApplicationId().toString();
            String trackingUrl = app.getTrackingUrl();
            boolean bl = trackingUrlIsNotReady = trackingUrl == null || trackingUrl.isEmpty() || "N/A".equalsIgnoreCase(trackingUrl);
            String ui = trackingUrlIsNotReady ? "UNASSIGNED" : (app.getFinishTime() == 0L ? "ApplicationMaster" : "History");
            out.append("[\"");
            Jsons.appendSortable((PrintWriter)out, (Object)app.getApplicationId().getId());
            Jsons.appendLink((PrintWriter)out, (Object)appID, (String)this.rc.prefix(), (String[])new String[]{"app", appID}).append("\",\"").append(StringEscapeUtils.escapeHtml((String)app.getUser().toString())).append("\",\"").append(StringEscapeUtils.escapeHtml((String)app.getName().toString())).append("\",\"").append(StringEscapeUtils.escapeHtml((String)app.getQueue())).append("\",\"").append(app.getState().toString()).append("\",\"").append(app.getFinalApplicationStatus().toString()).append("\",\"");
            Jsons.appendProgressBar((PrintWriter)out, (float)app.getProgress()).append("\",\"");
            Jsons.appendLink((PrintWriter)out, (Object)ui, (String)this.rc.prefix(), (String[])new String[]{trackingUrlIsNotReady ? "#" : "http://", trackingUrl}).append("\",\"").append(StringEscapeUtils.escapeJavaScript((String)StringEscapeUtils.escapeHtml((String)app.getDiagnostics().toString()))).append("\"]");
        }
        out.append(']');
    }

    public void toJSON(PrintWriter out) {
        out.print("{\"aaData\":");
        this.toDataTableArrays(out);
        out.print("}\n");
    }
}

