/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.inject.Inject;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.QueueState;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNodeReport;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fifo.FifoScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.AppsBlock;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.MetricsOverviewTable;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RmView;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.SubView;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.HtmlPage;
import org.apache.hadoop.yarn.webapp.view.InfoBlock;

class DefaultSchedulerPage
extends RmView {
    static final String _Q = ".ui-state-default.ui-corner-all";
    static final float WIDTH_F = 0.8f;
    static final String Q_END = "left:101%";
    static final String OVER = "font-size:1px;background:rgba(255, 140, 0, 0.8)";
    static final String UNDER = "font-size:1px;background:rgba(50, 205, 50, 0.8)";
    static final float EPSILON = 1.0E-8f;

    DefaultSchedulerPage() {
    }

    protected void postHead(Hamlet.HTML<HtmlPage._> html) {
        ((Hamlet.HTML)html.style().$type("text/css")._(new Object[]{"#cs { padding: 0.5em 0 1em 0; margin-bottom: 1em; position: relative }", "#cs ul { list-style: none }", "#cs a { font-weight: normal; margin: 2px; position: relative }", "#cs a span { font-weight: normal; font-size: 80% }", "#cs-wrapper .ui-widget-header { padding: 0.2em 0.5em }", "table.info tr th {width: 50%}"})._()).script("/static/jt/jquery.jstree.js").script().$type("text/javascript")._(new Object[]{"$(function() {", "  $('#cs a span').addClass('ui-corner-all').css('position', 'absolute');", "  $('#cs').bind('loaded.jstree', function (e, data) {", "    data.inst.open_all(); }).", "    jstree({", "    core: { animation: 188, html_titles: true },", "    plugins: ['themeroller', 'html_data', 'ui'],", "    themeroller: { item_open: 'ui-icon-minus',", "      item_clsd: 'ui-icon-plus', item_leaf: 'ui-icon-gear'", "    }", "  });", "  $('#cs').bind('select_node.jstree', function(e, data) {", "    var q = $('.q', data.rslt.obj).first().text();", "    if (q == 'root') q = '';", "    $('#apps').dataTable().fnFilter(q, 3);", "  });", "  $('#cs').show();", "});"})._();
    }

    @Override
    protected Class<? extends SubView> content() {
        return QueuesBlock.class;
    }

    static String percent(float f) {
        return String.format("%.1f%%", Float.valueOf(f * 100.0f));
    }

    static String width(float f) {
        return String.format("width:%.1f%%", Float.valueOf(f * 100.0f));
    }

    static String left(float f) {
        return String.format("left:%.1f%%", Float.valueOf(f * 100.0f));
    }

    static class QueuesBlock
    extends HtmlBlock {
        final FifoScheduler fs;
        final String qName;
        final QueueInfo qInfo;

        @Inject
        QueuesBlock(ResourceManager rm) {
            this.fs = (FifoScheduler)rm.getResourceScheduler();
            this.qName = this.fs.getQueueInfo("", false, false).getQueueName();
            this.qInfo = this.fs.getQueueInfo(this.qName, false, false);
        }

        public void render(HtmlBlock.Block html) {
            html._(MetricsOverviewTable.class);
            Hamlet.UL ul = ((Hamlet.DIV)html.div("#cs-wrapper.ui-widget").div(".ui-widget-header.ui-corner-top")._(new Object[]{"FifoScheduler Queue"})._()).div("#cs.ui-widget-content.ui-corner-bottom").ul();
            if (this.fs == null) {
                ((Hamlet.LI)((Hamlet.A)ul.li().a(DefaultSchedulerPage._Q).$style(DefaultSchedulerPage.width(0.8f)).span().$style(DefaultSchedulerPage.Q_END)._(new Object[]{"100% "})._()).span(".q", "default")._())._();
            } else {
                float used = this.qInfo.getCurrentCapacity() / 100.0f;
                float set = this.qInfo.getCapacity() / 100.0f;
                float delta = Math.abs(set - used) + 0.001f;
                ((Hamlet.LI)((Hamlet.A)((Hamlet.A)ul.li().a(DefaultSchedulerPage._Q).$style(DefaultSchedulerPage.width(0.8f)).$title(StringHelper.join((Object[])new Object[]{"used:", DefaultSchedulerPage.percent(used)})).span().$style(DefaultSchedulerPage.Q_END)._(new Object[]{"100%"})._()).span().$style(StringHelper.join((Object[])new Object[]{DefaultSchedulerPage.width(delta), Character.valueOf(';'), used > set ? DefaultSchedulerPage.OVER : DefaultSchedulerPage.UNDER, Character.valueOf(';'), used > set ? DefaultSchedulerPage.left(set) : DefaultSchedulerPage.left(used)}))._(new Object[]{"."})._()).span(".q", this.qName)._())._(QueueInfoBlock.class)._();
            }
            ((Hamlet)((Hamlet.DIV)((Hamlet.DIV)((Hamlet.DIV)ul._())._()).script().$type("text/javascript")._(new Object[]{"$('#cs').hide();"})._())._())._(AppsBlock.class);
        }
    }

    static class QueueInfoBlock
    extends HtmlBlock {
        final RMContext rmContext;
        final FifoScheduler fs;
        final String qName;
        final QueueInfo qInfo;

        @Inject
        QueueInfoBlock(RMContext context, View.ViewContext ctx, ResourceManager rm) {
            super(ctx);
            this.rmContext = context;
            this.fs = (FifoScheduler)rm.getResourceScheduler();
            this.qName = this.fs.getQueueInfo("", false, false).getQueueName();
            this.qInfo = this.fs.getQueueInfo(this.qName, true, true);
        }

        public void render(HtmlBlock.Block html) {
            String minmemoryresource = Integer.toString(this.fs.getMinimumResourceCapability().getMemory());
            String maxmemoryresource = Integer.toString(this.fs.getMaximumResourceCapability().getMemory());
            String qstate = this.qInfo.getQueueState() == QueueState.RUNNING ? "Running" : (this.qInfo.getQueueState() == QueueState.STOPPED ? "Stopped" : "Unknown");
            int usedNodeMem = 0;
            int availNodeMem = 0;
            int totNodeMem = 0;
            int nodeContainers = 0;
            for (RMNode ni : this.rmContext.getRMNodes().values()) {
                SchedulerNodeReport report = this.fs.getNodeReport(ni.getNodeID());
                usedNodeMem += report.getUsedResource().getMemory();
                availNodeMem += report.getAvailableResource().getMemory();
                totNodeMem += ni.getTotalCapability().getMemory();
                nodeContainers += this.fs.getNodeReport(ni.getNodeID()).getNumContainers();
            }
            this.info("'" + this.qName + "' Queue Status")._("Queue State:", (Object)qstate)._("Minimum Queue Memory Capacity:", (Object)minmemoryresource)._("Maximum Queue Memory Capacity:", (Object)maxmemoryresource)._("Number of Nodes:", (Object)Integer.toString(this.rmContext.getRMNodes().size()))._("Used Node Capacity:", (Object)Integer.toString(usedNodeMem))._("Available Node Capacity:", (Object)Integer.toString(availNodeMem))._("Total Node Capacity:", (Object)Integer.toString(totNodeMem))._("Number of Node Containers:", (Object)Integer.toString(nodeContainers));
            html._(InfoBlock.class);
        }
    }
}

