/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.inject.Inject;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.server.resourcemanager.ClusterMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;

public class MetricsOverviewTable
extends HtmlBlock {
    private static final long BYTES_IN_GB = 0x40000000L;
    private final RMContext rmContext;
    private final ResourceManager rm;

    @Inject
    MetricsOverviewTable(RMContext context, ResourceManager rm, View.ViewContext ctx) {
        super(ctx);
        this.rmContext = context;
        this.rm = rm;
    }

    protected void render(HtmlBlock.Block html) {
        QueueMetrics userMetrics;
        html.style(new Object[]{".metrics {margin-bottom:5px}"});
        ResourceScheduler rs = this.rm.getResourceScheduler();
        QueueMetrics metrics = rs.getRootQueueMetrics();
        ClusterMetrics clusterMetrics = ClusterMetrics.getMetrics();
        int appsSubmitted = metrics.getAppsSubmitted();
        int reservedGB = metrics.getReservedGB();
        int availableGB = metrics.getAvailableGB();
        int allocatedGB = metrics.getAllocatedGB();
        int containersAllocated = metrics.getAllocatedContainers();
        int totalGB = availableGB + reservedGB + allocatedGB;
        int totalNodes = clusterMetrics.getNumNMs();
        int lostNodes = clusterMetrics.getNumLostNMs();
        int unhealthyNodes = clusterMetrics.getUnhealthyNMs();
        int decommissionedNodes = clusterMetrics.getNumDecommisionedNMs();
        int rebootedNodes = clusterMetrics.getNumRebootedNMs();
        Hamlet.DIV div = html.div().$class("metrics");
        ((Hamlet.TABLE)((Hamlet.TBODY)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TABLE)((Hamlet.THEAD)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)div.table("#metricsoverview").thead().$class("ui-widget-header").tr().th().$class("ui-state-default")._(new Object[]{"Apps Submitted"})._()).th().$class("ui-state-default")._(new Object[]{"Containers Running"})._()).th().$class("ui-state-default")._(new Object[]{"Memory Used"})._()).th().$class("ui-state-default")._(new Object[]{"Memopry Total"})._()).th().$class("ui-state-default")._(new Object[]{"Memory Reserved"})._()).th().$class("ui-state-default")._(new Object[]{"Total Nodes"})._()).th().$class("ui-state-default")._(new Object[]{"Decommissioned Nodes"})._()).th().$class("ui-state-default")._(new Object[]{"Lost Nodes"})._()).th().$class("ui-state-default")._(new Object[]{"Unhealthy Nodes"})._()).th().$class("ui-state-default")._(new Object[]{"Rebooted Nodes"})._())._())._()).tbody().$class("ui-widget-content").tr().td(String.valueOf(appsSubmitted)).td(String.valueOf(containersAllocated)).td(StringUtils.byteDesc((long)((long)allocatedGB * 0x40000000L))).td(StringUtils.byteDesc((long)((long)totalGB * 0x40000000L))).td(StringUtils.byteDesc((long)((long)reservedGB * 0x40000000L))).td().a(this.url(new String[]{"nodes"}), String.valueOf(totalNodes))._()).td().a(this.url(new String[]{"nodes/decommissioned"}), String.valueOf(decommissionedNodes))._()).td().a(this.url(new String[]{"nodes/lost"}), String.valueOf(lostNodes))._()).td().a(this.url(new String[]{"nodes/unhealthy"}), String.valueOf(unhealthyNodes))._()).td().a(this.url(new String[]{"nodes/rebooted"}), String.valueOf(rebootedNodes))._())._())._())._();
        String user = this.request().getRemoteUser();
        if (user != null && (userMetrics = metrics.getUserMetrics(user)) != null) {
            int myAppsSubmitted = userMetrics.getAppsSubmitted();
            int myRunningContainers = userMetrics.getAllocatedContainers();
            int myPendingContainers = userMetrics.getPendingContainers();
            int myReservedContainers = userMetrics.getReservedContainers();
            int myReservedGB = userMetrics.getReservedGB();
            int myPendingGB = userMetrics.getPendingGB();
            int myAllocatedGB = userMetrics.getAllocatedGB();
            ((Hamlet.TABLE)((Hamlet.TBODY)((Hamlet.TABLE)((Hamlet.THEAD)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)div.table("#usermetricsoverview").thead().$class("ui-widget-header").tr().th().$class("ui-state-default")._(new Object[]{"Apps Submitted (" + user + ")"})._()).th().$class("ui-state-default")._(new Object[]{"Containers Running (" + user + ")"})._()).th().$class("ui-state-default")._(new Object[]{"Containers Pending (" + user + ")"})._()).th().$class("ui-state-default")._(new Object[]{"Containers Reserved (" + user + ")"})._()).th().$class("ui-state-default")._(new Object[]{"Memory Used (" + user + ")"})._()).th().$class("ui-state-default")._(new Object[]{"Memory Pending (" + user + ")"})._()).th().$class("ui-state-default")._(new Object[]{"Memory Reserved (" + user + ")"})._())._())._()).tbody().$class("ui-widget-content").tr().td(String.valueOf(myAppsSubmitted)).td(String.valueOf(myRunningContainers)).td(String.valueOf(myPendingContainers)).td(String.valueOf(myReservedContainers)).td(StringUtils.byteDesc((long)((long)myAllocatedGB * 0x40000000L))).td(StringUtils.byteDesc((long)((long)myPendingGB * 0x40000000L))).td(StringUtils.byteDesc((long)((long)myReservedGB * 0x40000000L)))._())._())._();
        }
        div._();
    }
}

