/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.resource;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class Resources {
    private static final Resource NONE = new Resource(){

        public int getMemory() {
            return 0;
        }

        public void setMemory(int memory) {
            throw new RuntimeException("NONE cannot be modified!");
        }

        public int compareTo(Resource o) {
            return 0 - o.getMemory();
        }
    };

    public static Resource createResource(int memory) {
        Resource resource = (Resource)Records.newRecord(Resource.class);
        resource.setMemory(memory);
        return resource;
    }

    public static Resource none() {
        return NONE;
    }

    public static Resource clone(Resource res) {
        return Resources.createResource(res.getMemory());
    }

    public static Resource addTo(Resource lhs, Resource rhs) {
        lhs.setMemory(lhs.getMemory() + rhs.getMemory());
        return lhs;
    }

    public static Resource add(Resource lhs, Resource rhs) {
        return Resources.addTo(Resources.clone(lhs), rhs);
    }

    public static Resource subtractFrom(Resource lhs, Resource rhs) {
        lhs.setMemory(lhs.getMemory() - rhs.getMemory());
        return lhs;
    }

    public static Resource subtract(Resource lhs, Resource rhs) {
        return Resources.subtractFrom(Resources.clone(lhs), rhs);
    }

    public static Resource negate(Resource resource) {
        return Resources.subtract(NONE, resource);
    }

    public static Resource multiplyTo(Resource lhs, int by) {
        lhs.setMemory(lhs.getMemory() * by);
        return lhs;
    }

    public static Resource multiply(Resource lhs, int by) {
        return Resources.multiplyTo(Resources.clone(lhs), by);
    }

    public static boolean equals(Resource lhs, Resource rhs) {
        return lhs.getMemory() == rhs.getMemory();
    }

    public static boolean lessThan(Resource lhs, Resource rhs) {
        return lhs.getMemory() < rhs.getMemory();
    }

    public static boolean lessThanOrEqual(Resource lhs, Resource rhs) {
        return lhs.getMemory() <= rhs.getMemory();
    }

    public static boolean greaterThan(Resource lhs, Resource rhs) {
        return lhs.getMemory() > rhs.getMemory();
    }

    public static boolean greaterThanOrEqual(Resource lhs, Resource rhs) {
        return lhs.getMemory() >= rhs.getMemory();
    }

    public static Resource min(Resource lhs, Resource rhs) {
        return lhs.getMemory() < rhs.getMemory() ? lhs : rhs;
    }

    public static Resource max(Resource lhs, Resource rhs) {
        return lhs.getMemory() > rhs.getMemory() ? lhs : rhs;
    }
}

