/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterInt;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableGaugeInt;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.resource.Resources;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AppSchedulingInfo;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.TimeBucketMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metrics(context="yarn")
@InterfaceAudience.Private
public class QueueMetrics
implements MetricsSource {
    @Metric(value={"# of apps submitted"})
    MutableCounterInt appsSubmitted;
    @Metric(value={"# of running apps"})
    MutableGaugeInt appsRunning;
    @Metric(value={"# of pending apps"})
    MutableGaugeInt appsPending;
    @Metric(value={"# of apps completed"})
    MutableCounterInt appsCompleted;
    @Metric(value={"# of apps killed"})
    MutableCounterInt appsKilled;
    @Metric(value={"# of apps failed"})
    MutableCounterInt appsFailed;
    @Metric(value={"Allocated memory in MB"})
    MutableGaugeInt allocatedMB;
    @Metric(value={"# of allocated containers"})
    MutableGaugeInt allocatedContainers;
    @Metric(value={"Aggregate # of allocated containers"})
    MutableCounterLong aggregateContainersAllocated;
    @Metric(value={"Aggregate # of released containers"})
    MutableCounterLong aggregateContainersReleased;
    @Metric(value={"Available memory in MB"})
    MutableGaugeInt availableMB;
    @Metric(value={"Pending memory allocation in MB"})
    MutableGaugeInt pendingMB;
    @Metric(value={"# of pending containers"})
    MutableGaugeInt pendingContainers;
    @Metric(value={"# of reserved memory in MB"})
    MutableGaugeInt reservedMB;
    @Metric(value={"# of reserved containers"})
    MutableGaugeInt reservedContainers;
    @Metric(value={"# of active users"})
    MutableGaugeInt activeUsers;
    @Metric(value={"# of active users"})
    MutableGaugeInt activeApplications;
    private final MutableGaugeInt[] runningTime;
    private TimeBucketMetrics<ApplicationId> runBuckets;
    static final Logger LOG = LoggerFactory.getLogger(QueueMetrics.class);
    static final MetricsInfo RECORD_INFO = Interns.info((String)"QueueMetrics", (String)"Metrics for the resource scheduler");
    static final MetricsInfo QUEUE_INFO = Interns.info((String)"Queue", (String)"Metrics by queue");
    static final MetricsInfo USER_INFO = Interns.info((String)"User", (String)"Metrics by user");
    static final Splitter Q_SPLITTER = Splitter.on((char)'.').omitEmptyStrings().trimResults();
    final MetricsRegistry registry = new MetricsRegistry(RECORD_INFO);
    final String queueName;
    final QueueMetrics parent;
    final MetricsSystem metricsSystem;
    private final Map<String, QueueMetrics> users;
    private final Configuration conf;

    QueueMetrics(MetricsSystem ms, String queueName, Queue parent, boolean enableUserMetrics, Configuration conf) {
        this.queueName = queueName;
        this.parent = parent != null ? parent.getMetrics() : null;
        this.users = enableUserMetrics ? new HashMap() : null;
        this.metricsSystem = ms;
        this.conf = conf;
        this.runningTime = this.buildBuckets(conf);
    }

    QueueMetrics tag(MetricsInfo info, String value) {
        this.registry.tag(info, value);
        return this;
    }

    static StringBuilder sourceName(String queueName) {
        StringBuilder sb = new StringBuilder(RECORD_INFO.name());
        int i = 0;
        for (String node : Q_SPLITTER.split((CharSequence)queueName)) {
            sb.append(",q").append(i++).append('=').append(node);
        }
        return sb;
    }

    public static synchronized QueueMetrics forQueue(String queueName, Queue parent, boolean enableUserMetrics, Configuration conf) {
        return QueueMetrics.forQueue(DefaultMetricsSystem.instance(), queueName, parent, enableUserMetrics, conf);
    }

    public static QueueMetrics forQueue(MetricsSystem ms, String queueName, Queue parent, boolean enableUserMetrics, Configuration conf) {
        QueueMetrics metrics = new QueueMetrics(ms, queueName, parent, enableUserMetrics, conf).tag(QUEUE_INFO, queueName);
        return ms == null ? metrics : (QueueMetrics)ms.register(QueueMetrics.sourceName(queueName).toString(), "Metrics for queue: " + queueName, (Object)metrics);
    }

    public synchronized QueueMetrics getUserMetrics(String userName) {
        if (this.users == null) {
            return null;
        }
        QueueMetrics metrics = this.users.get(userName);
        if (metrics == null) {
            metrics = new QueueMetrics(this.metricsSystem, this.queueName, null, false, this.conf);
            this.users.put(userName, metrics);
            this.metricsSystem.register(QueueMetrics.sourceName(this.queueName).append(",user=").append(userName).toString(), "Metrics for user '" + userName + "' in queue '" + this.queueName + "'", (Object)metrics.tag(QUEUE_INFO, this.queueName).tag(USER_INFO, userName));
        }
        return metrics;
    }

    private ArrayList<Integer> parseInts(String value) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (String s : value.split(",")) {
            result.add(Integer.parseInt(s.trim()));
        }
        return result;
    }

    private MutableGaugeInt[] buildBuckets(Configuration conf) {
        ArrayList<Integer> buckets = this.parseInts(conf.get("yarn.resourcemanager.metrics.runtime.buckets", "60,300,1440"));
        MutableGaugeInt[] result = new MutableGaugeInt[buckets.size() + 1];
        result[0] = this.registry.newGauge("running_0", "", 0);
        long[] cuts = new long[buckets.size()];
        for (int i = 0; i < buckets.size(); ++i) {
            result[i + 1] = this.registry.newGauge("running_" + buckets.get(i), "", 0);
            cuts[i] = (long)buckets.get(i).intValue() * 1000L * 60L;
        }
        this.runBuckets = new TimeBucketMetrics(cuts);
        return result;
    }

    private void updateRunningTime() {
        int[] counts = this.runBuckets.getBucketCounts(System.currentTimeMillis());
        for (int i = 0; i < counts.length; ++i) {
            this.runningTime[i].set(counts[i]);
        }
    }

    public void getMetrics(MetricsCollector collector, boolean all) {
        this.updateRunningTime();
        this.registry.snapshot(collector.addRecord(this.registry.info()), all);
    }

    public void submitApp(String user) {
        this.appsSubmitted.incr();
        this.appsPending.incr();
        QueueMetrics userMetrics = this.getUserMetrics(user);
        if (userMetrics != null) {
            userMetrics.submitApp(user);
        }
        if (this.parent != null) {
            this.parent.submitApp(user);
        }
    }

    public void incrAppsRunning(AppSchedulingInfo app, String user) {
        this.runBuckets.add(app.getApplicationId(), System.currentTimeMillis());
        this.appsRunning.incr();
        this.appsPending.decr();
        QueueMetrics userMetrics = this.getUserMetrics(user);
        if (userMetrics != null) {
            userMetrics.incrAppsRunning(app, user);
        }
        if (this.parent != null) {
            this.parent.incrAppsRunning(app, user);
        }
    }

    public void finishApp(AppSchedulingInfo app, RMAppAttemptState rmAppAttemptFinalState) {
        this.runBuckets.remove(app.getApplicationId());
        switch (rmAppAttemptFinalState) {
            case KILLED: {
                this.appsKilled.incr();
                break;
            }
            case FAILED: {
                this.appsFailed.incr();
                break;
            }
            default: {
                this.appsCompleted.incr();
            }
        }
        if (app.isPending()) {
            this.appsPending.decr();
        } else {
            this.appsRunning.decr();
        }
        QueueMetrics userMetrics = this.getUserMetrics(app.getUser());
        if (userMetrics != null) {
            userMetrics.finishApp(app, rmAppAttemptFinalState);
        }
        if (this.parent != null) {
            this.parent.finishApp(app, rmAppAttemptFinalState);
        }
    }

    public void setAvailableResourcesToQueue(Resource limit) {
        this.availableMB.set(limit.getMemory());
    }

    public void setAvailableResourcesToUser(String user, Resource limit) {
        QueueMetrics userMetrics = this.getUserMetrics(user);
        if (userMetrics != null) {
            userMetrics.setAvailableResourcesToQueue(limit);
        }
    }

    public void incrPendingResources(String user, int containers, Resource res) {
        this._incrPendingResources(containers, res);
        QueueMetrics userMetrics = this.getUserMetrics(user);
        if (userMetrics != null) {
            userMetrics.incrPendingResources(user, containers, res);
        }
        if (this.parent != null) {
            this.parent.incrPendingResources(user, containers, res);
        }
    }

    private void _incrPendingResources(int containers, Resource res) {
        this.pendingContainers.incr(containers);
        this.pendingMB.incr(res.getMemory());
    }

    public void decrPendingResources(String user, int containers, Resource res) {
        this._decrPendingResources(containers, res);
        QueueMetrics userMetrics = this.getUserMetrics(user);
        if (userMetrics != null) {
            userMetrics.decrPendingResources(user, containers, res);
        }
        if (this.parent != null) {
            this.parent.decrPendingResources(user, containers, res);
        }
    }

    private void _decrPendingResources(int containers, Resource res) {
        this.pendingContainers.decr(containers);
        this.pendingMB.decr(res.getMemory());
    }

    public void allocateResources(String user, int containers, Resource res) {
        this.allocatedContainers.incr(containers);
        this.aggregateContainersAllocated.incr((long)containers);
        this.allocatedMB.incr(res.getMemory() * containers);
        this._decrPendingResources(containers, Resources.multiply(res, containers));
        QueueMetrics userMetrics = this.getUserMetrics(user);
        if (userMetrics != null) {
            userMetrics.allocateResources(user, containers, res);
        }
        if (this.parent != null) {
            this.parent.allocateResources(user, containers, res);
        }
    }

    public void releaseResources(String user, int containers, Resource res) {
        this.allocatedContainers.decr(containers);
        this.aggregateContainersReleased.incr((long)containers);
        this.allocatedMB.decr(res.getMemory() * containers);
        QueueMetrics userMetrics = this.getUserMetrics(user);
        if (userMetrics != null) {
            userMetrics.releaseResources(user, containers, res);
        }
        if (this.parent != null) {
            this.parent.releaseResources(user, containers, res);
        }
    }

    public void reserveResource(String user, Resource res) {
        this.reservedContainers.incr();
        this.reservedMB.incr(res.getMemory());
        QueueMetrics userMetrics = this.getUserMetrics(user);
        if (userMetrics != null) {
            userMetrics.reserveResource(user, res);
        }
        if (this.parent != null) {
            this.parent.reserveResource(user, res);
        }
    }

    public void unreserveResource(String user, Resource res) {
        this.reservedContainers.decr();
        this.reservedMB.decr(res.getMemory());
        QueueMetrics userMetrics = this.getUserMetrics(user);
        if (userMetrics != null) {
            userMetrics.unreserveResource(user, res);
        }
        if (this.parent != null) {
            this.parent.unreserveResource(user, res);
        }
    }

    public void incrActiveUsers() {
        this.activeUsers.incr();
    }

    public void decrActiveUsers() {
        this.activeUsers.decr();
    }

    public void activateApp(String user) {
        this.activeApplications.incr();
        QueueMetrics userMetrics = this.getUserMetrics(user);
        if (userMetrics != null) {
            userMetrics.activateApp(user);
        }
        if (this.parent != null) {
            this.parent.activateApp(user);
        }
    }

    public void deactivateApp(String user) {
        this.activeApplications.decr();
        QueueMetrics userMetrics = this.getUserMetrics(user);
        if (userMetrics != null) {
            userMetrics.deactivateApp(user);
        }
        if (this.parent != null) {
            this.parent.deactivateApp(user);
        }
    }

    public int getAppsSubmitted() {
        return this.appsSubmitted.value();
    }

    public int getAppsRunning() {
        return this.appsRunning.value();
    }

    public int getAppsPending() {
        return this.appsPending.value();
    }

    public int getAppsCompleted() {
        return this.appsCompleted.value();
    }

    public int getAppsKilled() {
        return this.appsKilled.value();
    }

    public int getAppsFailed() {
        return this.appsFailed.value();
    }

    public int getAllocatedMB() {
        return this.allocatedMB.value();
    }

    public int getAllocatedContainers() {
        return this.allocatedContainers.value();
    }

    public int getAvailableMB() {
        return this.availableMB.value();
    }

    public int getPendingMB() {
        return this.pendingMB.value();
    }

    public int getPendingContainers() {
        return this.pendingContainers.value();
    }

    public int getReservedMB() {
        return this.reservedMB.value();
    }

    public int getReservedContainers() {
        return this.reservedContainers.value();
    }

    public int getActiveUsers() {
        return this.activeUsers.value();
    }

    public int getActiveApps() {
        return this.activeApplications.value();
    }
}

