/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.net.InetSocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.exceptions.YarnRemoteException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.server.api.ResourceTracker;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RegisterNodeManagerRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RegisterNodeManagerResponse;
import org.apache.hadoop.yarn.server.api.records.HeartbeatResponse;
import org.apache.hadoop.yarn.server.api.records.MasterKey;
import org.apache.hadoop.yarn.server.api.records.NodeAction;
import org.apache.hadoop.yarn.server.api.records.NodeStatus;
import org.apache.hadoop.yarn.server.api.records.RegistrationResponse;
import org.apache.hadoop.yarn.server.resourcemanager.NMLivelinessMonitor;
import org.apache.hadoop.yarn.server.resourcemanager.NodesListManager;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeReconnectEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeStatusEvent;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.authorize.RMPolicyProvider;
import org.apache.hadoop.yarn.service.AbstractService;
import org.apache.hadoop.yarn.util.RackResolver;

public class ResourceTrackerService
extends AbstractService
implements ResourceTracker {
    private static final Log LOG = LogFactory.getLog(ResourceTrackerService.class);
    private static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private final RMContext rmContext;
    private final NodesListManager nodesListManager;
    private final NMLivelinessMonitor nmLivelinessMonitor;
    private final RMContainerTokenSecretManager containerTokenSecretManager;
    private Server server;
    private InetSocketAddress resourceTrackerAddress;
    private static final NodeHeartbeatResponse reboot = (NodeHeartbeatResponse)recordFactory.newRecordInstance(NodeHeartbeatResponse.class);
    private static final NodeHeartbeatResponse shutDown = (NodeHeartbeatResponse)recordFactory.newRecordInstance(NodeHeartbeatResponse.class);

    public ResourceTrackerService(RMContext rmContext, NodesListManager nodesListManager, NMLivelinessMonitor nmLivelinessMonitor, RMContainerTokenSecretManager containerTokenSecretManager) {
        super(ResourceTrackerService.class.getName());
        this.rmContext = rmContext;
        this.nodesListManager = nodesListManager;
        this.nmLivelinessMonitor = nmLivelinessMonitor;
        this.containerTokenSecretManager = containerTokenSecretManager;
    }

    public synchronized void init(Configuration conf) {
        this.resourceTrackerAddress = conf.getSocketAddr("yarn.resourcemanager.resource-tracker.address", "0.0.0.0:8031", 8031);
        RackResolver.init((Configuration)conf);
        super.init(conf);
    }

    public synchronized void start() {
        super.start();
        Configuration conf = this.getConfig();
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        this.server = rpc.getServer(ResourceTracker.class, (Object)this, this.resourceTrackerAddress, conf, null, conf.getInt("yarn.resourcemanager.resource-tracker.client.thread-count", 50));
        if (conf.getBoolean("hadoop.security.authorization", false)) {
            this.refreshServiceAcls(conf, new RMPolicyProvider());
        }
        this.server.start();
        conf.updateConnectAddr("yarn.resourcemanager.resource-tracker.address", this.server.getListenerAddress());
    }

    public synchronized void stop() {
        if (this.server != null) {
            this.server.stop();
        }
        super.stop();
    }

    public RegisterNodeManagerResponse registerNodeManager(RegisterNodeManagerRequest request) throws YarnRemoteException {
        NodeId nodeId = request.getNodeId();
        String host = nodeId.getHost();
        int cmPort = nodeId.getPort();
        int httpPort = request.getHttpPort();
        Resource capability = request.getResource();
        RegisterNodeManagerResponse response = (RegisterNodeManagerResponse)recordFactory.newRecordInstance(RegisterNodeManagerResponse.class);
        RegistrationResponse regResponse = (RegistrationResponse)recordFactory.newRecordInstance(RegistrationResponse.class);
        if (!this.nodesListManager.isValidNode(host)) {
            LOG.info((Object)("Disallowed NodeManager from  " + host + ", Sending SHUTDOWN signal to the NodeManager."));
            regResponse.setNodeAction(NodeAction.SHUTDOWN);
            response.setRegistrationResponse(regResponse);
            return response;
        }
        if (this.isSecurityEnabled()) {
            MasterKey nextMasterKeyForNode = this.containerTokenSecretManager.getCurrentKey();
            regResponse.setMasterKey(nextMasterKeyForNode);
        }
        RMNodeImpl rmNode = new RMNodeImpl(nodeId, this.rmContext, host, cmPort, httpPort, ResourceTrackerService.resolve(host), capability);
        RMNode oldNode = this.rmContext.getRMNodes().putIfAbsent(nodeId, rmNode);
        if (oldNode == null) {
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMNodeEvent(nodeId, RMNodeEventType.STARTED));
        } else {
            LOG.info((Object)("Reconnect from the node at: " + host));
            this.nmLivelinessMonitor.unregister(nodeId);
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMNodeReconnectEvent(nodeId, rmNode));
        }
        this.nmLivelinessMonitor.register(nodeId);
        LOG.info((Object)("NodeManager from node " + host + "(cmPort: " + cmPort + " httpPort: " + httpPort + ") " + "registered with capability: " + capability + ", assigned nodeId " + nodeId));
        regResponse.setNodeAction(NodeAction.NORMAL);
        response.setRegistrationResponse(regResponse);
        return response;
    }

    public NodeHeartbeatResponse nodeHeartbeat(NodeHeartbeatRequest request) throws YarnRemoteException {
        NodeStatus remoteNodeStatus = request.getNodeStatus();
        NodeId nodeId = remoteNodeStatus.getNodeId();
        RMNode rmNode = (RMNode)this.rmContext.getRMNodes().get(nodeId);
        if (rmNode == null) {
            LOG.info((Object)("Node not found rebooting " + remoteNodeStatus.getNodeId()));
            return reboot;
        }
        this.nmLivelinessMonitor.receivedPing(nodeId);
        if (!this.nodesListManager.isValidNode(rmNode.getHostName())) {
            LOG.info((Object)("Disallowed NodeManager nodeId: " + nodeId + " hostname: " + rmNode.getNodeAddress()));
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMNodeEvent(nodeId, RMNodeEventType.DECOMMISSION));
            return shutDown;
        }
        NodeHeartbeatResponse nodeHeartBeatResponse = (NodeHeartbeatResponse)recordFactory.newRecordInstance(NodeHeartbeatResponse.class);
        HeartbeatResponse lastHeartbeatResponse = rmNode.getLastHeartBeatResponse();
        if (remoteNodeStatus.getResponseId() + 1 == lastHeartbeatResponse.getResponseId()) {
            LOG.info((Object)("Received duplicate heartbeat from node " + rmNode.getNodeAddress()));
            nodeHeartBeatResponse.setHeartbeatResponse(lastHeartbeatResponse);
            return nodeHeartBeatResponse;
        }
        if (remoteNodeStatus.getResponseId() + 1 < lastHeartbeatResponse.getResponseId()) {
            LOG.info((Object)("Too far behind rm response id:" + lastHeartbeatResponse.getResponseId() + " nm response id:" + remoteNodeStatus.getResponseId()));
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMNodeEvent(nodeId, RMNodeEventType.REBOOTING));
            return reboot;
        }
        HeartbeatResponse latestResponse = (HeartbeatResponse)recordFactory.newRecordInstance(HeartbeatResponse.class);
        latestResponse.setResponseId(lastHeartbeatResponse.getResponseId() + 1);
        latestResponse.addAllContainersToCleanup(rmNode.getContainersToCleanUp());
        latestResponse.addAllApplicationsToCleanup(rmNode.getAppsToCleanup());
        latestResponse.setNodeAction(NodeAction.NORMAL);
        if (this.isSecurityEnabled()) {
            MasterKey nodeKnownMasterKey;
            boolean shouldSendMasterKey = false;
            MasterKey nextMasterKeyForNode = this.containerTokenSecretManager.getNextKey();
            if (nextMasterKeyForNode != null && (nodeKnownMasterKey = request.getLastKnownMasterKey()).getKeyId() != nextMasterKeyForNode.getKeyId()) {
                shouldSendMasterKey = true;
            }
            if (shouldSendMasterKey) {
                latestResponse.setMasterKey(nextMasterKeyForNode);
            }
        }
        this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMNodeStatusEvent(nodeId, remoteNodeStatus.getNodeHealthStatus(), remoteNodeStatus.getContainersStatuses(), remoteNodeStatus.getKeepAliveApplications(), latestResponse));
        nodeHeartBeatResponse.setHeartbeatResponse(latestResponse);
        return nodeHeartBeatResponse;
    }

    public static Node resolve(String hostName) {
        return RackResolver.resolve((String)hostName);
    }

    void refreshServiceAcls(Configuration configuration, PolicyProvider policyProvider) {
        this.server.refreshServiceAcl(configuration, policyProvider);
    }

    protected boolean isSecurityEnabled() {
        return UserGroupInformation.isSecurityEnabled();
    }

    static {
        HeartbeatResponse rebootResp = (HeartbeatResponse)recordFactory.newRecordInstance(HeartbeatResponse.class);
        rebootResp.setNodeAction(NodeAction.REBOOT);
        reboot.setHeartbeatResponse(rebootResp);
        HeartbeatResponse decommissionedResp = (HeartbeatResponse)recordFactory.newRecordInstance(HeartbeatResponse.class);
        decommissionedResp.setNodeAction(NodeAction.SHUTDOWN);
        shutDown.setHeartbeatResponse(decommissionedResp);
    }
}

