/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.recovery;

import com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationAttemptStateDataPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationStateDataPBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.util.ConverterUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class MemoryRMStateStore
extends RMStateStore {
    RMStateStore.RMState state = new RMStateStore.RMState();

    @VisibleForTesting
    public RMStateStore.RMState getState() {
        return this.state;
    }

    @Override
    public synchronized RMStateStore.RMState loadState() throws Exception {
        RMStateStore.RMState returnState = new RMStateStore.RMState();
        returnState.appState.putAll(this.state.appState);
        return returnState;
    }

    @Override
    public synchronized void initInternal(Configuration conf) {
    }

    @Override
    protected synchronized void closeInternal() throws Exception {
    }

    @Override
    public void storeApplicationState(String appId, ApplicationStateDataPBImpl appStateData) throws Exception {
        RMStateStore.ApplicationState appState = new RMStateStore.ApplicationState(appStateData.getSubmitTime(), appStateData.getApplicationSubmissionContext());
        this.state.appState.put(appState.getAppId(), appState);
    }

    @Override
    public synchronized void storeApplicationAttemptState(String attemptIdStr, ApplicationAttemptStateDataPBImpl attemptStateData) throws Exception {
        ApplicationAttemptId attemptId = ConverterUtils.toApplicationAttemptId((String)attemptIdStr);
        RMStateStore.ApplicationAttemptState attemptState = new RMStateStore.ApplicationAttemptState(attemptId, attemptStateData.getMasterContainer());
        RMStateStore.ApplicationState appState = this.state.getApplicationState().get(attemptState.getAttemptId().getApplicationId());
        assert (appState != null);
        appState.attempts.put(attemptState.getAttemptId(), attemptState);
    }

    @Override
    public synchronized void removeApplicationState(RMStateStore.ApplicationState appState) throws Exception {
        ApplicationId appId = appState.getAppId();
        RMStateStore.ApplicationState removed = this.state.appState.remove(appId);
        assert (removed != null);
    }
}

