/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.resource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.Resource;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class ResourceCalculator {
    private static final Log LOG = LogFactory.getLog(ResourceCalculator.class);

    public abstract int compare(Resource var1, Resource var2, Resource var3);

    public static int divideAndCeil(int a, int b) {
        if (b == 0) {
            LOG.info((Object)("divideAndCeil called with a=" + a + " b=" + b));
            return 0;
        }
        return (a + (b - 1)) / b;
    }

    public static int roundUp(int a, int b) {
        return ResourceCalculator.divideAndCeil(a, b) * b;
    }

    public static int roundDown(int a, int b) {
        return a / b * b;
    }

    public abstract int computeAvailableContainers(Resource var1, Resource var2);

    public abstract Resource multiplyAndNormalizeUp(Resource var1, double var2, Resource var4);

    public abstract Resource multiplyAndNormalizeDown(Resource var1, double var2, Resource var4);

    public abstract Resource normalize(Resource var1, Resource var2);

    public abstract Resource roundUp(Resource var1, Resource var2);

    public abstract Resource roundDown(Resource var1, Resource var2);

    public abstract float divide(Resource var1, Resource var2, Resource var3);

    public abstract float ratio(Resource var1, Resource var2);

    public abstract Resource divideAndCeil(Resource var1, int var2);
}

