/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.resourcemanager.resource.ResourceCalculator;
import org.apache.hadoop.yarn.server.resourcemanager.resource.Resources;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class SchedulerUtils {
    private static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    public static final String RELEASED_CONTAINER = "Container released by application";
    public static final String LOST_CONTAINER = "Container released on a *lost* node";
    public static final String PREEMPTED_CONTAINER = "Container preempted by scheduler";
    public static final String COMPLETED_APPLICATION = "Container of a completed application";
    public static final String EXPIRED_CONTAINER = "Container expired since it was unused";
    public static final String UNRESERVED_CONTAINER = "Container reservation no longer required.";

    public static ContainerStatus createAbnormalContainerStatus(ContainerId containerId, String diagnostics) {
        ContainerStatus containerStatus = (ContainerStatus)recordFactory.newRecordInstance(ContainerStatus.class);
        containerStatus.setContainerId(containerId);
        containerStatus.setDiagnostics(diagnostics);
        containerStatus.setExitStatus(-100);
        containerStatus.setState(ContainerState.COMPLETE);
        return containerStatus;
    }

    public static void normalizeRequests(List<ResourceRequest> asks, ResourceCalculator resourceCalculator, Resource clusterResource, Resource minimumResource) {
        for (ResourceRequest ask : asks) {
            SchedulerUtils.normalizeRequest(ask, resourceCalculator, clusterResource, minimumResource);
        }
    }

    public static void normalizeRequest(ResourceRequest ask, ResourceCalculator resourceCalculator, Resource clusterResource, Resource minimumResource) {
        Resource normalized = Resources.normalize(resourceCalculator, ask.getCapability(), minimumResource);
        ask.setCapability(normalized);
    }
}

