/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueUserACLInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AppSchedulable;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.QueueManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.Resources;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.SchedulingAlgorithms;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.SchedulingMode;

public class FSLeafQueue
extends FSQueue {
    private static final Log LOG = LogFactory.getLog((String)FSLeafQueue.class.getName());
    private final List<AppSchedulable> appScheds = new ArrayList<AppSchedulable>();
    private SchedulingMode schedulingMode;
    private final FairScheduler scheduler;
    private final QueueManager queueMgr;
    private Resource demand = Resources.createResource(0);
    private long lastTimeAtMinShare;
    private long lastTimeAtHalfFairShare;

    public FSLeafQueue(String name, QueueManager queueMgr, FairScheduler scheduler, FSParentQueue parent) {
        super(name, queueMgr, scheduler, parent);
        this.scheduler = scheduler;
        this.queueMgr = queueMgr;
        this.lastTimeAtMinShare = scheduler.getClock().getTime();
        this.lastTimeAtHalfFairShare = scheduler.getClock().getTime();
    }

    public void addApp(FSSchedulerApp app) {
        AppSchedulable appSchedulable = new AppSchedulable(this.scheduler, app, this);
        app.setAppSchedulable(appSchedulable);
        this.appScheds.add(appSchedulable);
    }

    void addAppSchedulable(AppSchedulable appSched) {
        this.appScheds.add(appSched);
    }

    public void removeApp(FSSchedulerApp app) {
        Iterator<AppSchedulable> it = this.appScheds.iterator();
        while (it.hasNext()) {
            AppSchedulable appSched = it.next();
            if (appSched.getApp() != app) continue;
            it.remove();
            break;
        }
    }

    public Collection<AppSchedulable> getAppSchedulables() {
        return this.appScheds;
    }

    public void setSchedulingMode(SchedulingMode mode) {
        this.schedulingMode = mode;
    }

    @Override
    public void recomputeFairShares() {
        if (this.schedulingMode == SchedulingMode.FAIR) {
            SchedulingAlgorithms.computeFairShares(this.appScheds, this.getFairShare());
        } else {
            for (AppSchedulable sched : this.appScheds) {
                sched.setFairShare(Resources.createResource(0));
            }
        }
    }

    @Override
    public Resource getDemand() {
        return this.demand;
    }

    @Override
    public Resource getResourceUsage() {
        Resource usage = Resources.createResource(0);
        for (AppSchedulable app : this.appScheds) {
            Resources.addTo(usage, app.getResourceUsage());
        }
        return usage;
    }

    @Override
    public void updateDemand() {
        Resource maxRes = this.queueMgr.getMaxResources(this.getName());
        this.demand = Resources.createResource(0);
        for (AppSchedulable sched : this.appScheds) {
            sched.updateDemand();
            Resource toAdd = sched.getDemand();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Counting resource from " + sched.getName() + " " + toAdd + "; Total resource consumption for " + this.getName() + " now " + this.demand));
            }
            this.demand = Resources.add(this.demand, toAdd);
            if (!Resources.greaterThanOrEqual(this.demand, maxRes)) continue;
            this.demand = maxRes;
            break;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("The updated demand for " + this.getName() + " is " + this.demand + "; the max is " + maxRes));
        }
    }

    @Override
    public Resource assignContainer(FSSchedulerNode node, boolean reserved) {
        Serializable comparator;
        LOG.debug((Object)("Node offered to queue: " + this.getName() + " reserved: " + reserved));
        if (Resources.greaterThan(this.getResourceUsage(), this.queueMgr.getMaxResources(this.getName()))) {
            return Resources.none();
        }
        if (reserved) {
            for (AppSchedulable sched : this.appScheds) {
                if (sched.getApp().getApplicationAttemptId() != node.getReservedContainer().getApplicationAttemptId()) continue;
                return sched.assignContainer(node, reserved);
            }
            return Resources.none();
        }
        if (this.schedulingMode == SchedulingMode.FIFO) {
            comparator = new SchedulingAlgorithms.FifoComparator();
        } else if (this.schedulingMode == SchedulingMode.FAIR) {
            comparator = new SchedulingAlgorithms.FairShareComparator();
        } else {
            throw new RuntimeException("Unsupported queue scheduling mode " + (Object)((Object)this.schedulingMode));
        }
        Collections.sort(this.appScheds, comparator);
        for (AppSchedulable sched : this.appScheds) {
            Resource assignedResource;
            if (!sched.getRunnable() || (assignedResource = sched.assignContainer(node, reserved)).equals((Object)Resources.none())) continue;
            return assignedResource;
        }
        return Resources.none();
    }

    @Override
    public Collection<FSQueue> getChildQueues() {
        return new ArrayList<FSQueue>(1);
    }

    @Override
    public List<QueueUserACLInfo> getQueueUserAclInfo(UserGroupInformation user) {
        QueueUserACLInfo userAclInfo = (QueueUserACLInfo)this.recordFactory.newRecordInstance(QueueUserACLInfo.class);
        ArrayList<QueueACL> operations = new ArrayList<QueueACL>();
        for (QueueACL operation : QueueACL.values()) {
            Map<QueueACL, AccessControlList> acls = this.queueMgr.getQueueAcls(this.getName());
            if (!acls.get(operation).isUserAllowed(user)) continue;
            operations.add(operation);
        }
        userAclInfo.setQueueName(this.getQueueName());
        userAclInfo.setUserAcls(operations);
        return Collections.singletonList(userAclInfo);
    }

    public long getLastTimeAtMinShare() {
        return this.lastTimeAtMinShare;
    }

    public void setLastTimeAtMinShare(long lastTimeAtMinShare) {
        this.lastTimeAtMinShare = lastTimeAtMinShare;
    }

    public long getLastTimeAtHalfFairShare() {
        return this.lastTimeAtHalfFairShare;
    }

    public void setLastTimeAtHalfFairShare(long lastTimeAtHalfFairShare) {
        this.lastTimeAtHalfFairShare = lastTimeAtHalfFairShare;
    }
}

