/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueUserACLInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.QueueManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.Resources;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.SchedulingAlgorithms;

public class FSParentQueue
extends FSQueue {
    private static final Log LOG = LogFactory.getLog((String)FSParentQueue.class.getName());
    private final List<FSQueue> childQueues = new ArrayList<FSQueue>();
    private final QueueManager queueMgr;
    private Resource demand = Resources.createResource(0);

    public FSParentQueue(String name, QueueManager queueMgr, FairScheduler scheduler, FSParentQueue parent) {
        super(name, queueMgr, scheduler, parent);
        this.queueMgr = queueMgr;
    }

    public void addChildQueue(FSQueue child) {
        this.childQueues.add(child);
    }

    @Override
    public void recomputeFairShares() {
        SchedulingAlgorithms.computeFairShares(this.childQueues, this.getFairShare());
        for (FSQueue childQueue : this.childQueues) {
            childQueue.getMetrics().setAvailableResourcesToQueue(childQueue.getFairShare());
            childQueue.recomputeFairShares();
        }
    }

    @Override
    public Resource getDemand() {
        return this.demand;
    }

    @Override
    public Resource getResourceUsage() {
        Resource usage = Resources.createResource(0);
        for (FSQueue child : this.childQueues) {
            Resources.addTo(usage, child.getResourceUsage());
        }
        return usage;
    }

    @Override
    public void updateDemand() {
        Resource maxRes = this.queueMgr.getMaxResources(this.getName());
        this.demand = Resources.createResource(0);
        for (FSQueue childQueue : this.childQueues) {
            childQueue.updateDemand();
            Resource toAdd = childQueue.getDemand();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Counting resource from " + childQueue.getName() + " " + toAdd + "; Total resource consumption for " + this.getName() + " now " + this.demand));
            }
            this.demand = Resources.add(this.demand, toAdd);
            if (!Resources.greaterThanOrEqual(this.demand, maxRes)) continue;
            this.demand = maxRes;
            break;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("The updated demand for " + this.getName() + " is " + this.demand + "; the max is " + maxRes));
        }
    }

    private synchronized QueueUserACLInfo getUserAclInfo(UserGroupInformation user) {
        QueueUserACLInfo userAclInfo = (QueueUserACLInfo)this.recordFactory.newRecordInstance(QueueUserACLInfo.class);
        ArrayList<QueueACL> operations = new ArrayList<QueueACL>();
        for (QueueACL operation : QueueACL.values()) {
            if (!this.hasAccess(operation, user)) continue;
            operations.add(operation);
        }
        userAclInfo.setQueueName(this.getQueueName());
        userAclInfo.setUserAcls(operations);
        return userAclInfo;
    }

    @Override
    public synchronized List<QueueUserACLInfo> getQueueUserAclInfo(UserGroupInformation user) {
        ArrayList<QueueUserACLInfo> userAcls = new ArrayList<QueueUserACLInfo>();
        userAcls.add(this.getUserAclInfo(user));
        for (FSQueue child : this.childQueues) {
            userAcls.addAll(child.getQueueUserAclInfo(user));
        }
        return userAcls;
    }

    @Override
    public Resource assignContainer(FSSchedulerNode node, boolean reserved) {
        throw new IllegalStateException("Parent queue should not be assigned container");
    }

    @Override
    public Collection<FSQueue> getChildQueues() {
        return this.childQueues;
    }
}

