/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfigurationException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AppSchedulable;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairSchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.Resources;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.SchedulingMode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class QueueManager {
    public static final Log LOG = LogFactory.getLog((String)QueueManager.class.getName());
    public static final String ROOT_QUEUE = "root";
    public static final long ALLOC_RELOAD_INTERVAL = 10000L;
    public static final long ALLOC_RELOAD_WAIT = 5000L;
    private final FairScheduler scheduler;
    private Object allocFile;
    private final Collection<FSLeafQueue> leafQueues = new CopyOnWriteArrayList<FSLeafQueue>();
    private final Map<String, FSQueue> queues = new HashMap<String, FSQueue>();
    private FSParentQueue rootQueue;
    private volatile QueueManagerInfo info = new QueueManagerInfo();
    private long lastReloadAttempt;
    private long lastSuccessfulReload;
    private boolean lastReloadAttemptFailed = false;

    public QueueManager(FairScheduler scheduler) {
        this.scheduler = scheduler;
    }

    public FSParentQueue getRootQueue() {
        return this.rootQueue;
    }

    public void initialize() throws IOException, SAXException, AllocationConfigurationException, ParserConfigurationException {
        FairSchedulerConfiguration conf = this.scheduler.getConf();
        this.rootQueue = new FSParentQueue(ROOT_QUEUE, this, this.scheduler, null);
        this.queues.put(this.rootQueue.getName(), this.rootQueue);
        this.allocFile = conf.getAllocationFile();
        if (this.allocFile == null) {
            this.allocFile = new Configuration().getResource("fair-scheduler.xml");
            if (this.allocFile == null) {
                LOG.error((Object)"The fair scheduler allocation file fair-scheduler.xml was not found on the classpath, and no other config file is given through mapred.fairscheduler.allocation.file.");
            }
        }
        this.reloadAllocs();
        this.lastSuccessfulReload = this.scheduler.getClock().getTime();
        this.lastReloadAttempt = this.scheduler.getClock().getTime();
        this.getLeafQueue("default");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FSLeafQueue getLeafQueue(String name) {
        if (!name.startsWith("root.")) {
            name = "root." + name;
        }
        Map<String, FSQueue> map = this.queues;
        synchronized (map) {
            FSQueue queue = this.queues.get(name);
            if (queue == null) {
                FSLeafQueue leafQueue = this.createLeafQueue(name);
                if (leafQueue == null) {
                    return null;
                }
                leafQueue.setSchedulingMode(this.info.defaultSchedulingMode);
                queue = leafQueue;
            } else if (queue instanceof FSParentQueue) {
                return null;
            }
            return (FSLeafQueue)queue;
        }
    }

    private FSLeafQueue createLeafQueue(String name) {
        ArrayList<String> newQueueNames = new ArrayList<String>();
        newQueueNames.add(name);
        int sepIndex = name.length();
        FSParentQueue parent = null;
        while (sepIndex != -1) {
            sepIndex = name.lastIndexOf(46, sepIndex - 1);
            String curName = null;
            curName = name.substring(0, sepIndex);
            FSQueue queue = this.queues.get(curName);
            if (queue == null) {
                newQueueNames.add(curName);
                continue;
            }
            if (queue instanceof FSParentQueue) {
                parent = (FSParentQueue)queue;
                break;
            }
            return null;
        }
        FSLeafQueue leafQueue = null;
        for (int i = newQueueNames.size() - 1; i >= 0; --i) {
            String queueName = (String)newQueueNames.get(i);
            if (i == 0) {
                leafQueue = new FSLeafQueue(name, this, this.scheduler, parent);
                parent.addChildQueue(leafQueue);
                this.queues.put(leafQueue.getName(), leafQueue);
                this.leafQueues.add(leafQueue);
                continue;
            }
            FSParentQueue newParent = new FSParentQueue(queueName, this, this.scheduler, parent);
            parent.addChildQueue(newParent);
            this.queues.put(newParent.getName(), newParent);
            parent = newParent;
        }
        return leafQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FSQueue getQueue(String name) {
        if (!name.startsWith("root.") && !name.equals(ROOT_QUEUE)) {
            name = "root." + name;
        }
        Map<String, FSQueue> map = this.queues;
        synchronized (map) {
            return this.queues.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String name) {
        if (!name.startsWith("root.") && !name.equals(ROOT_QUEUE)) {
            name = "root." + name;
        }
        Map<String, FSQueue> map = this.queues;
        synchronized (map) {
            return this.queues.containsKey(name);
        }
    }

    public FSLeafQueue getQueueForApp(AppSchedulable app) {
        return this.getLeafQueue(app.getApp().getQueueName());
    }

    public void reloadAllocsIfNecessary() {
        long time = this.scheduler.getClock().getTime();
        if (time > this.lastReloadAttempt + 10000L) {
            this.lastReloadAttempt = time;
            if (null == this.allocFile) {
                return;
            }
            try {
                long lastModified;
                if (this.allocFile instanceof String) {
                    File file = new File((String)this.allocFile);
                    lastModified = file.lastModified();
                } else {
                    URLConnection conn = ((URL)this.allocFile).openConnection();
                    lastModified = conn.getLastModified();
                }
                if (lastModified > this.lastSuccessfulReload && time > lastModified + 5000L) {
                    this.reloadAllocs();
                    this.lastSuccessfulReload = time;
                    this.lastReloadAttemptFailed = false;
                }
            }
            catch (Exception e) {
                if (!this.lastReloadAttemptFailed) {
                    LOG.error((Object)"Failed to reload fair scheduler config file - will use existing allocations.", (Throwable)e);
                }
                this.lastReloadAttemptFailed = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadAllocs() throws IOException, ParserConfigurationException, SAXException, AllocationConfigurationException {
        if (this.allocFile == null) {
            return;
        }
        HashMap<String, Resource> minQueueResources = new HashMap<String, Resource>();
        HashMap<String, Resource> maxQueueResources = new HashMap<String, Resource>();
        HashMap<String, Integer> queueMaxApps = new HashMap<String, Integer>();
        HashMap<String, Integer> userMaxApps = new HashMap<String, Integer>();
        HashMap<String, Double> queueWeights = new HashMap<String, Double>();
        HashMap<String, SchedulingMode> queueModes = new HashMap<String, SchedulingMode>();
        HashMap<String, Long> minSharePreemptionTimeouts = new HashMap<String, Long>();
        HashMap<String, Map<QueueACL, AccessControlList>> queueAcls = new HashMap<String, Map<QueueACL, AccessControlList>>();
        int userMaxAppsDefault = Integer.MAX_VALUE;
        int queueMaxAppsDefault = Integer.MAX_VALUE;
        long fairSharePreemptionTimeout = Long.MAX_VALUE;
        long defaultMinSharePreemptionTimeout = Long.MAX_VALUE;
        SchedulingMode defaultSchedulingMode = SchedulingMode.FAIR;
        ArrayList<String> queueNamesInAllocFile = new ArrayList<String>();
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setIgnoringComments(true);
        DocumentBuilder builder = docBuilderFactory.newDocumentBuilder();
        Document doc = this.allocFile instanceof String ? builder.parse(new File((String)this.allocFile)) : builder.parse(this.allocFile.toString());
        Element root = doc.getDocumentElement();
        if (!"allocations".equals(root.getTagName())) {
            throw new AllocationConfigurationException("Bad fair scheduler config file: top-level element not <allocations>");
        }
        NodeList elements = root.getChildNodes();
        for (int i = 0; i < elements.getLength(); ++i) {
            String text;
            Node node = elements.item(i);
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            if ("queue".equals(element.getTagName()) || "pool".equals(element.getTagName())) {
                this.loadQueue(ROOT_QUEUE, element, minQueueResources, maxQueueResources, queueMaxApps, userMaxApps, queueWeights, queueModes, minSharePreemptionTimeouts, queueAcls, queueNamesInAllocFile);
                continue;
            }
            if ("user".equals(element.getTagName())) {
                String userName = element.getAttribute("name");
                NodeList fields = element.getChildNodes();
                for (int j = 0; j < fields.getLength(); ++j) {
                    Element field;
                    Node fieldNode = fields.item(j);
                    if (!(fieldNode instanceof Element) || !"maxRunningApps".equals((field = (Element)fieldNode).getTagName())) continue;
                    String text2 = ((Text)field.getFirstChild()).getData().trim();
                    int val = Integer.parseInt(text2);
                    userMaxApps.put(userName, val);
                }
                continue;
            }
            if ("userMaxAppsDefault".equals(element.getTagName())) {
                int val;
                text = ((Text)element.getFirstChild()).getData().trim();
                userMaxAppsDefault = val = Integer.parseInt(text);
                continue;
            }
            if ("fairSharePreemptionTimeout".equals(element.getTagName())) {
                long val;
                text = ((Text)element.getFirstChild()).getData().trim();
                fairSharePreemptionTimeout = val = Long.parseLong(text) * 1000L;
                continue;
            }
            if ("defaultMinSharePreemptionTimeout".equals(element.getTagName())) {
                long val;
                text = ((Text)element.getFirstChild()).getData().trim();
                defaultMinSharePreemptionTimeout = val = Long.parseLong(text) * 1000L;
                continue;
            }
            if ("queueMaxAppsDefault".equals(element.getTagName())) {
                int val;
                text = ((Text)element.getFirstChild()).getData().trim();
                queueMaxAppsDefault = val = Integer.parseInt(text);
                continue;
            }
            if ("defaultQueueSchedulingMode".equals(element.getTagName())) {
                text = ((Text)element.getFirstChild()).getData().trim();
                defaultSchedulingMode = this.parseSchedulingMode(text);
                continue;
            }
            LOG.warn((Object)("Bad element in allocations file: " + element.getTagName()));
        }
        QueueManager queueManager = this;
        synchronized (queueManager) {
            this.info = new QueueManagerInfo(minQueueResources, maxQueueResources, queueMaxApps, userMaxApps, queueWeights, userMaxAppsDefault, queueMaxAppsDefault, defaultSchedulingMode, minSharePreemptionTimeouts, queueAcls, fairSharePreemptionTimeout, defaultMinSharePreemptionTimeout);
            HashMap<QueueACL, AccessControlList> rootAcls = new HashMap<QueueACL, AccessControlList>();
            rootAcls.put(QueueACL.SUBMIT_APPLICATIONS, new AccessControlList(" "));
            rootAcls.put(QueueACL.ADMINISTER_QUEUE, new AccessControlList(" "));
            queueAcls.put(ROOT_QUEUE, rootAcls);
            for (String name : queueNamesInAllocFile) {
                FSLeafQueue queue = this.getLeafQueue(name);
                if (queueModes.containsKey(name)) {
                    queue.setSchedulingMode((SchedulingMode)((Object)queueModes.get(name)));
                    continue;
                }
                queue.setSchedulingMode(defaultSchedulingMode);
            }
        }
    }

    private void loadQueue(String parentName, Element element, Map<String, Resource> minQueueResources, Map<String, Resource> maxQueueResources, Map<String, Integer> queueMaxApps, Map<String, Integer> userMaxApps, Map<String, Double> queueWeights, Map<String, SchedulingMode> queueModes, Map<String, Long> minSharePreemptionTimeouts, Map<String, Map<QueueACL, AccessControlList>> queueAcls, List<String> queueNamesInAllocFile) throws AllocationConfigurationException {
        String queueName = parentName + "." + element.getAttribute("name");
        HashMap<QueueACL, AccessControlList> acls = new HashMap<QueueACL, AccessControlList>();
        NodeList fields = element.getChildNodes();
        boolean isLeaf = true;
        for (int j = 0; j < fields.getLength(); ++j) {
            String text;
            Node fieldNode = fields.item(j);
            if (!(fieldNode instanceof Element)) continue;
            Element field = (Element)fieldNode;
            if ("minResources".equals(field.getTagName())) {
                text = ((Text)field.getFirstChild()).getData().trim();
                int val = Integer.parseInt(text);
                minQueueResources.put(queueName, Resources.createResource(val));
                continue;
            }
            if ("maxResources".equals(field.getTagName())) {
                text = ((Text)field.getFirstChild()).getData().trim();
                int val = Integer.parseInt(text);
                maxQueueResources.put(queueName, Resources.createResource(val));
                continue;
            }
            if ("maxRunningApps".equals(field.getTagName())) {
                text = ((Text)field.getFirstChild()).getData().trim();
                int val = Integer.parseInt(text);
                queueMaxApps.put(queueName, val);
                continue;
            }
            if ("weight".equals(field.getTagName())) {
                text = ((Text)field.getFirstChild()).getData().trim();
                double val = Double.parseDouble(text);
                queueWeights.put(queueName, val);
                continue;
            }
            if ("minSharePreemptionTimeout".equals(field.getTagName())) {
                text = ((Text)field.getFirstChild()).getData().trim();
                long val = Long.parseLong(text) * 1000L;
                minSharePreemptionTimeouts.put(queueName, val);
                continue;
            }
            if ("schedulingMode".equals(field.getTagName())) {
                text = ((Text)field.getFirstChild()).getData().trim();
                queueModes.put(queueName, this.parseSchedulingMode(text));
                continue;
            }
            if ("aclSubmitApps".equals(field.getTagName())) {
                text = ((Text)field.getFirstChild()).getData().trim();
                acls.put(QueueACL.SUBMIT_APPLICATIONS, new AccessControlList(text));
                continue;
            }
            if ("aclAdministerApps".equals(field.getTagName())) {
                text = ((Text)field.getFirstChild()).getData().trim();
                acls.put(QueueACL.ADMINISTER_QUEUE, new AccessControlList(text));
                continue;
            }
            if (!"queue".endsWith(field.getTagName()) && !"pool".equals(field.getTagName())) continue;
            this.loadQueue(queueName, field, minQueueResources, maxQueueResources, queueMaxApps, userMaxApps, queueWeights, queueModes, minSharePreemptionTimeouts, queueAcls, queueNamesInAllocFile);
            isLeaf = false;
        }
        if (isLeaf) {
            queueNamesInAllocFile.add(queueName);
        }
        queueAcls.put(queueName, acls);
        if (maxQueueResources.containsKey(queueName) && minQueueResources.containsKey(queueName) && Resources.lessThan(maxQueueResources.get(queueName), minQueueResources.get(queueName))) {
            LOG.warn((Object)String.format("Queue %s has max resources %d less than min resources %d", queueName, maxQueueResources.get(queueName), minQueueResources.get(queueName)));
        }
    }

    private SchedulingMode parseSchedulingMode(String text) throws AllocationConfigurationException {
        if ((text = text.toLowerCase()).equals("fair")) {
            return SchedulingMode.FAIR;
        }
        if (text.equals("fifo")) {
            return SchedulingMode.FIFO;
        }
        throw new AllocationConfigurationException("Unknown scheduling mode : " + text + "; expected 'fifo' or 'fair'");
    }

    public Resource getMinResources(String queue) {
        Resource minQueueResource = this.info.minQueueResources.get(queue);
        if (minQueueResource != null) {
            return minQueueResource;
        }
        return Resources.createResource(0);
    }

    public Resource getMaxResources(String queueName) {
        Resource maxQueueResource = this.info.maxQueueResources.get(queueName);
        if (maxQueueResource != null) {
            return maxQueueResource;
        }
        return Resources.createResource(Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<FSLeafQueue> getLeafQueues() {
        Map<String, FSQueue> map = this.queues;
        synchronized (map) {
            return this.leafQueues;
        }
    }

    public int getUserMaxApps(String user) {
        QueueManagerInfo info = this.info;
        if (info.userMaxApps.containsKey(user)) {
            return info.userMaxApps.get(user);
        }
        return info.userMaxAppsDefault;
    }

    public int getQueueMaxApps(String queue) {
        QueueManagerInfo info = this.info;
        if (info.queueMaxApps.containsKey(queue)) {
            return info.queueMaxApps.get(queue);
        }
        return info.queueMaxAppsDefault;
    }

    public double getQueueWeight(String queue) {
        Double weight = this.info.queueWeights.get(queue);
        if (weight != null) {
            return weight;
        }
        return 1.0;
    }

    public long getMinSharePreemptionTimeout(String queueName) {
        QueueManagerInfo info = this.info;
        if (info.minSharePreemptionTimeouts.containsKey(queueName)) {
            return info.minSharePreemptionTimeouts.get(queueName);
        }
        return info.defaultMinSharePreemptionTimeout;
    }

    public long getFairSharePreemptionTimeout() {
        return this.info.fairSharePreemptionTimeout;
    }

    public Map<QueueACL, AccessControlList> getQueueAcls(String queue) {
        HashMap<QueueACL, AccessControlList> out = new HashMap<QueueACL, AccessControlList>();
        Map<QueueACL, AccessControlList> queueAcl = this.info.queueAcls.get(queue);
        if (queueAcl != null) {
            out.putAll(queueAcl);
        }
        if (!out.containsKey(QueueACL.ADMINISTER_QUEUE)) {
            out.put(QueueACL.ADMINISTER_QUEUE, new AccessControlList("*"));
        }
        if (!out.containsKey(QueueACL.SUBMIT_APPLICATIONS)) {
            out.put(QueueACL.SUBMIT_APPLICATIONS, new AccessControlList("*"));
        }
        return out;
    }

    static class QueueManagerInfo {
        public final Map<String, Resource> minQueueResources;
        public final Map<String, Resource> maxQueueResources;
        public final Map<String, Double> queueWeights;
        public final Map<String, Integer> queueMaxApps;
        public final Map<String, Integer> userMaxApps;
        public final int userMaxAppsDefault;
        public final int queueMaxAppsDefault;
        public final Map<String, Map<QueueACL, AccessControlList>> queueAcls;
        public final Map<String, Long> minSharePreemptionTimeouts;
        public final long defaultMinSharePreemptionTimeout;
        public final long fairSharePreemptionTimeout;
        public final SchedulingMode defaultSchedulingMode;

        public QueueManagerInfo(Map<String, Resource> minQueueResources, Map<String, Resource> maxQueueResources, Map<String, Integer> queueMaxApps, Map<String, Integer> userMaxApps, Map<String, Double> queueWeights, int userMaxAppsDefault, int queueMaxAppsDefault, SchedulingMode defaultSchedulingMode, Map<String, Long> minSharePreemptionTimeouts, Map<String, Map<QueueACL, AccessControlList>> queueAcls, long fairSharePreemptionTimeout, long defaultMinSharePreemptionTimeout) {
            this.minQueueResources = minQueueResources;
            this.maxQueueResources = maxQueueResources;
            this.queueMaxApps = queueMaxApps;
            this.userMaxApps = userMaxApps;
            this.queueWeights = queueWeights;
            this.userMaxAppsDefault = userMaxAppsDefault;
            this.queueMaxAppsDefault = queueMaxAppsDefault;
            this.defaultSchedulingMode = defaultSchedulingMode;
            this.minSharePreemptionTimeouts = minSharePreemptionTimeouts;
            this.queueAcls = queueAcls;
            this.fairSharePreemptionTimeout = fairSharePreemptionTimeout;
            this.defaultMinSharePreemptionTimeout = defaultMinSharePreemptionTimeout;
        }

        public QueueManagerInfo() {
            this.minQueueResources = new HashMap<String, Resource>();
            this.maxQueueResources = new HashMap<String, Resource>();
            this.queueWeights = new HashMap<String, Double>();
            this.queueMaxApps = new HashMap<String, Integer>();
            this.userMaxApps = new HashMap<String, Integer>();
            this.userMaxAppsDefault = Integer.MAX_VALUE;
            this.queueMaxAppsDefault = Integer.MAX_VALUE;
            this.queueAcls = new HashMap<String, Map<QueueACL, AccessControlList>>();
            this.minSharePreemptionTimeouts = new HashMap<String, Long>();
            this.defaultMinSharePreemptionTimeout = Long.MAX_VALUE;
            this.fairSharePreemptionTimeout = Long.MAX_VALUE;
            this.defaultSchedulingMode = SchedulingMode.FAIR;
        }
    }
}

