/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp.dao;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.StringHelper;

@XmlRootElement(name="appAttempt")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class AppAttemptInfo {
    protected int id;
    protected long startTime;
    protected String containerId;
    protected String nodeHttpAddress;
    protected String nodeId;
    protected String logsLink;

    public AppAttemptInfo() {
    }

    public AppAttemptInfo(RMAppAttempt attempt) {
        this.startTime = 0L;
        this.containerId = "";
        this.nodeHttpAddress = "";
        this.nodeId = "";
        this.logsLink = "";
        if (attempt != null) {
            this.id = attempt.getAppAttemptId().getAttemptId();
            this.startTime = attempt.getStartTime();
            Container masterContainer = attempt.getMasterContainer();
            if (masterContainer != null) {
                this.containerId = masterContainer.getId().toString();
                this.nodeHttpAddress = masterContainer.getNodeHttpAddress();
                this.nodeId = masterContainer.getNodeId().toString();
                this.logsLink = StringHelper.join((Object[])new Object[]{HttpConfig.getSchemePrefix(), masterContainer.getNodeHttpAddress(), "/node", "/containerlogs/", ConverterUtils.toString((ContainerId)masterContainer.getId()), "/", attempt.getSubmissionContext().getUser()});
            }
        }
    }

    public int getAttemptId() {
        return this.id;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public String getNodeHttpAddress() {
        return this.nodeHttpAddress;
    }

    public String getLogsLink() {
        return this.logsLink;
    }
}

