/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.QueueState;
import org.apache.hadoop.yarn.api.records.QueueUserACLInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ActiveUsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.NodeType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSAssignment;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueueUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.UserInfo;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.server.utils.Lock;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class LeafQueue
implements CSQueue {
    private static final Log LOG = LogFactory.getLog(LeafQueue.class);
    private final String queueName;
    private CSQueue parent;
    private float capacity;
    private float absoluteCapacity;
    private float maximumCapacity;
    private float absoluteMaxCapacity;
    private float absoluteUsedCapacity = 0.0f;
    private int userLimit;
    private float userLimitFactor;
    private int maxApplications;
    private int maxApplicationsPerUser;
    private float maxAMResourcePerQueuePercent;
    private int maxActiveApplications;
    private int maxActiveAppsUsingAbsCap;
    private int maxActiveApplicationsPerUser;
    private int nodeLocalityDelay;
    private Resource usedResources = Resources.createResource((int)0, (int)0);
    private float usedCapacity = 0.0f;
    private volatile int numContainers;
    Set<FiCaSchedulerApp> activeApplications;
    Map<ApplicationAttemptId, FiCaSchedulerApp> applicationsMap = new HashMap<ApplicationAttemptId, FiCaSchedulerApp>();
    Set<FiCaSchedulerApp> pendingApplications;
    private final Resource minimumAllocation;
    private final Resource maximumAllocation;
    private final float minimumAllocationFactor;
    private RMContainerTokenSecretManager containerTokenSecretManager;
    private Map<String, User> users = new HashMap<String, User>();
    private final QueueMetrics metrics;
    private QueueInfo queueInfo;
    private QueueState state;
    private Map<QueueACL, AccessControlList> acls = new HashMap<QueueACL, AccessControlList>();
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private CapacitySchedulerContext scheduler;
    private final ActiveUsersManager activeUsersManager;
    private final ResourceCalculator resourceCalculator;
    private static final CSAssignment NULL_ASSIGNMENT = new CSAssignment(Resources.createResource((int)0, (int)0), NodeType.NODE_LOCAL);
    private static final CSAssignment SKIP_ASSIGNMENT = new CSAssignment(true);

    public LeafQueue(CapacitySchedulerContext cs, String queueName, CSQueue parent, CSQueue old) {
        this.scheduler = cs;
        this.queueName = queueName;
        this.parent = parent;
        this.resourceCalculator = cs.getResourceCalculator();
        this.metrics = old != null ? old.getMetrics() : QueueMetrics.forQueue(this.getQueuePath(), parent, cs.getConfiguration().getEnableUserMetrics(), cs.getConf());
        this.activeUsersManager = new ActiveUsersManager(this.metrics);
        this.minimumAllocation = cs.getMinimumResourceCapability();
        this.maximumAllocation = cs.getMaximumResourceCapability();
        this.minimumAllocationFactor = Resources.ratio((ResourceCalculator)this.resourceCalculator, (Resource)Resources.subtract((Resource)this.maximumAllocation, (Resource)this.minimumAllocation), (Resource)this.maximumAllocation);
        this.containerTokenSecretManager = cs.getContainerTokenSecretManager();
        float capacity = cs.getConfiguration().getCapacity(this.getQueuePath()) / 100.0f;
        float absoluteCapacity = parent.getAbsoluteCapacity() * capacity;
        float maximumCapacity = cs.getConfiguration().getMaximumCapacity(this.getQueuePath()) / 100.0f;
        float absoluteMaxCapacity = CSQueueUtils.computeAbsoluteMaximumCapacity(maximumCapacity, parent);
        int userLimit = cs.getConfiguration().getUserLimit(this.getQueuePath());
        float userLimitFactor = cs.getConfiguration().getUserLimitFactor(this.getQueuePath());
        int maxApplications = cs.getConfiguration().getMaximumApplicationsPerQueue(this.getQueuePath());
        if (maxApplications < 0) {
            int maxSystemApps = cs.getConfiguration().getMaximumSystemApplications();
            maxApplications = (int)((float)maxSystemApps * absoluteCapacity);
        }
        this.maxApplicationsPerUser = (int)((float)maxApplications * ((float)userLimit / 100.0f) * userLimitFactor);
        this.maxAMResourcePerQueuePercent = cs.getConfiguration().getMaximumApplicationMasterResourcePerQueuePercent(this.getQueuePath());
        int maxActiveApplications = CSQueueUtils.computeMaxActiveApplications(this.resourceCalculator, cs.getClusterResources(), this.minimumAllocation, this.maxAMResourcePerQueuePercent, absoluteMaxCapacity);
        this.maxActiveAppsUsingAbsCap = CSQueueUtils.computeMaxActiveApplications(this.resourceCalculator, cs.getClusterResources(), this.minimumAllocation, this.maxAMResourcePerQueuePercent, absoluteCapacity);
        int maxActiveApplicationsPerUser = CSQueueUtils.computeMaxActiveApplicationsPerUser(this.maxActiveAppsUsingAbsCap, userLimit, userLimitFactor);
        this.queueInfo = (QueueInfo)this.recordFactory.newRecordInstance(QueueInfo.class);
        this.queueInfo.setQueueName(queueName);
        this.queueInfo.setChildQueues(new ArrayList());
        QueueState state = cs.getConfiguration().getState(this.getQueuePath());
        Map<QueueACL, AccessControlList> acls = cs.getConfiguration().getAcls(this.getQueuePath());
        this.setupQueueConfigs(cs.getClusterResources(), capacity, absoluteCapacity, maximumCapacity, absoluteMaxCapacity, userLimit, userLimitFactor, maxApplications, this.maxApplicationsPerUser, maxActiveApplications, maxActiveApplicationsPerUser, state, acls, cs.getConfiguration().getNodeLocalityDelay());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("LeafQueue: name=" + queueName + ", fullname=" + this.getQueuePath()));
        }
        Comparator<FiCaSchedulerApp> applicationComparator = cs.getApplicationComparator();
        this.pendingApplications = new TreeSet<FiCaSchedulerApp>(applicationComparator);
        this.activeApplications = new TreeSet<FiCaSchedulerApp>(applicationComparator);
    }

    private synchronized void setupQueueConfigs(Resource clusterResource, float capacity, float absoluteCapacity, float maximumCapacity, float absoluteMaxCapacity, int userLimit, float userLimitFactor, int maxApplications, int maxApplicationsPerUser, int maxActiveApplications, int maxActiveApplicationsPerUser, QueueState state, Map<QueueACL, AccessControlList> acls, int nodeLocalityDelay) {
        CSQueueUtils.checkMaxCapacity(this.getQueueName(), capacity, maximumCapacity);
        float absCapacity = this.getParent().getAbsoluteCapacity() * capacity;
        CSQueueUtils.checkAbsoluteCapacities(this.getQueueName(), absCapacity, absoluteMaxCapacity);
        this.capacity = capacity;
        this.absoluteCapacity = absCapacity;
        this.maximumCapacity = maximumCapacity;
        this.absoluteMaxCapacity = absoluteMaxCapacity;
        this.userLimit = userLimit;
        this.userLimitFactor = userLimitFactor;
        this.maxApplications = maxApplications;
        this.maxApplicationsPerUser = maxApplicationsPerUser;
        this.maxActiveApplications = maxActiveApplications;
        this.maxActiveApplicationsPerUser = maxActiveApplicationsPerUser;
        this.state = state;
        this.acls = acls;
        this.queueInfo.setCapacity(this.capacity);
        this.queueInfo.setMaximumCapacity(this.maximumCapacity);
        this.queueInfo.setQueueState(this.state);
        this.nodeLocalityDelay = nodeLocalityDelay;
        StringBuilder aclsString = new StringBuilder();
        for (Map.Entry<QueueACL, AccessControlList> e : acls.entrySet()) {
            aclsString.append(e.getKey() + ":" + e.getValue().getAclString());
        }
        CSQueueUtils.updateQueueStatistics(this.resourceCalculator, this, this.getParent(), clusterResource, this.minimumAllocation);
        LOG.info((Object)("Initializing " + this.queueName + "\n" + "capacity = " + capacity + " [= (float) configuredCapacity / 100 ]" + "\n" + "asboluteCapacity = " + absoluteCapacity + " [= parentAbsoluteCapacity * capacity ]" + "\n" + "maxCapacity = " + maximumCapacity + " [= configuredMaxCapacity ]" + "\n" + "absoluteMaxCapacity = " + absoluteMaxCapacity + " [= 1.0 maximumCapacity undefined, " + "(parentAbsoluteMaxCapacity * maximumCapacity) / 100 otherwise ]" + "\n" + "userLimit = " + userLimit + " [= configuredUserLimit ]" + "\n" + "userLimitFactor = " + userLimitFactor + " [= configuredUserLimitFactor ]" + "\n" + "maxApplications = " + maxApplications + " [= configuredMaximumSystemApplicationsPerQueue or" + " (int)(configuredMaximumSystemApplications * absoluteCapacity)]" + "\n" + "maxApplicationsPerUser = " + maxApplicationsPerUser + " [= (int)(maxApplications * (userLimit / 100.0f) * " + "userLimitFactor) ]" + "\n" + "maxActiveApplications = " + maxActiveApplications + " [= max(" + "(int)ceil((clusterResourceMemory / minimumAllocation) * " + "maxAMResourcePerQueuePercent * absoluteMaxCapacity)," + "1) ]" + "\n" + "maxActiveAppsUsingAbsCap = " + this.maxActiveAppsUsingAbsCap + " [= max(" + "(int)ceil((clusterResourceMemory / minimumAllocation) *" + "maxAMResourcePercent * absoluteCapacity)," + "1) ]" + "\n" + "maxActiveApplicationsPerUser = " + maxActiveApplicationsPerUser + " [= max(" + "(int)(maxActiveApplications * (userLimit / 100.0f) * " + "userLimitFactor)," + "1) ]" + "\n" + "usedCapacity = " + this.usedCapacity + " [= usedResourcesMemory / " + "(clusterResourceMemory * absoluteCapacity)]" + "\n" + "absoluteUsedCapacity = " + this.absoluteUsedCapacity + " [= usedResourcesMemory / clusterResourceMemory]" + "\n" + "maxAMResourcePerQueuePercent = " + this.maxAMResourcePerQueuePercent + " [= configuredMaximumAMResourcePercent ]" + "\n" + "minimumAllocationFactor = " + this.minimumAllocationFactor + " [= (float)(maximumAllocationMemory - minimumAllocationMemory) / " + "maximumAllocationMemory ]" + "\n" + "numContainers = " + this.numContainers + " [= currentNumContainers ]" + "\n" + "state = " + state + " [= configuredState ]" + "\n" + "acls = " + aclsString + " [= configuredAcls ]" + "\n" + "nodeLocalityDelay = " + nodeLocalityDelay + "\n"));
    }

    @Override
    public synchronized float getCapacity() {
        return this.capacity;
    }

    @Override
    public synchronized float getAbsoluteCapacity() {
        return this.absoluteCapacity;
    }

    @Override
    public synchronized float getMaximumCapacity() {
        return this.maximumCapacity;
    }

    @Override
    public synchronized float getAbsoluteMaximumCapacity() {
        return this.absoluteMaxCapacity;
    }

    @Override
    public synchronized float getAbsoluteUsedCapacity() {
        return this.absoluteUsedCapacity;
    }

    @Override
    public synchronized CSQueue getParent() {
        return this.parent;
    }

    @Override
    public synchronized void setParent(CSQueue newParentQueue) {
        this.parent = (ParentQueue)newParentQueue;
    }

    @Override
    public String getQueueName() {
        return this.queueName;
    }

    @Override
    public String getQueuePath() {
        return this.getParent().getQueuePath() + "." + this.getQueueName();
    }

    @InterfaceAudience.Private
    public Resource getMinimumAllocation() {
        return this.minimumAllocation;
    }

    @InterfaceAudience.Private
    public Resource getMaximumAllocation() {
        return this.maximumAllocation;
    }

    @InterfaceAudience.Private
    public float getMinimumAllocationFactor() {
        return this.minimumAllocationFactor;
    }

    public int getMaxApplications() {
        return this.maxApplications;
    }

    public synchronized int getMaxApplicationsPerUser() {
        return this.maxApplicationsPerUser;
    }

    public synchronized int getMaximumActiveApplications() {
        return this.maxActiveApplications;
    }

    public synchronized int getMaximumActiveApplicationsPerUser() {
        return this.maxActiveApplicationsPerUser;
    }

    @Override
    public ActiveUsersManager getActiveUsersManager() {
        return this.activeUsersManager;
    }

    @Override
    public synchronized float getUsedCapacity() {
        return this.usedCapacity;
    }

    @Override
    public synchronized Resource getUsedResources() {
        return this.usedResources;
    }

    @Override
    public List<CSQueue> getChildQueues() {
        return null;
    }

    @Override
    public synchronized void setUsedCapacity(float usedCapacity) {
        this.usedCapacity = usedCapacity;
    }

    @Override
    public synchronized void setAbsoluteUsedCapacity(float absUsedCapacity) {
        this.absoluteUsedCapacity = absUsedCapacity;
    }

    synchronized void setMaxCapacity(float maximumCapacity) {
        CSQueueUtils.checkMaxCapacity(this.getQueueName(), this.capacity, maximumCapacity);
        float absMaxCapacity = CSQueueUtils.computeAbsoluteMaximumCapacity(maximumCapacity, this.getParent());
        CSQueueUtils.checkAbsoluteCapacities(this.getQueueName(), this.absoluteCapacity, absMaxCapacity);
        this.maximumCapacity = maximumCapacity;
        this.absoluteMaxCapacity = absMaxCapacity;
    }

    synchronized void setUserLimit(int userLimit) {
        this.userLimit = userLimit;
    }

    synchronized void setUserLimitFactor(int userLimitFactor) {
        this.userLimitFactor = userLimitFactor;
    }

    @Override
    public synchronized int getNumApplications() {
        return this.getNumPendingApplications() + this.getNumActiveApplications();
    }

    public synchronized int getNumPendingApplications() {
        return this.pendingApplications.size();
    }

    public synchronized int getNumActiveApplications() {
        return this.activeApplications.size();
    }

    @InterfaceAudience.Private
    public synchronized int getNumApplications(String user) {
        return this.getUser(user).getTotalApplications();
    }

    @InterfaceAudience.Private
    public synchronized int getNumPendingApplications(String user) {
        return this.getUser(user).getPendingApplications();
    }

    @InterfaceAudience.Private
    public synchronized int getNumActiveApplications(String user) {
        return this.getUser(user).getActiveApplications();
    }

    public synchronized int getNumContainers() {
        return this.numContainers;
    }

    @Override
    public synchronized QueueState getState() {
        return this.state;
    }

    @InterfaceAudience.Private
    public synchronized int getUserLimit() {
        return this.userLimit;
    }

    @InterfaceAudience.Private
    public synchronized float getUserLimitFactor() {
        return this.userLimitFactor;
    }

    @Override
    public synchronized Map<QueueACL, AccessControlList> getQueueAcls() {
        return new HashMap<QueueACL, AccessControlList>(this.acls);
    }

    @Override
    public synchronized QueueInfo getQueueInfo(boolean includeChildQueues, boolean recursive) {
        this.queueInfo.setCurrentCapacity(this.usedCapacity);
        return this.queueInfo;
    }

    @Override
    public synchronized List<QueueUserACLInfo> getQueueUserAclInfo(UserGroupInformation user) {
        QueueUserACLInfo userAclInfo = (QueueUserACLInfo)this.recordFactory.newRecordInstance(QueueUserACLInfo.class);
        ArrayList<QueueACL> operations = new ArrayList<QueueACL>();
        for (QueueACL operation : QueueACL.values()) {
            if (!this.hasAccess(operation, user)) continue;
            operations.add(operation);
        }
        userAclInfo.setQueueName(this.getQueueName());
        userAclInfo.setUserAcls(operations);
        return Collections.singletonList(userAclInfo);
    }

    @InterfaceAudience.Private
    public int getNodeLocalityDelay() {
        return this.nodeLocalityDelay;
    }

    public String toString() {
        return this.queueName + ": " + "capacity=" + this.capacity + ", " + "absoluteCapacity=" + this.absoluteCapacity + ", " + "usedResources=" + this.usedResources + "usedCapacity=" + this.getUsedCapacity() + ", " + "absoluteUsedCapacity=" + this.getAbsoluteUsedCapacity() + ", " + "numApps=" + this.getNumApplications() + ", " + "numContainers=" + this.getNumContainers();
    }

    private synchronized User getUser(String userName) {
        User user = this.users.get(userName);
        if (user == null) {
            user = new User();
            this.users.put(userName, user);
        }
        return user;
    }

    public synchronized ArrayList<UserInfo> getUsers() {
        ArrayList<UserInfo> usersToReturn = new ArrayList<UserInfo>();
        for (Map.Entry<String, User> entry : this.users.entrySet()) {
            usersToReturn.add(new UserInfo(entry.getKey(), Resources.clone((Resource)entry.getValue().consumed), entry.getValue().getActiveApplications(), entry.getValue().getPendingApplications()));
        }
        return usersToReturn;
    }

    @Override
    public synchronized void reinitialize(CSQueue newlyParsedQueue, Resource clusterResource) throws IOException {
        if (!(newlyParsedQueue instanceof LeafQueue) || !newlyParsedQueue.getQueuePath().equals(this.getQueuePath())) {
            throw new IOException("Trying to reinitialize " + this.getQueuePath() + " from " + newlyParsedQueue.getQueuePath());
        }
        LeafQueue newlyParsedLeafQueue = (LeafQueue)newlyParsedQueue;
        this.setupQueueConfigs(clusterResource, newlyParsedLeafQueue.capacity, newlyParsedLeafQueue.absoluteCapacity, newlyParsedLeafQueue.maximumCapacity, newlyParsedLeafQueue.absoluteMaxCapacity, newlyParsedLeafQueue.userLimit, newlyParsedLeafQueue.userLimitFactor, newlyParsedLeafQueue.maxApplications, newlyParsedLeafQueue.getMaxApplicationsPerUser(), newlyParsedLeafQueue.getMaximumActiveApplications(), newlyParsedLeafQueue.getMaximumActiveApplicationsPerUser(), newlyParsedLeafQueue.state, newlyParsedLeafQueue.acls, newlyParsedLeafQueue.getNodeLocalityDelay());
        this.activateApplications();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasAccess(QueueACL acl, UserGroupInformation user) {
        LeafQueue leafQueue = this;
        synchronized (leafQueue) {
            if (this.acls.get(acl).isUserAllowed(user)) {
                return true;
            }
        }
        return this.getParent().hasAccess(acl, user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void submitApplication(FiCaSchedulerApp application, String userName, String queue) throws AccessControlException {
        UserGroupInformation userUgi = UserGroupInformation.createRemoteUser((String)userName);
        if (!this.hasAccess(QueueACL.SUBMIT_APPLICATIONS, userUgi)) {
            throw new AccessControlException("User " + userName + " cannot submit" + " applications to queue " + this.getQueuePath());
        }
        User user = null;
        LeafQueue leafQueue = this;
        synchronized (leafQueue) {
            if (this.getState() != QueueState.RUNNING) {
                String msg = "Queue " + this.getQueuePath() + " is STOPPED. Cannot accept submission of application: " + application.getApplicationId();
                LOG.info((Object)msg);
                throw new AccessControlException(msg);
            }
            if (this.getNumApplications() >= this.getMaxApplications()) {
                String msg = "Queue " + this.getQueuePath() + " already has " + this.getNumApplications() + " applications," + " cannot accept submission of application: " + application.getApplicationId();
                LOG.info((Object)msg);
                throw new AccessControlException(msg);
            }
            user = this.getUser(userName);
            if (user.getTotalApplications() >= this.getMaxApplicationsPerUser()) {
                String msg = "Queue " + this.getQueuePath() + " already has " + user.getTotalApplications() + " applications from user " + userName + " cannot accept submission of application: " + application.getApplicationId();
                LOG.info((Object)msg);
                throw new AccessControlException(msg);
            }
            this.addApplication(application, user);
        }
        int attemptId = application.getApplicationAttemptId().getAttemptId();
        this.metrics.submitApp(userName, attemptId);
        try {
            this.getParent().submitApplication(application, userName, queue);
        }
        catch (AccessControlException ace) {
            LOG.info((Object)("Failed to submit application to parent-queue: " + this.getParent().getQueuePath()), (Throwable)ace);
            this.removeApplication(application, user);
            throw ace;
        }
    }

    private synchronized void activateApplications() {
        Iterator<FiCaSchedulerApp> i = this.pendingApplications.iterator();
        while (i.hasNext()) {
            FiCaSchedulerApp application = i.next();
            if (this.getNumActiveApplications() >= this.getMaximumActiveApplications()) break;
            User user = this.getUser(application.getUser());
            if (user.getActiveApplications() >= this.getMaximumActiveApplicationsPerUser()) continue;
            user.activateApplication();
            this.activeApplications.add(application);
            i.remove();
            LOG.info((Object)("Application " + application.getApplicationId() + " from user: " + application.getUser() + " activated in queue: " + this.getQueueName()));
        }
    }

    private synchronized void addApplication(FiCaSchedulerApp application, User user) {
        user.submitApplication();
        this.pendingApplications.add(application);
        this.applicationsMap.put(application.getApplicationAttemptId(), application);
        this.activateApplications();
        LOG.info((Object)("Application added - appId: " + application.getApplicationId() + " user: " + user + "," + " leaf-queue: " + this.getQueueName() + " #user-pending-applications: " + user.getPendingApplications() + " #user-active-applications: " + user.getActiveApplications() + " #queue-pending-applications: " + this.getNumPendingApplications() + " #queue-active-applications: " + this.getNumActiveApplications()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishApplication(FiCaSchedulerApp application, String queue) {
        LeafQueue leafQueue = this;
        synchronized (leafQueue) {
            this.removeApplication(application, this.getUser(application.getUser()));
        }
        this.getParent().finishApplication(application, queue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeApplication(FiCaSchedulerApp application, User user) {
        boolean wasActive = this.activeApplications.remove(application);
        if (!wasActive) {
            this.pendingApplications.remove(application);
        }
        this.applicationsMap.remove(application.getApplicationAttemptId());
        user.finishApplication(wasActive);
        if (user.getTotalApplications() == 0) {
            this.users.remove(application.getUser());
        }
        this.activateApplications();
        FiCaSchedulerApp fiCaSchedulerApp = application;
        synchronized (fiCaSchedulerApp) {
            this.activeUsersManager.deactivateApplication(application.getUser(), application.getApplicationId());
        }
        LOG.info((Object)("Application removed - appId: " + application.getApplicationId() + " user: " + application.getUser() + " queue: " + this.getQueueName() + " #user-pending-applications: " + user.getPendingApplications() + " #user-active-applications: " + user.getActiveApplications() + " #queue-pending-applications: " + this.getNumPendingApplications() + " #queue-active-applications: " + this.getNumActiveApplications()));
    }

    private synchronized FiCaSchedulerApp getApplication(ApplicationAttemptId applicationAttemptId) {
        return this.applicationsMap.get(applicationAttemptId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized CSAssignment assignContainers(Resource clusterResource, FiCaSchedulerNode node) {
        RMContainer reservedContainer;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("assignContainers: node=" + node.getHostName() + " #applications=" + this.activeApplications.size()));
        }
        if ((reservedContainer = node.getReservedContainer()) != null) {
            FiCaSchedulerApp application = this.getApplication(reservedContainer.getApplicationAttemptId());
            return this.assignReservedContainer(application, node, reservedContainer, clusterResource);
        }
        for (FiCaSchedulerApp application : this.activeApplications) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("pre-assignContainers for application " + application.getApplicationId()));
                application.showRequests();
            }
            FiCaSchedulerApp fiCaSchedulerApp = application;
            synchronized (fiCaSchedulerApp) {
                if (this.isBlacklisted(application, node)) {
                    continue;
                }
                for (Priority priority : application.getPriorities()) {
                    Resource required;
                    if (!this.needContainers(application, priority, required = application.getResourceRequest(priority, "*").getCapability())) continue;
                    Resource userLimit = this.computeUserLimitAndSetHeadroom(application, clusterResource, required);
                    if (!this.assignToQueue(clusterResource, required)) {
                        return NULL_ASSIGNMENT;
                    }
                    if (!this.assignToUser(clusterResource, application.getUser(), userLimit)) break;
                    application.addSchedulingOpportunity(priority);
                    CSAssignment assignment = this.assignContainersOnNode(clusterResource, node, application, priority, null);
                    if (assignment.getSkipped()) {
                        application.subtractSchedulingOpportunity(priority);
                        continue;
                    }
                    Resource assigned = assignment.getResource();
                    if (!Resources.greaterThan((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)assigned, (Resource)Resources.none())) break;
                    this.allocateResource(clusterResource, application, assigned);
                    if (assignment.getType() != NodeType.OFF_SWITCH) {
                        application.resetSchedulingOpportunities(priority);
                    }
                    return assignment;
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("post-assignContainers for application " + application.getApplicationId()));
            }
            application.showRequests();
        }
        return NULL_ASSIGNMENT;
    }

    boolean isBlacklisted(FiCaSchedulerApp application, FiCaSchedulerNode node) {
        if (application.isBlacklisted(node.getHostName())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Skipping 'host' " + node.getHostName() + " for " + application.getApplicationId() + " since it has been blacklisted"));
            }
            return true;
        }
        if (application.isBlacklisted(node.getRackName())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Skipping 'rack' " + node.getRackName() + " for " + application.getApplicationId() + " since it has been blacklisted"));
            }
            return true;
        }
        return false;
    }

    private synchronized CSAssignment assignReservedContainer(FiCaSchedulerApp application, FiCaSchedulerNode node, RMContainer rmContainer, Resource clusterResource) {
        Priority priority = rmContainer.getReservedPriority();
        if (application.getTotalRequiredResources(priority) == 0) {
            return new CSAssignment(application, rmContainer);
        }
        this.assignContainersOnNode(clusterResource, node, application, priority, rmContainer);
        return new CSAssignment(Resources.none(), NodeType.NODE_LOCAL);
    }

    private synchronized boolean assignToQueue(Resource clusterResource, Resource required) {
        float potentialNewCapacity = Resources.divide((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)Resources.add((Resource)this.usedResources, (Resource)required), (Resource)clusterResource);
        if (potentialNewCapacity > this.absoluteMaxCapacity) {
            LOG.info((Object)(this.getQueueName() + " usedResources: " + this.usedResources + " clusterResources: " + clusterResource + " currentCapacity " + Resources.divide((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)this.usedResources, (Resource)clusterResource) + " required " + required + " potentialNewCapacity: " + potentialNewCapacity + " ( " + " max-capacity: " + this.absoluteMaxCapacity + ")"));
            return false;
        }
        return true;
    }

    @Lock(value={LeafQueue.class, FiCaSchedulerApp.class})
    private Resource computeUserLimitAndSetHeadroom(FiCaSchedulerApp application, Resource clusterResource, Resource required) {
        String user = application.getUser();
        Resource userLimit = this.computeUserLimit(application, clusterResource, required);
        Resource queueMaxCap = Resources.multiplyAndNormalizeDown((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (double)this.absoluteMaxCapacity, (Resource)this.minimumAllocation);
        Resource userConsumed = this.getUser(user).getConsumedResources();
        Resource headroom = Resources.subtract((Resource)Resources.min((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)userLimit, (Resource)queueMaxCap), (Resource)userConsumed);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Headroom calculation for user " + user + ": " + " userLimit=" + userLimit + " queueMaxCap=" + queueMaxCap + " consumed=" + userConsumed + " headroom=" + headroom));
        }
        application.setHeadroom(headroom);
        this.metrics.setAvailableResourcesToUser(user, headroom);
        return userLimit;
    }

    @Lock(value={Lock.NoLock.class})
    private Resource computeUserLimit(FiCaSchedulerApp application, Resource clusterResource, Resource required) {
        Resource queueCapacity = Resources.max((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)Resources.multiplyAndNormalizeUp((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (double)this.absoluteCapacity, (Resource)this.minimumAllocation), (Resource)required);
        Resource currentCapacity = Resources.lessThan((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)this.usedResources, (Resource)queueCapacity) ? queueCapacity : Resources.add((Resource)this.usedResources, (Resource)required);
        int activeUsers = this.activeUsersManager.getNumActiveUsers();
        Resource limit = Resources.roundUp((ResourceCalculator)this.resourceCalculator, (Resource)Resources.min((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)Resources.max((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)Resources.divideAndCeil((ResourceCalculator)this.resourceCalculator, (Resource)currentCapacity, (int)activeUsers), (Resource)Resources.divideAndCeil((ResourceCalculator)this.resourceCalculator, (Resource)Resources.multiplyAndRoundDown((Resource)currentCapacity, (double)this.userLimit), (int)100)), (Resource)Resources.multiplyAndRoundDown((Resource)queueCapacity, (double)this.userLimitFactor)), (Resource)this.minimumAllocation);
        if (LOG.isDebugEnabled()) {
            String userName = application.getUser();
            LOG.debug((Object)("User limit computation for " + userName + " in queue " + this.getQueueName() + " userLimit=" + this.userLimit + " userLimitFactor=" + this.userLimitFactor + " required: " + required + " consumed: " + this.getUser(userName).getConsumedResources() + " limit: " + limit + " queueCapacity: " + queueCapacity + " qconsumed: " + this.usedResources + " currentCapacity: " + currentCapacity + " activeUsers: " + activeUsers + " clusterCapacity: " + clusterResource));
        }
        return limit;
    }

    private synchronized boolean assignToUser(Resource clusterResource, String userName, Resource limit) {
        User user = this.getUser(userName);
        if (Resources.greaterThan((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)user.getConsumedResources(), (Resource)limit)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("User " + userName + " in queue " + this.getQueueName() + " will exceed limit - " + " consumed: " + user.getConsumedResources() + " limit: " + limit));
            }
            return false;
        }
        return true;
    }

    boolean needContainers(FiCaSchedulerApp application, Priority priority, Resource required) {
        int requiredContainers = application.getTotalRequiredResources(priority);
        int reservedContainers = application.getNumReservedContainers(priority);
        int starvation = 0;
        if (reservedContainers > 0) {
            float nodeFactor = Resources.ratio((ResourceCalculator)this.resourceCalculator, (Resource)required, (Resource)this.getMaximumAllocation());
            starvation = (int)((float)application.getReReservations(priority) / (float)reservedContainers * (1.0f - Math.min(nodeFactor, this.getMinimumAllocationFactor())));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("needsContainers: app.#re-reserve=" + application.getReReservations(priority) + " reserved=" + reservedContainers + " nodeFactor=" + nodeFactor + " minAllocFactor=" + this.getMinimumAllocationFactor() + " starvation=" + starvation));
            }
        }
        return starvation + requiredContainers - reservedContainers > 0;
    }

    private CSAssignment assignContainersOnNode(Resource clusterResource, FiCaSchedulerNode node, FiCaSchedulerApp application, Priority priority, RMContainer reservedContainer) {
        ResourceRequest offSwitchResourceRequest;
        Resource assigned = Resources.none();
        ResourceRequest nodeLocalResourceRequest = application.getResourceRequest(priority, node.getHostName());
        if (nodeLocalResourceRequest != null && Resources.greaterThan((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)(assigned = this.assignNodeLocalContainers(clusterResource, nodeLocalResourceRequest, node, application, priority, reservedContainer)), (Resource)Resources.none())) {
            return new CSAssignment(assigned, NodeType.NODE_LOCAL);
        }
        ResourceRequest rackLocalResourceRequest = application.getResourceRequest(priority, node.getRackName());
        if (rackLocalResourceRequest != null) {
            if (!rackLocalResourceRequest.getRelaxLocality()) {
                return SKIP_ASSIGNMENT;
            }
            assigned = this.assignRackLocalContainers(clusterResource, rackLocalResourceRequest, node, application, priority, reservedContainer);
            if (Resources.greaterThan((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)assigned, (Resource)Resources.none())) {
                return new CSAssignment(assigned, NodeType.RACK_LOCAL);
            }
        }
        if ((offSwitchResourceRequest = application.getResourceRequest(priority, "*")) != null) {
            if (!offSwitchResourceRequest.getRelaxLocality()) {
                return SKIP_ASSIGNMENT;
            }
            return new CSAssignment(this.assignOffSwitchContainers(clusterResource, offSwitchResourceRequest, node, application, priority, reservedContainer), NodeType.OFF_SWITCH);
        }
        return SKIP_ASSIGNMENT;
    }

    private Resource assignNodeLocalContainers(Resource clusterResource, ResourceRequest nodeLocalResourceRequest, FiCaSchedulerNode node, FiCaSchedulerApp application, Priority priority, RMContainer reservedContainer) {
        if (this.canAssign(application, priority, node, NodeType.NODE_LOCAL, reservedContainer)) {
            return this.assignContainer(clusterResource, node, application, priority, nodeLocalResourceRequest, NodeType.NODE_LOCAL, reservedContainer);
        }
        return Resources.none();
    }

    private Resource assignRackLocalContainers(Resource clusterResource, ResourceRequest rackLocalResourceRequest, FiCaSchedulerNode node, FiCaSchedulerApp application, Priority priority, RMContainer reservedContainer) {
        if (this.canAssign(application, priority, node, NodeType.RACK_LOCAL, reservedContainer)) {
            return this.assignContainer(clusterResource, node, application, priority, rackLocalResourceRequest, NodeType.RACK_LOCAL, reservedContainer);
        }
        return Resources.none();
    }

    private Resource assignOffSwitchContainers(Resource clusterResource, ResourceRequest offSwitchResourceRequest, FiCaSchedulerNode node, FiCaSchedulerApp application, Priority priority, RMContainer reservedContainer) {
        if (this.canAssign(application, priority, node, NodeType.OFF_SWITCH, reservedContainer)) {
            return this.assignContainer(clusterResource, node, application, priority, offSwitchResourceRequest, NodeType.OFF_SWITCH, reservedContainer);
        }
        return Resources.none();
    }

    boolean canAssign(FiCaSchedulerApp application, Priority priority, FiCaSchedulerNode node, NodeType type, RMContainer reservedContainer) {
        ResourceRequest nodeLocalRequest;
        if (type == NodeType.OFF_SWITCH) {
            float localityWaitFactor;
            if (reservedContainer != null) {
                return true;
            }
            ResourceRequest offSwitchRequest = application.getResourceRequest(priority, "*");
            long missedOpportunities = application.getSchedulingOpportunities(priority);
            long requiredContainers = offSwitchRequest.getNumContainers();
            return (float)requiredContainers * (localityWaitFactor = application.getLocalityWaitFactor(priority, this.scheduler.getNumClusterNodes())) < (float)missedOpportunities;
        }
        ResourceRequest rackLocalRequest = application.getResourceRequest(priority, node.getRackName());
        if (rackLocalRequest == null || rackLocalRequest.getNumContainers() <= 0) {
            return false;
        }
        if (type == NodeType.RACK_LOCAL) {
            long missedOpportunities = application.getSchedulingOpportunities(priority);
            return (long)Math.min(this.scheduler.getNumClusterNodes(), this.getNodeLocalityDelay()) < missedOpportunities;
        }
        if (type == NodeType.NODE_LOCAL && (nodeLocalRequest = application.getResourceRequest(priority, node.getHostName())) != null) {
            return nodeLocalRequest.getNumContainers() > 0;
        }
        return false;
    }

    private Container getContainer(RMContainer rmContainer, FiCaSchedulerApp application, FiCaSchedulerNode node, Resource capability, Priority priority) {
        return rmContainer != null ? rmContainer.getContainer() : this.createContainer(application, node, capability, priority);
    }

    Container createContainer(FiCaSchedulerApp application, FiCaSchedulerNode node, Resource capability, Priority priority) {
        NodeId nodeId = node.getRMNode().getNodeID();
        ContainerId containerId = BuilderUtils.newContainerId((ApplicationAttemptId)application.getApplicationAttemptId(), (int)application.getNewContainerId());
        Container container = BuilderUtils.newContainer((ContainerId)containerId, (NodeId)nodeId, (String)node.getRMNode().getHttpAddress(), (Resource)capability, (Priority)priority, null);
        return container;
    }

    Token createContainerToken(FiCaSchedulerApp application, Container container) {
        return this.containerTokenSecretManager.createContainerToken(container.getId(), container.getNodeId(), application.getUser(), container.getResource());
    }

    private Resource assignContainer(Resource clusterResource, FiCaSchedulerNode node, FiCaSchedulerApp application, Priority priority, ResourceRequest request, NodeType type, RMContainer rmContainer) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("assignContainers: node=" + node.getHostName() + " application=" + application.getApplicationId().getId() + " priority=" + priority.getPriority() + " request=" + request + " type=" + (Object)((Object)type)));
        }
        Resource capability = request.getCapability();
        Resource available = node.getAvailableResource();
        assert (Resources.greaterThan((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)available, (Resource)Resources.none()));
        Container container = this.getContainer(rmContainer, application, node, capability, priority);
        if (container == null) {
            LOG.warn((Object)"Couldn't get container for allocation!");
            return Resources.none();
        }
        int availableContainers = this.resourceCalculator.computeAvailableContainers(available, capability);
        if (availableContainers > 0) {
            Token containerToken;
            if (rmContainer != null) {
                this.unreserve(application, priority, node, rmContainer);
            }
            if ((containerToken = this.createContainerToken(application, container)) == null) {
                return Resources.none();
            }
            container.setContainerToken(containerToken);
            RMContainer allocatedContainer = application.allocate(type, node, priority, request, container);
            if (allocatedContainer == null) {
                return Resources.none();
            }
            node.allocateContainer(application.getApplicationId(), allocatedContainer);
            LOG.info((Object)("assignedContainer application=" + application.getApplicationId() + " container=" + container + " containerId=" + container.getId() + " queue=" + this + " usedCapacity=" + this.getUsedCapacity() + " absoluteUsedCapacity=" + this.getAbsoluteUsedCapacity() + " used=" + this.usedResources + " cluster=" + clusterResource));
            return container.getResource();
        }
        this.reserve(application, priority, node, rmContainer, container);
        LOG.info((Object)("Reserved container  application=" + application.getApplicationId() + " resource=" + request.getCapability() + " queue=" + this.toString() + " usedCapacity=" + this.getUsedCapacity() + " absoluteUsedCapacity=" + this.getAbsoluteUsedCapacity() + " used=" + this.usedResources + " cluster=" + clusterResource));
        return request.getCapability();
    }

    private void reserve(FiCaSchedulerApp application, Priority priority, FiCaSchedulerNode node, RMContainer rmContainer, Container container) {
        if (rmContainer == null) {
            this.getMetrics().reserveResource(application.getUser(), container.getResource());
        }
        rmContainer = application.reserve(node, priority, rmContainer, container);
        node.reserveResource(application, priority, rmContainer);
    }

    private void unreserve(FiCaSchedulerApp application, Priority priority, FiCaSchedulerNode node, RMContainer rmContainer) {
        application.unreserve(node, priority);
        node.unreserveResource(application);
        this.getMetrics().unreserveResource(application.getUser(), rmContainer.getContainer().getResource());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void completedContainer(Resource clusterResource, FiCaSchedulerApp application, FiCaSchedulerNode node, RMContainer rmContainer, ContainerStatus containerStatus, RMContainerEventType event) {
        if (application != null) {
            LeafQueue leafQueue = this;
            synchronized (leafQueue) {
                Container container = rmContainer.getContainer();
                if (rmContainer.getState() == RMContainerState.RESERVED) {
                    this.unreserve(application, rmContainer.getReservedPriority(), node, rmContainer);
                } else {
                    application.containerCompleted(rmContainer, containerStatus, event);
                    node.releaseContainer(container);
                }
                this.releaseResource(clusterResource, application, container.getResource());
                LOG.info((Object)("completedContainer container=" + container + " resource=" + container.getResource() + " queue=" + this + " usedCapacity=" + this.getUsedCapacity() + " absoluteUsedCapacity=" + this.getAbsoluteUsedCapacity() + " used=" + this.usedResources + " cluster=" + clusterResource));
            }
            this.getParent().completedContainer(clusterResource, application, node, rmContainer, null, event);
        }
    }

    synchronized void allocateResource(Resource clusterResource, FiCaSchedulerApp application, Resource resource) {
        Resources.addTo((Resource)this.usedResources, (Resource)resource);
        CSQueueUtils.updateQueueStatistics(this.resourceCalculator, this, this.getParent(), clusterResource, this.minimumAllocation);
        ++this.numContainers;
        String userName = application.getUser();
        User user = this.getUser(userName);
        user.assignContainer(resource);
        Resources.subtractFrom((Resource)application.getHeadroom(), (Resource)resource);
        this.metrics.setAvailableResourcesToUser(userName, application.getHeadroom());
        if (LOG.isDebugEnabled()) {
            LOG.info((Object)(this.getQueueName() + " user=" + userName + " used=" + this.usedResources + " numContainers=" + this.numContainers + " headroom = " + application.getHeadroom() + " user-resources=" + user.getConsumedResources()));
        }
    }

    synchronized void releaseResource(Resource clusterResource, FiCaSchedulerApp application, Resource resource) {
        Resources.subtractFrom((Resource)this.usedResources, (Resource)resource);
        CSQueueUtils.updateQueueStatistics(this.resourceCalculator, this, this.getParent(), clusterResource, this.minimumAllocation);
        --this.numContainers;
        String userName = application.getUser();
        User user = this.getUser(userName);
        user.releaseContainer(resource);
        this.metrics.setAvailableResourcesToUser(userName, application.getHeadroom());
        LOG.info((Object)(this.getQueueName() + " used=" + this.usedResources + " numContainers=" + this.numContainers + " user=" + userName + " user-resources=" + user.getConsumedResources()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void updateClusterResource(Resource clusterResource) {
        this.maxActiveApplications = CSQueueUtils.computeMaxActiveApplications(this.resourceCalculator, clusterResource, this.minimumAllocation, this.maxAMResourcePerQueuePercent, this.absoluteMaxCapacity);
        this.maxActiveAppsUsingAbsCap = CSQueueUtils.computeMaxActiveApplications(this.resourceCalculator, clusterResource, this.minimumAllocation, this.maxAMResourcePerQueuePercent, this.absoluteCapacity);
        this.maxActiveApplicationsPerUser = CSQueueUtils.computeMaxActiveApplicationsPerUser(this.maxActiveAppsUsingAbsCap, this.userLimit, this.userLimitFactor);
        CSQueueUtils.updateQueueStatistics(this.resourceCalculator, this, this.getParent(), clusterResource, this.minimumAllocation);
        this.activateApplications();
        Iterator<FiCaSchedulerApp> i$ = this.activeApplications.iterator();
        while (i$.hasNext()) {
            FiCaSchedulerApp application;
            FiCaSchedulerApp fiCaSchedulerApp = application = i$.next();
            synchronized (fiCaSchedulerApp) {
                this.computeUserLimitAndSetHeadroom(application, clusterResource, Resources.none());
            }
        }
    }

    @Override
    public QueueMetrics getMetrics() {
        return this.metrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recoverContainer(Resource clusterResource, FiCaSchedulerApp application, Container container) {
        LeafQueue leafQueue = this;
        synchronized (leafQueue) {
            this.allocateResource(clusterResource, application, container.getResource());
        }
        this.getParent().recoverContainer(clusterResource, application, container);
    }

    static class User {
        Resource consumed = Resources.createResource((int)0, (int)0);
        int pendingApplications = 0;
        int activeApplications = 0;

        User() {
        }

        public Resource getConsumedResources() {
            return this.consumed;
        }

        public int getPendingApplications() {
            return this.pendingApplications;
        }

        public int getActiveApplications() {
            return this.activeApplications;
        }

        public int getTotalApplications() {
            return this.getPendingApplications() + this.getActiveApplications();
        }

        public synchronized void submitApplication() {
            ++this.pendingApplications;
        }

        public synchronized void activateApplication() {
            --this.pendingApplications;
            ++this.activeApplications;
        }

        public synchronized void finishApplication(boolean wasActive) {
            if (wasActive) {
                --this.activeApplications;
            } else {
                --this.pendingApplications;
            }
        }

        public synchronized void assignContainer(Resource resource) {
            Resources.addTo((Resource)this.consumed, (Resource)resource);
        }

        public synchronized void releaseContainer(Resource resource) {
            Resources.subtractFrom((Resource)this.consumed, (Resource)resource);
        }
    }
}

