/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.policies;

import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.resource.ResourceType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.Schedulable;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.SchedulingPolicy;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class FairSharePolicy
extends SchedulingPolicy {
    @VisibleForTesting
    public static final String NAME = "fair";
    private static final DefaultResourceCalculator RESOURCE_CALCULATOR = new DefaultResourceCalculator();
    private FairShareComparator comparator = new FairShareComparator();
    private static final int COMPUTE_FAIR_SHARES_ITERATIONS = 25;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Comparator<Schedulable> getComparator() {
        return this.comparator;
    }

    @Override
    public void computeShares(Collection<? extends Schedulable> schedulables, Resource totalResources) {
        FairSharePolicy.computeFairShares(schedulables, totalResources);
    }

    public static void computeFairShares(Collection<? extends Schedulable> schedulables, Resource totalResources) {
        Resource totalDemand = Resources.createResource((int)0);
        for (Schedulable schedulable : schedulables) {
            Resources.addTo((Resource)totalDemand, (Resource)schedulable.getDemand());
        }
        Resource cap = Resources.min((ResourceCalculator)RESOURCE_CALCULATOR, null, (Resource)totalDemand, (Resource)totalResources);
        double d = 1.0;
        while (Resources.lessThan((ResourceCalculator)RESOURCE_CALCULATOR, null, (Resource)FairSharePolicy.resUsedWithWeightToResRatio(d, schedulables), (Resource)cap)) {
            d *= 2.0;
        }
        double left = 0.0;
        double right = d;
        for (int i = 0; i < 25; ++i) {
            double d2 = (left + right) / 2.0;
            if (Resources.lessThan((ResourceCalculator)RESOURCE_CALCULATOR, null, (Resource)FairSharePolicy.resUsedWithWeightToResRatio(d2, schedulables), (Resource)cap)) {
                left = d2;
                continue;
            }
            right = d2;
        }
        for (Schedulable schedulable : schedulables) {
            schedulable.setFairShare(FairSharePolicy.computeShare(schedulable, right));
        }
    }

    private static Resource resUsedWithWeightToResRatio(double w2sRatio, Collection<? extends Schedulable> schedulables) {
        Resource slotsTaken = Resources.createResource((int)0);
        for (Schedulable schedulable : schedulables) {
            Resource share = FairSharePolicy.computeShare(schedulable, w2sRatio);
            Resources.addTo((Resource)slotsTaken, (Resource)share);
        }
        return slotsTaken;
    }

    private static Resource computeShare(Schedulable sched, double r2sRatio) {
        double share = (double)sched.getWeights().getWeight(ResourceType.MEMORY) * r2sRatio;
        share = Math.max(share, (double)sched.getMinShare().getMemory());
        share = Math.min(share, (double)sched.getDemand().getMemory());
        return Resources.createResource((int)((int)share));
    }

    @Override
    public byte getApplicableDepth() {
        return 7;
    }

    private static class FairShareComparator
    implements Comparator<Schedulable>,
    Serializable {
        private static final long serialVersionUID = 5564969375856699313L;

        private FairShareComparator() {
        }

        @Override
        public int compare(Schedulable s1, Schedulable s2) {
            Resource minShare1 = Resources.min((ResourceCalculator)RESOURCE_CALCULATOR, null, (Resource)s1.getMinShare(), (Resource)s1.getDemand());
            Resource minShare2 = Resources.min((ResourceCalculator)RESOURCE_CALCULATOR, null, (Resource)s2.getMinShare(), (Resource)s2.getDemand());
            boolean s1Needy = Resources.lessThan((ResourceCalculator)RESOURCE_CALCULATOR, null, (Resource)s1.getResourceUsage(), (Resource)minShare1);
            boolean s2Needy = Resources.lessThan((ResourceCalculator)RESOURCE_CALCULATOR, null, (Resource)s2.getResourceUsage(), (Resource)minShare2);
            Resource one = Resources.createResource((int)1);
            double minShareRatio1 = (double)s1.getResourceUsage().getMemory() / (double)Resources.max((ResourceCalculator)RESOURCE_CALCULATOR, null, (Resource)minShare1, (Resource)one).getMemory();
            double minShareRatio2 = (double)s2.getResourceUsage().getMemory() / (double)Resources.max((ResourceCalculator)RESOURCE_CALCULATOR, null, (Resource)minShare2, (Resource)one).getMemory();
            double useToWeightRatio1 = (float)s1.getResourceUsage().getMemory() / s1.getWeights().getWeight(ResourceType.MEMORY);
            double useToWeightRatio2 = (float)s2.getResourceUsage().getMemory() / s2.getWeights().getWeight(ResourceType.MEMORY);
            int res = 0;
            res = s1Needy && !s2Needy ? -1 : (s2Needy && !s1Needy ? 1 : (s1Needy && s2Needy ? (int)Math.signum(minShareRatio1 - minShareRatio2) : (int)Math.signum(useToWeightRatio1 - useToWeightRatio2)));
            if (res == 0 && (res = (int)Math.signum(s1.getStartTime() - s2.getStartTime())) == 0) {
                res = s1.getName().compareTo(s2.getName());
            }
            return res;
        }
    }
}

